<?php
/**
 * Impeka Elementor Custom Contact Form Widget.
 *
 * Elementor widget that inserts a custom contact form into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Custom_Contact_Form_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_custom_contact_form';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Custom Contact Form', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-form';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


		$cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

		$contact_forms = array();
		if ( $cf7 ) {
			foreach ( $cf7 as $cform ) {
				$contact_forms[ $cform->ID ] = $cform->post_title;
			}
		} else {
			$contact_forms[0] = esc_html__( 'No contact forms found', 'impeka-elementor-extension' );
		}

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'contact_form',
			[
				'label' => esc_html__( 'Select Contact Form', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $contact_forms,
				'description' => esc_html__( "Choose previously created contact form from the drop down list.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'quote-text' => esc_html__( 'Quote Text', 'impeka-elementor-extension' ),
					],
				'default' => '',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'inputs_shape',
			[
				'label' => esc_html__( 'Inputs Shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''  => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round'  => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'extra-round'  => esc_html__( 'Extra Round', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( "Select the shape for your contact form inputs.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'input_bg_color',
			[
				'label' => esc_html__( 'Input Fields Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['transparent', 'primary', 'standard'] ),
				'default' => 'light-grey',
				'description' => esc_html__( 'Select the background color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_text_color',
			[
				'label' => esc_html__( 'Input Fields Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Select a text color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_placeholder_color',
			[
				'label' => esc_html__( 'Input Fields Placeholder Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Select a placeholder color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'inputs_borders',
			[
				'label' => esc_html__( 'Inputs Fields Borders', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'solid'  => esc_html__( 'Solid', 'impeka-elementor-extension' ),
					'underline'  => esc_html__( 'Underline', 'impeka-elementor-extension' ),
				],
				'default' => 'solid',
				'description' => esc_html__( "Select the shape for your contact form inputs.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_border_color',
			[
				'label' => esc_html__( 'Input Fields Border Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'grey',
				'description' => esc_html__( "Select a border color for your contact form inputs.", 'impeka-elementor-extension' ),
				'condition' => [
					'inputs_borders' => [ 'solid', 'underline' ],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'focus_section',
			[
				'label' => esc_html__( 'Focus', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'input_focus_bg_color',
			[
				'label' => esc_html__( 'Input Fields Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'transparent', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Select the background color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_focus_text_color',
			[
				'label' => esc_html__( 'Input Fields Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Select a text color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_focus_placeholder_color',
			[
				'label' => esc_html__( 'Input Fields Placeholder Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Select a placeholder color for your contact form inputs.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'input_focus_border_color',
			[
				'label' => esc_html__( 'Input Fields Border Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( "Select a border color for your contact form inputs.", 'impeka-elementor-extension' ),
				'condition' => [
					'inputs_borders' => [ 'solid', 'underline' ],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'button_type',
			[
				'label' => esc_html__( 'Button Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'simple'  => esc_html__( 'Simple', 'impeka-elementor-extension' ),
					'outline'  => esc_html__( 'Outline', 'impeka-elementor-extension' ),
				],
				'default' => 'simple',
				'description' => esc_html__( "Select button type.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Button Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'primary-1',
				'description' => esc_html__( 'Color of the button.', 'impeka-elementor-extension' ),
				'condition' => [
					'button_type' => [ 'simple', 'outline' ],
				],
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__( 'Button Hover Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Hover color of the button.', 'impeka-elementor-extension' ),
				'condition' => [
					'button_type' => [ 'simple', 'outline' ],
				],
			]
		);

		$this->add_control(
			'button_size',
			[
				'label' => esc_html__( 'Button Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'extrasmall' => esc_html__( 'Extra Small', 'impeka-elementor-extension' ),
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extralarge' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( "Select button size.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'button_shape',
			[
				'label' => esc_html__( 'Button Shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'square',
				'options' => [
					'square' => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round' => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'extra-round' => esc_html__( 'Extra Round', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( "Select button shape.", 'impeka-elementor-extension' ),
				'condition' => [
					'button_type' => [ 'simple', 'outline' ],
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'custom-contact-form.php', array( 'atts' => $atts ) );
	}

}