<?php
/**
 * Impeka Elementor Empty Space Widget.
 *
 * Elementor widget that inserts an empty space into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Empty_Space_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_empty_space';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Empty Space', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-empty-space';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'height_multiplier',
			[
				'label' => esc_html__( 'Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1x' => '1x',
					'2x' => '2x',
					'3x' => '3x',
					'4x' => '4x',
					'5x' => '5x',
					'6x' => '6x',
					'custom' => esc_html__( 'Custom', 'impeka-elementor-extension' ),
				],
				'default' => '1x',
				'description' => esc_html__( 'Select empty space height.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'height',
			[
				'label' => esc_html__( 'Height Custom', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '32',
				'description' => esc_html__( 'Enter empty space height (Note: CSS measurement units allowed).', 'impeka-elementor-extension' ),
				'condition' => [
					'height_multiplier' => [ 'custom' ],
				],
			]
		);

		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'empty-space.php', array( 'atts' => $atts ) );
	}

}