<?php
/**
 * Impeka Elementor Icon Widget.
 *
 * Elementor widget that inserts an icon into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Icon_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_icon';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Icon', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'icon'  => esc_html__( 'Icon', 'impeka-elementor-extension' ),
					'theme-icon-svg'  => esc_html__( 'Theme SVG Icon', 'impeka-elementor-extension' ),
				),
				'default' => 'icon',
				'description' => esc_html__( "Select icon type.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'extra-large' => esc_html__( 'Extra Large', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'extra-small' => esc_html__( 'Extra Small', 'impeka-elementor-extension' ),
				],
				'default' => 'medium',
				'description' => esc_html__( "Select icon size.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control(
			'theme_icon',
			[
				'label' => esc_html__( 'Theme SVG Icon', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'arrow-1',
				'options' => impeka_elementor_ext_get_theme_icons(),
				'description' => esc_html__( "Select an svg icon.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_type' => [ 'theme-icon-svg' ],
				],
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_type' => [ 'icon' ],
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'standard', 'custom'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'icon_color_custom',
			[
				'label' => esc_html__( 'Custom Icon Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#000000',
				'description' => esc_html__( "Select a custom color for your icon", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'icon_shape',
			[
				'label' => esc_html__( 'Icon Shape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square', 'impeka-elementor-extension' ),
					'round'  => esc_html__( 'Round', 'impeka-elementor-extension' ),
					'circle'  => esc_html__( 'Circle', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Select icon shape.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'shape_type',
			[
				'label' => esc_html__( 'Shape Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'simple'  => esc_html__( 'Simple', 'impeka-elementor-extension' ),
					'outline'  => esc_html__( 'Outline', 'impeka-elementor-extension' ),
				),
				'default' => 'simple',
				'description' => esc_html__( "Select shape type.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);
		$this->add_control(
			'icon_shape_color',
			[
				'label' => esc_html__( 'Icon Shape Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard', 'custom'] ),
				'default' => 'grey',
				'description' => esc_html__( 'Select the color of your icon.', 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle' ],
				],
			]
		);
		$this->add_control(
			'icon_shape_color_custom',
			[
				'label' => esc_html__( 'Custom Icon Shape Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_1,
				],
				'default' => '#000000',
				'description' => esc_html__( "Select a custom color for your icon", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape_color' => [ 'custom' ],
				],
			]
		);
		$this->add_control(
			'icon_animation',
			[
				'label' => esc_html__( 'Enable Advanced Hover', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'condition' => [
					'icon_box_type' => [ 'top-icon' ],
				],
			]
		);
		$this->add_control(
			'loop_animation',
			[
				'label' => esc_html__( 'Icon Loop Animation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'animation-1'  => esc_html__( 'Pulse', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Select loop animation for your icon.", 'impeka-elementor-extension' ),
				'condition' => [
					'icon_shape' => [ 'square', 'round', 'circle'],
				],
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
			]
		);
		$this->add_control(
			'link_class',
			[
				'label' => esc_html__( 'Link Class', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter a class for your link.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();


	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();


		echo impeka_elementor_ext_locate_template( 'icon.php', array( 'atts' => $atts ) );
	}

}