<?php
/**
 * Impeka Elementor Image Carousel Widget.
 *
 * Elementor widget that inserts a image grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Image_Carousel_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_image_carousel';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Image Carousel', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-image-carousel';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'type',
			[
				'label' => esc_html__( 'Carousel Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'classic'  => esc_html__( 'Classic', 'impeka-elementor-extension' ),
					'advanced'  => esc_html__( 'Advanced', 'impeka-elementor-extension' ),
				],
				'default' => 'classic',
				'description' => esc_html__( "Select your Carousel Type.", 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'images_mode',
			[
				'label' => esc_html__( 'Images Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => esc_html__( 'Gallery Images', 'impeka-elementor-extension' ),
					'single' => esc_html__( 'Single Images', 'impeka-elementor-extension' ),

				],
				'default' => 'default',
				'description' => esc_html__( "Select how to add your images( Add images from gallery or add separate images with different settings for each image ).", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'img_ids',
			[
				'label' => esc_html__( 'Attach Images', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
				'show_label' => false,
				'dynamic' => [
					'active' => false,
				],
				'description' => esc_html__( "Select your gallery images.", 'impeka-elementor-extension' ),
				'condition' => [
					'images_mode' => [ 'default' ],
				],
			]
		);
		
		$this->add_control(
			'link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'popup' => esc_html__( 'Image Popup', 'impeka-elementor-extension' ),
					'none' => esc_html__( 'None', 'impeka-elementor-extension' ),
				),
				'default' => 'popup',
				'description' => esc_html__( "Choose the image link mode.", 'impeka-elementor-extension' ),
				'condition' => [
					'images_mode' => [ 'default' ],
				],
			]
		);
		$this->add_control(
			'image_popup_size',
			[
				'label' => esc_html__( 'Image Popup Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka-elementor-extension' ),
					'full' => esc_html__( 'Full', 'impeka-elementor-extension' ),
				),
				'default' => 'extra-extra-large',
				'description' => esc_html__( "Select size for your popup image.", 'impeka-elementor-extension' ),
				'condition' => [
					'images_mode' => [ 'default' ],
					'link_type' => [ 'popup' ],
				],
			]
		);
		
		$repeater = new \Elementor\Repeater();
	

		$repeater->add_control(
			'img',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your Image.", 'impeka-elementor-extension' ),
			]
		);
		$repeater->add_control(
			'img_link_type',
			[
				'label' => esc_html__( 'Link Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'popup' => esc_html__( 'Image Popup', 'impeka-elementor-extension' ),
					'video-popup' => esc_html__( 'Video Popup', 'impeka-elementor-extension' ),
					'custom-link' => esc_html__( 'Custom Link', 'impeka-elementor-extension' ),
					'none' => esc_html__( 'None', 'impeka-elementor-extension' ),
				),
				'default' => 'popup',
				'description' => esc_html__( "Choose the image link mode.", 'impeka-elementor-extension' ),
			]
		);
		
		$repeater->add_control(
			'img_popup_size',
			[
				'label' => esc_html__( 'Image Popup Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka-elementor-extension' ),
					'full' => esc_html__( 'Full', 'impeka-elementor-extension' ),
				),
				'default' => 'extra-extra-large',
				'description' => esc_html__( "Select size for your popup image.", 'impeka-elementor-extension' ),
				'condition' => [
					'img_link_type' => [ 'popup' ],
				],
			]
		);
		

		$repeater->add_control(
			'img_video_link',
			[
				'label' => esc_html__( 'Video Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'condition' => [
					'img_link_type' => [ 'video-popup' ],
				],
			]
		);
		$repeater->add_control(
			'img_link',
			[
				'label' => esc_html__( 'Image Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => false,
				],
				'placeholder' => 'https://your-link.com',
				'condition' => [
					'img_link_type' => [ 'custom-link' ],
				],
			]
		);
		$this->add_control(
			'single_image_ids',
			[
				'label' => esc_html__( 'Images', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => '',
					],
					[
						'image' => '',
					],
				],
				'description' => esc_html__( "Configure your images.", 'impeka-elementor-extension' ),
				'condition' => [
					'images_mode' => [ 'single' ],
				],
			]
		);
		
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					'square' => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape' => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'impeka-elementor-extension' ),
					'portrait' => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'portrait-medium' => esc_html__( 'Portrait Medium Crop', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => 'landscape',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);
		
		$this->add_control(
			'item_gutter',
			[
				'label' => esc_html__( 'Gutter between items', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'type' => [ 'classic' ],
				],
			]
		);
		$this->add_control(
			'gutter_size',
			[
				'label' => esc_html__( 'Gutter Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '30',
				'condition' => [
					'item_gutter' => [ 'yes' ],
				],
			]
		);		

		$this->add_control(
			'items_per_page',
			[
				'label' => esc_html__( 'Items per page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '4',
				'description' => esc_html__( "Number of items per page", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_tablet_landscape',
			[
				'label' => esc_html__( 'Items Tablet Landscape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, landscape orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_tablet_portrait',
			[
				'label' => esc_html__( 'Items Tablet Portrait', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, portrait orientation.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_mobile',
			[
				'label' => esc_html__( 'Items Mobile', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
				],
				'default' => '1',
				'description' => esc_html__( "Select number of items on mobile devices.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'items_to_show',
			[
				'label' => esc_html__( 'Items to show', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '12',
				'description' => esc_html__( "Maximum Items to Show", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Titles & Hovers', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title_caption',
			[
				'label' => esc_html__( 'Image Title & Description Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'title-caption' => esc_html__( 'Title and Description' , 'impeka-elementor-extension' ),
					'title-only' => esc_html__( 'Title Only' , 'impeka-elementor-extension' ),
					'caption-only' => esc_html__( 'Description Only' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Define the visibility for your title - description.', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);
		
		$this->add_control(
			'title_heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
				],
				'default' => 'h4',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		
		$this->add_control(
			'title_custom_font_family',
			[
				'label' => esc_html__( 'Title Custom Font Family', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'Same as Typography', 'impeka-elementor-extension' ),
					'custom-font-1' => esc_html__( 'Custom Font Family 1', 'impeka-elementor-extension' ),
					'custom-font-2' => esc_html__( 'Custom Font Family 2', 'impeka-elementor-extension' ),
					'custom-font-3' => esc_html__( 'Custom Font Family 3', 'impeka-elementor-extension' ),
					'custom-font-4' => esc_html__( 'Custom Font Family 4', 'impeka-elementor-extension' ),


				],
				'default' => '',
				'description' => esc_html__( 'Select a different font family, defined in Theme Options - Typography Options - Extras - Custom Font Family', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Description/Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'default',
				'description' => esc_html__( 'Choose the description /text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'title_caption' => [ 'title-caption', 'title-only'],
				],
			]
		);
		
		$this->add_control(
			'hover_style',
			[
				'label' => esc_html__( 'Hover Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Text below image' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Split text on hover' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Text on media' , 'impeka-elementor-extension' ),
					'style-6' => esc_html__( 'Mouse move effect' , 'impeka-elementor-extension' ),
					'style-7' => esc_html__( 'Gradient Overlay' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your image style', 'impeka-elementor-extension' ),
				'default' => 'style-1',
			]
		);
		
		$this->add_control(
			'image_effect',
			[
				'label' => esc_html__( 'Image Effect', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'grayscale-image' => esc_html__( 'Grayscale Image' , 'impeka-elementor-extension' ),
					'grayscale-image-hover' => esc_html__( 'Colored on Hover' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the grayscale effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['primary', 'gradient', 'standard', 'dominant'] ),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'black',
				'conditions' => [
					'terms' => [
						[ 'name' => 'hover_style', 'operator' => '!in', 'value' => [ 'style-7' ] ],
					],
				],
			]
		);
		

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the overlay opacity ', 'impeka-elementor-extension' ),
				'default' => '30',
			]
		);
		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );
				
		$this->end_controls_section();

		//Navigation
		$this->start_controls_section(
			'navigation_pagination_section',
			[
				'label' => esc_html__( 'Navigation & Pagination', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_behavior',
			[
				'label' => esc_html__( 'Behavior', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'loop', impeka_elementor_ext_add_loop() );
		$this->add_control( 'auto_play', impeka_elementor_ext_add_auto_play() );
		$this->add_control( 'slideshow_speed', impeka_elementor_ext_add_slideshow_speed() );
		$this->add_control( 'pause_hover', impeka_elementor_ext_add_pause_hover() );
		
		$this->add_control(
			'label_navigation',
			[
				'label' => esc_html__( 'Navigation', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'nav_visibility', impeka_elementor_ext_add_nav_visibility() );
		$this->add_control( 'nav_icon', impeka_elementor_ext_add_nav_icon() );
		$this->add_control( 'nav_icon_color', impeka_elementor_ext_add_nav_icon_color() );
		$this->add_control( 'nav_shape', impeka_elementor_ext_add_nav_shape() );
		$this->add_control( 'nav_shape_type', impeka_elementor_ext_add_nav_shape_type() );
		$this->add_control( 'nav_shape_color', impeka_elementor_ext_add_nav_shape_color() );

		$this->add_control(
			'label_pagination',
			[
				'label' => esc_html__( 'Pagination', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control( 'pagination', impeka_elementor_ext_add_pagination() );
		$this->add_control( 'pagination_speed', impeka_elementor_ext_add_pagination_speed() );
		
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'image-carousel.php', array( 'atts' => $atts ) );
	}

}