<?php
/**
 * Impeka Elementor Image Text Widget.
 *
 * Elementor widget that inserts an element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Image_Text_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_image_text';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Image Text', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-image-text';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image_text_style',
			[
				'label' => esc_html__( 'Image Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'style-1' => esc_html__( 'Style 1', 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Style 2', 'impeka-elementor-extension' ),
				),
				'default' => 'style-1',
				'description' => esc_html__( "Select your image text style.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_mode',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'square'  => esc_html__( 'Square Small Crop', 'impeka-elementor-extension' ),
					'landscape'  => esc_html__( 'Landscape Small Crop', 'impeka-elementor-extension' ),
					'portrait'  => esc_html__( 'Portrait Small Crop', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'retina_image',
			[
				'label' => esc_html__( 'Retina Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select a 2x image.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_mode' => [ '' ],
				],
			]
		);
		$this->add_control(
			'image_load_mode',
			[
				'label' => esc_html__( 'Image Load Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Inherit', 'impeka-elementor-extension' ),
					'off' => esc_html__( 'Off', 'impeka-elementor-extension' ),
					'native-lazyload' => esc_html__( 'Native Lazyload', 'impeka-elementor-extension' ),
					'lazyload' => esc_html__( 'Theme Lazyload', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Enable Lazy load.", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'image_text_align',
			[
				'label' => esc_html__( 'Image Position', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
					'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),

				],
				'default' => 'left',
				'description' => esc_html__( 'Set the position of your image', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'radius',
			[
				'label' => esc_html__( 'Border Radius', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'3' => esc_html__( 'Radius 3px' , 'impeka-elementor-extension' ),
					'5' => esc_html__( 'Radius 5px' , 'impeka-elementor-extension' ),
					'10' => esc_html__( 'Radius 10px' , 'impeka-elementor-extension' ),
					'15' => esc_html__( 'Radius 15px' , 'impeka-elementor-extension' ),
					'20' => esc_html__( 'Radius 20px' , 'impeka-elementor-extension' ),
					'25' => esc_html__( 'Radius 25px' , 'impeka-elementor-extension' ),
					'30' => esc_html__( 'Radius 30px' , 'impeka-elementor-extension' ),
					'35' => esc_html__( 'Radius 35px' , 'impeka-elementor-extension' ),
					'circle' => esc_html__( 'Circle' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your border radius', 'impeka-elementor-extension' ),
				'default' => 'none',
			]
		);

		$this->add_control(
			'popup_mode',
			[
				'label' => esc_html__( 'Popup Mode', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'image' => esc_html__( 'Image Popup' , 'impeka-elementor-extension' ),
					'video' => esc_html__( 'Video Popup' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select the popup mode', 'impeka-elementor-extension' ),
				'default' => 'none',
				'condition' => [
					'image_text_style' => [ 'style-1'],
				],
			]
		);
		$this->add_control(
			'image_popup_size',
			[
				'label' => esc_html__( 'Image Popup Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka-elementor-extension' ),
					'full' => esc_html__( 'Full', 'impeka-elementor-extension' ),
				),
				'default' => 'extra-extra-large',
				'description' => esc_html__( "Select size for your popup image.", 'impeka-elementor-extension' ),
				'condition' => [
					'image_text_style' => [ 'style-1'],
					'popup_mode' => [ 'image'],
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Sample Title',
				'description' => esc_html__( 'Enter your title.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => 'Sample Text',
				'description' => esc_html__( 'Enter your text', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'page-description' => esc_html__( 'Page Description', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'content_align',
			[
				'label' => esc_html__( 'Content Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
					'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),

				],
				'default' => 'left',
				'description' => esc_html__( 'Set the alignment of your content', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Button Section
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		impeka_elementor_ext_get_button_params( $this );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'image-text.php', array( 'atts' => $atts ) );
	}

}