<?php
/**
 * Impeka Elementor Pricing Table Widget.
 *
 * Elementor widget that inserts a gallery grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Pricing_Table_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_pricing_table';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Pricing Table', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-pricing-table';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Pricing Table Layout', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'layout-1'  => esc_html__( 'Layout 1', 'impeka-elementor-extension' ),
					'layout-2'  => esc_html__( 'Layout 2', 'impeka-elementor-extension' ),
				),
				'default' => 'layout-1',
				'description' => esc_html__( "Select your pricing table layout", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'price',
			[
				'label' => esc_html__( 'Price', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '$0',
				'description' => esc_html__( "Enter your price here. eg $80 or 80€.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'heading_tag',
			[
				'label' => esc_html__( 'Price Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Price Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
			]
		);

		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Price Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'default' => 'h3',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control( 'increase_heading_reset', impeka_elementor_ext_add_increase_heading_reset() );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'interval',
			[
				'label' => esc_html__( 'Interval', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '/month',
				'description' => esc_html__( "Enter interval period here. e.g: /month, per month, per year.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Title',
				'description' => esc_html__( "Enter your title here.", 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'default' => 'h6',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( "Enter your description here.", 'impeka-elementor-extension' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'value1',
			[
				'label' => esc_html__( 'First Value', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$repeater->add_control(
			'value2',
			[
				'label' => esc_html__( 'Second Value', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$this->add_control(
			'pricing_lines_data',
			[
				'label' => esc_html__( 'Attributes', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'value1' => '100',
						'value2' => 'Users',
					],
					[
						'value1' => '8 Gig',
						'value2' => 'Disc Space',
					],
					[
						'value1' => 'Unlimited',
						'value2' => 'Data Transfer',
					],
				],
				'description' => esc_html__( "Configure your attributes.", 'impeka-elementor-extension' ),
				'condition' => [
					'layout' => [ 'layout-1' ],
				],
			]
		);

		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles',
			[
				'label' => esc_html__( 'Styles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Price Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Choose the price color.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'content_bg',
			[
				'label' => esc_html__( 'Content Background', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['none', 'primary', 'gradient', 'standard'] ),
				'default' => 'white',
				'description' => esc_html__( 'Select background color for your pricing table.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'border',
			[
				'label' => esc_html__( 'Border', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					''  => esc_html__( 'None', 'impeka-elementor-extension' ),
					'top-border'  => esc_html__( 'Top Border', 'impeka-elementor-extension' ),
					'bottom-border'  => esc_html__( 'Bottom Border', 'impeka-elementor-extension' ),
				),
				'default' => '',
				'description' => esc_html__( "Select your pricing table layout", 'impeka-elementor-extension' ),
				'condition' => [
					'layout' => [ 'layout-2' ],
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['none', 'primary', 'gradient', 'standard'] ),
				'default' => 'primary-1',
				'description' => esc_html__( 'Select background color for your pricing table.', 'impeka-elementor-extension' ),
				'conditions' => [
					'terms' => [
						[ 'name' => 'border', 'operator' => '!in', 'value' => [ '' ] ],
					],
				],
			]
		);

		$this->add_control( 'shadow',
			[
				'label' => esc_html__( 'Shadow', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None' , 'impeka-elementor-extension' ),
					'small-shadow' => esc_html__( 'Small' , 'impeka-elementor-extension' ),
					'medium-shadow' => esc_html__( 'Medium' , 'impeka-elementor-extension' ),
					'large-shadow' => esc_html__( 'Large' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your shadow', 'impeka-elementor-extension' ),
				'default' => '',
				'conditions' => [
					'terms' => [
						[ 'name' => 'content_bg', 'operator' => '!in', 'value' => [ 'none' ] ],
					],
				],
			]
		);
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );
		$this->end_controls_section();

		//Button Section
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		impeka_elementor_ext_get_button_params( $this );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );

		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'pricing-table.php', array( 'atts' => $atts ) );
	}

}