<?php
/**
 * Impeka Elementor Split Content Widget.
 *
 * Elementor widget that inserts an element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Split_Content_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_split_content';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Split Content', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-split-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Sample Title',
				'description' => esc_html__( 'Enter your title.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control( 'increase_heading_reset', impeka_elementor_ext_add_increase_heading_reset() );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );
		$this->add_control(
			'split_title',
			[
				'label' => esc_html__( 'Split Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				"description" => esc_html__( "Split Title", "impeka-elementor-extension" ),
			]
		);		
		$this->add_control(
			'split_title_space',
			[
				'label' => esc_html__( 'Split Title Space', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Split Title Space', 'impeka-elementor-extension' ),
				'default' => 'small',
				'condition' => [
					'split_title' => [ 'yes' ],
				],
			]
		);		
		$this->add_control(
			'content',
			[
				'label' => esc_html__( 'Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => 'Sample Text',
				'description' => esc_html__( "Enter your text", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'page-description' => esc_html__( 'Page Description', 'impeka-elementor-extension' ),
				],
				'default' => '',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'split_content_height',
			[
				'label' => esc_html__( 'Split Content Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'fullscreen' => esc_html__( 'Fullscreen', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Large', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Medium', 'impeka-elementor-extension' ),
					'small' => esc_html__( 'Small', 'impeka-elementor-extension' ),
				],
				'default' => 'fullscreen',
			]
		);	
		

		$this->add_control(
			'min_height',
			[
				'label' => esc_html__( 'Split Content Min Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '300',
			]
		);
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Media Section
		$this->start_controls_section(
			'media_section',
			[
				'label' => esc_html__( 'Media', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'media_type',
			[
				'label' => esc_html__( 'Media Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'impeka-elementor-extension' ),
					'slider' => esc_html__( 'Slider', 'impeka-elementor-extension' ),
					'hosted_video' => esc_html__( 'Hosted Video', 'impeka-elementor-extension' ),
					'video' => esc_html__( 'YouTube Video', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your Media Type.', 'impeka-elementor-extension' ),
				'default' => 'image',
			]
		);
		
		$this->add_control(
			'bg_video_url',
			[
				'label' => esc_html__( 'Video Link', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'https://www.youtube.com/watch?v=0s4_7BuszuQ',
				'description' => esc_html__( "Type a YouTube URL.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'video' ],
				],
			]
		);
		$this->add_control(
			'video_mp4',
			[
				'label' => esc_html__( 'MP4 File URL', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .mp4 format URL', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'hosted_video' ],
				],
			]
		);
		$this->add_control(
			'video_webm',
			[
				'label' => esc_html__( 'WebM File URL ( optional )', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .webm format for browser compatibility.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'hosted_video' ],
				],
			]
		);
		$this->add_control(
			'video_ogv',
			[
				'label' => esc_html__( 'OGV File URL ( optional )', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Fill .ogg format for browser compatibility.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'hosted_video' ],
				],
			]
		);
		$this->add_control(
			'bg_video_device',
			[
				'label' => esc_html__( 'Allow on devices', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'media_type' => [ 'hosted_video' ],
				],
			]
		);
		$this->add_control(
			'bg_image',
			[
				'label' => esc_html__( 'Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => false,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( "Select your image. Used also as fallback for video.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'video', 'hosted_video' ],
				],
			]
		);
		$this->add_control(
			'img_ids',
			[
				'label' => esc_html__( 'Attach Images', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
				'show_label' => false,
				'dynamic' => [
					'active' => false,
				],
				'description' => esc_html__( "Select your slider images.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'slider' ],
				],
			]
		);
		$this->add_control(
			'bg_image_size',
			[
				'label' => esc_html__( 'Image Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => apply_filters( 'impeka_elementor_ext_image_options', array(
					''  => esc_html__( 'Full', 'impeka-elementor-extension' ),
					'large' => esc_html__( 'Resize ( Large )', 'impeka-elementor-extension' ),
					'medium_large' => esc_html__( 'Resize ( Medium Large )', 'impeka-elementor-extension' ),
					'medium' => esc_html__( 'Resize ( Medium )', 'impeka-elementor-extension' ),
				) ),
				'default' => '',
				'description' => esc_html__( "Select your Image Size.", 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'image', 'slider' ],
				],
			]
		);		

		$this->add_control(
			'loop',
			[
				'label' => esc_html__( 'Loop', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'media_type' => [ 'slider' ],
				],
			]
		);
		$this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Autoplay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'media_type' => [ 'slider' ],
				],
			]
		);
		$this->add_control(
			'slideshow_speed',
			[
				'label' => esc_html__( 'Slideshow Speed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '3000',
				'description' => esc_html__( 'Slideshow Speed in ms.', 'impeka-elementor-extension' ),
				'condition' => [
					'media_type' => [ 'slider' ],
				],
			]
		);
		$this->add_control(
			'transition',
			[
				'label' => esc_html__( 'Transition', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'slide' => esc_html__( 'Slide' , 'impeka-elementor-extension' ),
					'fade' => esc_html__( 'Fade' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Transition Effect.', 'impeka-elementor-extension' ),
				'default' => 'slide',
				'condition' => [
					'media_type' => [ 'slider' ],
				],
			]
		);
		$this->add_control(
			'bg_position',
			[
				'label' => esc_html__( 'Background  Position', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left-top' => esc_html__( 'Left Top' , 'impeka-elementor-extension' ),
					'left-center' => esc_html__( 'Left Center' , 'impeka-elementor-extension' ),
					'left-bottom' => esc_html__( 'Left Bottom' , 'impeka-elementor-extension' ),
					'center-top' => esc_html__( 'Center Top' , 'impeka-elementor-extension' ),
					'center-center' => esc_html__( 'Center Center' , 'impeka-elementor-extension' ),
					'center-bottom' => esc_html__( 'Center Bottom' , 'impeka-elementor-extension' ),
					'right-top' => esc_html__( 'Right Top' , 'impeka-elementor-extension' ),
					'right-center' => esc_html__( 'Right Center' , 'impeka-elementor-extension' ),
					'right-bottom' => esc_html__( 'Right Bottom' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select position for background image.', 'impeka-elementor-extension' ),
				'default' => 'left-top',
				'condition' => [
					'media_type' => [ 'image', 'slider' ],
				],
			]
		);		
		$this->add_control(
			'split_content_align',
			[
				'label' => esc_html__( 'Media  Position', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left' , 'impeka-elementor-extension' ),
					'right' => esc_html__( 'Right' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Set the position of your media.', 'impeka-elementor-extension' ),
				'default' => 'left',
			]
		);		
			
		
		$this->add_control(
			'overlay_color',
			[
				'label' => esc_html__( 'Overlay Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'black',
			]
		);

		$this->add_control(
			'overlay_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'0' => esc_html__( '0%', 'impeka-elementor-extension' ),
					'10' => esc_html__( '10%', 'impeka-elementor-extension' ),
					'20' => esc_html__( '20%', 'impeka-elementor-extension' ),
					'30' => esc_html__( '30%', 'impeka-elementor-extension' ),
					'40' => esc_html__( '40%', 'impeka-elementor-extension' ),
					'50' => esc_html__( '50%', 'impeka-elementor-extension' ),
					'60' => esc_html__( '60%', 'impeka-elementor-extension' ),
					'70' => esc_html__( '70%', 'impeka-elementor-extension' ),
					'80' => esc_html__( '80%', 'impeka-elementor-extension' ),
					'90' => esc_html__( '90%', 'impeka-elementor-extension' ),
					'100' => esc_html__( '100%', 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Choose the opacity for the overlay.', 'impeka-elementor-extension' ),
				'default' => '70',
			]
		);
		$this->add_control(
			'overlapping_title_color',
			[
				'label' => esc_html__( 'Overlapping Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'description' => esc_html__( 'Choose the image color overlay.', 'impeka-elementor-extension' ),
				'default' => 'primary-1',
			]
		);		
		$this->end_controls_section();
		
		//Button Section
		$this->start_controls_section(
			'button_section',
			[
				'label' => esc_html__( 'Button', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		impeka_elementor_ext_get_button_params( $this );
		$this->end_controls_section();		

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'split-content.php', array( 'atts' => $atts ) );
	}

}