<?php
/**
 * Impeka Elementor Testimonial Carousel Widget.
 *
 * Elementor widget that inserts a testimonial grid into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Testimonial_Carousel_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_testimonial_carousel';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Testimonial Carousel', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-testimonial-carousel';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'style',
			[
				'label' => esc_html__( 'Testimonial Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'style-1' => esc_html__( 'Style 1 ( Classic )' , 'impeka-elementor-extension' ),
					'style-2' => esc_html__( 'Style 2 ( Classic )' , 'impeka-elementor-extension' ),
					'style-3' => esc_html__( 'Style 3 ( Classic )' , 'impeka-elementor-extension' ),
					'style-4' => esc_html__( 'Style 4' , 'impeka-elementor-extension' ),
					'style-5' => esc_html__( 'Style 5' , 'impeka-elementor-extension' ),
				],
				'description' => esc_html__( 'Select your testimonial style', 'impeka-elementor-extension' ),
				'default' => 'style-1',
			]
		);
		$this->add_control(
			'type',
			[
				'label' => esc_html__( 'Carousel Type', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'classic'  => esc_html__( 'Classic', 'impeka-elementor-extension' ),
					'advanced'  => esc_html__( 'Advanced', 'impeka-elementor-extension' ),
				],
				'default' => 'classic',
				'description' => esc_html__( "Select your Carousel Type.", 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'items_per_page',
			[
				'label' => esc_html__( 'Items per page', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'default' => '4',
				'description' => esc_html__( "Number of items per page", 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'items_tablet_landscape',
			[
				'label' => esc_html__( 'Items Tablet Landscape', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, landscape orientation.", 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'items_tablet_portrait',
			[
				'label' => esc_html__( 'Items Tablet Portrait', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				],
				'default' => '3',
				'description' => esc_html__( "Select number of items on tablet devices, portrait orientation.", 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'items_mobile',
			[
				'label' => esc_html__( 'Items Mobile', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
				],
				'default' => '1',
				'description' => esc_html__( "Select number of items on mobile devices.", 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'item_gutter',
			[
				'label' => esc_html__( 'Gutter between items', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
					'type' => [ 'classic' ],
				],
			]
		);
		$this->add_control(
			'gutter_size',
			[
				'label' => esc_html__( 'Gutter Size', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '30',
				'condition' => [
					'item_gutter' => [ 'yes' ],
				],
			]
		);
		$this->add_control(
			'items_to_show',
			[
				'label' => esc_html__( 'Items to show', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '20',
				'description' => esc_html__( "Maximum Items to Show", 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'order_by', impeka_elementor_ext_add_order_by() );
		$this->add_control( 'order', impeka_elementor_ext_add_order() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Styles Section
		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Styles & Titles', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Show Item Title', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No' , 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes' , 'impeka-elementor-extension' ),
				],
				'default' => 'yes',
			]
		);

		$this->add_control(
			'heading_tag',
			[
				'label' => esc_html__( 'Title Tag', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'div' => 'div',
				],
				'description' => esc_html__( 'Title Tag for SEO', 'impeka-elementor-extension' ),
				'default' => 'h3',
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'heading',
			[
				'label' => esc_html__( 'Title Size/Typography', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'h1' => 'h1',
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'link-text' => esc_html__( 'Link Text', 'impeka-elementor-extension' ),
					'page-title' => esc_html__( 'Page Title', 'impeka-elementor-extension' ),
					'feature-title' => esc_html__( 'Feature Title', 'impeka-elementor-extension' ),
				],
				'default' => 'h3',
				'description' => esc_html__( 'Title size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'impeka-elementor-extension' ),
					'leader-text' => esc_html__( 'Leader Text', 'impeka-elementor-extension' ),
					'subtitle-text' => esc_html__( 'Subtitle Text', 'impeka-elementor-extension' ),
					'small-text' => esc_html__( 'Small Text', 'impeka-elementor-extension' ),
					'quote-text' => esc_html__( 'Quote Text', 'impeka-elementor-extension' ),
				],
				'default' => 'none',
				'description' => esc_html__( 'Text size and typography, defined in Theme Options - Typography Options', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'black',
				'description' => esc_html__( 'Choose the title color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['default', 'primary', 'standard'] ),
				'default' => 'black',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array(),
				'default' => 'white',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
				'condition' => [
					'style' => [ 'style-4', 'style-5' ],
				],
			]
		);
		$this->add_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'left' => esc_html__( 'Left', 'impeka-elementor-extension' ),
					'right' => esc_html__( 'Right', 'impeka-elementor-extension' ),
					'center' => esc_html__( 'Center', 'impeka-elementor-extension' ),
				],
				'default' => 'left',
				'conditions' => [
					'terms' => [
						[ 'name' => 'style', 'operator' => '!in', 'value' => [ 'style-4', 'style-5' ] ],
					],
				],
			]
		);

		$this->add_control(
			'show_image',
			[
				'label' => esc_html__( 'Show Featured Image', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'no' => esc_html__( 'No' , 'impeka-elementor-extension' ),
					'yes' => esc_html__( 'Yes' , 'impeka-elementor-extension' ),
				],
				'default' => 'yes',
				'conditions' => [
					'terms' => [
						[ 'name' => 'style', 'operator' => '!in', 'value' => [ 'style-4', 'style-5' ] ],
					],
				],
			]
		);
		$this->add_control( 'shadow', impeka_elementor_ext_add_shadow() );
		$this->add_control( 'radius', impeka_elementor_ext_add_radius() );

		$this->end_controls_section();

		//Navigation
		$this->start_controls_section(
			'navigation_pagination_section',
			[
				'label' => esc_html__( 'Navigation & Pagination', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label_behavior',
			[
				'label' => esc_html__( 'Behavior', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'loop',
			[
				'label' => esc_html__( 'Loop', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Autoplay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'slideshow_speed',
			[
				'label' => esc_html__( 'Slideshow Speed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '3000',
				'description' => esc_html__( 'Slideshow Speed in ms ( Only available for Classic Carousel ).', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'auto_height',
			[
				'label' => esc_html__( 'Auto Height', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__( 'Select if you want smooth auto height', 'impeka-elementor-extension' ),
			]
		);	
		$this->add_control(
			'pause_hover',
			[
				'label' => esc_html__( 'Pause on Hover', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'no',
				'description' => esc_html__( 'If selected, carousel will be paused on hover ( Only available for Classic Carousel ).', 'impeka-elementor-extension' ),
			]
		);		
		$this->add_control(
			'pagination',
			[
				'label' => esc_html__( 'Pagination Visibility', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'pagination_speed',
			[
				'label' => esc_html__( 'Pagination Speed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '400',
				'description' => esc_html__( 'Pagination Speed in ms ( Only available for Classic Carousel ).', 'impeka-elementor-extension' ),
				'condition' => [
					'pagination' => [ 'yes' ],
				],
			]
		);
		$this->end_controls_section();

		//Categories
		$this->start_controls_section(
			'categories_section',
			[
				'label' => esc_html__( 'Categories', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'exclude_posts',
			[
				'label' => esc_html__( 'Exclude Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the post ids you want to exclude separated by comma ( , ).', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'categories',
			[
				'label' => esc_html__( 'Testimonial Categories', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => impeka_elementor_ext_get_post_categories( 'testimonial_category' ),
				"description" => esc_html__( 'Select all or multiple categories, leave empty for all.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->add_control(
			'include_posts',
			[
				'label' => esc_html__( 'Include Specific Posts', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ). Note: If you define specific post ids, Exclude Posts and Categories will have no effect.', 'impeka-elementor-extension' ),
				'default' => '',
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();
		echo impeka_elementor_ext_locate_template( 'testimonial-carousel.php', array( 'atts' => $atts ) );
	}

}