<?php
/**
 * Impeka Elementor Typed Text Widget.
 *
 * Elementor widget that inserts a typed text element into the page.
 *
 * @since 1.0.0
 */
class Impeka_Elementor_Typed_Text_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'impeka_typed_text';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Impeka Typed Text', 'impeka-elementor-extension' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'impeka-typed-text';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'impeka' ];
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'general_section',
			[
				'label' => esc_html__( 'General', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'typed_prefix',
			[
				'label' => esc_html__( 'Prefix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter prefix text.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'typed_values',
			[
				'label' => esc_html__( 'Typed Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => 'Sample Text;Use your own values!',
				'description' => "Text separator is <b>;</b> for example: <strong>Sample text;new value</strong> which will create new values at ;",
			]
		);

		$this->add_control(
			'typed_suffix',
			[
				'label' => esc_html__( 'Suffix', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_html__( 'Enter suffix text.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control( 'heading_tag', impeka_elementor_ext_add_heading_tag( 'h3' ) );
		$this->add_control( 'heading', impeka_elementor_ext_add_heading( 'h3' ) );
		$this->add_control( 'increase_heading', impeka_elementor_ext_add_increase_heading() );
		$this->add_control( 'increase_heading_reset', impeka_elementor_ext_add_increase_heading_reset() );
		$this->add_control( 'custom_font_family', impeka_elementor_ext_add_custom_font_family() );

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Typed Text Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['inherit', 'primary', 'standard'] ),
				'default' => 'inherit',
				'description' => esc_html__( 'Choose the text color.', 'impeka-elementor-extension' ),
			]
		);

		$this->add_control(
			'text_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => impeka_elementor_ext_get_color_array( ['none', 'primary', 'standard'] ),
				'default' => 'none',
				'description' => esc_html__( 'Background color for the typed text.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_responsive_control( 'align', impeka_elementor_ext_add_responsive_align() );
		$this->add_control( 'margin_bottom', impeka_elementor_ext_add_margin_bottom() );
		$this->add_control( 'el_class', impeka_elementor_ext_add_el_class() );
		$this->end_controls_section();

		//Animation Section
		$this->start_controls_section(
			'animation_section',
			[
				'label' => esc_html__( 'Animation', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control( 'grve_animation', impeka_elementor_ext_add_animation() );
		$this->add_control( 'grve_animation_delay', impeka_elementor_ext_add_animation_delay() );
		$this->add_control( 'grve_animation_duration', impeka_elementor_ext_add_animation_duration() );
		$this->end_controls_section();

		//Extra Section
		$this->start_controls_section(
			'extra_section',
			[
				'label' => esc_html__( 'Extra Settings', 'impeka-elementor-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'textspeed',
			[
				'label' => esc_html__( 'Text Speed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '100',
				'description' => esc_html__( 'Enter text speed in ms.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'backspeed',
			[
				'label' => esc_html__( 'Backspeed', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '80',
				'description' => esc_html__( 'Enter speed of delete in ms.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'startdelay',
			[
				'label' => esc_html__( 'Start Delay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '0',
				'description' => esc_html__( 'Enter start delay in ms.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'backdelay',
			[
				'label' => esc_html__( 'Back Delay', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '500',
				'description' => esc_html__( 'Enter back delay in ms.', 'impeka-elementor-extension' ),
			]
		);
		$this->add_control(
			'loop',
			[
				'label' => esc_html__( 'Loop', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_cursor',
			[
				'label' => esc_html__( 'Show Cursor', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'impeka-elementor-extension' ),
				'label_off' => esc_html__( 'No', 'impeka-elementor-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'cursor_text',
			[
				'label' => esc_html__( 'Cursor Text', 'impeka-elementor-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '|',
				'description' => esc_html__( 'Enter cursor text.', 'impeka-elementor-extension' ),
			]
		);
		$this->end_controls_section();

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		echo impeka_elementor_ext_locate_template( 'typed-text.php', array( 'atts' => $atts ) );
	}

}