<?php
/**
 * Greatives Social List Networking
 * A widget that displays social networking links.
 * @author		Greatives Team
 * @URI			http://greatives.eu
 */

class Impeka_Ext_Widget_Social_List extends WP_Widget {

	function __construct() {
		$widget_ops = array(
			'classname' => 'grve-widget grve-element grve-social-list',
			'description' => esc_html__( 'A widget that displays social list networking links', 'impeka-extension' ),
		);
		$control_ops = array(
			'width' => 400,
			'height' => 600,
			'id_base' => 'grve-widget-social-list',
		);
		parent::__construct( 'grve-widget-social-list', '(Greatives) ' . esc_html__( 'List Social Networking', 'impeka-extension' ), $widget_ops, $control_ops );
	}

	function impeka_ext_widget_social_list() {
		$this->__construct();
	}

	function widget( $args, $instance ) {

		global $impeka_grve_social_list_extended;

		//Our variables from the widget settings.
		extract( $args );

		echo wp_kses( $before_widget, impeka_ext_get_widget_allowed_html() );

		// Display the widget title
		$title = impeka_ext_array_value( $instance, 'title' );
		$title = apply_filters( 'widget_title', $title );
		if ( $title ) {
			echo wp_kses( $before_title, impeka_ext_get_widget_allowed_html() ) . esc_html( $title ) . wp_kses( $after_title, impeka_ext_get_widget_allowed_html() );
		}

		$list_type = impeka_ext_array_value( $instance, 'list_type', 'vertical' );
		$font_size = impeka_ext_array_value( $instance, 'font_size', 'link-text' );
		$list_align = impeka_ext_array_value( $instance, 'list_align', 'left' );

		$social_list_classes = array();
		$social_list_classes[] = 'grve-' . $list_type;
		if( 'left' != $list_align ) {
			$social_list_classes[] = 'grve-align-' . $list_align;
		}
		$social_list_class_string = implode( ' ', $social_list_classes );

		$social_font_size_classes = array();
		$social_font_size_classes[] = 'grve-' . $font_size;
		$social_font_size_class_string = implode( ' ', $social_font_size_classes );

	?>

		<ul class="<?php echo esc_attr( $social_list_class_string ); ?>">
		<?php
		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {

				$social_item_url = impeka_ext_array_value( $instance, $social_item['url'] );

				if ( ! empty( $social_item_url ) ) {

					if ( 'skype' == $social_item['id'] ) {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url, array( 'skype', 'http', 'https' ) ); ?>" class="<?php echo esc_attr( $social_font_size_class_string ); ?>">
							<span><?php echo esc_attr( $social_item['title'] ); ?></span>
						</a>
					</li>
		<?php
					} else {
		?>
					<li>
						<a href="<?php echo esc_url( $social_item_url ); ?>" class="<?php echo esc_attr( $social_font_size_class_string ); ?>" target="_blank">
							<span><?php echo esc_attr( $social_item['title'] ); ?></span>
						</a>
					</li>
		<?php
					}
				}
			}
		}
		?>
		</ul>


	<?php

		echo wp_kses( $after_widget, impeka_ext_get_widget_allowed_html() );
	}

	//Update the widget

	function update( $new_instance, $old_instance ) {

		global $impeka_grve_social_list_extended;
		$instance = $old_instance;

		//Strip tags from title to remove HTML
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['list_type'] = strip_tags( $new_instance['list_type'] );
		$instance['font_size'] = strip_tags( $new_instance['font_size'] );
		$instance['list_align'] = strip_tags( $new_instance['list_align'] );

		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {
				$instance[ $social_item['url'] ] = strip_tags( $new_instance[ $social_item['url'] ] );
			}
		}

		return $instance;
	}

	function form( $instance ) {

		global $impeka_grve_social_list_extended;

		//Set up some default widget settings.
		$defaults = array(
			'title' => '',
			'list_type' => 'vertical',
			'font_size' => 'link-text',
			'list_align' => 'left',
		);

		$instance = wp_parse_args( (array) $instance, $defaults );

		$list_type = impeka_ext_array_value( $instance, 'list_type');
		$font_size = impeka_ext_array_value( $instance, 'font_size');
		$list_align = impeka_ext_array_value( $instance, 'list_align');

		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo esc_html__( 'Title:', 'impeka-extension' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'list_type' ) ); ?>"><?php echo esc_html__( 'List Type:', 'impeka-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'list_type' ) ); ?>" style="width:100%;">
				<option value="vertical" <?php selected( "vertical", $list_type ); ?>><?php echo esc_html__( 'Vertical', 'impeka-extension' ); ?></option>
				<option value="horizontal" <?php selected( "horizontal", $list_type ); ?>><?php echo esc_html__( 'Horizontal', 'impeka-extension' ); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'font_size' ) ); ?>"><?php echo esc_html__( 'Font Size:', 'impeka-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'font_size' ) ); ?>" style="width:100%;">
				<option value="link-text" <?php selected( "link-text", $font_size ); ?>><?php echo esc_html__( 'Link Text', 'impeka-extension' ); ?></option>
				<option value="small-text" <?php selected( "small-text", $font_size ); ?>><?php echo esc_html__( 'Small Text', 'impeka-extension' ); ?></option>
				<option value="paragraph-text" <?php selected( "paragraph-text", $font_size ); ?>><?php echo esc_html__( 'Paragraph Text', 'impeka-extension' ); ?></option>
				<option value="leader-text" <?php selected( "leader-text", $font_size ); ?>><?php echo esc_html__( 'Leader Text', 'impeka-extension' ); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'list_align' ) ); ?>"><?php echo esc_html__( 'Align:', 'impeka-extension' ); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'list_align' ) ); ?>" style="width:100%;">
				<option value="left" <?php selected( "left", $list_align ); ?>><?php echo esc_html__( 'Left', 'impeka-extension' ); ?></option>
				<option value="center" <?php selected( "center", $list_align ); ?>><?php echo esc_html__( 'Center', 'impeka-extension' ); ?></option>
				<option value="right" <?php selected( "right", $list_align ); ?>><?php echo esc_html__( 'Right', 'impeka-extension' ); ?></option>
			</select>
		</p>
		<p>
				<em><?php echo esc_html__( 'Note: Make sure you include the full URL (i.e. http://www.samplesite.com)', 'impeka-extension' ); ?></em>
				<br>
				 <?php echo esc_html__( 'If you do not want a social to be visible, simply delete the supplied URL.', 'impeka-extension' ); ?>
		</p>

		<?php
		if ( isset( $impeka_grve_social_list_extended ) ) {
			foreach ( $impeka_grve_social_list_extended as $social_item ) {
				$social_item_url = impeka_ext_array_value( $instance, $social_item['url'] );
		?>
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>"><?php echo esc_html( $social_item['title'] ); ?>:</label>
					<input style="width: 100%;" id="<?php echo esc_attr( $this->get_field_id( $social_item['url'] ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( $social_item['url'] ) ); ?>" value="<?php echo esc_attr( $social_item_url ); ?>" />
				</p>

		<?php
			}
		}
		?>

	<?php
	}
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
