<?php
/** no direct access **/
defined('MECEXEC') or die();

$styling = $this->main->get_styling();
$fonts = include MEC::import('app.features.mec.webfonts.webfonts', true, true);

$google_fonts = array();
$google_fonts['none'] = array(
	'label'=>esc_html__('Default Font', 'mec'),
	'variants'=>array('regular'),
	'subsets'=>array(),
	'category'=>'',
    'value'=>'',
);

if(is_array($fonts))
{
	foreach($fonts['items'] as $font)
    {
        $google_fonts[$font['family']] = array(
            'label'=>$font['family'],
            'variants'=>$font['variants'],
            'subsets'=>$font['subsets'],
            'category'=>$font['category'],
        );
    }
}
?>
<div class="wns-be-container wns-be-container-sticky">

    <div id="wns-be-infobar">
        <div class="mec-search-settings-wrap">
            <i class="mec-sl-magnifier"></i>
            <input id="mec-search-settings" type="text" placeholder="<?php esc_html_e('Search...' ,'mec'); ?>">
        </div>
        <a href="" id="" class="dpr-btn dpr-save-btn"><?php esc_html_e('Save Changes', 'mec'); ?></a>
    </div>

    <div class="wns-be-sidebar">
        <?php $this->main->get_sidebar_menu('styling'); ?>
    </div>

    <div class="wns-be-main">

        <div id="wns-be-notification"></div>

        <div id="wns-be-content">
            <div class="wns-be-group-tab">

                <div class="mec-container">
                    <form id="mec_styling_form">
                        <div class="mec-options-fields">
                            <h2><?php esc_html_e('Styling', 'mec'); ?></h2>
                        <!-- Colorskin -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Color Skin', 'mec' ); ?></h5>
                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Predefined Color Skin', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <ul class="mec-image-select-wrap">
                                        <?php
                                        $colorskins = array(
                                            '#40d9f1'=>'mec-colorskin-1',
                                            '#0093d0'=>'mec-colorskin-2',
                                            '#e53f51'=>'mec-colorskin-3',
                                            '#f1c40f'=>'mec-colorskin-4',
                                            '#e64883'=>'mec-colorskin-5',
                                            '#45ab48'=>'mec-colorskin-6',
                                            '#9661ab'=>'mec-colorskin-7',
                                            '#0aad80'=>'mec-colorskin-8',
                                            '#0ab1f0'=>'mec-colorskin-9',
                                            '#ff5a00'=>'mec-colorskin-10',
                                            '#c3512f'=>'mec-colorskin-11',
                                            '#55606e'=>'mec-colorskin-12',
                                            '#fe8178'=>'mec-colorskin-13',
                                            '#7c6853'=>'mec-colorskin-14',
                                            '#bed431'=>'mec-colorskin-15',
                                            '#2d5c88'=>'mec-colorskin-16',
                                            '#77da55'=>'mec-colorskin-17',
                                            '#2997ab'=>'mec-colorskin-18',
                                            '#734854'=>'mec-colorskin-19',
                                            '#a81010'=>'mec-colorskin-20',
                                            '#4ccfad'=>'mec-colorskin-21',
                                            '#3a609f'=>'mec-colorskin-22',
                                            '#333333'=>'mec-colorskin-23',
                                            '#D2D2D2'=>'mec-colorskin-24',
                                            '#636363'=>'mec-colorskin-25',
                                            );

                                            foreach($colorskins as $colorskin=>$values): ?>
                                            <li class="mec-image-select">
                                                <label for="<?php echo esc_attr($values); ?>">
                                                    <input type="radio" id="<?php echo esc_attr($values); ?>" name="mec[styling][mec_colorskin]" value="<?php echo esc_attr($colorskin); ?>" <?php if(isset($styling['mec_colorskin']) && ($styling['mec_colorskin'] == $colorskin)) echo 'checked="checked"'; ?>>
                                                    <span class="<?php echo esc_attr($values); ?>"></span>
                                                </label>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Custom Color Skin', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_color" name="mec[styling][color]" value="<?php echo (isset($styling['color']) ? esc_attr($styling['color']) : ''); ?>" data-default-color="" />
                                </div>
                                <div class="mec-col-12">
                                    <p><?php esc_attr_e("If you want to select a predefined color skin, you must clear the color of this item", 'mec'); ?></p>
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_styling_dark_mode"><?php esc_html_e('Dark Mode', 'mec'); ?></label>
                                <div class="mec-col-9">
                                    <input type="hidden" name="mec[styling][dark_mode]" value="0" />
                                    <input value="1" type="checkbox" id="mec_styling_dark_mode" name="mec[styling][dark_mode]" <?php if(isset($styling['dark_mode']) and $styling['dark_mode']) echo 'checked="checked"'; ?> />
                                    <span class="mec-tooltip">
                                        <div class="box top">
                                            <h5 class="title"><?php esc_html_e('Dark Mode', 'mec'); ?></h5>
                                            <div class="content"><p><?php esc_attr_e('Enable it to turn on dark mode', 'mec'); ?><a href="https://webnus.net/dox/modern-events-calendar/style-options/" target="_blank"><?php esc_html_e('Read More', 'mec'); ?></a></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>

                            <!-- Advanced Options -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Advanced Color Options (shortcodes)', 'mec' ); ?></h5>
                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Title', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_title_color" name="mec[styling][title_color]" value="<?php echo (isset($styling['title_color']) ? esc_attr($styling['title_color']) : ''); ?>" data-default-color="" />
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Title Hover', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_title_color_hover" name="mec[styling][title_color_hover]" value="<?php echo (isset($styling['title_color_hover']) ? esc_attr($styling['title_color_hover']) : ''); ?>" data-default-color="" />
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Content', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_content_color" name="mec[styling][content_color]" value="<?php echo (isset($styling['content_color']) ? esc_attr($styling['content_color']) : ''); ?>" data-default-color="" />
                                </div>
                            </div>

                            <!-- Typography -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Typography', 'mec' ); ?></h5>
                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_h_fontfamily"><?php esc_html_e('Heading (Events Title) Font Family', 'mec'); ?></label>
                                <div class="mec-col-9">

                                    <select class="mec-p-fontfamily" name="mec[styling][mec_h_fontfamily]" id="mec_h_fontfamily">
                                        <?php
                                        foreach($google_fonts as $google_font)
                                        {
                                            $variants = '';
                                            foreach($google_font['variants'] as $key=>$variant)
                                            {
                                                $variants .= $variant;
                                                if(next($google_font['variants']) == true) $variants .= ",";
                                            }

                                            $value = (isset($google_font['value']) ? $google_font['value'] : '['. $google_font['label'] .','. $variants .']');
                                            if($value == '['.esc_html__('Default Font', 'mec').',regular]') $value = '';
                                            ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php if(isset($styling['mec_h_fontfamily']) and ($styling['mec_h_fontfamily'] == $value)) echo 'selected="selected"'; ?>><?php echo esc_html($google_font['label']); ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>

                                </div>
                            </div>

                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_p_fontfamily"><?php esc_html_e('Paragraph Font Family', 'mec'); ?></label>
                                <div class="mec-col-9">

                                    <select class="mec-p-fontfamily" name="mec[styling][mec_p_fontfamily]" id="mec_p_fontfamily">
                                        <?php
                                        foreach($google_fonts as $google_font)
                                        {
                                            $variants = '';
                                            foreach($google_font['variants'] as $key=>$variant)
                                            {
                                                $variants .= $variant;
                                                if(next($google_font['variants']) == true) $variants .= ",";
                                            }

                                            $value = (isset($google_font['value']) ? $google_font['value'] : '['. $google_font['label'] .','. $variants .']');
                                            if($value == '['.esc_html__('Default Font', 'mec').',regular]') $value = '';
                                            ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php if(isset($styling['mec_p_fontfamily'] ) && ($styling['mec_p_fontfamily'] == $value ) ) echo 'selected'; ?>><?php echo esc_html($google_font['label']); ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>

                                </div>
                            </div>

                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_styling_disable_gfonts"><?php esc_html_e('Disable Google Fonts', 'mec'); ?></label>
                                <div class="mec-col-9">
                                    <input type="hidden" name="mec[styling][disable_gfonts]" value="0" />
                                    <input value="1" type="checkbox" id="mec_styling_disable_gfonts" name="mec[styling][disable_gfonts]" <?php if(isset($styling['disable_gfonts']) and $styling['disable_gfonts']) echo 'checked="checked"'; ?> />
                                    <span class="mec-tooltip">
                                        <div class="box top">
                                            <h5 class="title"><?php esc_html_e('Disable Google Fonts', 'mec'); ?></h5>
                                            <div class="content"><p><?php esc_attr_e('To be GDPR compliant you may need to disable Google fonts! set "Default Font" value for font family and enable this option.', 'mec'); ?><a href="https://webnus.net/dox/modern-events-calendar/style-options/" target="_blank"><?php esc_html_e('Read More', 'mec'); ?></a></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>

                            <!-- Container Width -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Accessibility', 'mec' ); ?></h5>
                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_styling_accessibility"><?php esc_html_e('Accessibility', 'mec'); ?></label>
                                <div class="mec-col-9">
                                    <input type="hidden" name="mec[styling][accessibility]" value="0" />
                                    <input value="1" type="checkbox" id="mec_styling_accessibility" name="mec[styling][accessibility]" <?php if(isset($styling['accessibility']) and $styling['accessibility']) echo 'checked="checked"'; ?> />
                                    <span class="mec-tooltip">
                                        <div class="box top">
                                            <h5 class="title"><?php esc_html_e('Accessibility', 'mec'); ?></h5>
                                            <div class="content"><p><?php esc_attr_e('Enable A11Y or accessibility in MEC...', 'mec'); ?><a href="https://webnus.net/dox/modern-events-calendar/improving-accessibility-on-mec/" target="_blank"><?php esc_html_e('Read More', 'mec'); ?></a></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>


                            <!-- Container Width -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Container Width', 'mec' ); ?></h5>
                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_styling_container_normal_width"><?php esc_html_e('Desktop Normal Screens', 'mec'); ?></label>
                                <div class="mec-col-9">
                                    <input type="text" id="mec_styling_container_normal_width" name="mec[styling][container_normal_width]" value="<?php echo ((isset($styling['container_normal_width']) and trim($styling['container_normal_width']) != '') ? $styling['container_normal_width'] : ''); ?>" />
                                    <span class="mec-tooltip">
                                        <div class="box left">
                                            <h5 class="title"><?php esc_html_e('Desktop Normal Screens', 'mec'); ?></h5>
                                            <div class="content"><p><?php esc_attr_e('You can enter your theme container size in this field', 'mec'); ?><a href="https://webnus.net/dox/modern-events-calendar/style-options/" target="_blank"><?php esc_html_e('Read More', 'mec'); ?></a></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <label class="mec-col-3" for="mec_styling_container_large_width"><?php esc_html_e('Desktop Large Screens', 'mec'); ?></label>
                                <div class="mec-col-9">
                                    <input type="text" id="mec_styling_container_large_width" name="mec[styling][container_large_width]" value="<?php echo ((isset($styling['container_large_width']) and trim($styling['container_large_width']) != '') ? $styling['container_large_width'] : ''); ?>" />
                                    <span class="mec-tooltip">
                                        <div class="box left">
                                            <h5 class="title"><?php esc_html_e('Desktop Large Screens', 'mec'); ?></h5>
                                            <div class="content"><p><?php esc_attr_e('You can enter your theme container size in this field', 'mec'); ?><a href="https://webnus.net/dox/modern-events-calendar/style-options/" target="_blank"><?php esc_html_e('Read More', 'mec'); ?></a></p></div>
                                        </div>
                                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                                    </span>
                                </div>
                            </div>
                            <?php do_action('mec_end_styling_settings', $styling); ?>

                            <!-- Other Styling Option -->
                            <h5 class="mec-form-subtitle"><?php esc_html_e('Other Styling Option', 'mec' ); ?></h5>

                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Frontend Event Submission Color', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_fes_color" name="mec[styling][fes_color]" value="<?php echo (isset($styling['fes_color']) ? esc_attr($styling['fes_color']) : ''); ?>" data-default-color="" />
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <div class="mec-col-3">
                                    <span><?php esc_html_e('Notifications Background', 'mec' ); ?></span>
                                </div>
                                <div class="mec-col-9">
                                    <input type="text" class="wp-color-picker-field" id="mec_settings_notification_bg" name="mec[styling][notification_bg]" value="<?php echo (isset($styling['notification_bg']) ? esc_attr($styling['notification_bg']) : ''); ?>" data-default-color="" />
                                </div>
                            </div>

                            <div class="mec-form-row">
                                <?php wp_nonce_field('mec_options_form'); ?>
                                <button  style="display: none;" id="mec_styling_form_button" class="button button-primary mec-button-primary" type="submit"><?php esc_html_e('Save Changes', 'mec'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="wns-be-footer">
        <a href="" id="" class="dpr-btn dpr-save-btn"><?php esc_html_e('Save Changes', 'mec'); ?></a>
    </div>

</div>

<?php
$this->getFactory()->params('footer', function()
{
    ?>
    <script>
    jQuery(document).ready(function()
    {
        jQuery(".dpr-save-btn").on('click', function(event)
        {
            event.preventDefault();
            jQuery("#mec_styling_form_button").trigger('click');
        });
    });

    (function($)
    {
        'use strict';
        $(document).ready(function()
        {
            //Initiate Color Picker
            $('.wp-color-picker-field').wpColorPicker();
        });

        $('.wpsa-browse').click(function(e)
        {
            e.preventDefault();
            var image = wp.media({
                title: 'Upload',
                multiple: false
            }).open()
            .on('select', function(e)
            {
                var uploaded_image = image.state().get('selection').first();
                var image_url = uploaded_image.toJSON().url;
                $('#mec_settings_upload').val(image_url);
            });
        });
    })(jQuery);

    jQuery("#mec_styling_form").on('submit', function(event)
    {
        event.preventDefault();

        // Add loading Class to the button
        jQuery(".dpr-save-btn").addClass('loading').text("<?php echo esc_js(esc_attr__('Saved', 'mec')); ?>");
        jQuery('<div class="wns-saved-settings"><?php echo esc_js(esc_attr__('Settings Saved!', 'mec')); ?></div>').insertBefore('#wns-be-content');

        var styling = jQuery("#mec_styling_form").serialize();

        jQuery.ajax(
        {
            type: "POST",
            url: ajaxurl,
            data: "action=mec_save_styling&"+styling,
            beforeSend: function () {
                jQuery('.wns-be-main').append('<div class="mec-loarder-wrap mec-settings-loader"><div class="mec-loarder"><div></div><div></div><div></div></div></div>');
            },
            success: function(data)
            {
                // Remove the loading Class to the button
                setTimeout(function()
                {
                    jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js(esc_attr__('Save Changes', 'mec')); ?>");
                    jQuery('.wns-saved-settings').remove();
                    jQuery('.mec-loarder-wrap').remove();
                }, 1000);
            },
            error: function(jqXHR, textStatus, errorThrown)
            {
                // Remove the loading Class to the button
                setTimeout(function(){
                    jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js(esc_attr__('Save Changes', 'mec')); ?>");
                    jQuery('.wns-saved-settings').remove();
                    jQuery('.mec-loarder-wrap').remove();
                }, 1000);
            }
        });
    });
    </script>
    <?php
});