<?php
/**
 * Gift Card Amount List Options
 */

$product = new WC_Product_Gift_Card( $product_id );

$manual_mode       = $product->get_manual_amount_status();
$override_settings = $product->get_override_global_settings_status();


?>
	<div class="ywgc-form-field yith-plugin-ui" style="margin-left: 160px; margin-top: 1em;">
		<label class="ywgc-form-field__label"><?php echo esc_html__( 'Override custom amount settings', 'yith-woocommerce-gift-cards' ); ?></label>
		<div class="ywgc-form-field__content">
			<?php
			echo yith_plugin_fw_get_field(
				array(
					'type'  => 'onoff',
					'id'    => 'ywgc-override-product-settings-' . $product->get_id(),
					'name'  => 'ywgc-override-product-settings-' . $product->get_id(),
					'class' => 'ywgc-override-product-settings',
					'value' => $override_settings == 'yes' ? 'yes' : 'no',
					'data'  => array(
						'product-id' => $product->get_id(),
					),
				)
			);
			?>
		</div>

		<div class="ywgc-form-field__description">
			<?php esc_html_e( 'Enable to override the custom amount global settings for this gift card.', 'yith-woocommerce-gift-cards' ); ?>
		</div>
	</div>

	<div class="ywgc-form-field yith-plugin-ui ywgc-custom-amount-field ywgc-hidden" style="margin-left: 160px;margin-top: 15px;">
		<label class="ywgc-form-field__label"><?php echo esc_html__( 'Allow custom amount', 'yith-woocommerce-gift-cards' ); ?></label>
		<div class="ywgc-form-field__content">
			<?php
			echo yith_plugin_fw_get_field(
				array(
					'type'  => 'onoff',
					'id'    => 'manual_amount_mode-' . $product->get_id(),
					'name'  => 'manual_amount_mode-' . $product->get_id(),
					'value' => $manual_mode == 'yes' ? 'yes' : 'no',
					'data'  => array(
						'product-id' => $product->get_id(),
					),
					'deps'  => array(
						'id'    => 'ywgc-override-product-settings' . $product->get_id(),
						'value' => 'yes',
					),
				)
			);
			?>
		</div>

		<div class="ywgc-form-field__description">
			<?php esc_html_e( 'If enabled, customers can choose from the available amounts or also enter a custom amount for the gift card.', 'yith-woocommerce-gift-cards' ); ?>
		</div>
	</div>

<?php $minimal_amount = get_post_meta( $product_id, '_ywgc_minimal_manual_amount', true ); ?>
	<p class="form-field minimal-amount-field ywgc-hidden">
		<label for="ywgc-minimal-amount"><?php _e( 'Minimum custom amount', 'yith-woocommerce-gift-cards' ); ?></label>
		<input type="number" class="ywgc-minimal-amount" id="ywgc-minimal-amount" name="ywgc-minimal-amount" value="<?php echo $minimal_amount; ?>" placeholder="<?php _e( 'Enter a minimum amount', 'yith-woocommerce-gift-cards' ); ?>">
		<span class="ywgc-form-field__description "><?php _e( 'Set an optional minimum custom amount for this gift card.', 'yith-woocommerce-gift-cards' ); ?></span>
	</p>
<?php
 $maximum_amount = get_post_meta( $product_id, '_ywgc_maximum_manual_amount', true );
?>
<p class="form-field maximum-amount-field ywgc-hidden">
	<label for="ywgc-maximum-amount"><?php _e( 'Maximum custom amount', 'yith-woocommerce-gift-cards' ); ?></label>
	<input type="number" class="ywgc-maximum-amount" id="ywgc-maximum-amount" name="ywgc-maximum-amount" value="<?php echo $maximum_amount; ?>" placeholder="<?php _e( 'Enter a maximum amount', 'yith-woocommerce-gift-cards' ); ?>">
	<span class="ywgc-form-field__description "><?php _e( 'Set an optional maximum custom amount for this gift card.', 'yith-woocommerce-gift-cards' ); ?></span>
</p>
<?php
