<?php
/*
*	Post Content Link Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$post_link_text = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_link_text' );
$post_link = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
$new_window = get_post_meta( get_the_ID(), '_impeka_grve_post_link_new_window', true );

if( empty( $post_link ) ) {
	$post_link = get_permalink();
}

$post_link_target = '_self';
if( !empty( $new_window ) ) {
	$post_link_target = '_blank';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
	<div id="grve-single-link">
		<div class="grve-container">
			<a href="<?php echo esc_url( $post_link ); ?>" target="<?php echo esc_attr( $post_link_target ); ?>" rel="bookmark">
				<?php impeka_grve_print_post_bg_image_container_by_type( 'link' ); ?>
				<div class="grve-post-content">
					<?php if ( !empty( $post_link_text ) ) { ?>
					<div class="grve-leader-text"><?php echo wp_kses_post(  $post_link_text ); ?></div>
					<?php } ?>
					<div class="grve-post-url"><?php echo esc_url( $post_link ); ?></div>
				</div>
			</a>
		</div>
	</div>
	<?php do_action( 'impeka_grve_single_content_before' ); ?>
	<div id="grve-single-content">
		<?php impeka_grve_print_post_simple_title(); ?>
		<div itemprop="articleBody">
			<?php the_content(); ?>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
	</div>
	<?php do_action( 'impeka_grve_single_content_after' ); ?>
</article>
