<?php
/*
*	Post Content Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$disable_media = impeka_grve_post_meta( '_impeka_grve_disable_media' );
$media_type = impeka_grve_option( 'post_feature_media_type' );
$media_type = impeka_grve_post_meta( '_impeka_grve_feature_media_type', $media_type );
$media_classes = array('grve-media');
if( 'wide' == $media_type ) {
	$media_classes[] = 'grve-wide';
}
$media_class_string = implode( ' ', $media_classes );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">

	<?php
		if ( impeka_grve_visibility( 'post_feature_image_visibility', '1' ) && 'yes' != $disable_media && has_post_thumbnail() ) {
			if( 'wide' == $media_type ) {
				$image_size = "impeka-grve-large-rect-horizontal";
			} else {
				$image_size = "large";
			}
	?>
	<div id="grve-single-media">
		<div class="grve-container">
			<div class="<?php echo esc_attr( $media_class_string ); ?>">
				<?php
					$img_id = get_post_thumbnail_id();
					$img_src = wp_get_attachment_image_src( $img_id, $image_size );
					$img_width = $img_src[1];
					$img_height = $img_src[2];

					if( ($img_width >= $img_height && $img_width >= 1024) || 'wide' == $media_type ) {
						impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => 100 ) );
					} else {
						impeka_grve_the_post_thumbnail( $image_size );
					}
				?>
			</div>
		</div>
	</div>
	<?php
		}
	?>
	<?php do_action( 'impeka_grve_single_content_before' ); ?>
	<div id="grve-single-content">
		<?php impeka_grve_print_post_simple_title(); ?>
		<div itemprop="articleBody">
			<?php the_content(); ?>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
	</div>
	<?php do_action( 'impeka_grve_single_content_after' ); ?>
</article>
