<?php
/*
*	Admin Custom Sidebars
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	function impeka_grve_add_sidebar_settings() {

		if ( isset( $_POST['_impeka_grve_nonce_sidebar_save'] ) && wp_verify_nonce( $_POST['_impeka_grve_nonce_sidebar_save'], 'impeka_grve_nonce_sidebar_save' ) ) {

			$sidebars_items = array();
			if( isset( $_POST['_impeka_grve_custom_sidebar_item_id'] ) ) {
				$num_of_sidebars = sizeof( $_POST['_impeka_grve_custom_sidebar_item_id'] );
				for ( $i=0; $i < $num_of_sidebars; $i++ ) {
					$this_sidebar = array (
						'id' => sanitize_text_field( $_POST['_impeka_grve_custom_sidebar_item_id'][ $i ] ),
						'name' => sanitize_text_field( $_POST['_impeka_grve_custom_sidebar_item_name'][ $i ] ),
					);
					array_push( $sidebars_items, $this_sidebar );
				}
			}
			if ( empty( $sidebars_items ) ) {
				delete_option( '_impeka_grve_custom_sidebars' );
			} else {
				update_option( '_impeka_grve_custom_sidebars', $sidebars_items );
			}
			//Update Sidebar list
			wp_get_sidebars_widgets();
			wp_safe_redirect( 'admin.php?page=impeka-sidebars&sidebar-settings=saved' );

		}
	}

	add_action( 'admin_menu', 'impeka_grve_add_sidebar_settings' );

	function  impeka_grve_print_admin_custom_sidebars( $custom_sidebars ) {
		if ( ! empty( $custom_sidebars ) ) {
			foreach ( $custom_sidebars as $custom_sidebar ) {
				impeka_grve_print_admin_single_custom_sidebar( $custom_sidebar );
			}
		}
	}

	function  impeka_grve_print_admin_single_custom_sidebar( $sidebar_item, $mode = '' ) {

		$button_class = "grve-custom-sidebar-item-delete-button grve-delete-btn";
		$sidebar_item_id = uniqid('impeka_grve_sidebar_');

		if( $mode = "new" ) {
			$button_class = "grve-custom-sidebar-item-delete-button grve-delete-btn grve-item-new";
		}
?>

	<tr class="grve-custom-sidebar-item grve-custom-sidebar-normal">

		<td>
			<h4 class="grve-table-label grve-custom-sidebar-title">
				<?php esc_html_e('Custom Sidebar', 'impeka' ); ?>: <?php echo impeka_grve_array_value( $sidebar_item, 'name' ); ?>
			</h4>
			<div class="grve-custom-sidebar-settings">
				<input type="hidden" name="_impeka_grve_custom_sidebar_item_id[]" value="<?php echo impeka_grve_array_value( $sidebar_item, 'id', $sidebar_item_id ); ?>">
				<input type="hidden" class="grve-custom-sidebar-item-name" name="_impeka_grve_custom_sidebar_item_name[]" value="<?php echo impeka_grve_array_value( $sidebar_item, 'name' ); ?>"/>
			</div>
		</td>
		<td style="text-align: right;">
			<input class="<?php echo esc_attr( $button_class ); ?> button" type="button" value="<?php esc_attr_e('Delete', 'impeka' ); ?>">
		</td>
	</tr>

<?php

	}

	function impeka_grve_get_custom_sidebar() {

		check_ajax_referer( 'impeka-grve-get-custom-sidebar', '_grve_nonce' );

		if( isset( $_POST['sidebar_name'] ) ) {

			$sidebar_item_name = sanitize_text_field( $_POST['sidebar_name'] );
			$sidebar_item_id = uniqid('impeka_grve_sidebar_');
			if( empty( $sidebar_item_name ) ) {
				$sidebar_item_name = $sidebar_item_id;
			}

			$this_sidebar = array (
				'id' => $sidebar_item_id,
				'name' => $sidebar_item_name,
			);

			impeka_grve_print_admin_single_custom_sidebar( $this_sidebar, 'new' );
		}
		die();

	}
	add_action( 'wp_ajax_impeka_grve_get_custom_sidebar', 'impeka_grve_get_custom_sidebar' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
