<?php
/*
*	Collection of functions for admin feature section
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Get Replaced Image with ajax
 */
function impeka_grve_get_replaced_image() {

	check_ajax_referer( 'impeka-grve-get-replaced-image', '_grve_nonce' );

	if( isset( $_POST['attachment_id'] ) ) {

		if ( isset( $_POST['attachment_mode'] ) && !empty( $_POST['attachment_mode'] ) ) {
			$mode = sanitize_text_field( $_POST['attachment_mode'] );
			switch( $mode ) {
				case 'image':
					$input_name = '_impeka_grve_single_item_bg_image_id';
				break;
				case 'custom-image':
					if ( isset( $_POST['field_name'] ) && !empty( $_POST['field_name'] ) ) {
						$input_name = sanitize_text_field( $_POST['field_name'] );
					}
				break;
				case 'full-slider':
				default:
					$input_name = '_impeka_grve_slider_item_bg_image_id[]';
				break;
			}
		} else {
			$input_name = '_impeka_grve_slider_item_bg_image_id[]';
		}

		$media_id  = sanitize_text_field( $_POST['attachment_id'] );
		$thumb_src = wp_get_attachment_image_src( $media_id, 'thumbnail' );
		$thumbnail_url = $thumb_src[0];
		$alt = get_post_meta( $media_id, '_wp_attachment_image_alt', true );
?>
		<input type="hidden" class="grve-upload-media-id" value="<?php echo esc_attr( $media_id ); ?>" name="<?php echo esc_attr( $input_name ); ?>">
		<?php echo '<img class="grve-thumb" src="' . esc_url( $thumbnail_url ) . '" alt="' . esc_attr( $alt ) . '" width="120" height="120"/>'; ?>
		<a class="grve-upload-remove-image grve-item-new" href="#"></a>
<?php

	}

	if( isset( $_POST['attachment_id'] ) ) { die(); }
}
add_action( 'wp_ajax_impeka_grve_get_replaced_image', 'impeka_grve_get_replaced_image' );

/**
 * Get Single Feature Slider Media with ajax
 */
function impeka_grve_get_admin_feature_slider_media() {

	check_ajax_referer( 'impeka-grve-get-feature-slider-media', '_grve_nonce' );

	if( isset( $_POST['attachment_ids'] ) ) {

		$attachment_ids = sanitize_text_field( $_POST['attachment_ids'] );

		if( !empty( $attachment_ids ) ) {

			$media_ids = explode(",", $attachment_ids);

			foreach ( $media_ids as $media_id ) {
				$slider_item = array (
					'bg_image_id' => $media_id,
				);

				impeka_grve_print_admin_feature_slider_item( $slider_item, "new" );
			}
		}
	}

	if( isset( $_POST['post_ids'] ) ) {

		$post_ids = sanitize_text_field( $_POST['post_ids'] );
		if( !empty( $post_ids ) ) {

			$all_post_ids = explode(",", $post_ids);

			foreach ( $all_post_ids as $post_id ) {
				$slider_item = array (
					'type' => 'post',
					'post_id' => $post_id,
				);
				impeka_grve_print_admin_feature_slider_item( $slider_item, "new" );
			}
		} else {
			$slider_item = array (
				'type' => 'post',
				'post_id' => '0',
			);
			impeka_grve_print_admin_feature_slider_item( $slider_item, "new" );
		}
	}

	if( isset( $_POST['attachment_ids'] ) || isset( $_POST['post_ids'] )  ) { die(); }
}
add_action( 'wp_ajax_impeka_grve_get_admin_feature_slider_media', 'impeka_grve_get_admin_feature_slider_media' );

/**
 * Get Single Feature Map Point with ajax
 */
function impeka_grve_get_map_point() {

	check_ajax_referer( 'impeka-grve-get-map-point', '_grve_nonce' );

	if( isset( $_POST['map_mode'] ) ) {
		$mode = sanitize_text_field( $_POST['map_mode'] );
		impeka_grve_print_admin_feature_map_point( array(), $mode );
	}
	if( isset( $_POST['map_mode'] ) ) { die(); }
}
add_action( 'wp_ajax_impeka_grve_get_map_point', 'impeka_grve_get_map_point' );

/**
 * Prints Feature Map Points
 */
function impeka_grve_print_admin_feature_map_items( $map_items ) {

	if( !empty($map_items) ) {
		foreach ( $map_items as $map_item ) {
			impeka_grve_print_admin_feature_map_point( $map_item );
		}
	}

}

/**
 * Prints Feature Single Map Point
 */
function impeka_grve_print_admin_feature_map_point( $map_item, $mode = '' ) {


	$map_item_id = uniqid('_impeka_grve_map_point_');
	$map_uniqid = uniqid('-');
	$map_id = impeka_grve_array_value( $map_item, 'id', $map_item_id );

	$map_lat = impeka_grve_array_value( $map_item, 'lat', '51.516221' );
	$map_lng = impeka_grve_array_value( $map_item, 'lng', '-0.136986' );
	$map_marker = impeka_grve_array_value( $map_item, 'marker' );

	$map_title = impeka_grve_array_value( $map_item, 'title' );
	$map_infotext = impeka_grve_array_value( $map_item, 'info_text','' );
	$map_infotext_open = impeka_grve_array_value( $map_item, 'info_text_open','no' );

	$button_text = impeka_grve_array_value( $map_item, 'button_text' );
	$button_url = impeka_grve_array_value( $map_item, 'button_url' );
	$button_target = impeka_grve_array_value( $map_item, 'button_target', '_self' );
	$button_class = impeka_grve_array_value( $map_item, 'button_class' );
	$closed_class = 'closed';
	$item_new = '';
	if( "new" == $mode ) {
		$item_new = " grve-item-new grve-toggle-new";
		$closed_class = "grve-item-new";
	}
?>
	<div class="grve-map-item postbox <?php echo esc_attr( $closed_class ); ?>">
		<button class="handlediv button-link" type="button">
			<span class="screen-reader-text"><?php esc_html_e( 'Toggle panel: Feature Section Map Point', 'impeka' ); ?></span>
			<span class="toggle-indicator"></span>
		</button>
		<input class="grve-map-item-delete-button button<?php echo esc_attr( $item_new ); ?>" type="button" value="<?php esc_attr_e( 'Delete', 'impeka' ); ?>" />
		<span class="grve-button-spacer">&nbsp;</span>
		<span class="grve-modal-spinner"></span>
		<h3 class="grve-title">
			<span><?php esc_html_e( 'Map Point', 'impeka' ); ?>: </span><span id="<?php echo esc_attr( $map_id ); ?>_title_admin_label"><?php if ( !empty ($map_title) ) { echo esc_html( $map_title ); } ?></span>
		</h3>
		<div class="inside">

			<!--  METABOXES -->
			<div class="grve-metabox-content">

				<!-- TABS -->
				<div class="grve-tabs<?php echo esc_attr( $item_new ); ?>">

					<ul class="grve-tab-links">
						<li class="active"><a href="#grve-feature-single-map-tab-marker<?php echo esc_attr( $map_uniqid ); ?>"><?php esc_html_e( 'Marker', 'impeka' ); ?></a></li>
						<li><a href="#grve-feature-single-map-tab-infobox<?php echo esc_attr( $map_uniqid ); ?>"><?php esc_html_e( 'Info Box', 'impeka' ); ?></a></li>
						<li><a href="#grve-feature-single-map-tab-button<?php echo esc_attr( $map_uniqid ); ?>"><?php esc_html_e( 'Link', 'impeka' ); ?></a></li>
					</ul>

					<div class="grve-tab-content">

						<div id="grve-feature-single-map-tab-marker<?php echo esc_attr( $map_uniqid ); ?>" class="grve-tab-item active">
							<input type="hidden" name="_impeka_grve_map_item_point_id[]" value="<?php echo esc_attr( $map_id ); ?>"/>
							<div class="grve-fields-wrapper">
								<div class="grve-label">
									<label for="grve-page-feature-element">
										<span class="grve-title"><?php esc_html_e( 'Marker', 'impeka' ); ?></span>
									</label>
								</div>
								<div class="grve-field-items-wrapper">
									<div class="grve-field-item grve-field-item-fullwidth">
										<input type="text" name="_impeka_grve_map_item_point_marker[]" class="grve-upload-simple-media-field" value="<?php echo esc_attr( $map_marker ); ?>"/>
										<label></label>
										<input type="button" data-media-type="image" class="grve-upload-simple-media-button button-primary<?php echo esc_attr( $item_new ); ?>" value="<?php esc_attr_e( 'Insert Marker', 'impeka' ); ?>"/>
										<input type="button" class="grve-remove-simple-media-button button<?php echo esc_attr( $item_new ); ?>" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
									</div>
								</div>
							</div>
							<?php
								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_lat[]',
										'value' => $map_lat,
										'label' => array(
											"title" => esc_html__( 'Latitude', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_lng[]',
										'value' => $map_lng,
										'label' => array(
											"title" => esc_html__( 'Longitude', 'impeka' ),
										),
									)
								);
							?>

						</div>
						<div id="grve-feature-single-map-tab-infobox<?php echo esc_attr( $map_uniqid ); ?>" class="grve-tab-item">
							<?php
								impeka_grve_print_admin_option(
									array(
										'type' => 'label',
										'label' => array(
											"title" => esc_html__( 'Title / Info Text', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_title[]',
										'value' => $map_title,
										'label' => array(
											"title" => esc_html__( 'Title', 'impeka' ),
										),
										'id' => $map_id . '_title',
										'extra_class' => 'grve-admin-label-update',
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'textarea',
										'name' => '_impeka_grve_map_item_point_infotext[]',
										'value' => $map_infotext,
										'label' => array(
											"title" => esc_html__( 'Info Text', 'impeka' ),
										),
										'width' => 'fullwidth',
										'rows' => 2,
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'select-boolean',
										'name' => '_impeka_grve_map_item_point_infotext_open[]',
										'value' => $map_infotext_open,
										'label' => esc_html__( 'Open Info Text Onload', 'impeka' ),
									)
								);
							?>
						</div>
						<div id="grve-feature-single-map-tab-button<?php echo esc_attr( $map_uniqid ); ?>" class="grve-tab-item">
							<?php
								impeka_grve_print_admin_option(
									array(
										'type' => 'label',
										'label' => array(
											"title" => esc_html__( 'Link', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_button_text[]',
										'value' => $button_text,
										'label' => array(
											"title" => esc_html__( 'Link Text', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_button_url[]',
										'value' => $button_url,
										'label' => array(
											"title" => esc_html__( 'Link URL', 'impeka' ),
										),
										'width' => 'fullwidth',
									)
								);

								impeka_grve_print_admin_option(
									array(
										'type' => 'select-button-target',
										'name' => '_impeka_grve_map_item_point_button_target[]',
										'value' => $button_target,
										'label' => array(
											"title" => esc_html__( 'Link Target', 'impeka' ),
										),
									)
								);

								impeka_grve_print_admin_option(
									array(
										'type' => 'textfield',
										'name' => '_impeka_grve_map_item_point_button_class[]',
										'value' => $button_class,
										'label' => array(
											"title" => esc_html__( 'Link Class', 'impeka' ),
										),
									)
								);
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
}

/**
 * Prints Section Slider items
 */
function impeka_grve_print_admin_feature_slider_items( $slider_items ) {

	foreach ( $slider_items as $slider_item ) {
		impeka_grve_print_admin_feature_slider_item( $slider_item, '' );
	}

}

/**
* Prints Single Feature Slider Item
*/
function impeka_grve_print_admin_feature_slider_item( $slider_item, $new = "" ) {

	$slide_id = impeka_grve_array_value( $slider_item, 'id', uniqid() );
	$slider_item['id'] = $slide_id;
	$slide_type = impeka_grve_array_value( $slider_item, 'type' );
	$slide_post_id = impeka_grve_array_value( $slider_item, 'post_id' );

	$bg_image_id = impeka_grve_array_value( $slider_item, 'bg_image_id' );
	$bg_image_size = impeka_grve_array_value( $slider_item, 'bg_image_size' );
	$bg_position = impeka_grve_array_value( $slider_item, 'bg_position', 'center-center' );
	$bg_tablet_sm_position = impeka_grve_array_value( $slider_item, 'bg_tablet_sm_position' );


	$header_skin = impeka_grve_array_value( $slider_item, 'header_skin', 'default' );
	$title = impeka_grve_array_value( $slider_item, 'title' );

	$slider_item_button = impeka_grve_array_value( $slider_item, 'button' );
	$slider_item_button2 = impeka_grve_array_value( $slider_item, 'button2' );

	$button_class = "grve-feature-slider-item-delete-button";
	$replace_image_class = "grve-upload-replace-image";
	$closed_class = 'closed';
	$new_class = '';

	if( "new" == $new ) {
		$button_class = "grve-feature-slider-item-delete-button grve-item-new";
		$replace_image_class = "grve-upload-replace-image grve-item-new";
		$closed_class = 'grve-item-new grve-toggle-new';
		$new_class = ' grve-item-new';
	}

	$slide_uniqid = '-' . $slide_id;

	$slide_type_string = esc_html__( 'Slide', 'impeka' );
	if ( 'post' == $slide_type ) {
		$slide_type_string = esc_html__( 'Post Slide', 'impeka' );
		if( !empty( $slide_post_id ) ) {
			$title = get_the_title ( $slide_post_id  );
		}
	}

?>

	<div class="grve-slider-item postbox <?php echo esc_attr( $closed_class ); ?>">
		<button class="handlediv button-link" type="button">
			<span class="screen-reader-text"><?php esc_html_e( 'Toggle panel: Feature Section Slide', 'impeka' ); ?></span>
			<span class="toggle-indicator"></span>
		</button>
		<input class="<?php echo esc_attr( $button_class ); ?> button" type="button" value="<?php esc_attr_e( 'Delete', 'impeka' ); ?>">
		<span class="grve-button-spacer">&nbsp;</span>
		<span class="grve-modal-spinner"></span>
		<h3 class="hndle grve-title">
			<span><?php echo esc_html( $slide_type_string ); ?>: </span><span id="_impeka_grve_slider_item_title<?php echo esc_attr( $slide_id ); ?>_admin_label"><?php if ( !empty ($title) ) { echo esc_html( $title ); } ?></span>
		</h3>
		<div class="inside">
			<!--  METABOXES -->
			<div class="grve-metabox-content">

				<!-- TABS -->
				<div class="grve-tabs<?php echo esc_attr( $new_class ); ?>">

					<ul class="grve-tab-links">
						<li class="active"><a href="#grve-feature-single-tab-bg<?php echo esc_attr( $slide_uniqid ); ?>"><?php esc_html_e( 'Background / Header', 'impeka' ); ?></a></li>
						<li><a href="#grve-feature-single-tab-content<?php echo esc_attr( $slide_uniqid ); ?>"><?php esc_html_e( 'Content', 'impeka' ); ?></a></li>
						<?php if ( 'post' != $slide_type ) { ?>
						<li><a href="#grve-feature-single-tab-button<?php echo esc_attr( $slide_uniqid ); ?>"><?php esc_html_e( 'First Button', 'impeka' ); ?></a></li>
						<li><a href="#grve-feature-single-tab-button2<?php echo esc_attr( $slide_uniqid ); ?>"><?php esc_html_e( 'Second Button', 'impeka' ); ?></a></li>
						<?php } ?>
						<li><a href="#grve-feature-single-tab-extra<?php echo esc_attr( $slide_uniqid ); ?>"><?php esc_html_e( 'Extra', 'impeka' ); ?></a></li>
					</ul>

					<div class="grve-tab-content">

						<div id="grve-feature-single-tab-bg<?php echo esc_attr( $slide_uniqid ); ?>" class="grve-tab-item active">
							<?php

								impeka_grve_print_admin_option(
									array(
										'type' => 'hidden',
										'name' => '_impeka_grve_slider_item_id[]',
										'value' => $slide_id,
									)
								);

								impeka_grve_print_admin_option(
									array(
										'type' => 'hidden',
										'name' => '_impeka_grve_slider_item_type[]',
										'value' => $slide_type,
									)
								);
								if ( 'post' == $slide_type ) {
									impeka_grve_print_admin_option(
										array(
											'type' => 'hiddenfield',
											'name' => '_impeka_grve_slider_item_post_id[]',
											'value' => $slide_post_id,
											'label' => array(
												"title" => esc_html__( 'Post ID', 'impeka' ),
												"desc" => esc_html__( 'Background Image can be still used instead of the Feature Image', 'impeka' ),
											),
										)
									);
								} else {
									impeka_grve_print_admin_option(
										array(
											'type' => 'hidden',
											'name' => '_impeka_grve_slider_item_post_id[]',
											'value' => $slide_post_id,
										)
									);
								}

								impeka_grve_print_admin_option(
									array(
										'type' => 'select-image',
										'name' => '_impeka_grve_slider_item_bg_image_id[]',
										'value' => $bg_image_id,
										'label' => array(
											"title" => esc_html__( 'Background Image', 'impeka' ),
										),
										'width' => 'fullwidth',
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'select',
										'name' => '_impeka_grve_slider_item_bg_image_size[]',
										'value' => $bg_image_size,
										'options' => array(
											'' => esc_html__( '--Inherit--', 'impeka' ),
											'responsive' => esc_html__( 'Responsive', 'impeka' ),
											'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka' ),
											'full' => esc_html__( 'Full', 'impeka' ),
										),
										'label' => array(
											"title" => esc_html__( 'Background Image Size', 'impeka' ),
											"desc" => esc_html__( 'Inherit : Theme Options - Media Sizes.', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'label',
										'label' => array(
											"title" => esc_html__( 'Header / Background Position', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'select-bg-position',
										'name' => '_impeka_grve_slider_item_bg_position[]',
										'value' => $bg_position,
										'label' => array(
											"title" => esc_html__( 'Background Position', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'select-bg-position-inherit',
										'name' => '_impeka_grve_slider_item_bg_tablet_sm_position[]',
										'value' => $bg_tablet_sm_position,
										'label' => array(
											"title" => esc_html__( 'Background Position ( Tablet Portrait )', 'impeka' ),
											"desc" => esc_html__( 'Tablet devices with portrait orientation and below.', 'impeka' ),
										),
									)
								);
								impeka_grve_print_admin_option(
									array(
										'type' => 'select-header-style',
										'name' => '_impeka_grve_slider_item_header_skin[]',
										'value' => $header_skin,
										'label' => array(
											"title" => esc_html__( 'Header Skin', 'impeka' ),
										),
									)
								);

								impeka_grve_print_admin_feature_item_overlay_options( $slider_item, '_impeka_grve_slider_item_', '[]' );
							?>
						</div>
						<div id="grve-feature-single-tab-content<?php echo esc_attr( $slide_uniqid ); ?>" class="grve-tab-item">
							<?php impeka_grve_print_admin_feature_item_content_options( $slider_item, '_impeka_grve_slider_item_', '[]' ); ?>
						</div>
						<div id="grve-feature-single-tab-button<?php echo esc_attr( $slide_uniqid ); ?>" class="grve-tab-item">
							<?php impeka_grve_print_admin_feature_item_button_options( $slider_item_button, '_impeka_grve_slider_item_button_', '[]' ); ?>
						</div>
						<div id="grve-feature-single-tab-button2<?php echo esc_attr( $slide_uniqid ); ?>" class="grve-tab-item">
							<?php impeka_grve_print_admin_feature_item_button_options( $slider_item_button2, '_impeka_grve_slider_item_button2_', '[]' ); ?>
						</div>
						<div id="grve-feature-single-tab-extra<?php echo esc_attr( $slide_uniqid ); ?>" class="grve-tab-item">
							<?php impeka_grve_print_admin_feature_item_go_to_section_options( $slider_item, '_impeka_grve_slider_item_', '[]' ); ?>
							<?php impeka_grve_print_admin_feature_item_extra_options( $slider_item, '_impeka_grve_slider_item_', '[]' ); ?>

						</div>
					</div>

				</div>
				<!-- END TABS -->

			</div>
			<!-- END  METABOXES -->
		</div>

	</div>
<?php

}

/**
* Get Revolution Sliders
*/
function impeka_grve_get_revolution_selection() {

	$revsliders = array(
		"" => esc_html__( "None", 'impeka' ),
	);

	if ( class_exists( 'RevSlider' ) ) {
		$slider = new RevSlider();
		$arrSliders = $slider->getArrSliders();

		if ( $arrSliders ) {
			foreach ( $arrSliders as $slider ) {
				$revsliders[ $slider->getAlias() ] = $slider->getTitle();
			}
		}
	}

	return $revsliders;
}

/**
* Prints Item Button Options
*/
function impeka_grve_print_admin_feature_item_button_options( $item, $prefix = '_impeka_grve_single_item_button_', $suffix = '', $mode = '' ) {


	$id_prefix = str_replace( "[","_",$prefix );

	$button_id = impeka_grve_array_value( $item, 'id', uniqid() );
	$group_id = $id_prefix . $button_id;


	$fallback_text = '';
	if ( 'posts_slider' == $mode ) {
		$fallback_text = 'Read More';
	}

	echo '<div id="' . esc_attr( $group_id ) . '">';


	impeka_grve_print_admin_option(
		array(
			'type' => 'hidden',
			'name' => $prefix . 'id' . $suffix,
			'value' => $button_id,
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => $prefix . 'text' . $suffix,
			'id' => $id_prefix . 'text' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'text', $fallback_text ),
			'label' => esc_html__( 'Button Text', 'impeka' ),
		)
	);
	if ( 'posts_slider' != $mode ) {
		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => $prefix . 'url' . $suffix,
				'id' => $id_prefix . 'url' . '_' . $button_id,
				'value' => impeka_grve_array_value( $item, 'url' ),
				'label' => esc_html__( 'Button URL', 'impeka' ),
				'width' => 'fullwidth',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-button-target',
				'name' => $prefix . 'target' . $suffix,
				'id' => $id_prefix . 'target' . '_' . $button_id,
				'value' => impeka_grve_array_value( $item, 'target', '_self' ),
				'label' => esc_html__( 'Button Target', 'impeka' ),
			)
		);
	}

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'type' . $suffix,
			'id' => $id_prefix . 'type' . '_' . $button_id,
			'options' => array(
				'simple' => esc_html__( 'Simple', 'impeka' ),
				'outline' => esc_html__( 'Outline', 'impeka' ),
 				'line' => esc_html__( 'Line', 'impeka' ),
				'only-text' => esc_html__( 'Only Text', 'impeka' ),
				'video' => esc_html__( 'Video', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'type', '' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Type', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'color' . $suffix,
			'id' => $id_prefix . 'color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'color', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["outline","line", "only-text", "video"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'line_color' . $suffix,
			'id' => $id_prefix . 'line_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'line_color', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Line Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["line"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'line_position' . $suffix,
			'id' => $id_prefix . 'line_position' . '_' . $button_id,
			'options' => array(
				'left' => esc_html__( 'Left', 'impeka' ),
				'right' => esc_html__( 'Right', 'impeka' ),
 				'bottom' => esc_html__( 'Bottom', 'impeka' ),
				'bottom-advanced' => esc_html__( 'Bottom Advanced', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'line_position', 'left' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Line Positon', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["line"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color-gradient',
			'name' => $prefix . 'color_gradient' . $suffix,
			'id' => $id_prefix . 'color_gradient' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'color_gradient', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["simple"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'hover_color' . $suffix,
			'id' => $id_prefix . 'hover_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'hover_color', 'black' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Hover Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["only-text"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color-gradient',
			'name' => $prefix . 'hover_color_gradient' . $suffix,
			'id' => $id_prefix . 'hover_color_gradient' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'hover_color_gradient', 'black' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Hover Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["simple","outline"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'hover_action' . $suffix,
			'id' => $id_prefix . 'hover_action' . '_' . $button_id,
			'options' => array(
				'' => esc_html__( 'None', 'impeka' ),
				'pulse' => esc_html__( 'Pulse', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'hover_action' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Hover Action', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["simple","outline"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-size',
			'name' => $prefix . 'size' . $suffix,
			'value' => impeka_grve_array_value( $item, 'size', 'medium' ),
			'label' => esc_html__( 'Button Size', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-shape',
			'name' => $prefix . 'shape' . $suffix,
			'value' => impeka_grve_array_value( $item, 'shape', 'square' ),
			'label' => esc_html__( 'Button Shape', 'impeka' ),
			'group_id' => $group_id,
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["simple","outline"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'shadow' . $suffix,
			'value' => impeka_grve_array_value( $item, 'shadow' ),
			'options' => array(
				'' => esc_html__( 'None', 'impeka' ),
				'small' => esc_html__( 'Small', 'impeka' ),
				'medium' => esc_html__( 'Medium', 'impeka' ),
				'large' => esc_html__( 'Large', 'impeka' ),
			),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Shadow', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["simple"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'icon_type' . $suffix,
			'id' => $id_prefix . 'icon_type' . '_' . $button_id,
			'options' => array(
				'none' => esc_html__( 'None', 'impeka' ),
				'icon-svg' => esc_html__( 'Theme SVG Icon', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'icon_type', 'none' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Button Icon Type', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'svg_icon' . $suffix,
			'id' => $id_prefix . 'svg_icon' . '_' . $button_id,
			'options' => array(
				'arrow-1' => esc_html__( 'Arrow 1', 'impeka' ),
				'arrow-2' => esc_html__( 'Arrow 2', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'svg_icon', 'arrow-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'SVG Icon', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] },
				{ "id" : "' . $id_prefix . 'icon_type' . '_' . $button_id . '", "values" : ["icon-svg"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'svg_icon_shape' . $suffix,
			'id' => $id_prefix . 'svg_icon_shape' . '_' . $button_id,
			'options' => array(
				'' => esc_html__( 'None', 'impeka' ),
				'circle' => esc_html__( 'Circle', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'svg_icon_shape', '' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'SVG Icon Shape', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] },
				{ "id" : "' . $id_prefix . 'icon_type' . '_' . $button_id . '", "values" : ["icon-svg"] },
				{ "id" : "' . $id_prefix . 'svg_icon' . '_' . $button_id . '", "values" : ["arrow-1"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'svg_icon_shape_type' . $suffix,
			'id' => $id_prefix . 'svg_icon_shape_type' . '_' . $button_id,
			'options' => array(
				'simple' => esc_html__( 'Simple', 'impeka' ),
				'outline' => esc_html__( 'Outline', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'svg_icon_shape_type', 'simple' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'SVG Icon Shape Type', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] },
				{ "id" : "' . $id_prefix . 'icon_type' . '_' . $button_id . '", "values" : ["icon-svg"] },
				{ "id" : "' . $id_prefix . 'svg_icon' . '_' . $button_id . '", "values" : ["arrow-1"] },
				{ "id" : "' . $id_prefix . 'svg_icon_shape' . '_' . $button_id . '", "values" : ["circle"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'svg_icon_color' . $suffix,
			'id' => $id_prefix . 'svg_icon_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'svg_icon_color', 'white' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'SVG Icon Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] },
				{ "id" : "' . $id_prefix . 'icon_type' . '_' . $button_id . '", "values" : ["icon-svg"] },
				{ "id" : "' . $id_prefix . 'svg_icon' . '_' . $button_id . '", "values" : ["arrow-1"] },
				{ "id" : "' . $id_prefix . 'svg_icon_shape' . '_' . $button_id . '", "values" : ["circle"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'svg_icon_shape_color' . $suffix,
			'id' => $id_prefix . 'svg_icon_shape_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'svg_icon_shape_color', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'SVG Icon Shape Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "value_not_equal_to" : ["line", "video"] },
				{ "id" : "' . $id_prefix . 'icon_type' . '_' . $button_id . '", "values" : ["icon-svg"] },
				{ "id" : "' . $id_prefix . 'svg_icon' . '_' . $button_id . '", "values" : ["arrow-1"] },
				{ "id" : "' . $id_prefix . 'svg_icon_shape' . '_' . $button_id . '", "values" : ["circle"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'video_icon_shape' . $suffix,
			'id' => $id_prefix . 'video_icon_shape' . '_' . $button_id,
			'options' => array(
				'round' => esc_html__( 'Round', 'impeka' ),
				'circle' => esc_html__( 'Circle', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'video_icon_shape', 'round' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Video Icon Shape', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["video"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'video_icon_shape_type' . $suffix,
			'id' => $id_prefix . 'video_icon_shape_type' . '_' . $button_id,
			'options' => array(
				'simple' => esc_html__( 'Simple', 'impeka' ),
				'outline' => esc_html__( 'Outline', 'impeka' ),
			),
			'value' => impeka_grve_array_value( $item, 'video_icon_shape_type', 'simple' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Video Icon Shape Type', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["video"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'video_icon_shape_color' . $suffix,
			'id' => $id_prefix . 'video_icon_shape_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'video_icon_shape_color', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Video Icon Shape Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["video"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-button-color',
			'name' => $prefix . 'video_icon_shape_hover_color' . $suffix,
			'id' => $id_prefix . 'video_icon_shape_hover_color' . '_' . $button_id,
			'value' => impeka_grve_array_value( $item, 'video_icon_shape_hover_color', 'primary-1' ),
			'group_id' => $group_id,
			'label' => esc_html__( 'Video Icon Shape Hover Color', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'type' . '_' . $button_id . '", "values" : ["video"] },
				{ "id" : "' . $id_prefix . 'video_icon_shape_type' . '_' . $button_id . '", "values" : ["simple"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => $prefix . 'class' . $suffix,
			'value' => impeka_grve_array_value( $item, 'class' ),
			'label' => esc_html__( 'Button Class', 'impeka' ),
		)
	);

	echo '</div>';

}


/**
* Prints Item Overlay Options
*/
function impeka_grve_print_admin_feature_item_overlay_options( $item, $prefix = '_impeka_grve_single_item_', $suffix = '' ) {

	$id_prefix = str_replace( "[","_",$prefix );

	$overlay_id = impeka_grve_array_value( $item, 'id', uniqid() );
	$group_id = $id_prefix . 'overlay_container' . $overlay_id;

	$pattern_overlay = impeka_grve_array_value( $item, 'pattern_overlay' );
	$color_overlay = impeka_grve_array_value( $item, 'color_overlay', 'black' );
	$color_overlay_custom  = impeka_grve_array_value( $item, 'color_overlay_custom', '#000000' );
	$opacity_overlay = impeka_grve_array_value( $item, 'opacity_overlay', '0' );
	$gradient_overlay_custom_1 = impeka_grve_array_value( $item, 'gradient_overlay_custom_1', '#034e90' );
	$gradient_overlay_custom_1_opacity = impeka_grve_array_value( $item, 'gradient_overlay_custom_1_opacity', '0.90' );
	$gradient_overlay_custom_2 = impeka_grve_array_value( $item, 'gradient_overlay_custom_2', '#19b4d7' );
	$gradient_overlay_custom_2_opacity = impeka_grve_array_value( $item, 'gradient_overlay_custom_2_opacity', '0.90' );
	$gradient_overlay_direction  = impeka_grve_array_value( $item, 'gradient_overlay_direction', '90' );


	echo '<div id="' . esc_attr( $group_id ) . '">';

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-pattern-overlay',
			'name' => $prefix . 'pattern_overlay' . $suffix,
			'value' => $pattern_overlay,
			'label' => esc_html__( 'Pattern Overlay', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'color_overlay' . $suffix,
			'id' => $id_prefix . 'color_overlay' . $overlay_id,
			'value' => $color_overlay,
			'value2' => $color_overlay_custom,
			'default_value2' => $color_overlay_custom,
			'label' => esc_html__( 'Color Overlay', 'impeka' ),
			'multiple' => 'multi',
			'type_usage' => 'feature-bg',
			'group_id' => $group_id ,
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'opacity_overlay' . $suffix,
			'value' => $opacity_overlay,
			'label' => esc_html__( 'Opacity Overlay', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "value_not_equal_to" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'colorpicker',
			'name' => $prefix . 'gradient_overlay_custom_1' . $suffix,
			'value' => $gradient_overlay_custom_1,
			'label' => esc_html__( 'Custom Color 1', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'gradient_overlay_custom_1_opacity' . $suffix,
			'value' => $gradient_overlay_custom_1_opacity,
			'label' => esc_html__( 'Custom Color 1 Opacity', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'colorpicker',
			'name' => $prefix . 'gradient_overlay_custom_2' . $suffix,
			'value' => $gradient_overlay_custom_2,
			'label' => esc_html__( 'Custom Color 2', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'gradient_overlay_custom_2_opacity' . $suffix,
			'value' => $gradient_overlay_custom_2_opacity,
			'label' => esc_html__( 'Custom Color 2 Opacity', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'gradient_overlay_direction' . $suffix,
			'value' => $gradient_overlay_direction,
			'options' => array(
				'90' => esc_html__( "Left to Right", 'impeka' ),
				'135' => esc_html__( "Left Top to Right Bottom", 'impeka' ),
				'45' => esc_html__( "Left Bottom to Right Top", 'impeka' ),
				'180' => esc_html__( "Bottom to Top", 'impeka' ),
			),
			'label' => array(
				"title" => esc_html__( 'Gradient Direction', 'impeka' ),
			),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $overlay_id . '", "values" : ["gradient"] }
			]',
		)
	);

	echo '</div>';

}

/**
* Prints Item Content Options
*/
function impeka_grve_print_admin_feature_item_content_options( $item, $prefix = '_impeka_grve_single_item_', $suffix = '' ) {

	$item_id = impeka_grve_array_value( $item, 'id' );
	$title = impeka_grve_array_value( $item, 'title' );
	$content_bg_color = impeka_grve_array_value( $item, 'content_bg_color', 'none' );
	$content_bg_color_custom = impeka_grve_array_value( $item, 'content_bg_color_custom', '#ffffff' );
	$title_color = impeka_grve_array_value( $item, 'title_color', 'white' );
	$title_color_custom = impeka_grve_array_value( $item, 'title_color_custom', '#ffffff' );
	$title_tag = impeka_grve_array_value( $item, 'title_tag', 'div' );
	$title_heading = impeka_grve_array_value( $item, 'title_heading', 'feature-title' );
	$caption = impeka_grve_array_value( $item, 'caption' );
	$caption_color = impeka_grve_array_value( $item, 'caption_color', 'white' );
	$caption_color_custom = impeka_grve_array_value( $item, 'caption_color_custom', '#ffffff' );
	$caption_tag = impeka_grve_array_value( $item, 'caption_tag', 'div' );
	$caption_heading = impeka_grve_array_value( $item, 'caption_heading', 'feature-text' );
	$subheading = impeka_grve_array_value( $item, 'subheading' );
	$subheading_color = impeka_grve_array_value( $item, 'subheading_color', 'white' );
	$subheading_color_custom = impeka_grve_array_value( $item, 'subheading_color_custom', '#ffffff' );
	$subheading_tag = impeka_grve_array_value( $item, 'subheading_tag', 'div' );
	$subheading_heading = impeka_grve_array_value( $item, 'subheading_heading', 'feature-subheading' );

	$subheading_family = impeka_grve_array_value( $item, 'subheading_family' );
	$title_family = impeka_grve_array_value( $item, 'title_family' );
	$caption_family = impeka_grve_array_value( $item, 'caption_family' );

	$content_size = impeka_grve_array_value( $item, 'content_size', 'container' );
	$content_align = impeka_grve_array_value( $item, 'content_align', 'center' );
	$content_position = impeka_grve_array_value( $item, 'content_position', 'center-center' );
	$content_animation = impeka_grve_array_value( $item, 'content_animation', 'none' );
	$content_image_id = impeka_grve_array_value( $item, 'content_image_id', '0' );
	$content_image_size = impeka_grve_array_value( $item, 'content_image_size' );
	$content_image_max_height = impeka_grve_array_value( $item, 'content_image_max_height', '150' );
	$content_image_responsive_max_height = impeka_grve_array_value( $item, 'content_image_responsive_max_height', '50' );

	$container_size = impeka_grve_array_value( $item, 'container_size' );



	$id_prefix = str_replace( "[","_",$prefix );

	$type = impeka_grve_array_value( $item, 'type' );

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'container_size' . $suffix,
			'options' => array(
				'' => esc_html__( 'Default', 'impeka' ),
				'large' => esc_html__( 'Large', 'impeka' ),
			),
			'value' => $container_size,
			'label' => esc_html__( 'Container Size', 'impeka' ),
		)
	);

	if ( 'post' == $type ) {
?>
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'content_image_id' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'content_image_size' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'content_image_max_height' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'content_image_responsive_max_height' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'subheading' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'title' . $suffix ); ?>" value="" />
		<input type="hidden" name="<?php echo esc_attr( $prefix . 'caption' . $suffix ); ?>" value="" />
<?php

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'title_content_bg_color' . $suffix,
				'value' => $content_bg_color,
				'value2' => $content_bg_color_custom,
				'default_value2' => $content_bg_color_custom,
				'label' => array(
					"title" => esc_html__( 'Content Background Color', 'impeka' ),
				),
				'multiple' => 'multi',
				'type_usage' => 'title-content-bg',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'subheading_color' . $suffix,
				'value' => $subheading_color,
				'value2' => $subheading_color_custom,
				'default_value2' => $subheading_color_custom,
				'label' => esc_html__( 'Post Meta Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'title_color' . $suffix,
				'value' => $title_color,
				'value2' => $title_color_custom,
				'default_value2' => $title_color_custom,
				'label' => esc_html__( 'Post Title Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'caption_color' . $suffix,
				'value' => $caption_color,
				'value2' => $caption_color_custom,
				'default_value2' => $caption_color_custom,
				'label' => esc_html__( 'Post Description Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'subheading_tag' . $suffix,
				'value' => $subheading_tag,
				'label' => esc_html__( 'Post Meta Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'title_tag' . $suffix,
				'value' => $title_tag,
				'label' => esc_html__( 'Post Title Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'caption_tag' . $suffix,
				'value' => $caption_tag,
				'label' => esc_html__( 'Post Description Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'subheading_heading' . $suffix,
				'value' => $subheading_heading,
				'label' => esc_html__( 'Post Meta Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'title_heading' . $suffix,
				'value' => $title_heading,
				'label' => esc_html__( 'Post Title Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'caption_heading' . $suffix,
				'value' => $caption_heading,
				'label' => esc_html__( 'Post Description Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'subheading_family' . $suffix,
				'value' => $subheading_family,
				'label' => esc_html__( 'Post Meta Font Family', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'title_family' . $suffix,
				'value' => $title_family,
				'label' => esc_html__( 'Post Title Font Family', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'caption_family' . $suffix,
				'value' => $caption_family,
				'label' => esc_html__( 'Post Description Font Family', 'impeka' ),
			)
		);

	} else {
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-image',
				'name' => $prefix . 'content_image_id' . $suffix,
				'value' => $content_image_id,
				'label' => array(
					"title" => esc_html__( 'Graphic Image', 'impeka' ),
				),
				'width' => 'fullwidth',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => $prefix . 'content_image_size' . $suffix,
				'options' => array(
					'' => esc_html__( 'Resize ( Medium )', 'impeka' ),
					'full' => esc_html__( 'Full size', 'impeka' ),
				),
				'value' => $content_image_size,
				'label' => esc_html__( 'Graphic Image Size', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => $prefix . 'content_image_max_height' . $suffix,
				'value' => $content_image_max_height,
				'label' => esc_html__( 'Graphic Image Max Height', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => $prefix . 'content_image_responsive_max_height' . $suffix,
				'value' => $content_image_responsive_max_height,
				'label' => esc_html__( 'Graphic Image responsive Max Height', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textarea',
				'name' => $prefix . 'subheading' . $suffix,
				'value' => $subheading,
				'label' => esc_html__( 'Sub Heading', 'impeka' ),
				'width' => 'fullwidth',
				'rows' => 2,
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textarea',
				'name' => $prefix . 'title' . $suffix,
				'value' => $title,
				'label' => esc_html__( 'Title', 'impeka' ),
				'extra_class' =>  'grve-admin-label-update',
				'id' => $prefix . 'title' . $item_id,
				'width' => 'fullwidth',
				'rows' => 2,
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textarea',
				'name' => $prefix . 'caption' . $suffix,
				'value' => $caption,
				'label' => esc_html__( 'Description', 'impeka' ),
				'width' => 'fullwidth',
				'rows' => 2,
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'title_content_bg_color' . $suffix,
				'value' => $content_bg_color,
				'value2' => $content_bg_color_custom,
				'default_value2' => $content_bg_color_custom,
				'label' => array(
					"title" => esc_html__( 'Content Background Color', 'impeka' ),
				),
				'multiple' => 'multi',
				'type_usage' => 'title-content-bg',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'subheading_color' . $suffix,
				'value' => $subheading_color,
				'value2' => $subheading_color_custom,
				'default_value2' => $subheading_color_custom,
				'label' => esc_html__( 'Sub Heading Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'title_color' . $suffix,
				'value' => $title_color,
				'value2' => $title_color_custom,
				'default_value2' => $title_color_custom,
				'label' => esc_html__( 'Title Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select-colorpicker',
				'name' => $prefix . 'caption_color' . $suffix,
				'value' => $caption_color,
				'value2' => $caption_color_custom,
				'default_value2' => $caption_color_custom,
				'label' => esc_html__( 'Description Color', 'impeka' ),
				'multiple' => 'multi',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'subheading_tag' . $suffix,
				'value' => $subheading_tag,
				'label' => esc_html__( 'Sub Heading Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'title_tag' . $suffix,
				'value' => $title_tag,
				'label' => esc_html__( 'Title Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-tag',
				'name' => $prefix . 'caption_tag' . $suffix,
				'value' => $caption_tag,
				'label' => esc_html__( 'Description Tag', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'subheading_heading' . $suffix,
				'value' => $subheading_heading,
				'label' => esc_html__( 'Sub Heading Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'title_heading' . $suffix,
				'value' => $title_heading,
				'label' => esc_html__( 'Title Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-heading',
				'name' => $prefix . 'caption_heading' . $suffix,
				'value' => $caption_heading,
				'label' => esc_html__( 'Description Size/Typography', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'subheading_family' . $suffix,
				'value' => $subheading_family,
				'label' => esc_html__( 'Sub Heading Font Family', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'title_family' . $suffix,
				'value' => $title_family,
				'label' => esc_html__( 'Title Font Family', 'impeka' ),
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'select-custom-font-family',
				'name' => $prefix . 'caption_family' . $suffix,
				'value' => $caption_family,
				'label' => esc_html__( 'Description Font Family', 'impeka' ),
			)
		);

	}

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'content_size' . $suffix,
			'options' => array(
				'container' => esc_html__( 'Container Size', 'impeka' ),
				'large' => esc_html__( 'Large', 'impeka' ),
				'medium' => esc_html__( 'Medium', 'impeka' ),
				'small' => esc_html__( 'Small', 'impeka' ),
			),
			'value' => $content_size,
			'label' => esc_html__( 'Content Size', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-align',
			'name' => $prefix . 'content_align' . $suffix,
			'value' => $content_align,
			'label' => esc_html__( 'Content Alignment', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-position',
			'name' => $prefix . 'content_position' . $suffix,
			'value' => $content_position,
			'label' => esc_html__( 'Content Position', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-text-animation',
			'name' => $prefix . 'content_animation' . $suffix,
			'value' => $content_animation,
			'label' => esc_html__( 'Content Animation', 'impeka' ),
		)
	);

}

function impeka_grve_print_admin_feature_item_posts_slider_content_options( $item, $prefix = '_impeka_grve_single_item_', $suffix = '' ) {

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'title_color' . $suffix,
			'value' => impeka_grve_array_value( $item, 'title_color', 'white' ),
			'value2' => impeka_grve_array_value( $item, 'title_color_custom', '#ffffff' ),
			'default_value2' => '#ffffff',
			'label' => esc_html__( 'Title Color', 'impeka' ),
			'multiple' => 'multi',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'caption_color' . $suffix,
			'value' => impeka_grve_array_value( $item, 'caption_color', 'white' ),
			'value2' => impeka_grve_array_value( $item, 'caption_color_custom', '#ffffff' ),
			'default_value2' => '#ffffff',
			'label' => esc_html__( 'Description Color', 'impeka' ),
			'multiple' => 'multi',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-tag',
			'name' => $prefix . 'title_tag' . $suffix,
			'value' => impeka_grve_array_value( $item, 'title_tag', 'div' ),
			'label' => esc_html__( 'Title Tag', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-tag',
			'name' => $prefix . 'caption_tag' . $suffix,
			'value' => impeka_grve_array_value( $item, 'caption_tag', 'div' ),
			'label' => esc_html__( 'Description Tag', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-heading',
			'name' => $prefix . 'title_heading' . $suffix,
			'value' => impeka_grve_array_value( $item, 'title_heading', 'feature-title' ),
			'label' => esc_html__( 'Title Size/Typography', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-heading',
			'name' => $prefix . 'caption_heading' . $suffix,
			'value' => impeka_grve_array_value( $item, 'caption_heading', 'feature-text' ),
			'label' => esc_html__( 'Description Size/Typography', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-custom-font-family',
			'name' => $prefix . 'title_family' . $suffix,
			'value' => impeka_grve_array_value( $item, 'title_family' ),
			'label' => esc_html__( 'Title Font Family', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-custom-font-family',
			'name' => $prefix . 'caption_family' . $suffix,
			'value' => impeka_grve_array_value( $item, 'caption_family' ),
			'label' => esc_html__( 'Description Font Family', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => $prefix . 'excerpt_length' . $suffix,
				'value' => impeka_grve_array_value( $item, 'excerpt_length', '10' ),
				'label' => esc_html__( 'Excerpt Length', 'impeka' ),
			)
		);


}

/**
 * Prints Item Background Image Options
 */
function impeka_grve_print_admin_feature_item_posts_slider_bg_options( $item, $prefix = '_impeka_grve_post_type_slider_settings_', $suffix = '' ) {

	$id_prefix = str_replace( "[","_",$prefix );

	$bg_id = impeka_grve_array_value( $item, 'id', uniqid() );
	$group_id = $id_prefix . 'bg_container' . $bg_id;


	echo '<div id="' . esc_attr( $group_id ) . '">';

	//Colors
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'bg_color' . $suffix,
			'id' => $id_prefix . 'bg_color' . $bg_id,
			'value' => impeka_grve_array_value( $item, 'bg_color', 'black' ),
			'value2' => impeka_grve_array_value( $item, 'bg_color_custom', '#eef1f6' ),
			'default_value2' => '#eef1f6',
			'label' => esc_html__( 'Background Color', 'impeka' ),
			'multiple' => 'multi',
			'group_id' => $group_id ,
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'bg_image_size' . $suffix,
			'value' => impeka_grve_array_value( $item, 'bg_image_size' ),
			'options' => array(
				'' => esc_html__( '--Inherit--', 'impeka' ),
				'responsive' => esc_html__( 'Responsive', 'impeka' ),
				'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka' ),
				'full' => esc_html__( 'Full', 'impeka' ),
			),
			'label' => array(
				"title" => esc_html__( 'Background Image Size', 'impeka' ),
				"desc" => esc_html__( 'Inherit : Theme Options - Media Sizes.', 'impeka' ),
			),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-position',
			'name' => $prefix . 'bg_position' . $suffix,
			'value' => impeka_grve_array_value( $item, 'bg_position', 'center-center' ),
			'label' => esc_html__( 'Background Position', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-position-inherit',
			'name' => $prefix . 'bg_tablet_sm_position' . $suffix,
			'value' => impeka_grve_array_value( $item, 'bg_tablet_sm_position' ),
			'label' => array(
				"title" => esc_html__( 'Background Position ( Tablet Portrait )', 'impeka' ),
				"desc" => esc_html__( 'Tablet devices with portrait orientation and below.', 'impeka' ),
			),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'color_overlay' . $suffix,
			'id' => $id_prefix . 'color_overlay' . $bg_id,
			'value' => impeka_grve_array_value( $item, 'color_overlay', 'black' ),
			'value2' => impeka_grve_array_value( $item, 'color_overlay_custom', '#000000' ),
			'default_value2' => '#000000',
			'label' => esc_html__( 'Color Overlay', 'impeka' ),
			'multiple' => 'multi',
			'type_usage' => 'feature-bg',
			'group_id' => $group_id ,
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'opacity_overlay' . $suffix,
			'value' => impeka_grve_array_value( $item, 'opacity_overlay', '0' ),
			'label' => esc_html__( 'Opacity Overlay', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "value_not_equal_to" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'colorpicker',
			'name' => $prefix . 'gradient_overlay_custom_1' . $suffix,
			'value' => impeka_grve_array_value( $item, 'gradient_overlay_custom_1', '#034e90' ),
			'label' => esc_html__( 'Custom Color 1', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'gradient_overlay_custom_1_opacity' . $suffix,
			'value' => impeka_grve_array_value( $item, 'gradient_overlay_custom_1_opacity', '0.90' ),
			'label' => esc_html__( 'Custom Color 1 Opacity', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'colorpicker',
			'name' => $prefix . 'gradient_overlay_custom_2' . $suffix,
			'value' => impeka_grve_array_value( $item, 'gradient_overlay_custom_2', '#19b4d7' ),
			'label' => esc_html__( 'Custom Color 2', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-opacity',
			'name' => $prefix . 'gradient_overlay_custom_2_opacity' . $suffix,
			'value' => impeka_grve_array_value( $item, 'gradient_overlay_custom_2_opacity', '0.90' ),
			'label' => esc_html__( 'Custom Color 2 Opacity', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "values" : ["gradient"] }
			]',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'gradient_overlay_direction' . $suffix,
			'value' => impeka_grve_array_value( $item, 'gradient_overlay_direction', '90' ),
			'options' => array(
				'90' => esc_html__( "Left to Right", 'impeka' ),
				'135' => esc_html__( "Left Top to Right Bottom", 'impeka' ),
				'45' => esc_html__( "Left Bottom to Right Top", 'impeka' ),
				'180' => esc_html__( "Bottom to Top", 'impeka' ),
			),
			'label' => array(
				"title" => esc_html__( 'Gradient Direction', 'impeka' ),
			),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'color_overlay' . $bg_id . '", "values" : ["gradient"] }
			]',
		)
	);
	echo '</div>';


}

/**
* Prints Item Go To Section Options
*/
function impeka_grve_print_admin_feature_item_go_to_section_options( $item, $prefix = '_impeka_grve_single_item_', $suffix = '' ) {


	$id_prefix = str_replace( "[","_",$prefix );

	$arrow_enabled = impeka_grve_array_value( $item, 'arrow_enabled', 'no' );
	$arrow_text = impeka_grve_array_value( $item, 'arrow_text', 'Scroll Down' );
	$arrow_color = impeka_grve_array_value( $item, 'arrow_color', 'white' );
	$arrow_color_custom = impeka_grve_array_value( $item, 'arrow_color_custom', '#ffffff' );
	$arrow_id = uniqid();
	$group_id = $id_prefix . $arrow_id;

	echo '<div id="' . esc_attr( $group_id ) . '">';

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => $prefix . 'arrow_enabled' . $suffix,
			'value' => $arrow_enabled,
			'id' => $id_prefix . 'arrow_enabled' . '_' . $arrow_id,
			'group_id' => $group_id,
			'options' => array(
				'no' => esc_html__( 'None', 'impeka' ),
				'yes' => esc_html__( 'Arrow', 'impeka' ),
				'text' => esc_html__( 'Arrow & Text', 'impeka' ),
			),
			'label' => esc_html__( 'Scroll to Content', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => $prefix . 'arrow_text' . $suffix,
			'value' => $arrow_text,
			'label' => esc_html__( 'Scroll to Content Text', 'impeka' ),
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'arrow_enabled' . '_' . $arrow_id . '", "values" : ["text"] }
			]',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-colorpicker',
			'name' => $prefix . 'arrow_color' . $suffix,
			'value' => $arrow_color,
			'value2' => $arrow_color_custom,
			'default_value2' => $arrow_color_custom,
			'label' => esc_html__( 'Scroll to Content Color', 'impeka' ),
			'multiple' => 'multi',
			'dependency' =>
			'[
				{ "id" : "' . $id_prefix . 'arrow_enabled' . '_' . $arrow_id . '", "value_not_equal_to" : ["no"] }
			]',
		)
	);

	echo '</div>';

}

/**
* Prints Item Extra Options
*/
function impeka_grve_print_admin_feature_item_extra_options( $item, $prefix = '_impeka_grve_single_item_', $suffix = '' ) {

	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => $prefix . 'el_class' . $suffix,
			'value' => impeka_grve_array_value( $item, 'el_class' ),
			'label' => esc_html__( 'Extra Class', 'impeka' ),
		)
	);

}

/**
 * Prints Item Background Image Options
 */
function impeka_grve_print_admin_feature_item_background_options( $item ) {

	$bg_image_id = impeka_grve_array_value( $item, 'bg_image_id', '0' );
	$bg_image_size = impeka_grve_array_value( $item, 'bg_image_size' );
	$bg_position = impeka_grve_array_value( $item, 'bg_position', 'center-center' );
	$bg_tablet_sm_position = impeka_grve_array_value( $item, 'bg_tablet_sm_position' );
	$image_effect = impeka_grve_array_value( $item, 'image_effect' );


	impeka_grve_print_admin_option(
		array(
			'type' => 'select-image',
			'name' => '_impeka_grve_single_item_bg_image_id',
			'value' => $bg_image_id,
			'label' => array(
				"title" => esc_html__( 'Background Image', 'impeka' ),
				"desc" => esc_html__( 'Used also as fallback image for HTML5/YouTube/Vimeo Video.', 'impeka' ),
			),
			'width' => 'fullwidth',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => '_impeka_grve_single_item_bg_image_size',
			'value' => $bg_image_size,
			'options' => array(
				'' => esc_html__( '--Inherit--', 'impeka' ),
				'responsive' => esc_html__( 'Responsive', 'impeka' ),
				'extra-extra-large' => esc_html__( 'Extra Extra Large', 'impeka' ),
				'full' => esc_html__( 'Full', 'impeka' ),
			),
			'label' => array(
				"title" => esc_html__( 'Background Image Size', 'impeka' ),
				"desc" => esc_html__( 'Inherit : Theme Options - Media Sizes.', 'impeka' ),
			),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-position',
			'name' => '_impeka_grve_single_item_bg_position',
			'value' => $bg_position,
			'label' => esc_html__( 'Background Position', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-position-inherit',
			'name' => '_impeka_grve_single_item_bg_tablet_sm_position',
			'value' => $bg_tablet_sm_position,
			'label' => array(
				"title" => esc_html__( 'Background Position ( Tablet Portrait )', 'impeka' ),
				"desc" => esc_html__( 'Tablet devices with portrait orientation and below.', 'impeka' ),
			),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => '_impeka_grve_single_item_image_effect',
			'options' => array(
				'' => esc_html__( 'None', 'impeka' ),
				'animated' => esc_html__( 'Animated', 'impeka' ),
				'parallax' => esc_html__( 'Classic Parallax', 'impeka' ),
				'advanced-parallax' => esc_html__( 'Advanced Parallax', 'impeka' ),
				'fixed-section' => esc_html__( 'Fixed Section', 'impeka' ),
			),
			'value' => $image_effect,
			'label' => esc_html__( 'Background Effect', 'impeka' ),
			'wrap_class' => 'grve-feature-required grve-item-feature-image-settings',
		)
	);

}

/**
 * Prints Item Background Video Options
 */
function impeka_grve_print_admin_feature_item_video_options( $item ) {

	$video_webm = impeka_grve_array_value( $item, 'video_webm' );
	$video_mp4 = impeka_grve_array_value( $item, 'video_mp4' );
	$video_ogv = impeka_grve_array_value( $item, 'video_ogv' );
	$video_poster = impeka_grve_array_value( $item, 'video_poster', 'no' );
	$video_device = impeka_grve_array_value( $item, 'video_device', 'no' );
	$video_loop = impeka_grve_array_value( $item, 'video_loop', 'yes' );
	$video_muted = impeka_grve_array_value( $item, 'video_muted', 'yes' );
	$video_effect = impeka_grve_array_value( $item, 'video_effect' );

	impeka_grve_print_admin_option(
		array(
			'type' => 'label',
			'label' => esc_html__( 'HTML5 Video', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-video',
			'name' => '_impeka_grve_single_item_video_webm',
			'value' => $video_webm,
			'label' => esc_html__( 'WebM File URL', 'impeka' ),
			'width' => 'fullwidth',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-video',
			'name' => '_impeka_grve_single_item_video_mp4',
			'value' => $video_mp4,
			'label' => esc_html__( 'MP4 File URL', 'impeka' ),
			'width' => 'fullwidth',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-bg-video',
			'name' => '_impeka_grve_single_item_video_ogv',
			'value' => $video_ogv,
			'label' => esc_html__( 'OGV File URL', 'impeka' ),
			'width' => 'fullwidth',
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-boolean',
			'name' => '_impeka_grve_single_item_video_poster',
			'value' => $video_poster,
			'label' => esc_html__( 'Use Fallback Image as Poster', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select-boolean',
			'name' => '_impeka_grve_single_item_video_device',
			'value' => $video_device,
			'label' => esc_html__( 'Show video on devices', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-boolean',
			'name' => '_impeka_grve_single_item_video_loop',
			'value' => $video_loop,
			'label' => esc_html__( 'Loop', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'select-boolean',
			'name' => '_impeka_grve_single_item_video_muted',
			'value' => $video_muted,
			'label' => esc_html__( 'Muted', 'impeka' ),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'select',
			'name' => '_impeka_grve_single_item_video_effect',
			'options' => array(
				'' => esc_html__( 'None', 'impeka' ),
				'animated' => esc_html__( 'Animated', 'impeka' ),
				'parallax' => esc_html__( 'Classic Parallax', 'impeka' ),
				'advanced-parallax' => esc_html__( 'Advanced Parallax', 'impeka' ),
				'fixed-section' => esc_html__( 'Fixed Section', 'impeka' ),
			),
			'value' => $video_effect,
			'label' => esc_html__( 'Video Effect', 'impeka' ),
		)
	);


}

/**
 * Prints Item Background Video Options
 */
function impeka_grve_print_admin_feature_item_youtube_options( $item ) {

	$video_url = impeka_grve_array_value( $item, 'video_url' );
	$video_start = impeka_grve_array_value( $item, 'video_start' );
	$video_end = impeka_grve_array_value( $item, 'video_end' );
	impeka_grve_print_admin_option(
		array(
			'type' => 'label',
			'label' => esc_html__( 'YouTube/Vimeo Video', 'impeka' ),
		)
	);

	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => '_impeka_grve_single_item_video_url',
			'value' => $video_url,
			'label' => array(
				"title" => esc_html__( 'YouTube/Vimeo link', 'impeka' ),
				"desc" => esc_html__( 'e.g: https://www.youtube.com/watch?v=lMJXxhRFO1k', 'impeka' ),
			),
			'width' => 'fullwidth',
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => '_impeka_grve_single_item_video_start',
			'value' => $video_start,
			'label' => array(
				"title" => esc_html__( 'Start at:', 'impeka' ),
				"desc" => esc_html__( 'Value in seconds', 'impeka' ),
			),
		)
	);
	impeka_grve_print_admin_option(
		array(
			'type' => 'textfield',
			'name' => '_impeka_grve_single_item_video_end',
			'value' => $video_end,
			'label' => array(
				"title" => esc_html__( 'End at:', 'impeka' ),
				"desc" => esc_html__( 'Value in seconds', 'impeka' ),
			),
		)
	);
}

function impeka_grve_admin_get_feature_section( $post_id ) {

	$area_height = impeka_grve_global_admin_param( 'area_height' );
	$post_type = get_post_type( $post_id );

	//Feature Section
	$feature_section = get_post_meta( $post_id, '_impeka_grve_feature_section', true );

	//Feature Settings
	$feature_settings = impeka_grve_array_value( $feature_section, 'feature_settings' );

	$feature_element = impeka_grve_array_value( $feature_settings, 'element' );
	$feature_size = impeka_grve_array_value( $feature_settings, 'size' );
	$feature_height = impeka_grve_array_value( $feature_settings, 'height', '60' );
	$feature_min_height = impeka_grve_array_value( $feature_settings, 'min_height', '200' );
	$feature_bg_color  = impeka_grve_array_value( $feature_settings, 'bg_color', 'black' );
	$feature_bg_color_custom  = impeka_grve_array_value( $feature_settings, 'bg_color_custom', '#eef1f6' );
	$feature_header_position = impeka_grve_array_value( $feature_settings, 'header_position', 'above' );
	$feature_bg_gradient_color_1  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_1', '#034e90' );
	$feature_bg_gradient_color_2  = impeka_grve_array_value( $feature_settings, 'bg_gradient_color_2', '#19b4d7' );
	$feature_bg_gradient_direction  = impeka_grve_array_value( $feature_settings, 'bg_gradient_direction', '90' );
	$feature_separator_bottom  = impeka_grve_array_value( $feature_settings, 'separator_bottom' );
	$feature_separator_bottom_size  = impeka_grve_array_value( $feature_settings, 'separator_bottom_size', '90px' );
	$feature_separator_bottom_color  = impeka_grve_array_value( $feature_settings, 'separator_bottom_color', '#ffffff' );


	//Feature Single Item
	$feature_single_item = impeka_grve_array_value( $feature_section, 'single_item' );
	$feature_single_item_button = impeka_grve_array_value( $feature_single_item, 'button' );
	$feature_single_item_button2 = impeka_grve_array_value( $feature_single_item, 'button2' );


	//Slider Item
	$slider_items = impeka_grve_array_value( $feature_section, 'slider_items' );
	$slider_settings = impeka_grve_array_value( $feature_section, 'slider_settings' );

	$slider_speed = impeka_grve_array_value( $slider_settings, 'slideshow_speed', '3500' );
	$slider_pause = impeka_grve_array_value( $slider_settings, 'slider_pause', 'no' );
	$slider_nav_style = impeka_grve_array_value( $slider_settings, 'nav_style', '1' );
	$slider_arrows = impeka_grve_array_value( $slider_settings, 'arrows', 'yes' );
	$slider_dir_nav_color = impeka_grve_array_value( $slider_settings, 'direction_nav_color', 'white' );
	$slider_transition = impeka_grve_array_value( $slider_settings, 'transition', 'slide' );
	$slider_effect = impeka_grve_array_value( $slider_settings, 'slider_effect' );
	$slider_pagination = impeka_grve_array_value( $slider_settings, 'pagination', 'yes' );

	//Map Item
	$map_items = impeka_grve_array_value( $feature_section, 'map_items' );
	$map_settings = impeka_grve_array_value( $feature_section, 'map_settings' );

	$map_zoom = impeka_grve_array_value( $map_settings, 'zoom', 14 );
	$map_marker_type = impeka_grve_array_value( $map_settings, 'marker_type' );
	$map_marker = impeka_grve_array_value( $map_settings, 'marker' );
	$map_marker_bg_color = impeka_grve_array_value( $map_settings, 'marker_bg_color', 'primary-1' );
	$map_disable_style = impeka_grve_array_value( $map_settings, 'disable_style', 'no' );

	//Revolution slider
	$revslider_alias = impeka_grve_array_value( $feature_section, 'revslider_alias' );



?>

		<div class="grve-fields-wrapper grve-highlight">
			<div class="grve-label">
				<label for="grve-page-feature-element">
					<span class="grve-title"><?php esc_html_e( 'Feature Element', 'impeka' ); ?></span>
					<span class="grve-description"><?php esc_html_e( 'Select feature section element', 'impeka' ); ?></span>
				</label>
			</div>
			<div class="grve-field-items-wrapper">
				<div class="grve-field-item">
					<select id="grve-page-feature-element" name="_impeka_grve_page_feature_element">
						<option value="" <?php selected( "", $feature_element ); ?>><?php esc_html_e( 'None', 'impeka' ); ?></option>
						<optgroup label="<?php esc_attr_e( 'Post Types Overviews', 'impeka' ); ?>">
							<option value="posts-slider-style-1" <?php selected( "posts-slider-style-1", $feature_element ); ?>><?php esc_html_e( 'Posts Slider Style 1', 'impeka' ); ?></option>
							<option value="posts-slider-style-2" <?php selected( "posts-slider-style-2", $feature_element ); ?>><?php esc_html_e( 'Posts Slider Style 2', 'impeka' ); ?></option>
							<option value="posts-slider-style-3" <?php selected( "posts-slider-style-3", $feature_element ); ?>><?php esc_html_e( 'Posts Slider Style 3', 'impeka' ); ?></option>
							<option value="posts-slider-style-4" <?php selected( "posts-slider-style-4", $feature_element ); ?>><?php esc_html_e( 'Posts Slider Style 4', 'impeka' ); ?></option>
						 </optgroup>
						<optgroup label="<?php esc_attr_e( 'Custom Elements', 'impeka' ); ?>">
							<option value="title" <?php selected( "title", $feature_element ); ?>><?php esc_html_e( 'Title', 'impeka' ); ?></option>
							<option value="image" <?php selected( "image", $feature_element ); ?>><?php esc_html_e( 'Image', 'impeka' ); ?></option>
							<option value="video" <?php selected( "video", $feature_element ); ?>><?php esc_html_e( 'HTML5 Video', 'impeka' ); ?></option>
							<option value="youtube" <?php selected( "youtube", $feature_element ); ?>><?php esc_html_e( 'YouTube/Vimeo', 'impeka' ); ?></option>
							<option value="slider" <?php selected( "slider", $feature_element ); ?>><?php esc_html_e( 'Slider', 'impeka' ); ?></option>
							<option value="map" <?php selected( "map", $feature_element ); ?>><?php esc_html_e( 'Map', 'impeka' ); ?></option>
						 </optgroup>
						 <optgroup label="<?php esc_attr_e( 'External Plugins', 'impeka' ); ?>">
							<option value="revslider" <?php selected( "revslider", $feature_element ); ?>><?php esc_html_e( 'Revolution Slider', 'impeka' ); ?></option>
						 </optgroup>
					</select>
				</div>
			</div>
		</div>

		<div id="grve-feature-section-post-type-slider-settings" class="grve-feature-section-item postbox">

			<?php

				$post_type_slider_settings = impeka_grve_array_value( $feature_section, 'post_type_slider_settings' );
				$post_type_slider_settings_button = impeka_grve_array_value( $post_type_slider_settings, 'button' );

				$nav_color_selection = array(
					'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
					'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
					'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
					'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
					'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
					'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
					'green' => esc_html__( 'Green', 'impeka' ),
					'orange' => esc_html__( 'Orange', 'impeka' ),
					'red' => esc_html__( 'Red', 'impeka' ),
					'blue' => esc_html__( 'Blue', 'impeka' ),
					'aqua' => esc_html__( 'Aqua', 'impeka' ),
					'purple' => esc_html__( 'Purple', 'impeka' ),
					'black' => esc_html__( 'Black', 'impeka' ),
					'grey' => esc_html__( 'Grey', 'impeka' ),
					'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
					'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
					'white' => esc_html__( 'White', 'impeka' ),
				);


				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'options' => array(
							'latest' => esc_html__( 'Latest', 'impeka' ),
							'specific_posts' => esc_html__( 'Include Specific Posts', 'impeka' ),
						),
						'name' => '_impeka_grve_post_type_slider_settings[post_method]',
						'id' => '_impeka_grve_post_type_slider_settings_post_method',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'post_method', 'latest' ),
						'label' => array(
							'title' => esc_html__( 'Query Method', 'impeka' ),
							'desc' => esc_html__( 'Select the query method ', 'impeka' ),
						),
						'group_id' => 'grve-feature-section-post-type-slider-settings',
					)
				);

				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'options' => array(
							'post' => esc_html__( 'Post', 'impeka' ),
							'portfolio' => esc_html__( 'Portfolio', 'impeka' ),
							'product' => esc_html__( 'Product', 'impeka' ),
						),
						'name' => '_impeka_grve_post_type_slider_settings[post_type]',
						'id' => '_impeka_grve_post_type_slider_settings_post_type',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'post_type', 'post' ),
						'label' => array(
							'title' => esc_html__( 'Post Type', 'impeka' ),
							'desc' => esc_html__( 'Select Post Type', 'impeka' ),
						),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["latest"] }
						]',
						'group_id' => 'grve-feature-section-post-type-slider-settings',
					)
				);
				
				impeka_grve_print_admin_option(
					array(
						'type' => 'category-multiselect',
						'name' => '_impeka_grve_post_type_slider_settings[post_categories]',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'post_categories', '' ),
						'label' => array(
							'title' => esc_html__( 'Post Categories', 'impeka' ),
							'desc' => esc_html__( 'Select post categories', 'impeka' ),
							'info' => esc_html__( 'You can select/deselect multiple items ( ctrl + click on PC and command + click on Mac).', 'impeka' ),
						),
						'term_slug' => 'category',
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["latest"] },
							{ "id" : "_impeka_grve_post_type_slider_settings_post_type", "values" : ["post"] }
						]',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'category-multiselect',
						'name' => '_impeka_grve_post_type_slider_settings[portfolio_categories]',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'portfolio_categories', '' ),
						'label' => array(
							'title' => esc_html__( 'Portfolio Categories', 'impeka' ),
							'desc' => esc_html__( 'Select portfolio categories', 'impeka' ),
							'info' => esc_html__( 'You can select/deselect multiple items ( ctrl + click on PC and command + click on Mac).', 'impeka' ),
						),
						'term_slug' => 'portfolio_category',
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["latest"] },
							{ "id" : "_impeka_grve_post_type_slider_settings_post_type", "values" : ["portfolio"] }
						]',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'category-multiselect',
						'name' => '_impeka_grve_post_type_slider_settings[product_categories]',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'product_categories', '' ),
						'label' => array(
							'title' => esc_html__( 'Product Categories', 'impeka' ),
							'desc' => esc_html__( 'Select product categories', 'impeka' ),
							'info' => esc_html__( 'You can select/deselect multiple items ( ctrl + click on PC and command + click on Mac).', 'impeka' ),
						),
						'term_slug' => 'product_cat',
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["latest"] },
							{ "id" : "_impeka_grve_post_type_slider_settings_post_type", "values" : ["product"] }
						]',
					)
				);					

				impeka_grve_print_admin_option(
					array(
						'type' => 'textfield',
						'name' => '_impeka_grve_post_type_slider_settings[posts_per_page]',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'posts_per_page', '5' ),
						'label' => array(
							'title' => esc_html__( 'Number of Posts', 'impeka' ),
							'desc' => esc_html__( 'Select number of posts', 'impeka' ),
						),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["latest"] }
						]',
					)
				);

				impeka_grve_print_admin_option(
					array(
						'type' => 'textfield',
						'name' => '_impeka_grve_post_type_slider_settings[include_posts]',
						'value' => impeka_grve_array_value( $post_type_slider_settings, 'include_posts', '' ),
						'label' => array(
							'title' => esc_html__( 'Include Specific Posts', 'impeka' ),
							'desc' => esc_html__( 'Type the specific post ids you want to include separated by comma ( , ).', 'impeka' ),
						),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_post_type_slider_settings_post_method", "values" : ["specific_posts"] }
						]',
					)
				);
			?>
		</div>
		<div id="grve-feature-section-post-type-slider-options" class="grve-feature-section-item">
			<div class="grve-post-type-slider-item postbox">
				<h3 class="grve-title">
					<span><?php esc_html_e( 'Options', 'impeka' ); ?></span>
				</h3>
				<div class="inside">

					<!--  METABOXES -->
					<div class="grve-metabox-content">

						<!-- TABS -->
						<div class="grve-tabs">

							<ul class="grve-tab-links">
								<li class="grve-feature-required grve-item-post-type-slider-bg-settings"><a id="grve-feature-post-type-slider-tab-bg-link" href="#grve-feature-post-type-slider-tab-bg"><?php esc_html_e( 'Background', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-post-type-slider-content-settings"><a id="grve-feature-post-type-slider-tab-content-link" href="#grve-feature-post-type-slider-tab-content"><?php esc_html_e( 'Content', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-post-type-slider-first-button-settings"><a id="grve-feature-post-type-slider-tab-button-link" href="#grve-feature-post-type-slider-tab-button"><?php esc_html_e( 'Button', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-post-type-slider-extra-settings"><a id="grve-feature-post-type-slider-tab-extra-link" href="#grve-feature-post-type-slider-tab-extra"><?php esc_html_e( 'Extra', 'impeka' ); ?></a></li>
							</ul>

							<div class="grve-tab-content">
								<div id="grve-feature-post-type-slider-tab-bg" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_posts_slider_bg_options( $post_type_slider_settings, '_impeka_grve_post_type_slider_settings[', ']' ); ?>
								</div>
								<div id="grve-feature-post-type-slider-tab-content" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_posts_slider_content_options( $post_type_slider_settings, '_impeka_grve_post_type_slider_settings[', ']' ); ?>
								</div>
								<div id="grve-feature-post-type-slider-tab-button" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_button_options( $post_type_slider_settings_button, '_impeka_grve_post_type_slider_button[', ']', 'posts_slider' ); ?>
								</div>
								<div id="grve-feature-post-type-slider-tab-extra" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_extra_options( $post_type_slider_settings,'_impeka_grve_post_type_slider_settings[', ']' ); ?>
								</div>
							</div>

						</div>
						<!-- END TABS -->

					</div>
					<!-- END  METABOXES -->
				</div>
			</div>
		</div>

		<div id="grve-feature-section-options" class="grve-feature-section-item postbox">

			<div class="grve-fields-wrapper grve-feature-options-wrapper">
				<div class="grve-label">
					<label for="grve-page-feature-element">
						<span class="grve-title"><?php esc_html_e( 'Feature Size', 'impeka' ); ?></span>
						<span class="grve-description"><?php esc_html_e( 'With Custom Size option you can select the feature height.', 'impeka' ); ?></span>
					</label>
				</div>
				<div class="grve-field-items-wrapper">
					<div class="grve-field-item">
						<select name="_impeka_grve_page_feature_size" id="grve-page-feature-size">
							<option value="" <?php selected( "", $feature_size ); ?>><?php esc_html_e( 'Full Screen', 'impeka' ); ?></option>
							<option value="custom" <?php selected( "custom", $feature_size ); ?>><?php esc_html_e( 'Custom Size', 'impeka' ); ?></option>
						</select>
					</div>
					<div class="grve-field-item">
						<span id="grve-feature-section-height">
							<select name="_impeka_grve_page_feature_height">
								<?php impeka_grve_print_select_options( $area_height, $feature_height ); ?>
							</select>
							<span class="grve-sub-title"><?php esc_html_e( 'Height', 'impeka' ); ?></span>
							<input type="text" name="_impeka_grve_page_feature_min_height" value="<?php echo esc_attr( $feature_min_height ); ?>"/>
							<span class="grve-sub-title"><?php esc_html_e( 'Minimum Height in px', 'impeka' ); ?></span>
						</span>
					</div>
				</div>
			</div>
			<?php
				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'options' => array(
							'above' => esc_html__( 'Header above Feature', 'impeka' ),
							'below' => esc_html__( 'Header below Feature', 'impeka' ),
						),
						'name' => '_impeka_grve_page_feature_header_position',
						'value' => $feature_header_position,
						'label' => array(
							'title' => esc_html__( 'Feature/Header Position', 'impeka' ),
							'desc' => esc_html__( 'With this option header will be shown above or below feature section.', 'impeka' ),
						),
					)
				);
			?>
			<div id="grve-feature-options-wrapper" class="grve-feature-options-wrapper">
			<?php

				impeka_grve_print_admin_option(
					array(
						'type' => 'select-colorpicker',
						'name' => '_impeka_grve_page_feature_bg_color',
						'id' => '_impeka_grve_page_feature_bg_color',
						'value' => $feature_bg_color,
						'value2' => $feature_bg_color_custom,
						'default_value2' => $feature_bg_color_custom,
						'label' => esc_html__( 'Background Color', 'impeka' ),
						'multiple' => 'multi',
						'type_usage' => 'feature-bg',
						'group_id' => 'grve-feature-options-wrapper',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'colorpicker',
						'name' => '_impeka_grve_page_feature_bg_gradient_color_1',
						'value' => $feature_bg_gradient_color_1,
						'label' => esc_html__( 'Custom Color 1', 'impeka' ),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_page_feature_bg_color", "values" : ["gradient"] }
						]',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'colorpicker',
						'name' => '_impeka_grve_page_feature_bg_gradient_color_2',
						'value' => $feature_bg_gradient_color_2,
						'label' => esc_html__( 'Custom Color 2', 'impeka' ),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_page_feature_bg_color", "values" : ["gradient"] }
						]',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'name' => '_impeka_grve_page_feature_bg_gradient_direction',
						'value' => $feature_bg_gradient_direction,
						'options' => array(
							'90' => esc_html__( "Left to Right", 'impeka' ),
							'135' => esc_html__( "Left Top to Right Bottom", 'impeka' ),
							'45' => esc_html__( "Left Bottom to Right Top", 'impeka' ),
							'180' => esc_html__( "Bottom to Top", 'impeka' ),
						),
						'label' => array(
							"title" => esc_html__( 'Gradient Direction', 'impeka' ),
						),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_page_feature_bg_color", "values" : ["gradient"] }
						]',
					)
				);

				$feature_separator_list = array(
					'' => esc_html__( "None", 'impeka' ),
					'wave-right-separator' => esc_html__( "Wave Right", 'impeka' ),
					'wave-left-separator' => esc_html__( "Wave Left", 'impeka' ),
					'triangle-separator' => esc_html__( "Triangle", 'impeka' ),
					'large-triangle-separator' => esc_html__( "Large Triangle", 'impeka' ),
					'curve-separator' => esc_html__( "Curve", 'impeka' ),
					'curve-left-separator' => esc_html__( "Curve Left", 'impeka' ),
					'curve-right-separator' => esc_html__( "Curve Right", 'impeka' ),
					'tilt-left-separator' => esc_html__( "Tilt Left", 'impeka' ),
					'tilt-right-separator' => esc_html__( "Tilt Right", 'impeka' ),
					'tilt-alt-left-separator' => esc_html__( "Tilt Alt Left", 'impeka' ),
					'tilt-alt-right-separator' => esc_html__( "Tilt Alt Right", 'impeka' ),
					'round-split-separator' => esc_html__( "Round Split", 'impeka' ),
					'line-separator' => esc_html__( "Line", 'impeka' ),
					'torn-paper-separator' => esc_html__( "Torn Paper", 'impeka' ),
				);

				$feature_separator_size_list = array(
					'30px' => esc_html__( "30px", 'impeka' ),
					'60px' => esc_html__( "60px", 'impeka' ),
					'90px' => esc_html__( "90px", 'impeka' ),
					'120px'=> esc_html__( "120px", 'impeka' ),
					'150px'=> esc_html__( "150px", 'impeka' ),
					'180px'=> esc_html__( "180px", 'impeka' ),
					'200px'=> esc_html__( "200px", 'impeka' ),
					'300px'=> esc_html__( "300px", 'impeka' ),
					'10%' => esc_html__( "10%", 'impeka' ),
					'20%' => esc_html__( "20%", 'impeka' ),
					'30%' => esc_html__( "30%", 'impeka' ),
					'40%' => esc_html__( "40%", 'impeka' ),
					'50%' => esc_html__( "50%", 'impeka' ),
					'60%' => esc_html__( "60%", 'impeka' ),
					'70%' => esc_html__( "70%", 'impeka' ),
					'80%' => esc_html__( "80%", 'impeka' ),
					'90%' => esc_html__( "90%", 'impeka' ),
					'100%' => esc_html__( "100%", 'impeka' ),
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'name' => '_impeka_grve_page_feature_separator_bottom',
						'id' => '_impeka_grve_page_feature_separator_bottom',
						'value' => $feature_separator_bottom,
						'options' => $feature_separator_list,
						'label' => array(
							"title" => esc_html__( 'Bottom Separator', 'impeka' ),
						),
						'group_id' => 'grve-feature-options-wrapper',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'colorpicker',
						'name' => '_impeka_grve_page_feature_separator_bottom_color',
						'value' => $feature_separator_bottom_color,
						'label' => esc_html__( 'Bottom Separator Color', 'impeka' ),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_page_feature_separator_bottom", "value_not_equal_to" : [""] }
						]',
					)
				);
				impeka_grve_print_admin_option(
					array(
						'type' => 'select',
						'name' => '_impeka_grve_page_feature_separator_bottom_size',
						'value' => $feature_separator_bottom_size,
						'options' => $feature_separator_size_list,
						'label' => array(
							"title" => esc_html__( 'Bottom Separator Size', 'impeka' ),
						),
						'dependency' =>
						'[
							{ "id" : "_impeka_grve_page_feature_separator_bottom", "value_not_equal_to" : [""] }
						]',
					)
				);
			?>
			</div>

		</div>



		<div id="grve-feature-section-slider" class="grve-feature-section-item">

			<div class="postbox">
				<h3 class="grve-title">
					<span><?php esc_html_e( 'Slider Settings', 'impeka' ); ?></span>
				</h3>
				<div class="inside">

					<?php
						impeka_grve_print_admin_option(
							array(
								'type' => 'textfield',
								'name' => '_impeka_grve_page_slider_settings_speed',
								'value' => $slider_speed,
								'label' => esc_html__( 'Slideshow Speed', 'impeka' ),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'name' => '_impeka_grve_page_slider_settings_pause',
								'options' => array(
									'no' => esc_html__( 'No', 'impeka' ),
									'yes' => esc_html__( 'Yes', 'impeka' ),
								),
								'value' => $slider_pause,
								'label' => esc_html__( 'Pause on Hover', 'impeka' ),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => array(
									'1' => esc_html__( 'Style 1', 'impeka' ),
									'2' => esc_html__( 'Style 2', 'impeka' ),
									'3' => esc_html__( 'Style 3', 'impeka' ),
								),
								'name' => '_impeka_grve_page_slider_settings_nav_style',
								'value' => $slider_nav_style,
								'label' => array(
									'title' => esc_html__( 'Navigation Style', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => array(
									'yes' => esc_html__( 'Yes', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
								),
								'name' => '_impeka_grve_page_slider_settings_pagination',
								'value' => $slider_pagination,
								'label' => array(
									'title' => esc_html__( 'Pagination', 'impeka' ),
								),
							)
						);
						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => array(
									'yes' => esc_html__( 'Yes', 'impeka' ),
									'no' => esc_html__( 'No', 'impeka' ),
								),
								'name' => '_impeka_grve_page_slider_settings_arrows',
								'value' => $slider_arrows,
								'label' => array(
									'title' => esc_html__( 'Navigation Arrows', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => array(
									'slide' => esc_html__( 'Slide', 'impeka' ),
									'fade' => esc_html__( 'Fade', 'impeka' ),
								),
								'name' => '_impeka_grve_page_slider_settings_transition',
								'value' => $slider_transition,
								'label' => array(
									'title' => esc_html__( 'Transition', 'impeka' ),
								),
							)
						);

						impeka_grve_print_admin_option(
							array(
								'type' => 'select',
								'options' => array(
									'' => esc_html__( 'None', 'impeka' ),
									'animated' => esc_html__( 'Animated', 'impeka' ),
									'parallax' => esc_html__( 'Classic Parallax', 'impeka' ),
									'advanced-parallax' => esc_html__( 'Advanced Parallax', 'impeka' ),
									'fixed-section' => esc_html__( 'Fixed Section', 'impeka' ),
								),
								'name' => '_impeka_grve_page_slider_settings_effect',
								'value' => $slider_effect,
								'label' => array(
									'title' => esc_html__( 'Slider Effect', 'impeka' ),
								),
							)
						);
					?>
					<div class="grve-fields-wrapper">
						<div class="grve-label">
							<label for="grve-page-feature-element">
								<span class="grve-title"><?php esc_html_e( 'Add Slides', 'impeka' ); ?></span>
							</label>
						</div>
						<div class="grve-field-items-wrapper">
							<div class="grve-field-item">
								<input type="button" class="grve-upload-feature-slider-button button-primary" value="<?php esc_attr_e( 'Insert Images to Slider', 'impeka' ); ?>"/>
								<span id="grve-upload-feature-slider-button-spinner" class="grve-action-spinner"></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div id="grve-feature-slider-container" data-mode="slider-full" class="grve-feature-section-item">
			<?php
				if( !empty( $slider_items ) ) {
					impeka_grve_print_admin_feature_slider_items( $slider_items );
				}
			?>
		</div>

		<div id="grve-feature-map-container" class="grve-feature-section-item">
			<div class="grve-map-item postbox">
				<h3 class="grve-title">
					<span><?php esc_html_e( 'Map', 'impeka' ); ?></span>
				</h3>
				<div class="inside">
					<div class="grve-fields-wrapper">
						<div class="grve-label">
							<label for="grve-page-feature-element">
								<span class="grve-title"><?php esc_html_e( 'Single Point Zoom', 'impeka' ); ?></span>
							</label>
						</div>
						<div class="grve-field-items-wrapper">
							<div class="grve-field-item">
								<select id="grve-page-feature-map-zoom" name="_impeka_grve_page_feature_map_zoom">
									<?php for ( $i=1; $i < 20; $i++ ) { ?>
										<option value="<?php echo esc_attr( $i ); ?>" <?php selected( $i, $map_zoom ); ?>><?php echo esc_html( $i ); ?></option>
									<?php } ?>
								</select>
							</div>
						</div>
					</div>
					<?php

					impeka_grve_print_admin_option(
						array(
							'type' => 'select',
							'id' => '_impeka_grve_page_feature_map_marker_type',
							'name' => '_impeka_grve_page_feature_map_marker_type',
							'value' => $map_marker_type,
							'label' => array(
								"title" => esc_html__( 'Global Marker Type', 'impeka' ),
							),
							'options' => array(
								'' => esc_html__( 'Image', 'impeka' ),
								'pulse-dot' => esc_html__( 'Pulse Dot Icon', 'impeka' ),
								'dot' => esc_html__( 'Dot Icon', 'impeka' ),
							),
							'group_id' => 'grve-feature-map-container',
						)
					);

					impeka_grve_print_admin_option(
						array(
							'type' => 'select-bg-image',
							'name' => '_impeka_grve_page_feature_map_marker',
							'value' => $map_marker,
							'label' => array(
								"title" => esc_html__( 'Global Marker', 'impeka' ),
							),
							'width' => 'fullwidth',
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_page_feature_map_marker_type", "values" : [""] }
							]',
							'group_id' => 'grve-feature-map-container',
						)
					);
					impeka_grve_print_admin_option(
						array(
							'type' => 'select-button-color',
							'name' => '_impeka_grve_page_feature_map_marker_bg_color',
							'id' => '_impeka_grve_page_feature_map_marker_bg_color',
							'value' => $map_marker_bg_color,
							'label' => esc_html__( 'Marker Background Color', 'impeka' ),
							'dependency' =>
							'[
								{ "id" : "_impeka_grve_page_feature_map_marker_type", "value_not_equal_to" : [""] }
							]',
							'group_id' => 'grve-feature-map-container',
						)
					);
					?>
					<div class="grve-fields-wrapper">
						<div class="grve-label">
							<label for="grve-page-feature-element">
								<span class="grve-title"><?php esc_html_e( 'Disable Custom Style', 'impeka' ); ?></span>
							</label>
						</div>
						<div class="grve-field-items-wrapper">
							<div class="grve-field-item">
								<select id="grve-page-feature-map-disable-style" name="_impeka_grve_page_feature_map_disable_style">
									<option value="no" <?php selected( "no", $map_disable_style ); ?>><?php esc_html_e( 'No', 'impeka' ); ?></option>
									<option value="yes" <?php selected( "yes", $map_disable_style ); ?>><?php esc_html_e( 'Yes', 'impeka' ); ?></option>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="grve-fields-wrapper">
					<div class="grve-label">
						<label for="grve-page-feature-element">
							<span class="grve-title"><?php esc_html_e( 'Add Map Points', 'impeka' ); ?></span>
						</label>
					</div>
					<div class="grve-field-items-wrapper">
						<div class="grve-field-item">
							<input type="button" id="grve-upload-multi-map-point" class="grve-upload-multi-map-point button-primary" value="<?php esc_attr_e( 'Insert Point to Map', 'impeka' ); ?>"/>
							<span id="grve-upload-multi-map-button-spinner" class="grve-action-spinner"></span>
						</div>
					</div>
				</div>
			</div>
			<?php impeka_grve_print_admin_feature_map_items( $map_items ); ?>
		</div>

		<div id="grve-feature-single-container" class="grve-feature-section-item">
			<div class="grve-video-item postbox">
				<span class="grve-modal-spinner"></span>
				<h3 class="grve-title">
					<span><?php esc_html_e( 'Options', 'impeka' ); ?></span>
				</h3>
				<div class="inside">

					<!--  METABOXES -->
					<div class="grve-metabox-content">

						<!-- TABS -->
						<div class="grve-tabs">

							<ul class="grve-tab-links">
								<li class="grve-feature-required grve-item-feature-video-settings active"><a id="grve-feature-single-tab-video-link" href="#grve-feature-single-tab-video"><?php esc_html_e( 'HTML5 Video', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-youtube-settings active"><a id="grve-feature-single-tab-youtube-link" href="#grve-feature-single-tab-youtube"><?php esc_html_e( 'YouTube/Vimeo', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-bg-settings"><a id="grve-feature-single-tab-bg-link" href="#grve-feature-single-tab-bg"><?php esc_html_e( 'Background', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-content-settings"><a id="grve-feature-single-tab-content-link" href="#grve-feature-single-tab-content"><?php esc_html_e( 'Content', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-revslider-settings"><a id="grve-feature-single-tab-revslider-link" href="#grve-feature-single-tab-revslider"><?php esc_html_e( 'Revolution Slider', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-first-button-settings"><a href="#grve-feature-single-tab-button"><?php esc_html_e( 'First Button', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-second-button-settings"><a href="#grve-feature-single-tab-button2"><?php esc_html_e( 'Second Button', 'impeka' ); ?></a></li>
								<li class="grve-feature-required grve-item-feature-extra-settings"><a href="#grve-feature-single-tab-extra"><?php esc_html_e( 'Extra', 'impeka' ); ?></a></li>
							</ul>

							<div class="grve-tab-content">
								<div id="grve-feature-single-tab-video" class="grve-tab-item active">
									<?php impeka_grve_print_admin_feature_item_video_options( $feature_single_item ); ?>
								</div>
								<div id="grve-feature-single-tab-youtube" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_youtube_options( $feature_single_item ); ?>
								</div>
								<div id="grve-feature-single-tab-revslider" class="grve-tab-item">
									<?php
										impeka_grve_print_admin_option(
												array(
													'type' => 'select',
													'options' => impeka_grve_get_revolution_selection(),
													'name' => '_impeka_grve_page_revslider',
													'value' => $revslider_alias,
													'label' => array(
														'title' => esc_html__( 'Revolution Slider', 'impeka' ),
													),
												)
											);
									?>
								</div>
								<div id="grve-feature-single-tab-bg" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_background_options( $feature_single_item ); ?>
									<?php impeka_grve_print_admin_feature_item_overlay_options( $feature_single_item ); ?>
								</div>
								<div id="grve-feature-single-tab-content" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_content_options( $feature_single_item ); ?>
								</div>
								<div id="grve-feature-single-tab-button" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_button_options( $feature_single_item_button, '_impeka_grve_single_item_button_' ); ?>
								</div>
								<div id="grve-feature-single-tab-button2" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_button_options( $feature_single_item_button2, '_impeka_grve_single_item_button2_' ); ?>
								</div>
								<div id="grve-feature-single-tab-extra" class="grve-tab-item">
									<?php impeka_grve_print_admin_feature_item_go_to_section_options( $feature_single_item ); ?>
									<?php impeka_grve_print_admin_feature_item_extra_options( $feature_single_item ); ?>
								</div>
							</div>

						</div>
						<!-- END TABS -->

					</div>
					<!-- END  METABOXES -->
				</div>
			</div>
		</div>
<?php
}

function impeka_grve_admin_save_feature_section( $post_id ) {

	//Feature Section variable
	$feature_section = array();


	if ( isset( $_POST['_impeka_grve_page_feature_element'] ) ) {

		//Feature Settings

		$feature_section['feature_settings'] = array (
			'element' => sanitize_text_field( $_POST['_impeka_grve_page_feature_element'] ),
			'size' => sanitize_text_field( $_POST['_impeka_grve_page_feature_size'] ),
			'height' => sanitize_text_field( $_POST['_impeka_grve_page_feature_height'] ),
			'min_height' => sanitize_text_field( $_POST['_impeka_grve_page_feature_min_height'] ),
			'header_position' => sanitize_text_field( $_POST['_impeka_grve_page_feature_header_position'] ),
			'bg_color' => sanitize_text_field( $_POST['_impeka_grve_page_feature_bg_color'] ),
			'bg_color_custom' => sanitize_text_field( $_POST['_impeka_grve_page_feature_bg_color_custom'] ),
			'bg_gradient_color_1' => sanitize_text_field( $_POST['_impeka_grve_page_feature_bg_gradient_color_1'] ),
			'bg_gradient_color_2' => sanitize_text_field( $_POST['_impeka_grve_page_feature_bg_gradient_color_2'] ),
			'bg_gradient_direction' => sanitize_text_field( $_POST['_impeka_grve_page_feature_bg_gradient_direction'] ),
			'separator_bottom' => sanitize_text_field( $_POST['_impeka_grve_page_feature_separator_bottom'] ),
			'separator_bottom_color' => sanitize_text_field( $_POST['_impeka_grve_page_feature_separator_bottom_color'] ),
			'separator_bottom_size' => sanitize_text_field( $_POST['_impeka_grve_page_feature_separator_bottom_size'] ),
		);


		//Feature Revolution Slider
		if ( isset( $_POST['_impeka_grve_page_revslider'] ) ) {
			$feature_section['revslider_alias'] = sanitize_text_field( $_POST['_impeka_grve_page_revslider'] );
		}

		//Feature Post Slider
		$post_type_slider_button = array();
		if ( isset( $_POST['_impeka_grve_post_type_slider_button'] ) ) {
			$cat_keys = array_keys( $_POST['_impeka_grve_post_type_slider_button'] );
			foreach ( $cat_keys as $key ) {
				if ( isset( $_POST['_impeka_grve_post_type_slider_button'][$key] ) ) {
					$post_type_slider_button[$key] = sanitize_text_field( $_POST['_impeka_grve_post_type_slider_button'][$key] );
				}
			}
		}
		if ( isset( $_POST['_impeka_grve_post_type_slider_settings'] ) ) {
			$post_type_slider_settings = array ();
			$cat_keys = array_keys( $_POST['_impeka_grve_post_type_slider_settings'] );
			foreach ( $cat_keys as $key ) {
				if ( isset( $_POST['_impeka_grve_post_type_slider_settings'][$key] ) ) {	
					if ( is_array( $_POST['_impeka_grve_post_type_slider_settings'][$key] ) ) {
						$categories = implode( ',', $_POST['_impeka_grve_post_type_slider_settings'][$key] );
						$post_type_slider_settings[$key] = sanitize_text_field( $categories );
					} else {
						$post_type_slider_settings[$key] = sanitize_text_field( $_POST['_impeka_grve_post_type_slider_settings'][$key] );
					}
				}
			}
			$post_type_slider_settings['button'] = $post_type_slider_button;
			if (!empty( $post_type_slider_settings ) ) {
				$feature_section['post_type_slider_settings'] = $post_type_slider_settings;
			}
		}

		//Feature Single Item
		if ( isset( $_POST['_impeka_grve_single_item_title'] ) ) {


			$feature_section['single_item'] = array (

				'title' => wp_filter_post_kses( $_POST['_impeka_grve_single_item_title'] ),
				'content_bg_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_content_bg_color'] ),
				'content_bg_color_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_content_bg_color_custom'] ),
				'title_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_color'] ),
				'title_color_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_color_custom'] ),
				'title_tag' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_tag'] ),
				'caption' => wp_filter_post_kses( $_POST['_impeka_grve_single_item_caption'] ),
				'caption_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_caption_color'] ),
				'caption_color_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_caption_color_custom'] ),
				'caption_tag' => sanitize_text_field( $_POST['_impeka_grve_single_item_caption_tag'] ),
				'subheading' => wp_filter_post_kses( $_POST['_impeka_grve_single_item_subheading'] ),
				'subheading_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_subheading_color'] ),
				'subheading_color_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_subheading_color_custom'] ),
				'subheading_tag' => sanitize_text_field( $_POST['_impeka_grve_single_item_subheading_tag'] ),
				'subheading_heading' => sanitize_text_field( $_POST['_impeka_grve_single_item_subheading_heading'] ),
				'title_heading' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_heading'] ),
				'caption_heading' => sanitize_text_field( $_POST['_impeka_grve_single_item_caption_heading'] ),
				'subheading_family' => sanitize_text_field( $_POST['_impeka_grve_single_item_subheading_family'] ),
				'title_family' => sanitize_text_field( $_POST['_impeka_grve_single_item_title_family'] ),
				'caption_family' => sanitize_text_field( $_POST['_impeka_grve_single_item_caption_family'] ),
				'content_size' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_size'] ),
				'content_align' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_align'] ),
				'content_position' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_position'] ),
				'content_animation' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_animation'] ),
				'container_size' => sanitize_text_field( $_POST['_impeka_grve_single_item_container_size'] ),
				'content_image_id' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_image_id'] ),
				'content_image_size' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_image_size'] ),
				'content_image_max_height' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_image_max_height'] ),
				'content_image_responsive_max_height' => sanitize_text_field( $_POST['_impeka_grve_single_item_content_image_responsive_max_height'] ),
				'pattern_overlay' => sanitize_text_field( $_POST['_impeka_grve_single_item_pattern_overlay'] ),
				'color_overlay' => sanitize_text_field( $_POST['_impeka_grve_single_item_color_overlay'] ),
				'color_overlay_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_color_overlay_custom'] ),
				'opacity_overlay' => sanitize_text_field( $_POST['_impeka_grve_single_item_opacity_overlay'] ),
				'gradient_overlay_custom_1' => sanitize_text_field( $_POST['_impeka_grve_single_item_gradient_overlay_custom_1'] ),
				'gradient_overlay_custom_1_opacity' => sanitize_text_field( $_POST['_impeka_grve_single_item_gradient_overlay_custom_1_opacity'] ),
				'gradient_overlay_custom_2' => sanitize_text_field( $_POST['_impeka_grve_single_item_gradient_overlay_custom_2'] ),
				'gradient_overlay_custom_2_opacity' => sanitize_text_field( $_POST['_impeka_grve_single_item_gradient_overlay_custom_2_opacity'] ),
				'gradient_overlay_direction' => sanitize_text_field( $_POST['_impeka_grve_single_item_gradient_overlay_direction'] ),
				'bg_image_id' => sanitize_text_field( $_POST['_impeka_grve_single_item_bg_image_id'] ),
				'bg_image_size' => sanitize_text_field( $_POST['_impeka_grve_single_item_bg_image_size'] ),
				'bg_position' => sanitize_text_field( $_POST['_impeka_grve_single_item_bg_position'] ),
				'bg_tablet_sm_position' => sanitize_text_field( $_POST['_impeka_grve_single_item_bg_tablet_sm_position'] ),
				'image_effect' => sanitize_text_field( $_POST['_impeka_grve_single_item_image_effect'] ),
				'video_webm' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_webm'] ),
				'video_mp4' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_mp4'] ),
				'video_ogv' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_ogv'] ),
				'video_poster' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_poster'] ),
				'video_device' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_device'] ),
				'video_loop' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_loop'] ),
				'video_muted' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_muted'] ),
				'video_effect' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_effect'] ),
				'video_url' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_url'] ),
				'video_start' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_start'] ),
				'video_end' => sanitize_text_field( $_POST['_impeka_grve_single_item_video_end'] ),
				'button' => array(
					'id' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_id'] ),
					'text' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_text'] ),
					'url' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_url'] ),
					'target' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_target'] ),
					'color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_color'] ),
					'line_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_line_color'] ),
					'line_position' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_line_position'] ),
					'hover_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_hover_color'] ),
					'color_gradient' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_color_gradient'] ),
					'hover_color_gradient' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_hover_color_gradient'] ),
					'hover_action' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_hover_action'] ),
					'size' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_size'] ),
					'shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_shape'] ),
					'shadow' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_shadow'] ),
					'type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_type'] ),
					'icon_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_icon_type'] ),
					'svg_icon' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_svg_icon'] ),
					'svg_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_svg_icon_shape'] ),
					'svg_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_svg_icon_shape_type'] ),
					'svg_icon_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_svg_icon_color'] ),
					'svg_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_svg_icon_shape_color'] ),
					'video_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_video_icon_shape'] ),
					'video_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_video_icon_shape_type'] ),
					'video_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_video_icon_shape_color'] ),
					'video_icon_shape_hover_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_video_icon_shape_hover_color'] ),
					'class' => sanitize_text_field( $_POST['_impeka_grve_single_item_button_class'] ),
				),
				'button2' => array(
					'id' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_id'] ),
					'text' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_text'] ),
					'url' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_url'] ),
					'target' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_target'] ),
					'color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_color'] ),
					'line_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_line_color'] ),
					'line_position' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_line_position'] ),
					'hover_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_hover_color'] ),
					'color_gradient' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_color_gradient'] ),
					'hover_color_gradient' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_hover_color_gradient'] ),
					'hover_action' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_hover_action'] ),
					'size' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_size'] ),
					'shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_shape'] ),
					'shadow' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_shadow'] ),
					'type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_type'] ),
					'icon_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_icon_type'] ),
					'svg_icon' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_svg_icon'] ),
					'svg_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_svg_icon_shape'] ),
					'svg_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_svg_icon_shape_type'] ),
					'svg_icon_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_svg_icon_color'] ),
					'svg_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_svg_icon_shape_color'] ),
					'video_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_video_icon_shape'] ),
					'video_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_video_icon_shape_type'] ),
					'video_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_video_icon_shape_color'] ),
					'video_icon_shape_hover_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_video_icon_shape_hover_color'] ),
					'class' => sanitize_text_field( $_POST['_impeka_grve_single_item_button2_class'] ),
				),
				'arrow_enabled' => sanitize_text_field( $_POST['_impeka_grve_single_item_arrow_enabled'] ),
				'arrow_text' => sanitize_text_field( $_POST['_impeka_grve_single_item_arrow_text'] ),
				'arrow_color' => sanitize_text_field( $_POST['_impeka_grve_single_item_arrow_color'] ),
				'arrow_color_custom' => sanitize_text_field( $_POST['_impeka_grve_single_item_arrow_color_custom'] ),
				'el_class' => sanitize_text_field( $_POST['_impeka_grve_single_item_el_class'] ),

			);
		}

		//Feature Slider Items
		$slider_items = array();
		if ( isset( $_POST['_impeka_grve_slider_item_id'] ) ) {

			$num_of_images = sizeof( $_POST['_impeka_grve_slider_item_id'] );
			for ( $i=0; $i < $num_of_images; $i++ ) {

				$slide = array (
					'id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_id'][ $i ] ),
					'type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_type'][ $i ] ),
					'post_id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_post_id'][ $i ] ),
					'bg_image_id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_bg_image_id'][ $i ] ),
					'bg_image_size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_bg_image_size'][ $i ] ),
					'bg_position' => sanitize_text_field( $_POST['_impeka_grve_slider_item_bg_position'][ $i ] ),
					'bg_tablet_sm_position' => sanitize_text_field( $_POST['_impeka_grve_slider_item_bg_tablet_sm_position'][ $i ] ),
					'header_skin' => sanitize_text_field( $_POST['_impeka_grve_slider_item_header_skin'][ $i ] ),
					'title' => wp_filter_post_kses( $_POST['_impeka_grve_slider_item_title'][ $i ] ),
					'content_bg_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_content_bg_color'][ $i ] ),
					'content_bg_color_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_content_bg_color_custom'][ $i ] ),
					'title_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_color'][ $i ] ),
					'title_color_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_color_custom'][ $i ] ),
					'title_tag' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_tag'][ $i ] ),
					'caption' => wp_filter_post_kses( $_POST['_impeka_grve_slider_item_caption'][ $i ] ),
					'caption_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_caption_color'][ $i ] ),
					'caption_color_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_caption_color_custom'][ $i ] ),
					'caption_tag' => sanitize_text_field( $_POST['_impeka_grve_slider_item_caption_tag'][ $i ] ),
					'subheading' => wp_filter_post_kses( $_POST['_impeka_grve_slider_item_subheading'][ $i ] ),
					'subheading_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_subheading_color'][ $i ] ),
					'subheading_color_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_subheading_color_custom'][ $i ] ),
					'subheading_tag' => sanitize_text_field( $_POST['_impeka_grve_slider_item_subheading_tag'][ $i ] ),
					'subheading_heading' => sanitize_text_field( $_POST['_impeka_grve_slider_item_subheading_heading'][ $i ] ),
					'title_heading' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_heading'][ $i ] ),
					'caption_heading' => sanitize_text_field( $_POST['_impeka_grve_slider_item_caption_heading'][ $i ] ),
					'subheading_family' => sanitize_text_field( $_POST['_impeka_grve_slider_item_subheading_family'][ $i ] ),
					'title_family' => sanitize_text_field( $_POST['_impeka_grve_slider_item_title_family'][ $i ] ),
					'caption_family' => sanitize_text_field( $_POST['_impeka_grve_slider_item_caption_family'][ $i ] ),
					'content_size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_size'][ $i ] ),
					'content_align' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_align'][ $i ] ),
					'content_position' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_position'][ $i ] ),
					'content_animation' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_animation'][ $i ] ),
					'container_size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_container_size'][ $i ] ),
					'content_image_id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_image_id'][ $i ] ),
					'content_image_size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_image_size'][ $i ] ),
					'content_image_max_height' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_image_max_height'][ $i ] ),
					'content_image_responsive_max_height' => sanitize_text_field( $_POST['_impeka_grve_slider_item_content_image_responsive_max_height'][ $i ] ),
					'pattern_overlay' => sanitize_text_field( $_POST['_impeka_grve_slider_item_pattern_overlay'][ $i ] ),
					'color_overlay' => sanitize_text_field( $_POST['_impeka_grve_slider_item_color_overlay'][ $i ] ),
					'color_overlay_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_color_overlay_custom'][ $i ] ),
					'opacity_overlay' => sanitize_text_field( $_POST['_impeka_grve_slider_item_opacity_overlay'][ $i ] ),
					'gradient_overlay_custom_1' => sanitize_text_field( $_POST['_impeka_grve_slider_item_gradient_overlay_custom_1'][ $i ] ),
					'gradient_overlay_custom_1_opacity' => sanitize_text_field( $_POST['_impeka_grve_slider_item_gradient_overlay_custom_1_opacity'][ $i ] ),
					'gradient_overlay_custom_2' => sanitize_text_field( $_POST['_impeka_grve_slider_item_gradient_overlay_custom_2'][ $i ] ),
					'gradient_overlay_custom_2_opacity' => sanitize_text_field( $_POST['_impeka_grve_slider_item_gradient_overlay_custom_2_opacity'][ $i ] ),
					'gradient_overlay_direction' => sanitize_text_field( $_POST['_impeka_grve_slider_item_gradient_overlay_direction'][ $i ] ),
					'button' => array(
						'id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_id'][ $i ] ),
						'text' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_text'][ $i ] ),
						'url' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_url'][ $i ] ),
						'target' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_target'][ $i ] ),
						'color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_color'][ $i ] ),
						'line_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_line_color'][ $i ] ),
						'line_position' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_line_position'][ $i ] ),
						'hover_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_hover_color'][ $i ] ),
						'color_gradient' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_color_gradient'][ $i ] ),
						'hover_color_gradient' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_hover_color_gradient'][ $i ] ),
						'hover_action' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_hover_action'][ $i ] ),
						'size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_size'][ $i ] ),
						'shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_shape'][ $i ] ),
						'shadow' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_shadow'][ $i ] ),
						'type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_type'][ $i ] ),
						'icon_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_icon_type'][ $i ] ),
						'svg_icon' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_svg_icon'][ $i ] ),
						'svg_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_svg_icon_shape'][ $i ] ),
						'svg_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_svg_icon_shape_type'][ $i ] ),
						'svg_icon_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_svg_icon_color'][ $i ] ),
						'svg_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_svg_icon_shape_color'][ $i ] ),
						'video_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_video_icon_shape'][ $i ] ),
						'video_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_video_icon_shape_type'][ $i ] ),
						'video_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_video_icon_shape_color'][ $i ] ),
						'video_icon_shape_hover_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_video_icon_shape_hover_color'][ $i ] ),
						'class' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button_class'][ $i ] ),
					),
					'button2' => array(
						'id' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_id'][ $i ] ),
						'text' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_text'][ $i ] ),
						'url' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_url'][ $i ] ),
						'target' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_target'][ $i ] ),
						'color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_color'][ $i ] ),
						'line_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_line_color'][ $i ] ),
						'line_position' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_line_position'][ $i ] ),
						'hover_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_hover_color'][ $i ] ),
						'color_gradient' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_color_gradient'][ $i ] ),
						'hover_color_gradient' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_hover_color_gradient'][ $i ] ),
						'hover_action' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_hover_action'][ $i ] ),
						'size' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_size'][ $i ] ),
						'shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_shape'][ $i ] ),
						'shadow' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_shadow'][ $i ] ),
						'type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_type'][ $i ] ),
						'icon_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_icon_type'][ $i ] ),
						'svg_icon' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_svg_icon'][ $i ] ),
						'svg_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_svg_icon_shape'][ $i ] ),
						'svg_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_svg_icon_shape_type'][ $i ] ),
						'svg_icon_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_svg_icon_color'][ $i ] ),
						'svg_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_svg_icon_shape_color'][ $i ] ),
						'video_icon_shape' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_video_icon_shape'][ $i ] ),
						'video_icon_shape_type' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_video_icon_shape_type'][ $i ] ),
						'video_icon_shape_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_video_icon_shape_color'][ $i ] ),
						'video_icon_shape_hover_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_video_icon_shape_hover_color'][ $i ] ),
						'class' => sanitize_text_field( $_POST['_impeka_grve_slider_item_button2_class'][ $i ] ),
					),
					'arrow_enabled' => sanitize_text_field( $_POST['_impeka_grve_slider_item_arrow_enabled'][ $i ] ),
					'arrow_text' => sanitize_text_field( $_POST['_impeka_grve_slider_item_arrow_text'][ $i ] ),
					'arrow_color' => sanitize_text_field( $_POST['_impeka_grve_slider_item_arrow_color'][ $i ] ),
					'arrow_color_custom' => sanitize_text_field( $_POST['_impeka_grve_slider_item_arrow_color_custom'][ $i ] ),
					'el_class' => sanitize_text_field( $_POST['_impeka_grve_slider_item_el_class'][ $i ] ),
				);

				$slider_items[] = $slide;
			}

		}

		if( !empty( $slider_items ) ) {
			$feature_section['slider_items'] = $slider_items;

			$feature_section['slider_settings'] = array (
				'slideshow_speed' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_speed'] ),
				'nav_style' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_nav_style'] ),
				'arrows' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_arrows'] ),
				'slider_pause' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_pause'] ),
				'transition' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_transition'] ),
				'slider_effect' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_effect'] ),
				'pagination' => sanitize_text_field( $_POST['_impeka_grve_page_slider_settings_pagination'] ),
			);
		}

		//Feature Map Items
		$map_items = array();
		if ( isset( $_POST['_impeka_grve_map_item_point_id'] ) ) {

			$num_of_map_points = sizeof( $_POST['_impeka_grve_map_item_point_id'] );
			for ( $i=0; $i < $num_of_map_points; $i++ ) {

				$this_point = array (
					'id' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_id'][ $i ] ),
					'lat' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_lat'][ $i ] ),
					'lng' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_lng'][ $i ] ),
					'marker' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_marker'][ $i ] ),
					'title' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_title'][ $i ] ),
					'info_text' => wp_filter_post_kses( $_POST['_impeka_grve_map_item_point_infotext'][ $i ] ),
					'info_text_open' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_infotext_open'][ $i ] ),
					'button_text' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_button_text'][ $i ] ),
					'button_url' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_button_url'][ $i ] ),
					'button_target' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_button_target'][ $i ] ),
					'button_class' => sanitize_text_field( $_POST['_impeka_grve_map_item_point_button_class'][ $i ] ),
				);
				$map_items[] =  $this_point;
			}

		}

		if( !empty( $map_items ) ) {

			$feature_section['map_items'] = $map_items;
			$feature_section['map_settings'] = array (
				'zoom' => sanitize_text_field( $_POST['_impeka_grve_page_feature_map_zoom'] ),
				'marker' => sanitize_text_field( $_POST['_impeka_grve_page_feature_map_marker'] ),
				'marker_type' => sanitize_text_field( $_POST['_impeka_grve_page_feature_map_marker_type'] ),
				'marker_bg_color' => sanitize_text_field( $_POST['_impeka_grve_page_feature_map_marker_bg_color'] ),
				'disable_style' => sanitize_text_field( $_POST['_impeka_grve_page_feature_map_disable_style'] ),
			);

		}

	}

	//Save Feature Section

	$new_meta_value = $feature_section;
	$meta_key = '_impeka_grve_feature_section';
	$meta_value = get_post_meta( $post_id, $meta_key, true );

	if ( '' != $new_meta_value  && '' == $meta_value ) {
		if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
			update_post_meta( $post_id, $meta_key, $new_meta_value );
		}
	} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
		update_post_meta( $post_id, $meta_key, $new_meta_value );
	} elseif ( '' == $new_meta_value && '' != $meta_value ) {
		delete_post_meta( $post_id, $meta_key );
	}

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
