<?php
/*
*	Collection of functions for admin options
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

/**
 * Print Array Selector Functions
 */
function impeka_grve_print_select_options( $selector_array, $current_value = "" ) {

	foreach ( $selector_array as $value=>$display_value ) {
	?>
		<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $current_value, $value ); ?>><?php echo esc_html( $display_value ); ?></option>
	<?php
	}

}

function impeka_grve_print_select_multiple_options( $selector_array, $current_values = '' ) {
	$values = array();
	if ( !empty( $current_values )  ) {
		$values = explode( ',', $current_values );
	}

	foreach ( $selector_array as $value=>$display_value ) {
			$current_value = '';
			if ( !empty( $values )  ) {
				$current_value = in_array( $value, $values ) ? $value : '';
			}
	?>
		<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $current_value, $value ); ?>><?php echo esc_html( $display_value ); ?></option>
	<?php
	}

}

/**
 * Prints Media Slider items
 */
function impeka_grve_print_admin_media_slider_items( $slider_items ) {

	foreach ( $slider_items as $slider_item ) {
		impeka_grve_print_admin_media_slider_item( $slider_item );
	}

}

/**
 * Get Single Slider Media with ajax
 */
function impeka_grve_get_slider_media() {

	check_ajax_referer( 'impeka-grve-get-slider-media', '_grve_nonce' );

	if( isset( $_POST['attachment_ids'] ) ) {

		$attachment_ids = sanitize_text_field( $_POST['attachment_ids'] );

		if( !empty( $attachment_ids ) ) {

			$media_ids = explode(",", $attachment_ids);

			foreach ( $media_ids as $media_id ) {
				$slider_item = array (
					'id' => $media_id,
				);
				impeka_grve_print_admin_media_slider_item( $slider_item, "new" );
			}
		}
	}
	if( isset( $_POST['attachment_ids'] ) ) { die(); }
}
add_action( 'wp_ajax_impeka_grve_get_slider_media', 'impeka_grve_get_slider_media' );


/**
 * Prints Single Slider Media  Item
 */
function impeka_grve_print_admin_media_slider_item( $slider_item, $new = "" ) {
	$media_id = $slider_item['id'];
	$thumbnail_url = '';
	$thumb_src = wp_get_attachment_image_src( $media_id, 'thumbnail' );
	if ( $thumb_src ) {
		$thumbnail_url = $thumb_src[0];
	}
	$alt = get_post_meta( $media_id, '_wp_attachment_image_alt', true );

	$button_class = "grve-slider-item-delete-button";

	if( $new = "new" ) {
		$button_class = "grve-slider-item-delete-button grve-item-new";
	}

?>
	<div class="grve-slider-item-minimal">
		<div class="grve-slider-item-title">
			<input class="<?php echo esc_attr( $button_class ); ?> button" type="button" value="<?php esc_attr_e( 'Delete', 'impeka' ); ?>">
			<h3 class="hndle grve-title">
				<span><?php esc_html_e( 'Image', 'impeka' ); ?></span>
			</h3>
		</div>
		<div class="inside">
			<input type="hidden" value="<?php echo esc_attr( $media_id ); ?>" name="_impeka_grve_media_slider_item_id[]">
			<?php echo '<img class="grve-thumb" src="' . esc_url( $thumbnail_url ) . '" alt="' . esc_attr( $alt ) . '" width="120" height="120"/>'; ?>
		</div>
	</div>
<?php

}

/**
 * Prints Admin Option Selector
 */
function impeka_grve_print_admin_option_wrapper_start( $item ) {

	$data_dependency = $item_highlight = $item_width = '';

	$item_type = impeka_grve_array_value( $item, 'type' );
	$item_label = impeka_grve_array_value( $item, 'label' );
	$item_required = impeka_grve_array_value( $item, 'required' );
	$item_dependency = impeka_grve_array_value( $item, 'dependency' );
	$item_multiple = impeka_grve_array_value( $item, 'multiple' );
	$item_highlight = impeka_grve_array_value( $item, 'highlight', 'standard' );
	$item_width = impeka_grve_array_value( $item, 'width', 'normal' );
	$item_wrap_class = impeka_grve_array_value( $item, 'wrap_class' );

	$wrapper_attributes = array();
	if( !empty( $item_dependency ) ) {
		$wrapper_attributes[] = "data-dependency='" . esc_attr( $item_dependency ) . "'";
	}

	$label_class = 'grve-label';
	if ( 'label' == $item_type ) {
		$label_class = 'grve-label grve-header-label';
	}

	$item_title = $item_desc = $item_info = '';

	if ( is_array ( $item_label ) ) {
		$item_title = impeka_grve_array_value( $item_label, 'title' );
		$item_desc = impeka_grve_array_value( $item_label, 'desc' );
		$item_info = impeka_grve_array_value( $item_label, 'info' );
	} else {
		$item_title = $item_label;
	}

	//Classes
	$option_wrapper_classes = array( 'grve-fields-wrapper' );
	$option_wrapper_classes[] = 'grve-' . $item_highlight;
	if ( !empty ( $item_wrap_class ) ) {
		$option_wrapper_classes[] = $item_wrap_class;
	}
	$option_wrapper_class_string = implode( ' ', $option_wrapper_classes );

	$wrapper_attributes[] = 'class="' . esc_attr( $option_wrapper_class_string ) . '"';

?>
	<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
		<div class="<?php echo esc_attr( $label_class ); ?>">
			<label>
				<span class="grve-title"><?php echo esc_html( $item_title ); ?></span>
				<span class="grve-description"><?php echo esc_html( $item_desc ); ?></span>
				<span class="grve-info"><?php echo esc_html( $item_info ); ?></span>
			</label>
		</div>
		<div class="grve-field-items-wrapper">
			<?php if ( '' == $item_multiple ) { ?>
			<div class="grve-field-item grve-field-item-<?php echo esc_attr( $item_width ); ?>">
			<?php } ?>

<?php
}

function impeka_grve_print_admin_option_wrapper_end( $multiple = '' ) {
?>
			<?php if ( '' == $multiple ) { ?>
			</div>
			<?php } ?>
		</div>
	</div>

<?php
}

/**
 * Prints Admin Feature Setting
 */
function impeka_grve_print_admin_option( $item ) {

	$item_type = impeka_grve_array_value( $item, 'type' );
	$item_options = impeka_grve_array_value( $item, 'options' );
	$item_label = impeka_grve_array_value( $item, 'label' );
	$item_id = impeka_grve_array_value( $item, 'id' );
	$item_group_id = impeka_grve_array_value( $item, 'group_id' );
	$item_name = impeka_grve_array_value( $item, 'name' );
	$item_default_value = impeka_grve_array_value( $item, 'default_value' );
	$item_value = impeka_grve_array_value( $item, 'value', $item_default_value );
	$item2_default_value = impeka_grve_array_value( $item, 'default_value2' );
	$item2_value = impeka_grve_array_value( $item, 'value2', $item2_default_value );
	$item_required = impeka_grve_array_value( $item, 'required' );
	$item_dependency = impeka_grve_array_value( $item, 'dependency' );
	$item_multiple = impeka_grve_array_value( $item, 'multiple' );
	$item_type_usage = impeka_grve_array_value( $item, 'type_usage' );
	$item_class = impeka_grve_array_value( $item, 'extra_class' );
	$item_rows = impeka_grve_array_value( $item, 'rows', 5 );
	$item_term_slug = impeka_grve_array_value( $item, 'term_slug', 'category' );

	$item_attributes = array();

	if ( 'select-colorpicker' == $item_type ) {
		$item_class = "grve-select-color-extra";
	}

	$dependency_field = $item_id_attr = '';
	if( !empty( $item_group_id ) ) {
		$item_attributes[] = 'class="grve-dependency-field ' . esc_attr( $item_class ) . '"';
		$item_attributes[] = 'data-group="' . esc_attr( $item_group_id ) . '"';
	} else {
		$item_attributes[] = 'class="' . esc_attr( $item_class ) . '"';
	}

	if( !empty( $item_id ) ) {
		$item_attributes[] = 'id="' . esc_attr( $item_id ) . '"';
	}

	if ( 'hidden' == $item_type ) {
?>
	<input type="hidden" name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $item_value ); ?>" <?php echo implode( ' ', $item_attributes ); ?>/>
<?php
		return;
	}

	impeka_grve_print_admin_option_wrapper_start( $item );
?>
	<?php if ( 'hiddenfield' == $item_type ) { ?>
		<span class="grve-info"><?php echo esc_html( $item_value ); ?></span>
		<input type="hidden" name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $item_value ); ?>" <?php echo implode( ' ', $item_attributes ); ?>/>
	<?php } elseif ( 'textfield' == $item_type ) { ?>
		<input type="text" name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $item_value ); ?>" <?php echo implode( ' ', $item_attributes ); ?>/>
	<?php } elseif ( 'textarea' == $item_type ) { ?>
		<textarea name="<?php echo esc_attr( $item_name ); ?>" cols="100" rows="<?php echo esc_attr( $item_rows ); ?>" <?php echo implode( ' ', $item_attributes ); ?>><?php echo wp_kses_post( $item_value ); ?></textarea>
	<?php } elseif ( 'select' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php impeka_grve_print_select_options( $item_options, $item_value ); ?>
		</select>
	<?php } elseif ( 'checkbox' == $item_type ) { ?>
		<input type="checkbox" name="<?php echo esc_attr( $item_name ); ?>" value="yes" <?php checked( $item_value, 'yes' ); ?> <?php echo implode( ' ', $item_attributes ); ?>/>
	<?php } elseif ( 'category-multiselect' == $item_type ) { ?>
		<?php $options = impeka_grve_global_get_post_type_categories( $item_term_slug ); ?>
		<select name="<?php echo esc_attr( $item_name ); ?>[]" multiple="multiple" <?php echo implode( ' ', $item_attributes ); ?>>
		<?php impeka_grve_print_select_multiple_options( $options, $item_value ); ?>
		</select>
		<br><br>
		<input type="button" class="grve-deselect-multi-select button" value="<?php esc_attr_e( 'Deselect All', 'impeka' ); ?>"/>
	<?php } elseif ( 'select-boolean' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'boolean_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-tag' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'tag_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-heading' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'heading_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-custom-font-family' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'custom_font_family_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-colorpicker' == $item_type ) { ?>
		<div class="grve-field-item">
			<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php
				if ( 'sidebar-inpage' == $item_type_usage ) {
					impeka_grve_print_select_options(
						array(
							'' => esc_html__( '-- Inherit --', 'impeka' ),
							'none' => esc_html__( 'None', 'impeka' ),
						),
						$item_value
					);
				} else if ( 'title-content-bg'  == $item_type_usage ) {
					impeka_grve_print_select_options(
						array(
							'none' => esc_html__( 'None', 'impeka' ),
						),
						$item_value
					);
				}  else if ( 'section-bg'  == $item_type_usage ) {
					impeka_grve_print_select_options(
						array(
							'transparent' => esc_html__( 'Transparent', 'impeka' ),
						),
						$item_value
					);
				}   else if ( 'feature-bg'  == $item_type_usage ) {
					impeka_grve_print_select_options(
						array(
							'transparent' => esc_html__( 'Transparent', 'impeka' ),
							'gradient' => esc_html__( 'Gradient', 'impeka' ),
						),
						$item_value
					);
				}
				$options = impeka_grve_global_admin_param( 'color_extra_selection' );
				impeka_grve_print_select_options( $options, $item_value );
			?>
			</select>
		</div>
		<div class="grve-field-item">
			<div class="grve-wp-colorpicker">
				<?php
					if ( strpos( $item_name,'color_overlay') !== false) {
						$custom_name = str_replace ( 'color_overlay' , 'color_overlay_custom', $item_name );
					} else {
						$custom_name = str_replace ( 'color' , 'color_custom', $item_name );
					}
				?>
				<input type="text" name="<?php echo esc_attr( $custom_name ); ?>" class="wp-color-picker-field" value="<?php echo esc_attr( $item2_value ); ?>" data-default-color="<?php echo esc_attr( $item2_default_value ); ?>"/>
			</div>
		</div>
	<?php } elseif ( 'select-image' == $item_type ) { ?>
		<?php
			$thumb_src = wp_get_attachment_image_src( $item_value, 'thumbnail' );
			$thumbnail_url = '';
			if( $thumb_src ) {
				$thumbnail_url = $thumb_src[0];
			}
			$visibility_class = '';
			if ( empty( $thumbnail_url ) ) {
				$thumbnail_url = get_template_directory_uri() . '/includes/images/no-image.jpg';
				$alt = '';
			} else {
				$alt = get_post_meta( $item_value, '_wp_attachment_image_alt', true );
				$visibility_class = 'grve-visible';
			}
		?>
			<div class="grve-thumb-container <?php echo esc_attr( $visibility_class ); ?>" data-mode="custom-image" data-field-name="<?php echo esc_attr( $item_name ); ?>" >
				<input class="grve-upload-media-id" type="hidden" value="<?php echo esc_attr( $item_value ); ?>" name="<?php echo esc_attr( $item_name ); ?>">
				<?php echo '<img class="grve-thumb" src="' . esc_url( $thumbnail_url ) . '" alt="' . esc_attr( $alt ) . '" width="120" height="120"/>'; ?>
				<a class="grve-upload-remove-image" href="#"></a>
			</div>
			<div class="grve-upload-replace-image"><?php echo esc_html__("Insert/Replace Image", "impeka"); ?></div>

	<?php } elseif ( 'colorpicker' == $item_type ) { ?>
		<input type="text" name="<?php echo esc_attr( $item_name ); ?>" class="wp-color-picker-field" value="<?php echo esc_attr( $item_value ); ?>" data-default-color="<?php echo esc_attr( $item_default_value ); ?>" <?php echo implode( ' ', $item_attributes ); ?>/>
	<?php } elseif ( 'select-color' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'color_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-color-extra' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'color_extra_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-opacity' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'opacity_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-header-style' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'header_skin_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-align' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'align_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-text-animation' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'text_animation_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-target' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_target_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-type' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_type_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-color' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_color_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-color-gradient' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_color_gradient_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-size' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_size_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-button-shape' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'button_shape_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-pattern-overlay' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'pattern_overlay_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-color-overlay' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'color_overlay_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-bg-image' == $item_type ) { ?>
		<input type="text" class="grve-upload-simple-media-field"  name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $item_value ); ?>"/>
		<label></label>
		<input type="button" data-media-type="image" class="grve-upload-simple-media-button button-primary" value="<?php esc_attr_e( 'Upload Image', 'impeka' ); ?>"/>
		<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
	<?php } elseif ( 'select-bg-position' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<?php $options = impeka_grve_global_admin_param( 'bg_position_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-bg-position-inherit' == $item_type ) { ?>
		<select name="<?php echo esc_attr( $item_name ); ?>" <?php echo implode( ' ', $item_attributes ); ?>>
			<option value="" <?php selected( "", $item_value ); ?>><?php esc_html_e( 'Inherit from above', 'impeka' ); ?></option>
			<?php $options = impeka_grve_global_admin_param( 'bg_position_selection' ); ?>
			<?php impeka_grve_print_select_options( $options, $item_value ); ?>
		</select>
	<?php } elseif ( 'select-bg-video' == $item_type ) { ?>
		<input type="text" class="grve-upload-simple-media-field grve-meta-text" name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $item_value ); ?>"/>
		<label></label>
		<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
		<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
	<?php } ?>
<?php
	impeka_grve_print_admin_option_wrapper_end( $item_multiple );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
