<?php
/*
*	Greatives Post Items
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	add_action( 'save_post', 'impeka_grve_post_options_save_postdata', 10, 2 );

	function impeka_grve_meta_box_post_custom_overview( $post ) {

		wp_nonce_field( 'impeka_grve_nonce_post_save', '_impeka_grve_nonce_post_save' );

		$color_selection = array(
			'' => esc_html__( '-- Inherit --', 'impeka' ),
			'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
			'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
			'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
			'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
			'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
			'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
			'green' => esc_html__( 'Green', 'impeka' ),
			'orange' => esc_html__( 'Orange', 'impeka' ),
			'red' => esc_html__( 'Red', 'impeka' ),
			'blue' => esc_html__( 'Blue', 'impeka' ),
			'aqua' => esc_html__( 'Aqua', 'impeka' ),
			'purple' => esc_html__( 'Purple', 'impeka' ),
			'black' => esc_html__( 'Black', 'impeka' ),
			'grey' => esc_html__( 'Grey', 'impeka' ),
			'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
			'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
			'white' => esc_html__( 'White', 'impeka' ),
		);

		$overlay_color_selection = array(
			'' => esc_html__( '-- Inherit --', 'impeka' ),
			'primary-1' => esc_html__( 'Primary 1', 'impeka' ),
			'primary-2' => esc_html__( 'Primary 2', 'impeka' ),
			'primary-3' => esc_html__( 'Primary 3', 'impeka' ),
			'primary-4' => esc_html__( 'Primary 4', 'impeka' ),
			'primary-5' => esc_html__( 'Primary 5', 'impeka' ),
			'primary-6' => esc_html__( 'Primary 6', 'impeka' ),
			'green' => esc_html__( 'Green', 'impeka' ),
			'orange' => esc_html__( 'Orange', 'impeka' ),
			'red' => esc_html__( 'Red', 'impeka' ),
			'blue' => esc_html__( 'Blue', 'impeka' ),
			'aqua' => esc_html__( 'Aqua', 'impeka' ),
			'purple' => esc_html__( 'Purple', 'impeka' ),
			'black' => esc_html__( 'Black', 'impeka' ),
			'grey' => esc_html__( 'Grey', 'impeka' ),
			'dark-grey' => esc_html__( 'Dark Grey', 'impeka' ),
			'light-grey' => esc_html__( 'Light Grey', 'impeka' ),
			'white' => esc_html__( 'White', 'impeka' ),
			'gradient-1' => esc_html__( 'Gradient 1', 'impeka' ),
			'gradient-2' => esc_html__( 'Gradient 2', 'impeka' ),
			'gradient-3' => esc_html__( 'Gradient 3', 'impeka' ),
		);

		$opacity_selection = array(
			'' => esc_html__( '-- Inherit --', 'impeka' ),
			'0' => '0%',
			'10' => '10%',
			'20' => '20%',
			'30' => '30%',
			'40' => '40%',
			'50' => '50%',
			'60' => '60%',
			'70' => '70%',
			'80' => '80%',
			'90' => '90%',
			'100' => '100%',
		);

		$overview_style = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_style' );
		$double_size = impeka_grve_admin_post_meta( $post->ID,  '_impeka_grve_post_overview_double_size' );

		$heading_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_heading_color' );
		$text_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_text_color' );
		$meta_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_meta_color' );
		$bg_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_bg_color' );
		$border_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_border_color' );
		$overlay_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_overlay_color' );
		$overlay_opacity = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_overview_overlay_opacity' );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Select one of the choices below for the post overview.', 'impeka' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>
		<div id="grve-custom-overview-options">

	<?php
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_double_size',
				'options' => array(
					'no' => esc_html__( 'No', 'impeka' ),
					'yes' => esc_html__( 'Yes', 'impeka' ),
				),
				'value' => $double_size,
				'default_value' => 'no',
				'label' => array(
					'title' => esc_html__( 'Post Double Size', 'impeka' ),
					'desc' => esc_html__( 'Note: Post style affects only Grid/Masonry mode.', 'impeka' ),
				),
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_style',
				'id' => 'grve-post-overview-style',
				'options' => array(
					'' => esc_html__( '-- Inherit --', 'impeka' ),
					'style-1' => esc_html__( 'Style 1', 'impeka' ),
					'style-2' => esc_html__( 'Style 2', 'impeka' ),
					'style-3' => esc_html__( 'Style 3', 'impeka' ),
				),
				'value' => $overview_style,
				'default_value' => '',
				'label' => array(
					'title' => esc_html__( 'Post Style', 'impeka' ),
					'desc' => esc_html__( 'Note: Post style affects only Grid/Masonry mode.', 'impeka' ),
				),
				'group_id' => 'grve-custom-overview-options',
				'highlight' => 'highlight',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_heading_color',
				'options' => $color_selection,
				'value' => $heading_color,
				'label' => esc_html__( 'Heading Color', 'impeka' ),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-2", "style-3"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_text_color',
				'options' => $color_selection,
				'value' => $text_color,
				'label' => esc_html__( 'Text Color', 'impeka' ),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-2", "style-3"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_meta_color',
				'options' => $color_selection,
				'value' => $meta_color,
				'label' => esc_html__( 'Meta Color', 'impeka' ),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-2", "style-3"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_bg_color',
				'options' => $color_selection,
				'value' => $bg_color,
				'label' => esc_html__( 'Background Color', 'impeka' ),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-2", "style-3"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_border_color',
				'options' => $color_selection,
				'value' => $border_color,
				'label' => esc_html__( 'Border Color', 'impeka' ),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-2"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_post_overview_overlay_color',
				'options' => $overlay_color_selection,
				'value' => $overlay_color,
				'label' => array(
					'title' => esc_html__( 'Overlay Color', 'impeka' ),
					'desc' => esc_html__( 'Note: only if Featured Image is available.', 'impeka' ),
				),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-3"] }
				]',
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'options' => $opacity_selection,
				'name' => '_impeka_grve_post_overview_overlay_opacity',
				'value' => $overlay_opacity,
				'label' => array(
					'title' => esc_html__( 'Overlay Opacity', 'impeka' ),
					'desc' => esc_html__( 'Note: only if Featured Image is available.', 'impeka' ),
				),
				'default_value' => '',
				'dependency' =>
				'[
					{ "id" : "grve-post-overview-style", "values" : ["style-3"] }
				]',
			)
		);

	?>
		</div>
	<?php
	}

	function impeka_grve_meta_box_post_format_gallery( $post ) {

		$gallery_mode = get_post_meta( $post->ID, '_impeka_grve_post_type_gallery_mode', true );
		$gallery_image_mode = get_post_meta( $post->ID, '_impeka_grve_post_type_gallery_image_mode', true );

		$media_slider_items = get_post_meta( $post->ID, '_impeka_grve_post_slider_items', true );

		$media_slider_settings = get_post_meta( $post->ID, '_impeka_grve_post_slider_settings', true );
		$media_slider_speed = impeka_grve_array_value( $media_slider_settings, 'slideshow_speed', '3500' );
		$media_slider_arrows = impeka_grve_array_value( $media_slider_settings, 'arrows', 'yes' );
		$media_slider_dir_nav_color = impeka_grve_array_value( $media_slider_settings, 'direction_nav_color', 'black' );
		$format = get_post_format( $post->ID );
		if ( !$format ) {
			$format = 'standard';
		}

	?>
		<input type="hidden" id="grve-post-format-value" value="<?php echo esc_attr( $format ); ?>"/>
			<table class="form-table grve-metabox">
				<tbody>
					<tr class="grve-border-bottom">
						<th>
							<label for="grve-post-gallery-mode">
								<strong><?php esc_html_e( 'Gallery Mode', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select Gallery mode.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-post-gallery-mode" name="_impeka_grve_post_type_gallery_mode">
								<option value="" <?php selected( '', $gallery_mode ); ?>><?php esc_html_e( 'Gallery', 'impeka' ); ?></option>
								<option value="slider" <?php selected( 'slider', $gallery_mode ); ?>><?php esc_html_e( 'Slider', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-post-gallery-image-mode-section" class="grve-post-media-item">
						<th>
							<label for="grve-post-gallery-image-mode">
								<strong><?php esc_html_e( 'Image Mode', 'impeka' ); ?></strong>
								<span>
									<?php esc_html_e( 'Select image mode.', 'impeka' ); ?>
								</span>
							</label>
						</th>
						<td>
							<select id="grve-post-gallery-image-mode" name="_impeka_grve_post_type_gallery_image_mode">
								<option value="" <?php selected( '', $gallery_image_mode ); ?>><?php esc_html_e( 'Auto Crop', 'impeka' ); ?></option>
								<option value="resize" <?php selected( 'resize', $gallery_image_mode ); ?>><?php esc_html_e( 'Resize', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-post-media-slider-speed" class="grve-post-media-item">
						<th>
							<label for="grve-post-slider-speed">
								<strong><?php esc_html_e( 'Slideshow Speed', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<input type="text" id="grve-post-slider-speed" name="_impeka_grve_post_slider_settings_speed" value="<?php echo esc_attr( $media_slider_speed ); ?>" /> ms
						</td>
					</tr>
					<tr id="grve-post-media-slider-arrows" class="grve-post-media-item">
						<th>
							<label for="grve-post-slider-arrows">
								<strong><?php esc_html_e( 'Arrows', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<select id="grve-post-slider-arrows" name="_impeka_grve_post_slider_settings_arrows">
								<option value="yes" <?php selected( "yes", $media_slider_arrows ); ?>><?php esc_html_e( 'Yes', 'impeka' ); ?></option>
								<option value="no" <?php selected( "no", $media_slider_arrows ); ?>><?php esc_html_e( 'No', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr id="grve-post-media-slider-direction-nav-color" class="grve-post-media-item">
						<th>
							<label for="grve-post-slider-direction-nav-color">
								<strong><?php esc_html_e( 'Navigation Buttons Color', 'impeka' ); ?></strong>
							</label>
						</th>
						<td>
							<select id="grve-post-slider-direction-nav-color" name="_impeka_grve_post_slider_settings_direction_nav_color">
								<option value="black" <?php selected( "black", $media_slider_dir_nav_color ); ?>><?php esc_html_e( 'Black', 'impeka' ); ?></option>
								<option value="white" <?php selected( "white", $media_slider_dir_nav_color ); ?>><?php esc_html_e( 'White', 'impeka' ); ?></option>
							</select>
						</td>
					</tr>
					<tr>
						<th>
							<label><?php esc_html_e( 'Images', 'impeka' ); ?></label>
						</th>
						<td>
							<input type="button" class="grve-upload-slider-button button-primary" value="<?php esc_attr_e( 'Insert Images to Gallery/Slider', 'impeka' ); ?>"/>
							<span id="grve-upload-slider-button-spinner" class="grve-action-spinner"></span>
						</td>
					</tr>
				</tbody>
			</table>
			<div id="grve-slider-container" class="grve-slider-container-minimal" data-mode="minimal">
				<?php
					if( !empty( $media_slider_items ) ) {
						impeka_grve_print_admin_media_slider_items( $media_slider_items );
					}
				?>
			</div>
	<?php
	}


	function impeka_grve_meta_box_post_format_link( $post ) {

		$color_selection = impeka_grve_global_admin_param( 'post_color_selection' );
		$opacity_selection = impeka_grve_global_admin_param( 'post_bg_opacity_selection' );

		$link_url = get_post_meta( $post->ID, '_impeka_grve_post_link_url', true );
		$new_window = get_post_meta( $post->ID, '_impeka_grve_post_link_new_window', true );
		$post_link_text = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_link_text' );

		$post_link_bg_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_link_bg_color', 'primary-1' );
		$post_link_bg_hover_color = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_link_bg_hover_color', 'black' );
		$post_link_bg_opacity = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_link_bg_opacity', '70' );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Add your text in the content area. The text will be wrapped with a link.', 'impeka' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>
<?php

			impeka_grve_print_admin_option(
				array(
					'type' => 'textfield',
					'name' => '_impeka_grve_post_link_url',
					'value' => $link_url ,
					'label' => array(
						'title' => esc_html__( 'Link URL', 'impeka' ),
						'desc' => esc_html__( 'Enter the full URL of your link.', 'impeka' ),
					),
					'width' => 'fullwidth',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'checkbox',
					'name' => '_impeka_grve_post_link_new_window',
					'value' => $new_window ,
					'label' => array(
						'title' => esc_html__( 'Open Link in new window', 'impeka' ),
						'desc' => esc_html__( 'If selected, link will open in a new window.', 'impeka' ),
					),
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'textarea',
					'name' => '_impeka_grve_post_link_text',
					'value' => $post_link_text,
					'label' => array(
						'title' => esc_html__( 'Link Text', 'impeka' ),
						'desc' => esc_html__( 'Enter your link text.', 'impeka' ),
					),
					'width' => 'fullwidth',
				)
			);

			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => '_impeka_grve_post_link_bg_color',
					'options' => $color_selection,
					'value' => $post_link_bg_color,
					'label' => esc_html__( 'Background Color', 'impeka' ),
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'name' => '_impeka_grve_post_link_bg_hover_color',
					'options' => $color_selection,
					'value' => $post_link_bg_hover_color,
					'label' => esc_html__( 'Background Hover Color', 'impeka' ),
				)
			);
			impeka_grve_print_admin_option(
				array(
					'type' => 'select',
					'options' => $opacity_selection,
					'name' => '_impeka_grve_post_link_bg_opacity',
					'value' => $post_link_bg_opacity,
					'label' => array(
						'title' => esc_html__( 'Background Opacity', 'impeka' ),
						'desc' => esc_html__( 'Note: only if Featured Image is available.', 'impeka' ),
					),
					'default_value' => '70',
				)
			);

	}

	function impeka_grve_meta_box_post_format_quote( $post ) {

		$color_selection = impeka_grve_global_admin_param( 'post_color_selection' );
		$opacity_selection = impeka_grve_global_admin_param( 'post_bg_opacity_selection' );

		$post_quote_text = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_quote_text' );
		$post_quote_name = impeka_grve_admin_post_meta( $post->ID, '_impeka_grve_post_quote_name' );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Simply add some text in the text area. This text will automatically displayed as quote.', 'impeka' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>

<?php

		impeka_grve_print_admin_option(
			array(
				'type' => 'textarea',
				'name' => '_impeka_grve_post_quote_text',
				'id' => '_impeka_grve_post_quote_text',
				'value' => $post_quote_text,
				'label' => array(
					'title' => esc_html__( 'Quote Text', 'impeka' ),
					'desc' => esc_html__( 'Enter your quote text.', 'impeka' ),
				),
				'width' => 'fullwidth',
			)
		);

		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => '_impeka_grve_post_quote_name',
				'id' => '_impeka_grve_post_quote_name',
				'value' => $post_quote_name,
				'label' => array(
					'title' => esc_html__( 'Quote Name', 'impeka' ),
					'desc' => esc_html__( 'Enter your quote name.', 'impeka' ),
				),
				'width' => 'fullwidth',
			)
		);

	}

	function impeka_grve_meta_box_post_format_video( $post ) {

		$video_mode = get_post_meta( $post->ID, '_impeka_grve_post_type_video_mode', true );
		$post_video_webm = get_post_meta( $post->ID, '_impeka_grve_post_video_webm', true );
		$post_video_mp4 = get_post_meta( $post->ID, '_impeka_grve_post_video_mp4', true );
		$post_video_ogv = get_post_meta( $post->ID, '_impeka_grve_post_video_ogv', true );
		$post_video_poster = get_post_meta( $post->ID, '_impeka_grve_post_video_poster', true );
		$post_video_embed = get_post_meta( $post->ID, '_impeka_grve_post_video_embed', true );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Select one of the choices below for the featured video.', 'impeka' ); ?></p>
					</td>
				</tr>
				<tr class="grve-border-bottom">
					<th>
						<label for="grve-post-type-video-mode">
							<strong><?php esc_html_e( 'Video Mode', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Select your Video Mode', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<select id="grve-post-type-video-mode" name="_impeka_grve_post_type_video_mode">
							<option value="" <?php selected( "", $video_mode ); ?>><?php esc_html_e( 'YouTube/Vimeo Video', 'impeka' ); ?></option>
							<option value="html5" <?php selected( "html5", $video_mode ); ?>><?php esc_html_e( 'HTML5 Video', 'impeka' ); ?></option>
						</select>
					</td>
				</tr>
				<tr class="grve-post-video-html5">
					<th>
						<label for="grve-post-video-webm">
							<strong><?php esc_html_e( 'WebM File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .webm video file.', 'impeka' ); ?>
								<br/>
								<strong><?php esc_html_e( 'This Format must be included for HTML5 Video.', 'impeka' ); ?></strong>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-video-webm" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_video_webm" value="<?php echo esc_attr( $post_video_webm ); ?>"/>
						<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-video-html5">
					<th>
						<label for="grve-post-video-mp4">
							<strong><?php esc_html_e( 'MP4 File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .mp4 video file.', 'impeka' ); ?>
								<br/>
								<strong><?php esc_html_e( 'This Format must be included for HTML5 Video.', 'impeka' ); ?></strong>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-video-mp4" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_video_mp4" value="<?php echo esc_attr( $post_video_mp4 ); ?>"/>
						<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-video-html5">
					<th>
						<label for="grve-post-video-ogv">
							<strong><?php esc_html_e( 'OGV File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .ogv video file (optional).', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-video-ogv" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_video_ogv" value="<?php echo esc_attr( $post_video_ogv ); ?>"/>
						<input type="button" data-media-type="video" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-video-html5">
					<th>
						<label for="grve-post-video-poster">
							<strong><?php esc_html_e( 'Poster Image', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Use same resolution as video.', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-video-poster" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_video_poster" value="<?php echo esc_attr( $post_video_poster ); ?>"/>
						<input type="button" data-media-type="image" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-video-embed">
					<th>
						<label for="grve-post-video-embed">
							<strong><?php esc_html_e( 'Vimeo/YouTube URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Enter the full URL of your video from Vimeo or YouTube.', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-video-embed" class="grve-meta-text" name="_impeka_grve_post_video_embed" value="<?php echo esc_attr( $post_video_embed ); ?>"/>
					</td>
				</tr>
			</tbody>
		</table>
	<?php
	}

	function impeka_grve_meta_box_post_format_audio( $post ) {

		$audio_mode = get_post_meta( $post->ID, '_impeka_grve_post_type_audio_mode', true );
		$post_audio_mp3 = get_post_meta( $post->ID, '_impeka_grve_post_audio_mp3', true );
		$post_audio_ogg = get_post_meta( $post->ID, '_impeka_grve_post_audio_ogg', true );
		$post_audio_wav = get_post_meta( $post->ID, '_impeka_grve_post_audio_wav', true );
		$post_audio_embed = get_post_meta( $post->ID, '_impeka_grve_post_audio_embed', true );

	?>
		<table class="form-table grve-metabox">
			<tbody>
				<tr>
					<td colspan="2">
						<p class="howto"><?php esc_html_e( 'Select one of the choices below for the featured audio.', 'impeka' ); ?></p>
					</td>
				</tr>
				<tr class="grve-border-bottom">
					<th>
						<label for="grve-post-type-audio-mode">
							<strong><?php esc_html_e( 'Audio Mode', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Select your Audio Mode', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<select id="grve-post-type-audio-mode" name="_impeka_grve_post_type_audio_mode">
							<option value="" <?php selected( "", $audio_mode ); ?>><?php esc_html_e( 'Embed Audio', 'impeka' ); ?></option>
							<option value="html5" <?php selected( "html5", $audio_mode ); ?>><?php esc_html_e( 'HTML5 Audio', 'impeka' ); ?></option>
						</select>
					</td>
				</tr>
				<tr class="grve-post-audio-html5">
					<th>
						<label for="grve-post-audio-mp3">
							<strong><?php esc_html_e( 'MP3 File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .mp3 audio file.', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-audio-mp3" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_audio_mp3" value="<?php echo esc_attr( $post_audio_mp3 ); ?>"/>
						<input type="button" data-media-type="audio" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-audio-html5">
					<th>
						<label for="grve-post-audio-ogg">
							<strong><?php esc_html_e( 'OGG File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .ogg audio file.', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-audio-ogg" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_audio_ogg" value="<?php echo esc_attr( $post_audio_ogg ); ?>"/>
						<input type="button" data-media-type="audio" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-audio-html5">
					<th>
						<label for="grve-post-audio-wav">
							<strong><?php esc_html_e( 'WAV File URL', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Upload the .wav audio file (optional).', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<input type="text" id="grve-post-audio-wav" class="grve-upload-simple-media-field grve-meta-text" name="_impeka_grve_post_audio_wav" value="<?php echo esc_attr( $post_audio_wav ); ?>"/>
						<input type="button" data-media-type="audio" class="grve-upload-simple-media-button button" value="<?php esc_attr_e( 'Upload Media', 'impeka' ); ?>"/>
						<input type="button" class="grve-remove-simple-media-button button" value="<?php esc_attr_e( 'Remove', 'impeka' ); ?>"/>
					</td>
				</tr>
				<tr class="grve-post-audio-embed">
					<th>
						<label for="grve-post-audio-embed">
							<strong><?php esc_html_e( 'Audio embed code', 'impeka' ); ?></strong>
							<span>
								<?php esc_html_e( 'Type your audio embed code.', 'impeka' ); ?>
							</span>
						</label>
					</th>
					<td>
						<textarea id="grve-post-audio-embed" name="_impeka_grve_post_audio_embed" cols="40" rows="5"><?php echo esc_textarea( $post_audio_embed ); ?></textarea>
					</td>
				</tr>
			</tbody>
		</table>

	<?php
	}

	function impeka_grve_post_options_save_postdata( $post_id , $post ) {

		$options = array (
			//Post Overview
			array(
				'id' => '_impeka_grve_post_overview_double_size',
			),
			array(
				'id' => '_impeka_grve_post_overview_style',
			),
			array(
				'id' => '_impeka_grve_post_overview_heading_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_text_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_meta_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_bg_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_border_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_overlay_color',
			),
			array(
				'id' => '_impeka_grve_post_overview_overlay_opacity',
			),

			//Gallery Format
			array(
				'id' => '_impeka_grve_post_type_gallery_mode',
			),
			array(
				'id' => '_impeka_grve_post_type_gallery_image_mode',
			),
			//Link Format
			array(
				'id' => '_impeka_grve_post_link_url',
			),
			array(
				'id' => '_impeka_grve_post_link_new_window',
			),
			array(
				'id' => '_impeka_grve_post_link_text',
				'html' => true,
			),
			array(
				'id' => '_impeka_grve_post_link_bg_color',
			),
			array(
				'id' => '_impeka_grve_post_link_bg_hover_color',
			),
			array(
				'id' => '_impeka_grve_post_link_bg_opacity',
			),
			//Quote Format
			array(
				'id' => '_impeka_grve_post_quote_text',
				'html' => true,
			),
			array(
				'id' => '_impeka_grve_post_quote_name',
				'html' => true,
			),
			//Audio Format
			array(
				'id' => '_impeka_grve_post_type_audio_mode',
			),
			array(
				'id' => '_impeka_grve_post_audio_mp3',
			),
			array(
				'id' => '_impeka_grve_post_audio_ogg',
			),
			array(
				'id' => '_impeka_grve_post_audio_wav',
			),
			array(
				'id' => '_impeka_grve_post_audio_embed',
				'html' => true,
			),
			//Video Format
			array(
				'id' => '_impeka_grve_post_type_video_mode',
			),
			array(
				'id' => '_impeka_grve_post_video_webm',
			),
			array(
				'id' => '_impeka_grve_post_video_mp4',
			),
			array(
				'id' => '_impeka_grve_post_video_ogv',
			),
			array(
				'id' => '_impeka_grve_post_video_poster',
			),
			array(
				'id' => '_impeka_grve_post_video_embed',
			),
		);

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( wp_is_post_revision( $post_id ) || wp_is_post_autosave( $post_id ) ) {
			return $post_id;
		}

		if ( ! isset( $_POST['_impeka_grve_nonce_post_save'] ) || !wp_verify_nonce( $_POST['_impeka_grve_nonce_post_save'], 'impeka_grve_nonce_post_save' ) ) {
			return;
		}

		// Check permissions
		if ( 'post' == $_POST['post_type'] )
		{
			if ( !current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}

		foreach ( $options as $value ) {
			$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
			if( $allow_html ) {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : '' );
			} else {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : '' );
			}
			$meta_key = $value['id'];


			$meta_value = get_post_meta( $post_id, $meta_key, true );

			if ( '' != $new_meta_value  && '' == $meta_value ) {
				if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
					update_post_meta( $post_id, $meta_key, $new_meta_value );
				}
			} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
				update_post_meta( $post_id, $meta_key, $new_meta_value );
			} elseif ( '' == $new_meta_value && '' != $meta_value ) {
				delete_post_meta( $post_id, $meta_key );
			}
		}



		//Feature Slider Items
		$media_slider_items = array();
		if ( isset( $_POST['_impeka_grve_media_slider_item_id'] ) ) {

			$num_of_images = sizeof( $_POST['_impeka_grve_media_slider_item_id'] );
			for ( $i=0; $i < $num_of_images; $i++ ) {

				$this_image = array (
					'id' => sanitize_text_field( $_POST['_impeka_grve_media_slider_item_id'][ $i ] ),
				);
				array_push( $media_slider_items, $this_image );
			}

		}

		if( empty( $media_slider_items ) ) {
			delete_post_meta( $post->ID, '_impeka_grve_post_slider_items' );
			delete_post_meta( $post->ID, '_impeka_grve_post_slider_settings' );
		} else{
			update_post_meta( $post->ID, '_impeka_grve_post_slider_items', $media_slider_items );
			$media_slider_speed = 3500;
			$media_slider_arrows = 'yes';
			$media_slider_direction_nav_color = 'black';

			if ( isset( $_POST['_impeka_grve_post_slider_settings_speed'] ) ) {
				$media_slider_speed = sanitize_text_field( $_POST['_impeka_grve_post_slider_settings_speed'] );
			}
			if ( isset( $_POST['_impeka_grve_post_slider_settings_arrows'] ) ) {
				$media_slider_arrows = sanitize_text_field( $_POST['_impeka_grve_post_slider_settings_arrows'] );
			}
			if ( isset( $_POST['_impeka_grve_post_slider_settings_direction_nav_color'] ) ) {
				$media_slider_direction_nav_color = sanitize_text_field( $_POST['_impeka_grve_post_slider_settings_direction_nav_color'] );
			}

			$media_slider_settings = array (
				'slideshow_speed' => $media_slider_speed,
				'arrows' => $media_slider_arrows,
				'direction_nav_color' => $media_slider_direction_nav_color,
			);
			update_post_meta( $post->ID, '_impeka_grve_post_slider_settings', $media_slider_settings );
		}


	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
