<?php
/*
*	Greatives Testimonial Items
*
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

	add_action( 'save_post', 'impeka_grve_testimonial_options_save_postdata', 10, 2 );

	function impeka_grve_testimonial_options_box( $post ) {

		wp_nonce_field( 'impeka_grve_nonce_testimonial_save', '_impeka_grve_nonce_testimonial_save' );

		$testimonial_name = get_post_meta( $post->ID, '_impeka_grve_testimonial_name', true );
		$testimonial_identity = get_post_meta( $post->ID, '_impeka_grve_testimonial_identity', true );
		$testimonial_rating = get_post_meta( $post->ID, '_impeka_grve_testimonial_rating', true );

	?>
		<div id="grve-testimonial-options-wrapper">
	<?php
		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => '_impeka_grve_testimonial_name',
				'value' => $testimonial_name,
				'label' => array(
					'title' => esc_html__( 'Name', 'impeka' ),
					'desc' => esc_html__( 'Type the name.', 'impeka' ),
				),
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'textfield',
				'name' => '_impeka_grve_testimonial_identity',
				'value' => $testimonial_identity,
				'label' => array(
					'title' => esc_html__( 'Identity', 'impeka' ),
					'desc' => esc_html__( 'Type the identity.', 'impeka' ),
				),
			)
		);
		impeka_grve_print_admin_option(
			array(
				'type' => 'select',
				'name' => '_impeka_grve_testimonial_rating',
				'options' => array(
					'' => esc_html__( 'None', 'impeka' ),
					'1' => esc_html__( '1 Star', 'impeka' ),
					'2' => esc_html__( '2 Stars', 'impeka' ),
					'3' => esc_html__( '3 Stars', 'impeka' ),
					'4' => esc_html__( '4 Stars', 'impeka' ),
					'5' => esc_html__( '5 Stars', 'impeka' ),
				),
				'value' => $testimonial_rating,
				'default_value' => '',
				'label' => array(
					'title' => esc_html__( 'Rating', 'impeka' ),
					'desc' => esc_html__( 'Type the rating.', 'impeka' ),
				),
			)
		);
	?>
		</div>
	<?php
	}


	function impeka_grve_testimonial_options_save_postdata( $post_id , $post ) {

		$testimonial_options = array (
			array(
				'id' => '_impeka_grve_testimonial_name',
				'html' => true,
			),
			array(
				'id' => '_impeka_grve_testimonial_identity',
				'html' => true,
			),
			array(
				'id' => '_impeka_grve_testimonial_rating',
			),
		);

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		if ( wp_is_post_revision( $post_id ) || wp_is_post_autosave( $post_id ) ) {
			return $post_id;
		}

		if ( ! isset( $_POST['_impeka_grve_nonce_testimonial_save'] ) || !wp_verify_nonce( $_POST['_impeka_grve_nonce_testimonial_save'], 'impeka_grve_nonce_testimonial_save' ) ) {
			return;
		}

		// Check permissions
		if ( 'testimonial' == $_POST['post_type'] )
		{
			if ( !current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
		}

		foreach ( $testimonial_options as $value ) {
			$allow_html = ( isset( $value['html'] ) ? $value['html'] : false );
			if( $allow_html ) {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? wp_filter_post_kses( $_POST[$value['id']] ) : '' );
			} else {
				$new_meta_value = ( isset( $_POST[$value['id']] ) ? sanitize_text_field( $_POST[$value['id']] ) : '' );
			}
			$meta_key = $value['id'];


			$meta_value = get_post_meta( $post_id, $meta_key, true );

			if ( '' != $new_meta_value  && '' == $meta_value ) {
				if ( !add_post_meta( $post_id, $meta_key, $new_meta_value, true ) ) {
					update_post_meta( $post_id, $meta_key, $new_meta_value );
				}
			} elseif ( '' != $new_meta_value && $new_meta_value != $meta_value ) {
				update_post_meta( $post_id, $meta_key, $new_meta_value );
			} elseif ( '' == $new_meta_value && '' != $meta_value ) {
				delete_post_meta( $post_id, $meta_key );
			}
		}

	}

//Omit closing PHP tag to avoid accidental whitespace output errors.
