<?php
/**
 * The template for the menu container of the panel.
 * Override this template by specifying the path where it is stored (templates_path) in your Redux config.
 *
 * @author     Redux Framework
 * @package    ReduxFramework/Templates
 * @version:    4.0.0
 */

 
function redux_custom_section_menu( $current, $k, $section ) {
    return $current->parent->section_menu ( $k, $section );
}

?>
<div class="redux-sidebar">
    <ul class="redux-group-menu">
<?php
        foreach ( $this->parent->sections as $k => $section ) {
            $title = isset ( $section[ 'title' ] ) ? $section[ 'title' ] : '';
            $skip_sec = false;

            $options_class = $this->parent;
            if ( isset( $this->parent->options_class ) ) {
                $options_class = $this->parent->options_class;
            }
            foreach ( $options_class->hidden_perm_sections as $num => $section_title ) {
                if ( $section_title == $title ) {
                    $skip_sec = true;
                }
            }

            if ( isset ( $section[ 'customizer_only' ] ) && $section[ 'customizer_only' ] == true ) {
                continue;
            }

            if ( false == $skip_sec ) {
                echo redux_custom_section_menu( $this, $k, $section ); // phpcs:ignore WordPress.Security.EscapeOutput
                $skip_sec = false;
            }
        }

        /**
         * Action 'redux/page/{opt_name}/menu/after'
         *
         * @param object $this ReduxFramework
         */
        do_action ( "redux/page/{$this->parent->args[ 'opt_name' ]}/menu/after", $this );
?>
    </ul>
</div>