<?php
/**
 *  Dynamic css style
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */

$css = "";

/* Singular Dynamic rules
============================================================================= */
if ( is_singular( 'post' ) ) {

	$impeka_grve_width = impeka_grve_post_meta( '_impeka_grve_post_content_width', impeka_grve_option( 'post_content_width', 'small' ) );
	$impeka_grve_post_content_width = impeka_grve_array_value( impeka_grve_get_post_width_array(), $impeka_grve_width, impeka_grve_option( 'container_size', 1390 ) );

$css .= "
.single-post #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) .grve-container,
#grve-about-author-section .grve-container,
#grve-comments-section .grve-container,
#grve-no-comments .grve-container {
	max-width: " . esc_attr( $impeka_grve_post_content_width ) . "px;
}

.single-post #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) #grve-single-media .grve-media.grve-wide {
	margin-right: calc( -1 * (100vw - " . esc_attr( $impeka_grve_post_content_width ) . "px)/2 );
	margin-left: -3.500rem;
}

.single-post #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) #grve-single-media .grve-media.grve-wide.grve-gallery {
	padding-right: 2.000rem;
}

@media only screen and (max-width: 959px) {
	.single-post #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) #grve-single-media .grve-media.grve-wide {
		margin-right: 0;
		margin-left: 0;
	}
	.single-post #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) #grve-single-media .grve-media.grve-wide.grve-gallery {
		padding-right: 0;
	}
}

";

} elseif ( is_singular( 'portfolio' ) ) {

	$impeka_grve_media_margin_bottom = impeka_grve_post_meta( '_impeka_grve_portfolio_media_margin_bottom' );
	if( '' != $impeka_grve_media_margin_bottom ) {
		$css .= "#grve-single-media.grve-portfolio-media {";
		$css .= 'margin-bottom: '. ( preg_match('/(px|em|\%|pt|cm)$/', $impeka_grve_media_margin_bottom) ? esc_attr( $impeka_grve_media_margin_bottom ) : esc_attr( $impeka_grve_media_margin_bottom ) . 'px').';';
		$css .= "}";
	}

} elseif ( is_singular( 'tribe_events' ) ) {

	$impeka_grve_width = impeka_grve_post_meta( '_impeka_grve_post_content_width', impeka_grve_option( 'event_content_width', 'large' ) );
	$impeka_grve_post_content_width = impeka_grve_array_value( impeka_grve_get_post_width_array(), $impeka_grve_width, impeka_grve_option( 'container_size', 1390 ) );

$css .= "
#grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) .grve-container {
	max-width: " . esc_attr( $impeka_grve_post_content_width ) . "px;
}
";

} elseif ( is_singular( 'product' ) ) {
	$impeka_grve_width = impeka_grve_post_meta( '_impeka_grve_post_content_width', impeka_grve_option( 'product_content_width', 'medium' ) );
	$impeka_grve_post_content_width = impeka_grve_array_value( impeka_grve_get_post_width_array(), $impeka_grve_width, impeka_grve_option( 'container_size', 1170 ) );
$css .= "

.woocommerce #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) div.product .woocommerce-tabs ul.tabs,
.single-product #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) .woocommerce-Tabs-panel.woocommerce-Tabs-panel--description .grve-container,
.single-product #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) .woocommerce-Tabs-panel:not(.woocommerce-Tabs-panel--description) {
	max-width: " . esc_attr( $impeka_grve_post_content_width ) . "px;
}

@media only screen and (max-width: 1200px) {
	.woocommerce #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) div.product .woocommerce-tabs ul.tabs {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 7.500rem );
	}
}

@media only screen and (max-width: 960px) {
	.woocommerce #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) div.product .woocommerce-tabs ul.tabs {
		max-width: " . impeka_grve_option( 'container_size', 1390 ) . "px;
		width: calc( 100% - 6.000rem );
	}
}
@media only screen and (max-width: 767px) {
	.woocommerce #grve-content:not(.grve-right-sidebar):not(.grve-left-sidebar) div.product .woocommerce-tabs ul.tabs {
		max-width: 500px;
		width: calc( 100% - " . impeka_grve_option( 'mobile_container_space', 1390 ) * 2 . "px );
	}
}

";

}

/* Main Content Skin Options
============================================================================= */
$impeka_grve_content_skin_options = array();
if ( is_singular() ) {
	$impeka_grve_content_skin_options = impeka_grve_post_meta( '_impeka_grve_content_skin_options' );
} else if ( impeka_grve_is_woo_shop() ) {
	$impeka_grve_content_skin_options = impeka_grve_post_meta_shop( '_impeka_grve_content_skin_options' );
}

$impeka_grve_content_skin = impeka_grve_array_value( $impeka_grve_content_skin_options, 'skin' );

switch( $impeka_grve_content_skin ) {
	case 'custom':
		$impeka_grve_content_background = $impeka_grve_content_skin_options;
		$impeka_grve_content_heading_color = impeka_grve_array_value( $impeka_grve_content_skin_options, 'heading_color', '#000000' );
		$impeka_grve_content_text_color = impeka_grve_array_value( $impeka_grve_content_skin_options, 'text_color', '#000000' );
		$impeka_grve_content_widget_title_color = impeka_grve_array_value( $impeka_grve_content_skin_options, 'heading_color', '#000000' );
		$impeka_grve_content_link_color = impeka_grve_array_value( $impeka_grve_content_skin_options, 'link_color', '#000000' );
		$impeka_grve_content_link_hover_color = impeka_grve_array_value( $impeka_grve_content_skin_options, 'link_hover_color', '#FF4433' );
	break;
	case 'light':
		$impeka_grve_content_background = array( 'background-color' => '#ffffff' );
		$impeka_grve_content_heading_color = "#000000";
		$impeka_grve_content_text_color = "#000000";
		$impeka_grve_content_widget_title_color = "#000000";
		$impeka_grve_content_link_color = "#000000";
		$impeka_grve_content_link_hover_color = "#FF4433";
	break;
	case 'dark':
		$impeka_grve_content_background = array( 'background-color' => '#000000' );
		$impeka_grve_content_heading_color = "#ffffff";
		$impeka_grve_content_text_color = "#ffffff";
		$impeka_grve_content_widget_title_color = "#ffffff";
		$impeka_grve_content_link_color = "#ffffff";
		$impeka_grve_content_link_hover_color = "#FF4433";
	break;
	default:
		if( is_404() ) {
			$impeka_grve_content_background = impeka_grve_option( '404_content_background', array( 'background-color' => '#ffffff' ) );
		} else {
			$impeka_grve_content_background = impeka_grve_option( 'content_background', array( 'background-color' => '#ffffff' ) );
		}
		$impeka_grve_content_heading_color = impeka_grve_option( 'body_heading_color' );
		$impeka_grve_content_text_color = impeka_grve_option( 'body_text_color' );
		$impeka_grve_content_widget_title_color = impeka_grve_option( 'widget_title_color' );
		$impeka_grve_content_link_color = impeka_grve_option( 'body_text_link_color' );
		$impeka_grve_content_link_hover_color = impeka_grve_option( 'body_text_link_hover_color' );
	break;
}

$css .= "
	#grve-theme-content {
		" . impeka_grve_get_background_css( $impeka_grve_content_background ) . "
	}
	@media only screen and (max-width: 767px) {
		.grve-navigation-bar.grve-layout-2 {
			" . impeka_grve_get_background_css( $impeka_grve_content_background ) . "
		}
	}
";

if ( 'fixed' == impeka_grve_array_value( $impeka_grve_content_background, 'background-attachment' ) ) {
	$impeka_grve_content_background['background-attachment'] = 'scroll';
	$css .= "
		#grve-theme-content {
			clip: rect(auto auto auto auto);
		}
		#grve-theme-content:before {
			" . impeka_grve_get_background_css( $impeka_grve_content_background ) . "
			content: '';
			position:fixed;
			top:0;
			width:100vw;
			height:auto;
			left:0;
			right:0;
			z-index:-1;
		}
	";
}

/* Link Colors */

$css .= "
a,
.grve-link-default a,
.grve-menu-element .grve-arrow,
.grve-link-default .grve-menu-element .grve-arrow {
	color: " . esc_attr( $impeka_grve_content_link_color ) . ";
}

a:hover,
.grve-menu-element .grve-arrow:hover {
	color: " . esc_attr( $impeka_grve_content_link_hover_color ) . ";
}

#grve-theme-wrapper .grve-link-hover-default a:hover {
	color: " . esc_attr( $impeka_grve_content_link_hover_color ) . ";
}

";

/* Text Colors */
$css .= "
body,
.grve-text-content,
.grve-text-content a,
#grve-content form,
#grve-content form p,
#grve-content form div,
#grve-content form span:not(.grve-heading-color),
.mfp-content form div
table,
.grve-content-slider {
	color: " . esc_attr( $impeka_grve_content_text_color ) . ";
}

";

/* - Widget Colors
========================================================================= */
$css .= "
#grve-content .widget .grve-widget-title {
	color: " . esc_attr( $impeka_grve_content_widget_title_color ) . ";
}

.widget {
	color: " . esc_attr( $impeka_grve_content_text_color ) . ";
}

.widget a:not(.grve-outline):not(.grve-btn) {
	color: " . esc_attr( $impeka_grve_content_text_color ) . ";
}
";

/* Headings Colors */
$css .= "

h1,h2,h3,h4,h5,h6,
.grve-heading-color,
.grve-heading-hover-color:hover,
p.grve-dropcap:first-letter,
.grve-content-slider .grve-title {
	color: " . esc_attr( $impeka_grve_content_heading_color ) . ";
}

.grve-svg-heading-color {
	fill: " . esc_attr( $impeka_grve_content_heading_color ) . ";
}

";

/* Product Area Colors
============================================================================= */

function impeka_grve_get_product_area_css() {

	$css = '';

	$impeka_grve_colors = impeka_grve_get_color_array();

	$mode = 'product';
	$impeka_grve_area_colors = array(
		'bg_color' => impeka_grve_option( $mode . '_area_bg_color', '#eeeeee' ),
		'headings_color' => impeka_grve_option( $mode . '_area_headings_color', '#000000' ),
		'font_color' => impeka_grve_option( $mode . '_area_font_color', '#000000' ),
		'link_color' => impeka_grve_option( $mode . '_area_link_color', '#FF7D88' ),
		'hover_color' => impeka_grve_option( $mode . '_area_hover_color', '#000000' ),
		'border_color' => impeka_grve_option( $mode . '_area_border_color', '#e0e0e0' ),
		'button_color' => impeka_grve_option( $mode . '_area_button_color', 'primary-1' ),
		'button_hover_color' => impeka_grve_option( $mode . '_area_button_hover_color', 'black' ),
	);

	$impeka_grve_single_area_colors = impeka_grve_post_meta( '_impeka_grve_area_colors' );
	$impeka_grve_single_area_colors_custom = impeka_grve_array_value( $impeka_grve_single_area_colors, 'custom' );

	if ( 'custom' == $impeka_grve_single_area_colors_custom ) {
		$impeka_grve_area_colors = $impeka_grve_single_area_colors;
	}


$css .= "

#grve-product-area {
	background-color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'bg_color' ) . ";
	color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'font_color' ) . ";
	border-color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'border_color' ) . ";
}

#grve-theme-wrapper .grve-product-area-wrapper .grve-border,
#grve-theme-wrapper .grve-product-area-wrapper form,
#grve-theme-wrapper .grve-product-area-wrapper .quantity,
.grve-product-area-wrapper .grve-product-form,
#grve-entry-summary,
#grve-theme-wrapper .quantity,
#grve-theme-wrapper .summary input,
#grve-theme-wrapper .summary select,
.woocommerce-grouped-product-list-item,
.woocommerce div.product form.cart .variations tr,
.woocommerce div.product .woocommerce-tabs ul.tabs,
.woocommerce .grve-form-wrapper {
	border-color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'border_color' ) . ";
}

.grve-product-area-wrapper a {
	color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'link_color' ) . ";
}

.grve-product-area-wrapper a:hover {
	color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'hover_color' ) . ";
}

.grve-product-area-wrapper h1,
.grve-product-area-wrapper h2,
.grve-product-area-wrapper h3,
.grve-product-area-wrapper h4,
.grve-product-area-wrapper h5,
.grve-product-area-wrapper h6,
.grve-product-area-wrapper .grve-heading-color {
    color: " . impeka_grve_array_value( $impeka_grve_area_colors, 'headings_color' ) . ";
}

";

	$default_button_color = impeka_grve_option( 'body_primary_1_color' );
	$area_button_color = impeka_grve_array_value( $impeka_grve_area_colors, 'button_color' );
	$button_color = impeka_grve_array_value( $impeka_grve_colors, $area_button_color, $default_button_color);
	$area_button_hover_color = impeka_grve_array_value( $impeka_grve_area_colors, 'button_hover_color' );
	$button_hover_color = impeka_grve_array_value( $impeka_grve_colors, $area_button_hover_color, '#000000');

	$impeka_button_css = "";
	$impeka_button_css .= "#grve-product-area button.single_add_to_cart_button {";
	$impeka_button_css .= "background-color: " . esc_attr( $button_color ) . ";";
	$impeka_button_css .= "border: none;";
	if ( 'white' == $area_button_color ) {
		$impeka_button_css .= "color: #bababa;";
	} else {
		$impeka_button_css .= "color: #ffffff;";
	}
	$impeka_button_css .= "}";

	$impeka_button_css .= "#grve-product-area button.single_add_to_cart_button:hover {";
	$impeka_button_css .= "background-color: " . esc_attr( $button_hover_color ) . ";";
	if ( 'white' == $area_button_hover_color ) {
		$impeka_button_css .= "color: #bababa;";
	} else {
		$impeka_button_css .= "color: #ffffff;";
	}
	$impeka_button_css .= "}";

	$css .= $impeka_button_css;

	return $css;

}

if ( is_singular( 'product') ) {
	$css .= impeka_grve_get_product_area_css();
}


/* Paddings
============================================================================= */

function impeka_grve_print_space_css( $type = 'padding-top', $multiplier = '3x', $padding = '', $ratio = 1 ) {

	$default_space_size = 30;
	$min_space_size = 30;

	$css = '';
	if ( 'custom' == $multiplier) {
		if( 1 == $ratio ) {
			if( '' == $padding ) {
				$padding = '0';
			}
			$css .= esc_attr( $type ) . ': '. ( preg_match('/(px|em|\%|pt|cm)$/', $padding) ? esc_attr( $padding ) : esc_attr( $padding ) . 'px').';';
		}
	} else if ( 'none' == $multiplier) {
		$css .= esc_attr( $type ) . ': 0;';
	} else {
		$multiplier = filter_var( $multiplier, FILTER_SANITIZE_NUMBER_INT );
		$space_size = $default_space_size * $multiplier * $ratio;
		if ( $space_size < $default_space_size ) {
			$space_size = $min_space_size;
		}
		$css .= esc_attr( $type ) . ': ' . esc_attr( $space_size ) . 'px;';
	}

	return $css;
}

$impeka_grve_padding_top_multiplier = '3x';
$impeka_grve_padding_bottom_multiplier = '3x';
$impeka_grve_padding_top = $impeka_grve_padding_bottom = '';

if ( is_singular() || impeka_grve_is_woo_shop() ) {

	if ( impeka_grve_is_woo_shop() ) {
		$impeka_grve_padding_top_multiplier = impeka_grve_post_meta_shop( '_impeka_grve_padding_top_multiplier' );
		$impeka_grve_padding_top = impeka_grve_post_meta_shop( '_impeka_grve_padding_top' );
		if ( empty( $impeka_grve_padding_top_multiplier ) ) {
			$impeka_grve_padding_top_multiplier = impeka_grve_option( 'page_padding_top_multiplier', 'x3' );
			$impeka_grve_padding_top = impeka_grve_option( 'page_padding_top' );
		}
		$impeka_grve_padding_bottom_multiplier = impeka_grve_post_meta_shop( '_impeka_grve_padding_bottom_multiplier' );
		$impeka_grve_padding_bottom = impeka_grve_post_meta_shop( '_impeka_grve_padding_top' );
		if ( empty( $impeka_grve_padding_bottom_multiplier ) ) {
			$impeka_grve_padding_bottom_multiplier = impeka_grve_option( 'page_padding_bottom_multiplier', 'x3' );
			$impeka_grve_padding_bottom = impeka_grve_option( 'page_padding_bottom' );
		}
	} else {
		if ( is_singular( 'post' ) ) {
			$mode = 'post';
		} else if ( is_singular( 'portfolio' ) ) {
			$mode = 'portfolio';
		} else if ( is_singular( 'product' ) ) {
			$mode = 'product';
		} else if ( is_singular( 'tribe_events' ) ) {
			$mode = 'event';
		} else {
			$mode = 'page';
		}
		$impeka_grve_padding_top_multiplier = impeka_grve_post_meta( '_impeka_grve_padding_top_multiplier' );
		$impeka_grve_padding_top = impeka_grve_post_meta( '_impeka_grve_padding_top' );
		if ( empty( $impeka_grve_padding_top_multiplier ) ) {
			$impeka_grve_padding_top_multiplier = impeka_grve_option( $mode . '_padding_top_multiplier', 'x3' );
			$impeka_grve_padding_top = impeka_grve_option( $mode . '_padding_top' );
		}
		$impeka_grve_padding_bottom_multiplier = impeka_grve_post_meta( '_impeka_grve_padding_bottom_multiplier' );
		$impeka_grve_padding_bottom = impeka_grve_post_meta( '_impeka_grve_padding_top' );
		if ( empty( $impeka_grve_padding_bottom_multiplier ) ) {
			$impeka_grve_padding_bottom_multiplier = impeka_grve_option( $mode . '_padding_bottom_multiplier', 'x3' );
			$impeka_grve_padding_bottom = impeka_grve_option( $mode . '_padding_bottom' );
		}
	}
}

$ratio = 1;
$css .= "#grve-main-content .grve-main-content-wrapper, #grve-sidebar {";
$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_bottom_multiplier, $impeka_grve_padding_bottom, $ratio );
$css .= "}";
if ( is_singular( 'portfolio' ) ) {
	$css .= "#grve-single-media.grve-portfolio-media.grve-without-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
	$css .= "#grve-single-media.grve-portfolio-media.grve-with-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
}

$ratio = 0.8;
$css .= "@media only screen and (max-width: 1200px) {";
$css .= "#grve-main-content .grve-main-content-wrapper, #grve-sidebar {";
$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_bottom_multiplier, $impeka_grve_padding_bottom, $ratio );
$css .= "}";
if ( is_singular( 'portfolio' ) ) {
	$css .= "#grve-single-media.grve-portfolio-media.grve-without-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
	$css .= "#grve-single-media.grve-portfolio-media.grve-with-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
}
$css .= "}";

$ratio = 0.6;
$css .= "@media only screen and (max-width: 768px) {";
$css .= "#grve-main-content .grve-main-content-wrapper, #grve-sidebar {";
$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_bottom_multiplier, $impeka_grve_padding_bottom, $ratio );
$css .= "}";
if ( is_singular( 'portfolio' ) ) {
	$css .= "#grve-single-media.grve-portfolio-media.grve-without-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-top', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
	$css .= "#grve-single-media.grve-portfolio-media.grve-with-sidebar {";
	$css .= impeka_grve_print_space_css( 'padding-bottom', $impeka_grve_padding_top_multiplier, $impeka_grve_padding_top, $ratio );
	$css .= "}";
}
$css .= "}";


/* Builders
============================================================================= */

/* WPBakery Page Builder Front End Fix*/
if ( class_exists( 'Impeka_WPBakery_Extension_Plugin' ) ) {
$css .= "
.compose-mode .vc_element .grve-row {
    margin-top: 30px;
}
.compose-mode .vc_element.vc_vc_column {
	display: flex;
	flex-direction: row;
	flex-wrap: wrap;
}
.compose-mode .vc_vc_column .wpb_column {
    width: 100% !important;
    margin-bottom: 30px;
    border: 1px dashed rgba(125, 125, 125, 0.4);
}
.compose-mode .vc_controls > .vc_controls-out-tl {
    left: 15px;
}
.compose-mode .vc_controls > .vc_controls-bc {
    bottom: 15px;
}
.compose-mode .vc_welcome .vc_buttons {
    margin-top: 60px;
}
.compose-mode .vc_controls > div {
    z-index: 9;
}
.compose-mode .grve-image img,
.compose-mode .grve-bg-image {
    opacity: 1;
}
.compose-mode #grve-theme-wrapper .grve-section.grve-fullwidth-background,
.compose-mode #grve-theme-wrapper .grve-section.grve-fullwidth-element {
	visibility: visible;
}
.compose-mode .grve-animated-item {
	opacity: 1;
	visibility: visible;
}
.compose-mode .grve-isotope-item-inner {
	opacity: 1 !important;
	transform: none !important;
}
.compose-mode #grve-theme-wrapper .grve-isotope .grve-isotope-container {
    visibility: visible;
}
.compose-mode .grve-clipping-animation,
.compose-mode .grve-clipping-animation .grve-clipping-content,
.compose-mode .grve-appear-animation {
    visibility: visible;
    opacity: 1;
}
";
}

/* Elementor Front End Fix*/
$css .= "
.elementor-editor-active .grve-animated-item {
	opacity: 1;
	visibility: visible;
}
.elementor-editor-active .grve-bg-image {
    opacity: 1;
}
.elementor-editor-active .grve-isotope-item-inner {
	opacity: 1 !important;
	transform: none !important;
}
.elementor-editor-active .grve-isotope .grve-isotope-container {
    visibility: visible;
}
.elementor-editor-active .grve-clipping-animation,
.elementor-editor-active .grve-clipping-animation .grve-clipping-content,
.elementor-editor-active .grve-appear-animation {
    visibility: visible;
    opacity: 1;
}
";

// output dynamic css
echo impeka_grve_compress_css( $css );

//Omit closing PHP tag to avoid accidental whitespace output errors.