<?php

/*
*	bbPress helper functions and configuration
*
* 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
*/

/**
 * Helper function to check if bbPress is enabled
 */
function impeka_grve_bbpress_enabled() {
	if ( class_exists( 'bbPress' ) ) {
		return true;
	}
	return false;
}

function impeka_grve_is_bbpress() {
	if ( impeka_grve_bbpress_enabled() && is_bbpress() ) {
		return true;
	}
	return false;
}

//If woocomerce plugin is not enabled return
if ( !impeka_grve_bbpress_enabled() ) {
	return false;
}

/**
 * De-register bbPress styles
 */
add_filter( 'bbp_default_styles', 'impeka_grve_bbpress_deregister_styles', 10, 1 );
function impeka_grve_bbpress_deregister_styles( $styles ) {
	return array();
}

/**
 * Register custom bbPress styles
 */
if( !is_admin() ) {
	add_action('bbp_enqueue_scripts', 'impeka_grve_bbpress_register_styles', 15 );
}
function impeka_grve_bbpress_register_styles() {
	$impeka_version = trim ( IMPEKA_GRVE_THEME_VERSION );
	$min = '';
	if ( impeka_grve_visibility( 'minify_assets', '1' ) ) {
		$min = '.min';
	}
	wp_enqueue_style( 'impeka-bbpress', get_template_directory_uri() . '/css/bbpress' . $min . '.css', array(), esc_attr( $impeka_version ), 'all' );
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
