<?php
/**
 *  Generate Dynamic css
 *  @version	1.0
 *  @author		Greatives Team
 *  @URI		https://greatives.eu
 */

function impeka_grve_check_css_folder() {
	$wp_upload_dir = wp_upload_dir();
	if ( wp_mkdir_p( $wp_upload_dir['basedir'] . '/grve-css' ) ) {
		return true;
	}
	return false;
}
function impeka_grve_get_css_file_path() {
	$wp_upload_dir = wp_upload_dir();
	return sprintf( '%s/grve-css/%s.%s', $wp_upload_dir['basedir'], 'grve-dynamic-' . impeka_grve_get_css_file_hash(), 'css' );
}

function impeka_grve_get_css_file_url() {
	$wp_upload_dir = wp_upload_dir();
	return sprintf( '%s/grve-css/%s.%s', $wp_upload_dir['baseurl'], 'grve-dynamic-' . impeka_grve_get_css_file_hash(), 'css' );
}

function impeka_grve_get_css_file_hash() {
	$hash = get_option( 'impeka_grve_hash' );
	if( !$hash ) {
		update_option('impeka_grve_hash' , uniqid() );
	}
	return $hash;
}

if ( ! function_exists( 'impeka_grve_remove_dynamic_css_file' ) ) {
	function impeka_grve_remove_dynamic_css_file() {
		if (  1 == impeka_grve_option( 'css_generation' ) ) {
			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once (ABSPATH . '/wp-admin/includes/file.php');
				WP_Filesystem();
			}
			$file_path = impeka_grve_get_css_file_path();
			if( impeka_grve_check_css_folder() ) {
				$wp_filesystem->delete( $file_path );
			}
			delete_option( 'impeka_grve_hash' );
		}
	}
}

if ( ! function_exists( 'impeka_grve_generate_dynamic_css_file' ) ) {
	function impeka_grve_generate_dynamic_css_file(){
		if (  1 == impeka_grve_option( 'css_generation' ) ) {
			global $wp_filesystem;
			if ( empty( $wp_filesystem ) ) {
				require_once (ABSPATH . '/wp-admin/includes/file.php');
				WP_Filesystem();
			}
			$file_path = impeka_grve_get_css_file_path();
			$styles_css = impeka_grve_dynamic_options_css();

			if( impeka_grve_check_css_folder() ) {
				if( $wp_filesystem->put_contents( $file_path, $styles_css, 0777 ) ){
					return true;
				}
			}
			return false;
		}
	}
}
add_action("redux/options/impeka_grve_options/saved", 'impeka_grve_remove_dynamic_css_file');
add_action('customize_save_after', 'impeka_grve_remove_dynamic_css_file', 99);
add_action( 'after_switch_theme', 'impeka_grve_remove_dynamic_css_file' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
