<?php

/*
*	Footer Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/


/**
 * Prints Footer Background Image
 */
if ( !function_exists('impeka_grve_print_footer_bg_image') ) {
	function impeka_grve_print_footer_bg_image() {
		if ( 'custom' == impeka_grve_option( 'footer_bg_mode' ) ) {
			$footer_custom_bg = array(
				'bg_mode' => 'custom',
				'bg_image_id' => impeka_grve_option( 'footer_bg_image', '', 'id' ),
				'bg_position' => impeka_grve_option( 'footer_bg_position', 'center-center' ),
				'pattern_overlay' => impeka_grve_option( 'footer_pattern_overlay' ),
				'color_overlay' => impeka_grve_option( 'footer_color_overlay' ),
				'opacity_overlay' => impeka_grve_option( 'footer_opacity_overlay' ),
			);
			impeka_grve_print_title_bg_image( $footer_custom_bg );
		}
	}
}

/**
 * Prints Footer Widgets
 */
if ( !function_exists('impeka_grve_print_footer_widgets') ) {
	function impeka_grve_print_footer_widgets() {
		$section_visibility = 'no';
		if ( impeka_grve_visibility( 'footer_widgets_visibility' ) ) {
			$section_visibility = 'yes';
		}
		if ( is_singular() ) {
			$section_visibility = impeka_grve_post_meta( '_impeka_grve_footer_widgets_visibility', $section_visibility );
		} else if( impeka_grve_is_woo_shop() ) {
			$section_visibility = impeka_grve_post_meta_shop( '_impeka_grve_footer_widgets_visibility', $section_visibility );
		}

		if ( 'yes' == $section_visibility ) {

			$footer_columns = impeka_grve_option('footer_widgets_layout');

			switch( $footer_columns ) {
				case 'footer-1':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-3-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-4-sidebar',
							'column' => '1-4',
						),
					);
				break;
				case 'footer-2':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-2',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-3-sidebar',
							'column' => '1-4',
						),
					);
				break;
				case 'footer-3':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-3-sidebar',
							'column' => '1-2',
						),
					);
				break;
				case 'footer-4':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-2',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-2',
						),
					);
				break;
				case 'footer-5':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-3',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-3',
						),
						array(
							'sidebar-id' => 'grve-footer-3-sidebar',
							'column' => '1-3',
						),
					);
				break;
				case 'footer-6':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '2-3',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-3',
						),
					);
				break;
				case 'footer-7':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-3',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '2-3',
						),
					);
				break;
				case 'footer-8':
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1-4',
						),
						array(
							'sidebar-id' => 'grve-footer-2-sidebar',
							'column' => '1-2',
						),
						array(
							'sidebar-id' => 'grve-footer-3-sidebar',
							'column' => '1-4',
						),
					);
				break;
				case 'footer-9':
				default:
					$footer_sidebars = array(
						array(
							'sidebar-id' => 'grve-footer-1-sidebar',
							'column' => '1',
						),
					);
				break;
			}

			$section_type = impeka_grve_option( 'footer_section_type', 'fullwidth-background' );

			$footer_class = array( 'grve-widget-area' );
			$footer_class[] = 'grve-layout-' . $footer_columns;
			if( 'fullwidth-element' == $section_type ) {
				$footer_class[] = 'grve-fullwidth';
			}
			$footer_class_string = implode( ' ', $footer_class );

			$footer_padding_top = impeka_grve_option( 'footer_padding_top_multiplier', '3x' );
			$footer_padding_bottom = impeka_grve_option( 'footer_padding_bottom_multiplier', '3x' );
			
			$has_footer_sidebars = false;
			foreach ( $footer_sidebars as $footer_sidebar ) {
				if( is_active_sidebar( $footer_sidebar['sidebar-id']) ) {
					$has_footer_sidebars = true;
				}
			}
			if ( $has_footer_sidebars ) {
	?>
			<!-- Footer -->
			<div class="<?php echo esc_attr( $footer_class_string ); ?>">
				<div class="grve-container grve-padding-top-<?php echo esc_attr( $footer_padding_top ); ?> grve-padding-bottom-<?php echo esc_attr( $footer_padding_bottom ); ?> ">
					<div class="grve-footer-row">
		<?php
					foreach ( $footer_sidebars as $footer_sidebar ) {
						echo '<div class="grve-footer-column grve-footer-column-' . $footer_sidebar['column'] . '">';
						dynamic_sidebar( $footer_sidebar['sidebar-id'] );
						echo '</div>';
					}
		?>
					</div>
				</div>
			</div>
	<?php
			}
		}
	}
}

/**
 * Prints Footer Bar Area
 */

if ( !function_exists('impeka_grve_print_footer_bar') ) {
	function impeka_grve_print_footer_bar() {

		global $impeka_grve_social_list_extended;
		$social_list_extended = $impeka_grve_social_list_extended;


		$section_visibility = 'no';
		if ( impeka_grve_visibility( 'footer_bar_visibility' ) ) {
			$section_visibility = 'yes';
		}
		if ( is_singular() ) {
			$section_visibility = impeka_grve_post_meta( '_impeka_grve_footer_bar_visibility', $section_visibility );
		} else if( impeka_grve_is_woo_shop() ) {
			$section_visibility = impeka_grve_post_meta_shop( '_impeka_grve_footer_bar_visibility', $section_visibility );
		}

		if ( 'yes' == $section_visibility ) {

			$section_type = impeka_grve_option( 'footer_bar_section_type', 'fullwidth-background' );
			$align_center = impeka_grve_option( 'footer_bar_align_center', 'no' );
			$second_area = impeka_grve_option( 'second_area_visibility', '1' );

			// Footer Bar Class
			$footer_bar_class = array( 'grve-footer-bar', 'grve-padding-top-1x', 'grve-padding-bottom-1x' );

			if( 'fullwidth-element' == $section_type ) {
				$footer_bar_class[] = 'grve-fullwidth';
			}
			if( 'yes' == $align_center ) {
				$footer_bar_class[] = 'grve-align-center';
			}
			$footer_bar_class_string = implode( ' ', $footer_bar_class );

			// Column Class
			$column_class = array( 'grve-footer-column' );

			if( 'yes' == $align_center ) {
				$column_class[] = 'grve-footer-column-1';
			} else {
				$column_class[] = 'grve-footer-column-1-2';
			}
			$column_class_string = implode( ' ', $column_class );

	?>

		<div class="<?php echo esc_attr( $footer_bar_class_string ); ?>">
			<div class="grve-footer-bar-section">
				<div class="grve-container">
					<div class="grve-footer-row">
						<div class="<?php echo esc_attr( $column_class_string ); ?>">
							<div class="grve-column-content grve-align-left">
								<?php if ( impeka_grve_visibility( 'footer_copyright_visibility' ) ) { ?>
								<div class="grve-bar-content grve-left-side">
									<div class="grve-copyright">
										<?php echo do_shortcode( wp_kses_post( impeka_grve_option( 'footer_copyright_text' ) ) ); ?>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>
						<?php if ( '1' != $second_area ) { ?>
						<div class="<?php echo esc_attr( $column_class_string ); ?>">
							<div class="grve-column-content grve-align-right">
								<?php if ( '2' == $second_area ) { ?>
								<div class="grve-bar-content grve-right-side">
									<nav class="grve-footer-menu" aria-label="<?php esc_attr_e( 'Footer', 'impeka' ); ?>">
										<?php impeka_grve_footer_nav(); ?>
									</nav>
								</div>
								<?php
								} else if ( '3' == $second_area ) { ?>
								<div class="grve-bar-content grve-right-side">
									<?php
									$options = impeka_grve_option('footer_social_options');
									$social_display = impeka_grve_option('footer_social_display', 'text');
									$social_options = impeka_grve_option('social_options');

									if ( !empty( $options ) && !empty( $social_options ) ) {
										if ( 'text' == $social_display ) {
											echo '<ul class="grve-social grve-margin-list-left-2x">';
											foreach ( $social_options as $key => $value ) {
												if ( isset( $options[$key] ) && 1 == $options[$key] && $value ) {
													if ( 'skype' == $key ) {
														echo '<li><a href="' . esc_url( $value, array( 'skype', 'http', 'https' ) ) . '">' . esc_html( $social_list_extended[$key]['title'] ) . '</a></li>';
													} else {
														echo '<li><a href="' . esc_url( $value ) . '" target="_blank" rel="noopener noreferrer">' . esc_html( $social_list_extended[$key]['title'] ) . '</a></li>';
													}
												}
											}
											echo '</ul>';
										} else {
											echo '<ul class="grve-social grve-social-icons grve-margin-list-left-2x">';
											foreach ( $social_options as $key => $value ) {
												if ( isset( $options[$key] ) && 1 == $options[$key] && $value ) {
													if ( 'skype' == $key ) {
														echo '<li><a href="' . esc_url( $value, array( 'skype', 'http', 'https' ) ) . '" class="' . esc_attr( $social_list_extended[$key]['class'] ) . '"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span></a></li>';
													} else {
														echo '<li><a href="' . esc_url( $value ) . '" target="_blank" rel="noopener noreferrer" class="' . esc_attr( $social_list_extended[$key]['class'] ) . '"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span></a></li>';
													}
												}
											}
											echo '</ul>';
										}
									}
									?>
								</div>
								<?php
								} else if ( '4' == $second_area ) { ?>
								<div class="grve-bar-content grve-right-side">
									<div class="grve-copyright">
										<?php echo do_shortcode( wp_kses_post( impeka_grve_option( 'footer_second_copyright_text' ) ) ); ?>
									</div>
								</div>
								<?php
								}
								?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php
		}
	}
}

/**
 * Prints Back To Top Link
 */
if ( !function_exists('impeka_grve_print_back_top') ) {
	function impeka_grve_print_back_top() {
		if ( ( is_singular() && 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_back_to_top' ) ) || ( impeka_grve_is_woo_shop() && 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_back_to_top' ) ) ) {
			return;
		}
		if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
			return;
		}

		if ( impeka_grve_visibility( 'back_to_top_enabled' )  ) {

			$back_to_top_shape = impeka_grve_option( 'back_to_top_shape', 'none' );

			$back_to_top_icon_wrapper_classes = array('grve-arrow-wrapper');
			if( 'none' != $back_to_top_shape ){
				$back_to_top_icon_wrapper_classes[] = 'grve-' . $back_to_top_shape;
				$back_to_top_icon_wrapper_classes[] = 'grve-wrapper-color';
				$back_to_top_icon_wrapper_classes[] = 'grve-with-shape';
			} else {
				$back_to_top_icon_wrapper_classes[] = 'grve-skin-dark';
				$back_to_top_icon_wrapper_classes[] = 'grve-skin-scroll';
				$back_to_top_icon_wrapper_classes[] = 'grve-no-shape';
			}
			$back_to_top_icon_wrapper_class_string = implode( ' ', $back_to_top_icon_wrapper_classes );

		?>
			<div class="grve-back-top">
				<div class="<?php echo esc_attr( $back_to_top_icon_wrapper_class_string ); ?>" data-skin="dark">
					<?php if( 'none' != $back_to_top_shape ) {
						echo impeka_grve_get_svg_icon( 'arrow-small-up');
					} else {
						echo impeka_grve_get_svg_icon( 'arrow-large-up');
					}
					?>
				</div>
			</div>
		<?php
		}
	}
}
add_action( 'impeka_grve_bottom_right_area', 'impeka_grve_print_back_top', 10 );

 /**
 * Prints Bottom Bar
 */
if ( !function_exists('impeka_grve_print_bottom_bar') ) {
	function impeka_grve_print_bottom_bar() {

		$area_visibility = impeka_grve_global_param( 'bottom_bar_area_visibility' );
		if ( 'yes' == $area_visibility ) {
			$area_id = impeka_grve_global_param( 'bottom_bar_area_id' );
	?>
			<!-- BOTTOM BAR -->
			<div id="grve-bottom-bar" class="grve-bookmark">
				<?php do_action( 'impeka_grve_area_content', $area_id ); ?>
			</div>
			<!-- END BOTTOM BAR -->
	<?php
		}
	}
}


/**
 * Prints global modals and element modals
 */
function impeka_grve_print_modal_area() {
	get_template_part( 'templates/modal/modal-start' );
	/**
	 * impeka_grve_modal_area hook
	 *
	 * @hooked impeka_grve_print_global_modals
	 * @hooked impeka_grve_print_singular_modals
	 */
	do_action( 'impeka_grve_modal_area' );
	get_template_part( 'templates/modal/modal-end' );
}
add_action( 'impeka_grve_footer_after', 'impeka_grve_print_modal_area', 5 );

function impeka_grve_print_global_modals() {
	$custom_modals = get_option( '_impeka_grve_custom_modals' );
	if ( ! empty( $custom_modals ) ) {
		foreach ( $custom_modals as $custom_modal ) {
			get_template_part( 'templates/modal/modal', '', $custom_modal );
		}
	}
}
add_action( 'impeka_grve_modal_area', 'impeka_grve_print_global_modals' );

function impeka_grve_print_singular_modals() {
	$custom_modals = '';
	if ( is_singular() ) {
		$custom_modals = impeka_grve_post_meta( '_impeka_grve_modals' );
	} else if ( impeka_grve_is_woo_shop() ) {
		$custom_modals = impeka_grve_post_meta_shop( '_impeka_grve_modals' );
	}
	if ( ! empty( $custom_modals ) ) {
		foreach ( $custom_modals as $custom_modal ) {
			get_template_part( 'templates/modal/modal', '', $custom_modal );
		}
	}
}
add_action( 'impeka_grve_modal_area', 'impeka_grve_print_singular_modals' );

/**
 * Prints sliding area modals
 */
function impeka_grve_print_sliding_area() {

	$header_visibility = impeka_grve_global_param( 'header_visibility' );
	if ( 'no' == $header_visibility ) {
		return;
	}

	get_template_part( 'templates/sliding-area/sliding-area-start' );
	/**
	 * impeka_grve_sliding_area hook
	 *
	 * @hooked impeka_grve_print_search_sliding_area
	 * @hooked impeka_grve_print_top_left_form_sliding_area
	 * @hooked impeka_grve_print_top_right_form_sliding_area
	 * @hooked impeka_grve_print_menu_form_sliding_area
	 * @hooked impeka_grve_print_language_sliding_area
	 * @hooked impeka_grve_print_social_sliding_area
	 */
	do_action( 'impeka_grve_sliding_area' );
	get_template_part( 'templates/sliding-area/sliding-area-end' );
}
add_action( 'impeka_grve_footer_after', 'impeka_grve_print_sliding_area', 5 );

function impeka_grve_print_top_left_form_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'top_bar_left_form_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-top-left-form' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_top_left_form_sliding_area' );

function impeka_grve_print_top_right_form_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'top_bar_right_form_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-top-right-form' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_top_right_form_sliding_area' );

function impeka_grve_print_menu_form_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'header_form_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-menu-form' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_menu_form_sliding_area' );

function impeka_grve_print_search_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'top_bar_search_modal' ) || 'yes' == impeka_grve_global_param( 'header_search_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-search-form' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_search_sliding_area' );

function impeka_grve_print_language_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'top_bar_language_modal' ) || 'yes' == impeka_grve_global_param( 'header_language_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-language-selector' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_language_sliding_area' );

function impeka_grve_print_social_sliding_area() {
	if ( 'yes' == impeka_grve_global_param( 'header_social_modal' ) ) {
		get_template_part( 'templates/sliding-area/sliding-area-socials' );
	}
}
add_action( 'impeka_grve_sliding_area', 'impeka_grve_print_social_sliding_area' );

/**
 * Prints Side Area
 */
function impeka_grve_print_side_area() {

	$header_visibility = impeka_grve_global_param( 'header_visibility' );
	if ( 'no' == $header_visibility ) {
		return;
	}

	$sidearea_visibility = impeka_grve_global_param( 'sidearea_visibility' );

	if ( 'yes' == $sidearea_visibility ) {
		$sidearea_id = impeka_grve_global_param( 'sidearea_id' );
		$close_btn_color = impeka_grve_option( 'side_area_close_btn_color', 'black' );
?>
	<div id="grve-side-area" class="grve-hidden-area" data-animation="right-to-left">
		<div class="grve-area-inner">
			<?php impeka_grve_print_close_icon( $close_btn_color ); ?>
			<div class="grve-area-scroller">
				<div class="grve-area-container">
					<div class="grve-area-content">
					<?php
						if( is_active_sidebar( $sidearea_id ) ) {
							dynamic_sidebar( $sidearea_id );
						} else {
							if( current_user_can( 'administrator' ) ) {
								echo esc_html__( 'No widgets found in Side Area!', 'impeka'  ) . "<br/>" .
								"<a href='" . esc_url( admin_url() ) . "widgets.php'>" .
								esc_html__( "Activate Widgets", 'impeka' ) .
								"</a>";
							}
						}
					?>
					</div>
				</div>
			</div>
		</div>
		<div class="grve-hidden-area-overlay"></div>
	</div>
<?php
	}
}
add_action( 'impeka_grve_footer_after', 'impeka_grve_print_side_area', 10 );

/**
 * Prints Safe Button Area
 */
function impeka_grve_print_safebutton_area() {

	$header_visibility = impeka_grve_global_param( 'header_visibility' );
	if ( 'no' == $header_visibility ) {
		return;
	}

	$safebutton_visibility = impeka_grve_global_param( 'safebutton_visibility' );
	$safebutton_id = impeka_grve_global_param( 'safebutton_id' );
	$header_layout = impeka_grve_option( 'header_layout' );
	$safebutton_close_position = impeka_grve_option( 'safebutton_close_position' );

	if ( 'yes' == $safebutton_visibility ) {
?>
	<div id="grve-safebutton-area">
	<?php if( 'layout-default-style-2' != $header_layout ) { ?>
		<?php impeka_grve_print_close_icon( 'white', $safebutton_close_position); ?>
	<?php } ?>
		<div class="grve-safebutton-wrapper">
			<?php do_action( 'impeka_grve_area_content', $safebutton_id ); ?>
		</div>
	</div>
	<div id="grve-safebutton-overlay"></div>
<?php
	}

}
add_action( 'impeka_grve_footer_after', 'impeka_grve_print_safebutton_area', 30 );


 /**
 * Prints Bottom Right Area
 */
if ( !function_exists('impeka_grve_print_bottom_right_area') ) {
	function impeka_grve_print_bottom_right_area() {
?>
		<div id="grve-bottom-right-area">
<?php
		/**
		 * impeka_grve_bottom_right_area hook
		 *
		 * @hooked impeka_grve_print_back_top - 10
		 */
		do_action( 'impeka_grve_bottom_right_area' );
?>
		</div>
<?php
	}
}
add_action( 'impeka_grve_footer_after', 'impeka_grve_print_bottom_right_area', 40 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
