<?php

/*
*	Header Helper functions
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

function impeka_grve_theme_wrapper_class() {
	echo 'class="' . join( ' ', impeka_grve_get_theme_wrapper_class() ) . '"';
}

function impeka_grve_get_theme_wrapper_class() {

	$classes = array();

	$content_skin = '';
	if ( is_singular() ) {
		$content_skin_options = impeka_grve_post_meta( '_impeka_grve_content_skin_options' );
		$content_skin = impeka_grve_array_value( $content_skin_options, 'skin' );
	} else if ( impeka_grve_is_woo_shop() ) {
		$content_skin_options = impeka_grve_post_meta_shop( '_impeka_grve_content_skin_options' );
		$content_skin = impeka_grve_array_value( $content_skin_options, 'skin' );
	}
	if( !empty( $content_skin ) ) {
		$classes[] = 'grve-skin-' . esc_attr( $content_skin );
	}

	if ( is_page_template( 'page-templates/template-section-nav.php' ) || is_page_template( 'page-templates/template-skin-on-scroll-effect.php' ) ) {
		$nav_hide = impeka_grve_post_meta( '_impeka_grve_section_nav_hide', 'never' );
		$classes[] = 'grve-section-nav-hide-' . $nav_hide ;
	}

	$classes = array_map( 'esc_attr', $classes );
	$classes = apply_filters( 'impeka_grve_theme_wrapper_class', $classes );
	return array_unique( $classes );
}

 /**
 * Print Logo
 */
function impeka_grve_print_logo( $mode = '' ) {

	$disable_logo = '';
	if ( is_singular() ) {
		$disable_logo = impeka_grve_post_meta( '_impeka_grve_disable_logo', $disable_logo );
	} else if( impeka_grve_is_woo_shop() ) {
		$disable_logo = impeka_grve_post_meta_shop( '_impeka_grve_disable_logo', $disable_logo );
	}

	if ( 'yes' != $disable_logo ) {

		if( 'responsive' == $mode ) {
			do_action( 'impeka_grve_logo_responsive_before' );
		} else {
			do_action( 'impeka_grve_logo_before' );
		}

		$logo_custom_link_url = impeka_grve_option( 'logo_custom_link_url' );
		$logo_link_url = home_url( '/' );
		if( !empty( $logo_custom_link_url ) ) {
			$logo_link_url = $logo_custom_link_url;
		}

		if ( impeka_grve_visibility( 'logo_as_text_enabled' ) ) {
?>
		<!-- Logo As Text-->
		<div class="grve-logo grve-logo-text">
			<a href="<?php echo esc_url( $logo_link_url ); ?>"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a>
		</div>
<?php
		} else {
?>
		<!-- Logo -->
		<div class="grve-logo">
			<div class="grve-logo-inner">
				<a href="<?php echo esc_url( $logo_link_url ); ?>">
<?php
				switch( $mode ) {
					case 'responsive':
						impeka_grve_print_logo_data( 'logo_responsive', 'grve-logo-responsive'  );
					break;
					default:
						impeka_grve_print_logo_data( 'logo', 'grve-default');
						impeka_grve_print_logo_data( 'logo_light', 'grve-light');
						impeka_grve_print_logo_data( 'logo_dark', 'grve-dark');
						impeka_grve_print_logo_data( 'logo_sticky', 'grve-sticky');
					break;
				}
?>
				</a>
			</div>
		</div>
		<!-- End Logo -->
<?php
		}
		if( 'responsive' == $mode ) {
			do_action( 'impeka_grve_logo_responsive_after' );
		} else {
			do_action( 'impeka_grve_logo_after' );
		}
	}
}

 /**
 * Get Logo Data
 */
function impeka_grve_print_logo_data( $logo_id, $logo_class ) {

	$img_id = impeka_grve_option( $logo_id, '', 'id' );
	if ( !empty( $img_id ) ) {
		echo wp_get_attachment_image( $img_id, 'full' , "", array( 'class' => $logo_class, 'alt' => get_bloginfo('name') ) );
	} else {
		$logo_url = impeka_grve_option( $logo_id, '', 'url' );
		$logo_attributes = array();
		$logo_width = impeka_grve_option( $logo_id, '', 'width' );
		$logo_height = impeka_grve_option( $logo_id, '', 'height' );
		if ( !empty( $logo_width ) && !empty( $logo_height ) ) {
			$logo_attributes[] = 'width="' . esc_attr( $logo_width ) . '"';
			$logo_attributes[] = 'height="' . esc_attr( $logo_height ) . '"';
		}
		if ( !empty( $logo_url ) ) {
			$logo_url = str_replace( array( 'http:', 'https:' ), '', $logo_url );
?>
		<img class="<?php echo esc_attr( $logo_class ); ?>" src="<?php echo esc_url( $logo_url ); ?>" alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" <?php echo implode( ' ', $logo_attributes ); ?>>
<?php
		}
	}

}


 /**
 * Prints correct title/subtitle for all cases
 */
function impeka_grve_header_title() {
	global $post;
	$page_title = $page_description = $page_reversed = '';

	//Shop
	if( impeka_grve_woocommerce_enabled() ) {

		if ( is_shop() && !is_search() ) {
			$post_id = wc_get_page_id( 'shop' );
			$page_title = get_post_meta( $post_id, '_impeka_grve_title', true );
			if ( empty( $page_title ) ) {
				$page_title = get_the_title( $post_id );
			}
			$page_description = get_post_meta( $post_id, '_impeka_grve_description', true );
			$header_title = array(
				'title' => $page_title,
				'description' => $page_description,
			);
			return apply_filters( 'impeka_grve_header_title_args', $header_title );
		} else if( is_product_taxonomy() ) {
			$page_title  = single_term_title("", false);
			$page_description = category_description();
			$header_title = array(
				'title' => $page_title,
				'description' => $page_description,
			);
			return apply_filters( 'impeka_grve_header_title_args', $header_title );
		}
	}

	//Events Calendar Overview Pages
	if ( impeka_grve_events_calendar_is_overview() ) {
		if ( is_tax() ) {
			$page_title = single_term_title("", false);
			$page_description = term_description();
		} else {
			$page_title = tribe_get_events_title("", false);
			$page_description = '';
		}
		$header_title = array(
			'title' => $page_title,
			'description' => $page_description,
		);
		return apply_filters( 'impeka_grve_header_title_args', $header_title );
	}

	//Main Pages
	if ( is_front_page() && is_home() ) {
		// Default homepage
		$page_title = get_bloginfo( 'name' );
		$page_description = get_bloginfo( 'description' );
		if ( 'custom' === impeka_grve_option( 'blog_title' ) ) {
			$page_title = impeka_grve_option( 'blog_custom_title' );
			$page_description = impeka_grve_option( 'blog_custom_description' );
		}
	} else if ( is_front_page() ) {
		// static homepage
		$page_title = get_bloginfo( 'name' );
		$page_description = get_bloginfo( 'description' );
	} else if ( is_home() ) {
		// blog page
		$page_title = get_bloginfo( 'name' );
		$page_description = get_bloginfo( 'description' );
		if ( 'custom' === impeka_grve_option( 'blog_title' ) ) {
			$page_title = impeka_grve_option( 'blog_custom_title' );
			$page_description = impeka_grve_option( 'blog_custom_description' );
		}
	} else if( is_search() ) {
		$page_description = esc_html__( 'Search Results for :', 'impeka' );
		$page_title = esc_attr( get_search_query() );
		$page_reversed = 'reversed';
	} else if ( is_singular() ) {
		$post_id = $post->ID;
		$page_title = get_post_meta( $post_id, '_impeka_grve_title', true );
		if ( empty( $page_title ) ) {
			$page_title = get_the_title( $post_id );
		}
		$page_description = get_post_meta( $post_id, '_impeka_grve_description', true );

		 if ( impeka_grve_events_calendar_enabled() && is_singular( 'tribe_events' ) ) {
			$page_description = tribe_events_event_schedule_details( $post_id, '', '' );
			if ( tribe_get_cost() ) {
				$page_description .= '<span class="grve-event-cost">' . tribe_get_cost( null, true ) . '</span>';
			}
		} else if ( impeka_grve_events_calendar_enabled() && is_singular( 'tribe_organizer' ) ) {
			$page_description = impeka_grve_event_organizer_title_meta();
		}
	} else if ( is_archive() ) {
		//Post Categories
		if ( is_category() ) {
			$page_title = single_cat_title("", false);
			$page_description = category_description();
		} else if ( is_tag() ) {
			$page_title = single_tag_title("", false);
			$page_description = tag_description();
		} else if ( is_tax() ) {
			$page_title = single_term_title("", false);
			$page_description = term_description();
		} else if ( is_author() ) {
			global $author;
			$userdata = get_userdata( $author );
			$page_description = esc_html__( "Posts By :", 'impeka' );
			$page_title = $userdata->display_name;
			$page_reversed = 'reversed';
		} else if ( is_day() ) {
			$page_description = esc_html__( "Daily Archives :", 'impeka' );
			$page_title = get_the_time( 'l, F j, Y' );
			$page_reversed = 'reversed';
		} else if ( is_month() ) {
			$page_description = esc_html__( "Monthly Archives :", 'impeka' );
			$page_title = get_the_time( 'F Y' );
			$page_reversed = 'reversed';
		} else if ( is_year() ) {
			$page_description = esc_html__( "Yearly Archives :", 'impeka' );
			$page_title = get_the_time( 'Y' );
			$page_reversed = 'reversed';
		}  else if ( is_post_type_archive( 'tribe_events' ) && impeka_grve_events_calendar_enabled() ) {
			$page_title = tribe_get_events_title("", false);
		}  else if ( is_post_type_archive( 'portfolio' ) ) {
			$page_title = impeka_grve_option( 'portfolio_archive_title' );
			$page_description = impeka_grve_option( 'portfolio_archive_description' );
		} else {
			$page_title = esc_html__( "Archives", 'impeka' );
		}
	} else {
		$page_title = get_bloginfo( 'name' );
		$page_description = get_bloginfo( 'description' );
	}

	$header_title = array(
		'title' => $page_title,
		'description' => $page_description,
		'reversed' => $page_reversed,
	);
	return apply_filters( 'impeka_grve_header_title_args', $header_title );

}

/**
 * Prints side Header Background Image
 */
 if ( !function_exists('impeka_grve_print_side_header_bg_image') ) {

	function impeka_grve_print_side_header_bg_image() {

		if ( 'custom' == impeka_grve_option( 'header_side_bg_mode' ) ) {
			$header_custom_bg = array(
				'bg_mode' => 'custom',
				'bg_image_id' => impeka_grve_option( 'header_side_bg_image', '', 'id' ),
				'bg_position' => impeka_grve_option( 'header_side_bg_position', 'center-center' ),
				'pattern_overlay' => impeka_grve_option( 'header_side_pattern_overlay' ),
				'color_overlay' => impeka_grve_option( 'header_side_color_overlay' ),
				'opacity_overlay' => impeka_grve_option( 'header_side_opacity_overlay' ),
			);
			impeka_grve_print_title_bg_image( $header_custom_bg );
		}

	}
}

function impeka_grve_print_title_bg_image( $page_title = array() ) {

	$image_url = '';
	$bg_mode = impeka_grve_array_value( $page_title, 'bg_mode', 'color' );

	if ( 'color' != $bg_mode ) {

		$bg_position = impeka_grve_array_value( $page_title, 'bg_position', 'center-center' );

		$media_id = '0';

		if ( 'featured' == $bg_mode ) {
			$is_woo_shop = impeka_grve_is_woo_shop();
			if ( is_singular() || $is_woo_shop ) {
				if ( $is_woo_shop ) {
					$id = wc_get_page_id( 'shop' );
				} else {
					$id = get_the_ID();
				}
				if( has_post_thumbnail( $id ) ) {
					$media_id = get_post_thumbnail_id( $id );
				}
			}
		} else if ( 'custom' ) {
			$media_id = impeka_grve_array_value( $page_title, 'bg_image_id' );
		}
		$full_src = wp_get_attachment_image_src( $media_id, 'impeka-grve-fullscreen' );
		if ( $full_src ) {
			$image_url = $full_src[0];
		}

		if( !empty( $image_url ) ) {

			//Adaptive Background URL
			$image_url = impeka_grve_get_adaptive_url( $media_id );

			echo '<div class="grve-background-wrapper">';
			echo '<div class="grve-bg-image grve-bg-' . esc_attr( $bg_position ) . ' grve-bg-image-id-' . esc_attr( $media_id ) . '" style="background-image: url(' . esc_url( $image_url ) . ');"></div>';
			impeka_grve_print_overlay_container( $page_title );
			echo '</div>';
		}
	}

}

 /**
 * Prints title/subtitle ( Page )
 */
function impeka_grve_print_header_title( $mode = 'page') {
	global $post;

	if ( 'yes' == impeka_grve_global_param( 'header_title_visibility' ) ) {

        $item_type = str_replace ( '_' , '-', $mode );
		$page_title_id = 'grve-' . $item_type  . '-title';
		$page_title = array(
			'height' => impeka_grve_option( $mode . '_title_height' ),
			'min_height' => impeka_grve_option( $mode . '_title_min_height' ),
			'subheading_color' => impeka_grve_option( $mode . '_subheading_color' ),
			'subheading_color_custom' => impeka_grve_option( $mode . '_subheading_color_custom' ),
			'title_color' => impeka_grve_option( $mode . '_title_color' ),
			'title_color_custom' => impeka_grve_option( $mode . '_title_color_custom' ),
			'caption_color' => impeka_grve_option( $mode . '_description_color' ),
			'caption_color_custom' => impeka_grve_option( $mode . '_description_color_custom' ),
			'content_bg_color' => impeka_grve_option( $mode . '_title_content_bg_color' ),
			'content_bg_color_custom' => impeka_grve_option( $mode . '_title_content_bg_color_custom' ),
			'content_position' => impeka_grve_option( $mode . '_title_content_position' ),
			'content_animation' => impeka_grve_option( $mode . '_title_content_animation' ),
			'container_size' => impeka_grve_option( $mode . '_title_container_size' ),
			'content_size' => impeka_grve_option( $mode . '_title_content_size' ),
			'content_alignment' => impeka_grve_option( $mode . '_title_content_alignment' ),
			'bg_mode' => impeka_grve_option( $mode . '_title_bg_mode' ),
			'bg_image_id' => impeka_grve_option( $mode . '_title_bg_image', '', 'id' ),
			'bg_position' => impeka_grve_option( $mode . '_title_bg_position' ),
			'bg_color' => impeka_grve_option( $mode . '_title_bg_color', 'black' ),
			'bg_color_custom' => impeka_grve_option( $mode . '_title_bg_color_custom' ),
			'pattern_overlay' => impeka_grve_option( $mode . '_title_pattern_overlay' ),
			'color_overlay' => impeka_grve_option( $mode . '_title_color_overlay' ),
			'color_overlay_custom' => impeka_grve_option( $mode . '_title_color_overlay_custom' ),
			'opacity_overlay' => impeka_grve_option( $mode . '_title_opacity_overlay' ),
		);

		$header_data = impeka_grve_header_title();
		$header_title = isset( $header_data['title'] ) ? $header_data['title'] : '';
		$header_description = isset( $header_data['description'] ) ? $header_data['description'] : '';
		$header_reversed = isset( $header_data['reversed'] ) ? $header_data['reversed'] : '';

		if ( 'forum' == $mode && !is_singular() ) {
			$header_title = esc_html__( 'Forums' , 'impeka' );
		}

		$is_woo_shop = impeka_grve_is_woo_shop();

		if ( is_singular() || $is_woo_shop  ) {
			if ( $is_woo_shop ) {
				$post_id = wc_get_page_id( 'shop' );
			} else {
				$post_id = $post->ID;
			}

			$custom_title_options = get_post_meta( $post_id, '_impeka_grve_custom_title_options', true );
			$title_style = impeka_grve_option( $mode . '_title_style' );
			$page_title_custom = impeka_grve_array_value( $custom_title_options, 'custom', $title_style );
			if ( 'custom' == $page_title_custom ) {
				$page_title = $custom_title_options;
			} else if ( 'simple' == $page_title_custom ) {
				return;
			}
			if( 'product' == $mode && impeka_grve_woocommerce_enabled() ) {
				impeka_grve_woo_replace_default_single_title();
			}

		} else if ( is_tag() || is_category() || impeka_grve_is_woo_category() || impeka_grve_is_woo_tag() || is_tax('portfolio_category') || is_tax('portfolio_field')  ) {
			$category_id = get_queried_object_id();
			$custom_title_options = impeka_grve_get_term_meta( $category_id, '_impeka_grve_custom_title_options' );
			$page_title_custom = impeka_grve_array_value( $custom_title_options, 'custom' );
			if ( 'custom' == $page_title_custom ) {
				$page_title = $custom_title_options;
			}
		}

		$wrapper_title_classes = array( 'grve-title-section' );

		$bg_mode = impeka_grve_array_value( $page_title, 'bg_mode', 'color' );
		if ( 'color' == $bg_mode ) {
			$wrapper_title_classes[] = 'grve-with-title';
		} else {
			$wrapper_title_classes[] = 'grve-with-image';
		}

		$content_container_classes = array( 'grve-content' );
		$subheading_classes = array( 'grve-subheading', 'grve-title-categories', 'clearfix' );
		$title_classes = array( 'grve-title' );
		$caption_classes = array( 'grve-description' );
		$title_meta_classes = array( 'grve-title-meta-content' );
		$content_classes = array( 'grve-title-content-wrapper' );

		$content_position = impeka_grve_array_value( $page_title, 'content_position', 'center-center' );
		$content_animation = impeka_grve_array_value( $page_title, 'content_animation', 'none' );
		$page_title_height = impeka_grve_array_value( $page_title, 'height', '40' );
		$page_title_min_height = impeka_grve_array_value( $page_title, 'min_height', '200' );

		$container_size = impeka_grve_array_value( $page_title, 'container_size' );
		$content_container_classes[] = 'grve-align-' . $content_position;
		if ( 'large' == $container_size ) {
			$content_container_classes[] = 'grve-fullwidth';
		}

		if ( is_numeric( $page_title_height ) ) { //Custom Size
			$wrapper_title_classes[] = 'grve-custom-size';
		} else {
			$wrapper_title_classes[] = 'grve-' . $page_title_height . '-height';
		}

		$page_title_bg_color = impeka_grve_array_value( $page_title, 'bg_color', 'black' );
		if ( 'custom' != $page_title_bg_color ) {
			$wrapper_title_classes[] = 'grve-bg-' . $page_title_bg_color;
		}

		$page_title_content_bg_color = impeka_grve_array_value( $page_title, 'content_bg_color', 'none' );
		$content_align = impeka_grve_array_value( $page_title, 'content_alignment', 'center' );
		$content_size = impeka_grve_array_value( $page_title, 'content_size', 'container' );
		if ( 'custom' != $page_title_content_bg_color ) {
			$content_classes[] = 'grve-bg-' . $page_title_content_bg_color;
		}
		$content_classes[] = 'grve-align-' . $content_align;
		$content_classes[] = 'grve-content-' . $content_size;

		$page_title_subheading_color = impeka_grve_array_value( $page_title, 'subheading_color', 'white' );
		if ( 'custom' != $page_title_subheading_color ) {
			$subheading_classes[] = 'grve-text-' . $page_title_subheading_color;
			$title_meta_classes[] = 'grve-text-' . $page_title_subheading_color;
		}
		$title_classes[] = 'grve-' . $item_type  . '-title';
		$page_title_color = impeka_grve_array_value( $page_title, 'title_color', 'white' );
		if ( 'custom' != $page_title_color ) {
			$title_classes[] = 'grve-text-' . $page_title_color;
		}

		$page_title_caption_color = impeka_grve_array_value( $page_title, 'caption_color', 'white' );
		if ( 'custom' != $page_title_caption_color ) {
			$caption_classes[] = 'grve-text-' . $page_title_caption_color;
		}
		$caption_classes[] = 'grve-' . $item_type  . '-description';

		$wrapper_title_classes = implode( ' ', $wrapper_title_classes );
		$content_container_classes = implode( ' ', $content_container_classes );
		$title_classes = implode( ' ', $title_classes );
		$caption_classes = implode( ' ', $caption_classes );
		$subheading_classes = implode( ' ', $subheading_classes );
		$title_meta_classes = implode( ' ', $title_meta_classes );
		$content_classes = implode( ' ', $content_classes );

		if ( is_numeric( $page_title_height ) ) { //Custom Size
			$wrapper_style = 'height:' . esc_attr( $page_title_height ) . 'vh; min-height:' . esc_attr( $page_title_min_height ) . 'px;';
		} else {
			$wrapper_style = 'min-height:' . esc_attr( $page_title_min_height ) . 'px;';
		}
?>
	<!-- Page Title -->
	<div id="<?php echo esc_attr( $page_title_id ); ?>" class="<?php echo esc_attr( $wrapper_title_classes ); ?>" data-height="<?php echo esc_attr( $page_title_height ); ?>">
		<div class="grve-wrapper" style="<?php echo esc_attr( $wrapper_style ); ?>">
			<?php do_action( 'impeka_grve_page_title_top' ); ?>
			<div class="<?php echo esc_attr( $content_container_classes ); ?>" data-animation="<?php echo esc_attr( $content_animation ); ?>">
				<div class="grve-container">
					<div class="<?php echo esc_attr( $content_classes ); ?>">
					<?php if ( empty( $header_reversed ) ) { ?>

						<?php if( 'post' == $mode && impeka_grve_visibility( 'post_category_visibility', '1' ) ) { ?>
						<div class="<?php echo esc_attr( $subheading_classes ); ?>">
							<?php impeka_grve_print_post_title_categories(); ?>
						</div>
						<?php } ?>
						<?php if( 'portfolio' == $mode && impeka_grve_visibility( 'portfolio_category_visibility', '1' ) ) { ?>
						<div class="<?php echo esc_attr( $subheading_classes ); ?>">
							<?php impeka_grve_print_portfolio_title_categories(); ?>
						</div>
						<?php } ?>

						<h1 class="<?php echo esc_attr( $title_classes ); ?>"><span><?php echo wp_kses_post( $header_title ); ?></span></h1>
						<?php if ( !empty( $header_description ) ) { ?>
						<div class="<?php echo esc_attr( $caption_classes ); ?>"><?php echo wp_kses_post( $header_description ); ?></div>
						<?php } ?>

						<?php if( 'post' == $mode ) { ?>
							<div class="<?php echo esc_attr( $title_meta_classes ); ?>">
								<?php impeka_grve_print_post_title_meta(); ?>
							</div>
						<?php } ?>

					<?php } else { ?>
						<?php if ( !empty( $header_description ) ) { ?>
						<div class="<?php echo esc_attr( $caption_classes ); ?>"><?php echo wp_kses_post( $header_description ); ?></div>
						<?php } ?>
						<h1 class="<?php echo esc_attr( $title_classes ); ?>"><span><?php echo wp_kses_post( $header_title ); ?></span></h1>
					<?php } ?>
					</div>
				</div>
			</div>
			<?php do_action( 'impeka_grve_page_title_bottom' ); ?>
		</div>
		<?php impeka_grve_print_title_bg_image( $page_title ); ?>
	</div>
	<!-- End Page Title -->
<?php
	}
}

 /**
 * Prints Anchor Menu
 */
function impeka_grve_print_anchor_menu( $mode = 'page' ) {
	$anchor_nav_menu = impeka_grve_global_param( 'anchor_id' );
	$anchor_device_layout = impeka_grve_global_param( 'anchor_device_layout' );
	if ( !empty( $anchor_nav_menu ) ) {
		$item_type = str_replace ( '_' , '-', $mode );
		$anchor_params = array(
			'id' => 'grve-' . $item_type  . '-anchor',
			'nav_menu' => apply_filters( 'wpml_object_id', $anchor_nav_menu, 'nav_menu', TRUE  ),
			'device_layout' => $anchor_device_layout,
			'fullwidth' => impeka_grve_option( $mode . '_anchor_menu_fullwidth' ),
			'alignment' => impeka_grve_option( $mode . '_anchor_menu_alignment', 'left' ),
		);

		get_template_part( 'templates/singular/anchor-menu/anchor-menu', '', $anchor_params );
	}
}

 /**
 * Prints header breadcrumbs
 */
function impeka_grve_print_header_breadcrumbs( $mode = 'page') {

	$disable_breadcrumbs = 'yes';

	if( impeka_grve_visibility( $mode . '_breadcrumbs_enabled' ) ) {
		$disable_breadcrumbs = 'no';
		if ( is_singular() ) {
			$disable_breadcrumbs = impeka_grve_post_meta( '_impeka_grve_disable_breadcrumbs', $disable_breadcrumbs );
		} else if( impeka_grve_is_woo_shop() ) {
			$disable_breadcrumbs = impeka_grve_post_meta_shop( '_impeka_grve_disable_breadcrumbs', $disable_breadcrumbs );
		}
	}

	if ( 'yes' != $disable_breadcrumbs  ) {

		$item_type = str_replace ( '_' , '-', $mode );
		$breadcrumbs_id = 'grve-' . $item_type  . '-breadcrumbs';
		$breadcrumbs_fullwidth = impeka_grve_option( $mode . '_breadcrumbs_fullwidth' );
		$breadcrumbs_alignment = impeka_grve_option( $mode . '_breadcrumbs_alignment', 'left' );

		$breadcrumbs_classes = array( 'grve-breadcrumbs', 'clearfix' );
		if ( '1' == $breadcrumbs_fullwidth ) {
			$breadcrumbs_classes[] = ' grve-fullwidth';
		}
		$breadcrumbs_classes[] = 'grve-align-' . $breadcrumbs_alignment ;
		$breadcrumbs_classes = implode( ' ', $breadcrumbs_classes );
?>
	<div id="<?php echo esc_attr( $breadcrumbs_id ); ?>" class="<?php echo esc_attr( $breadcrumbs_classes ); ?>">
		<div class="grve-breadcrumbs-wrapper">
			<div class="grve-container">
				<?php impeka_grve_print_breadcrumbs(); ?>
			</div>
		</div>
	</div>
<?php
	}
}

/**
 * Prints header top bar text
 */
function impeka_grve_print_header_top_bar_text( $text, $position = 'left' ) {
	if ( !empty( $text ) ) {
		$text = wpautop(preg_replace('/<\/?p\>/', "\n", $text)."\n");
?>
		<div class="grve-topbar-item"><?php echo do_shortcode( shortcode_unautop( $text ) ); ?></div>
<?php
	}
}

/**
 * Prints header top bar navigation
 */
function impeka_grve_print_header_top_bar_nav( $position = 'left' ) {
?>
	<div class="grve-topbar-item">
		<nav class="grve-top-bar-menu grve-small-text" aria-label="<?php esc_attr_e( 'Top Bar', 'impeka' ); ?>">
			<?php
				if( 'left' == $position ) {
					impeka_grve_top_left_nav();
				} else {
					impeka_grve_top_right_nav();
				}
			?>
		</nav>
	</div>
<?php
}

/**
 * Prints header top bar search icon
 */
function impeka_grve_print_header_top_bar_search( $position = 'left', $mode = 'modal' ) {

	if( 'modal' == $mode ) {
?>
	<div class="grve-topbar-item"><a href="#grve-search-modal" class="grve-toggle-modal"><span class="screen-reader-text"><?php echo esc_html__( 'Open search modal', 'impeka' ); ?></span><?php echo impeka_grve_get_icon( 'search' ); ?></a></div>
<?php
		} else {
?>
	<div class="grve-topbar-item">
		<div class="grve-widget">
			<?php get_search_form(); ?>
		</div>
	</div>
<?php
	}
}

/**
 * Prints header top bar form icon
 */
function impeka_grve_print_header_top_bar_form( $position = 'left' ) {
	if( 'left' == $position ) {
		$modal_id = '#grve-top-left-form-modal';
	} else {
		$modal_id = '#grve-top-right-form-modal';
	}
?>
	<div class="grve-topbar-item"><a href="<?php echo esc_attr( $modal_id ); ?>" class="grve-toggle-modal"><span class="screen-reader-text"><?php echo esc_html__( 'Toggle form modal', 'impeka' ); ?></span><?php echo impeka_grve_get_icon( 'envelope' ); ?></a></div>
<?php

}

/**
 * Prints header top bar socials
 */
function impeka_grve_print_header_top_bar_socials( $options, $position = 'left' ) {

	global $impeka_grve_social_list_extended;
	$social_list_extended = $impeka_grve_social_list_extended;

	$social_options = impeka_grve_option('social_options');

	if ( !empty( $options ) && !empty( $social_options ) ) {
		?>
			<div class="grve-topbar-item">
				<ul class="grve-social">
		<?php
		foreach ( $social_options as $key => $value ) {
			if ( isset( $options[$key] ) && 1 == $options[$key] && $value ) {
				if ( 'skype' == $key ) {
					echo '<li><a href="' . esc_url( $value, array( 'skype', 'http', 'https' ) ) . '" class="' . esc_attr( $social_list_extended[$key]['class'] ) . '"></a></li>';
				} else {
					echo '<li><a href="' . esc_url( $value ) . '" target="_blank" rel="noopener noreferrer" class="' . esc_attr( $social_list_extended[$key]['class'] ) . '"></a></li>';
				}
			}
		}
		?>
				</ul>
			</div>
		<?php
	}

}

/**
 * Prints header top bar language selector
 */
function impeka_grve_print_header_top_bar_language_selector( $language_style = 'dropdown' ) {
?>
	<div class="grve-topbar-item">
<?php
	if( 'modal' == $language_style ) {
?>
		<a href="#grve-language-modal" class="grve-toggle-modal">
			<span class="grve-item">
				<span class="screen-reader-text"><?php echo esc_html__( 'Toggle language modal', 'impeka' ); ?></span>
				<?php echo impeka_grve_get_icon( 'globe' ); ?>
			</span>
		</a>
<?php
	} elseif( 'dropdown' == $language_style ) {
		get_template_part( 'templates/header/language/dropdown-language-selector' );
	} else {
		get_template_part( 'templates/header/language/list-language-selector' );
	}
?>
	</div>
<?php
}

/**
 * Prints header language menu selector
 */
function impeka_grve_print_language_menu_selector( $mode = '') {

	$language_style = impeka_grve_option( 'header_menu_language_style', 'modal' );
	if( 'responsive' == $mode ) {
		$language_style = 'list';
	}
	if( 'modal' == $language_style ) {
?>
		<a href="#grve-language-modal" class="grve-toggle-modal" aria-label="<?php echo esc_attr__( 'Open language modal', 'impeka' ); ?>">
			<span class="grve-item">
				<?php echo impeka_grve_get_icon( 'globe' ); ?>
			</span>
		</a>
<?php
	} elseif( 'dropdown' == $language_style ) {
		get_template_part( 'templates/header/language/dropdown-language-selector' );
	} else {
		get_template_part( 'templates/header/language/list-language-selector' );
	}
}

/**
 * Prints header top bar login
 */
function impeka_grve_print_header_top_bar_login() {}


/**
 * Prints header top bar
 */
function impeka_grve_print_header_top_bar() {

	if ( impeka_grve_visibility( 'top_bar_enabled' ) ) {
		if ( ( is_singular() && 'yes' == impeka_grve_post_meta( '_impeka_grve_disable_top_bar' ) ) || ( impeka_grve_is_woo_shop() && 'yes' == impeka_grve_post_meta_shop( '_impeka_grve_disable_top_bar' ) ) ) {
			return;
		}

		$fullwidth = impeka_grve_option( 'top_bar_fullwidth' );
		$header_group = impeka_grve_global_param( 'header_group' );
		$header_sticky_enable = impeka_grve_option( 'header_sticky_enabled', 0 );
		$top_bar_class = array('');
		if( $fullwidth ) {
			$top_bar_class[] = 'grve-fullwidth';
		}
		if( $header_sticky_enable && 'side' != $header_group ) {
			$top_bar_class[] = 'grve-sticky-topbar';
		}
		$top_bar_classes = implode( ' ', $top_bar_class );
?>

		<!-- Top Bar -->
		<div id="grve-top-bar" class="<?php echo esc_attr( $top_bar_classes ); ?>">
			<div class="grve-top-bar-section">
				<div class="grve-container">
					<div class="grve-top-bar-row">
						<div class="grve-left-area">
							<?php
							if ( impeka_grve_visibility( 'top_bar_left_enabled' ) ) {
							?>
							<div class="grve-top-bar-items">
								<?php

									//Top Left First Item Hook
									do_action( 'impeka_grve_header_top_bar_left_first_item' );

									//Top Left Options
									$top_bar_left_options = impeka_grve_option('top_bar_left_options');

									if ( !empty( $top_bar_left_options ) ) {
										foreach ( $top_bar_left_options as $key => $value ) {
											if( !empty( $value ) && '0' != $value ) {

												switch( $key ) {
													case 'menu':
														impeka_grve_print_header_top_bar_nav( 'left' );
													break;
													case 'search':
														$search_mode = impeka_grve_option( 'top_bar_left_search_mode', 'modal' );
														impeka_grve_print_header_top_bar_search( 'left', $search_mode );
													break;
													case 'form':
														impeka_grve_print_header_top_bar_form( 'left' );
													break;
													case 'text':
														$left_text = impeka_grve_option('top_bar_left_text');
														impeka_grve_print_header_top_bar_text( $left_text, 'left' );
													break;
													case 'language':
														$language_style = impeka_grve_option( 'top_bar_left_language_style', 'dropdown' );
														impeka_grve_print_header_top_bar_language_selector( $language_style );
													break;
													case 'login':
														impeka_grve_print_header_top_bar_login();
													break;
													case 'social':
														$top_bar_left_social_options = impeka_grve_option('top_bar_left_social_options');
														impeka_grve_print_header_top_bar_socials( $top_bar_left_social_options, 'left');
													break;
													default:
													break;
												}
											}
										}
									}

									//Top Left Last Item Hook
									do_action( 'impeka_grve_header_top_bar_left_last_item' );

								?>
							</div>
							<?php
								}
							?>
						</div>
						<div class="grve-right-area">
							<?php
							if ( impeka_grve_visibility( 'top_bar_right_enabled' ) ) {
							?>
							<div class="grve-top-bar-items">
								<?php

									//Top Right First Item Hook
									do_action( 'impeka_grve_header_top_bar_right_first_item' );

									//Top Right Options
									$top_bar_right_options = impeka_grve_option('top_bar_right_options');
									if ( !empty( $top_bar_right_options ) ) {
										foreach ( $top_bar_right_options as $key => $value ) {
											if( !empty( $value ) && '0' != $value ) {

												switch( $key ) {
													case 'menu':
														impeka_grve_print_header_top_bar_nav( 'right' );
													break;
													case 'search':
														$search_mode = impeka_grve_option( 'top_bar_right_search_mode', 'modal' );
														impeka_grve_print_header_top_bar_search( 'right', $search_mode );
													break;
													case 'form':
														impeka_grve_print_header_top_bar_form( 'right' );
													break;
													case 'text':
														$right_text = impeka_grve_option('top_bar_right_text');
														impeka_grve_print_header_top_bar_text( $right_text, 'right' );
													break;
													case 'language':
														$language_style = impeka_grve_option( 'top_bar_right_language_style', 'dropdown' );
														impeka_grve_print_header_top_bar_language_selector( $language_style );
													break;
													case 'login':
														impeka_grve_print_header_top_bar_login();
													break;
													case 'social':
														$top_bar_right_social_options = impeka_grve_option('top_bar_right_social_options');
														impeka_grve_print_header_top_bar_socials( $top_bar_right_social_options, 'right' );
													break;
													default:
													break;
												}
											}
										}
									}

									//Top Right Last Item Hook
									do_action( 'impeka_grve_header_top_bar_right_last_item' );
								?>
							</div>
							<?php
								}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End Top Bar -->
<?php

	}
}
add_action( 'impeka_grve_theme_wrapper_top', 'impeka_grve_print_header_top_bar', 10 );

/**
 * Prints check header elements visibility
 */
function impeka_grve_check_header_elements_visibility_any( $mode = '' ) {

	$menu_options_enabled = 'header_menu_options_enabled';
	$menu_options = 'header_menu_options';
	if ( 'responsive' == $mode ) {
		$menu_options_enabled = 'responsive_menu_options_enabled';
		$menu_options = 'responsive_menu_options';
	}

	if ( !impeka_grve_visibility( $menu_options_enabled ) ) {
		return false;
	}

	$header_menu_options = impeka_grve_option( $menu_options );
	if ( !empty( $header_menu_options ) ) {
		foreach ( $header_menu_options as $key => $value ) {
			if( !empty( $value ) && '0' != $value && impeka_grve_check_header_elements_visibility( $key, $mode ) ) {
				return true;
			}
		}
	}
	return false;
}

function impeka_grve_check_header_elements_visibility( $item = 'none', $mode = '' ) {

	$visibility = false;
	$menu_options_enabled = 'header_menu_options_enabled';
	$menu_options = 'header_menu_options';
	if ( 'responsive' == $mode ) {
		$menu_options_enabled = 'responsive_menu_options_enabled';
		$menu_options = 'responsive_menu_options';
	}

	if ( impeka_grve_visibility( $menu_options_enabled ) ) {

		if ( is_singular() ) {
			$disable_menu_items = impeka_grve_post_meta( '_impeka_grve_disable_menu_items' );
			if ( 'yes' == impeka_grve_array_value( $disable_menu_items, $item  ) ) {
				return false;
			}
		}
		if ( impeka_grve_is_woo_shop() ) {
			$disable_menu_items = impeka_grve_post_meta_shop( '_impeka_grve_disable_menu_items' );
			if ( 'yes' == impeka_grve_array_value( $disable_menu_items, $item  ) ) {
				return false;
			}
		}

		$header_menu_options = impeka_grve_option( $menu_options );
		if ( !empty( $header_menu_options ) ) {
			if ( isset( $header_menu_options[ $item ] ) && !empty( $header_menu_options[ $item ] ) && '0' != $header_menu_options[ $item ] ) {
				$visibility = true;
			}
		}

	}

	return $visibility;
}


/**
 * Prints header Safe Button
 */
if ( !function_exists('impeka_grve_print_header_safebutton') ) {
	function impeka_grve_print_header_safebutton( $mode = '' ) {

		$safebutton_visibility = impeka_grve_global_param( 'safebutton_visibility' );

		if ( 'yes' == $safebutton_visibility ) {
			$safebutton_icon_style = impeka_grve_option('safebutton_icon_style');
			$safebutton_aria_label = impeka_grve_option('safebutton_aria_label');
			$safebutton_custom_icon_svg = impeka_grve_option('safebutton_custom_icon_svg');

		?>
			<?php if ( 'element' == $mode ) { ?>
			<div class="grve-header-element">
			<?php } ?>
				<a href="#grve-safebutton-area" class="grve-safe-button grve-toggle-safebutton-area">
					<span class="screen-reader-text"><?php echo esc_html( $safebutton_aria_label ); ?></span>
				<?php
					if ( 'element' != $mode ) {
						if( 'custom' == $safebutton_icon_style ) {
							impeka_grve_print_custom_burger_icon( $safebutton_custom_icon_svg, 'with-close' );
						} else {
							impeka_grve_print_burger_icon( $safebutton_icon_style, 'with-close' );
						}
					} else {
						if( 'custom' == $safebutton_icon_style ) {
							impeka_grve_print_custom_burger_icon( $safebutton_custom_icon_svg );
						} else {
							impeka_grve_print_burger_icon( $safebutton_icon_style );
						}
					}
				?>
				</a>
			<?php if ( 'element' == $mode ) { ?>
			</div>
			<?php } ?>
		<?php
		}
	}
}
/**
 * Prints header elements e.g: social, language selector, search
 */
function impeka_grve_print_header_elements( $header_group = 'default', $header_style = 'style-1', $extra_elements = array(), $position = '', $extra_class = '' ) {

	global $impeka_grve_social_list_extended;
	$social_list_extended = $impeka_grve_social_list_extended;

	$extra_elements_visibility = $sidearea_icon_visibility = $safebutton_icon_visibility = false;
	$sidearea_visibility = impeka_grve_global_param( 'sidearea_visibility' );
	$safebutton_visibility = impeka_grve_global_param( 'safebutton_visibility' );

	if ( !empty( $extra_elements ) ) {
		foreach ( $extra_elements as $key ) {
			if ( 'sidearea_icon' == $key && 'yes' == $sidearea_visibility ) {
				$extra_elements_visibility = true;
				$sidearea_icon_visibility = true;
			} else if ( 'safebutton_icon' == $key && 'yes' == $safebutton_visibility ) {
				$extra_elements_visibility = true;
				$safebutton_icon_visibility = true;
			}
		}
	}

	if ( impeka_grve_check_header_elements_visibility_any() || $extra_elements_visibility ) {

		$header_menu_options = impeka_grve_option('header_menu_options');
		$header_menu_social_mode = impeka_grve_option('header_menu_social_mode', 'modal');
		$header_menu_search_mode = impeka_grve_option('header_menu_search_mode', 'modal');
		$header_borders = impeka_grve_option( 'header_borders', '1' );
		$header_menu_text_element = impeka_grve_option('header_menu_text_element');

		// Header Elements Classes
		$header_elements_class = array( 'grve-header-elements' );

		if ( !empty( $position ) ) {
			$header_elements_class[] = 'grve-position-' . $position;
		}
		if ( !empty( $extra_class ) ) {
			$header_elements_class[] = $extra_class;
		}

		// Add Borders
		if ( 1 == $header_borders ) {
			$header_elements_class[] = 'grve-border';
			if ( 'offcanvas' == $header_group && 'style-1' == $header_style ) {
				$header_elements_class[] = 'grve-border-right';
			} else if ( ( 'offcanvas' == $header_group && 'style-2' == $header_style ) ) {
				$header_elements_class[] = 'grve-border-top';
			} else if ( 'side' != $header_group ) {
				$header_elements_class[] = 'grve-border-left';
			}
		}

		$header_elements_class_string = implode( ' ', $header_elements_class );

?>
		<div class="<?php echo esc_attr( $header_elements_class_string ); ?>">
<?php
		do_action( 'impeka_grve_header_elements_first_item' );

		if ( !empty( $header_menu_options ) ) {
			foreach ( $header_menu_options as $key => $value ) {
				if( !empty( $value ) && '0' != $value && impeka_grve_check_header_elements_visibility( $key ) ) {
					if ( 'text' == $key ) {
					?>
						<div class="grve-header-element grve-header-text-element"><span class="grve-item"><?php echo do_shortcode( $header_menu_text_element ); ?></span></div>
					<?php
					} else if ( 'search' == $key ) {
						if ( 'modal' == $header_menu_search_mode ) {
					?>
						<div class="grve-header-element">
							<a href="#grve-search-modal" class="grve-toggle-modal">
								<span class="grve-item">
									<span class="screen-reader-text"><?php echo esc_html__( 'Toggle search modal', 'impeka' ); ?></span>
									<?php echo impeka_grve_get_icon( 'search' ); ?>
								</span>
							</a>
						</div>
					<?php
						} else {
					?>
						<div class="grve-header-element">
							<div class="grve-header-search">
							<?php get_search_form(); ?>
							</div>
						</div>
					<?php
						}
					} else if ( 'language' == $key ) {
					?>
						<div class="grve-header-element">
							<?php impeka_grve_print_language_menu_selector(); ?>
						</div>
					<?php
					} else if ( 'login' == $key ) {
					} else if ( 'form' == $key ) {
					?>
						<div class="grve-header-element">
							<a href="#grve-menu-form-modal" class="grve-toggle-modal">
								<span class="grve-item">
									<span class="screen-reader-text"><?php echo esc_html__( 'Toggle form modal', 'impeka' ); ?></span>
									<?php echo impeka_grve_get_icon( 'envelope' ); ?>
								</span>
							</a>
						</div>
					<?php
					} else if ( 'cart' == $key && impeka_grve_woocommerce_enabled() ) {
						global $woocommerce;
					?>
						<div class="grve-header-element grve-cart-element">
							<a href="#grve-cart-area" class="grve-toggle-minicart">
								<span class="grve-item">
									<span class="screen-reader-text"><?php echo esc_html__( 'Toggle cart modal', 'impeka' ); ?></span>
									<?php echo impeka_grve_get_icon( 'cart' ); ?>
								</span>
								<span class="grve-purchased-items"><?php echo esc_html( $woocommerce->cart->cart_contents_count ); ?></span>
							</a>
							<?php impeka_grve_print_cart_area(); ?>
						</div>
					<?php
					} else if ( 'social' == $key ) {
						$header_social_options = impeka_grve_option('header_menu_social_options');
						$social_options = impeka_grve_option('social_options');
						if( 'modal' == $header_menu_social_mode ) {
					?>
						<div class="grve-header-element">
							<a href="#grve-socials-modal" class="grve-toggle-modal">
								<span class="grve-item">
									<span class="screen-reader-text"><?php echo esc_html__( 'Toggle social modal', 'impeka' ); ?></span>
									<?php echo impeka_grve_get_icon( 'share' ); ?>
								</span>
							</a>
						</div>
					<?php
						} else {
							if ( !empty( $header_social_options ) && !empty( $social_options ) ) {
								echo '<ul class="grve-header-element grve-socials-elements">';
								foreach ( $social_options as $key => $value ) {
									if ( isset( $header_social_options[$key] ) && 1 == $header_social_options[$key] && $value ) {
										if ( 'skype' == $key ) {
											echo '<li><a href="' . esc_url( $value, array( 'skype', 'http', 'https' ) ) . '"><span class="grve-item"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span><span class="grve-icon ' . esc_attr( $social_list_extended[$key]['class'] ) . '"></span></span></a></li>';
										} else {
											echo '<li><a href="' . esc_url( $value ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-item"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span><span class="grve-icon ' . esc_attr( $social_list_extended[$key]['class'] ) . '"></span></span></a></li>';
										}
									}
								}
								echo '</ul>';

							}
						}
					}
				}
			}
		}

		if ( $sidearea_icon_visibility ) {
			impeka_grve_print_header_sidearea_button( 'element' );
		}
		if ( $safebutton_icon_visibility ) {
			impeka_grve_print_header_safebutton( 'element' );
		}

		do_action( 'impeka_grve_header_elements_last_item' );
?>
		</div>
<?php
	}

}

/**
 * Prints header elements e.g: social, language selector, search
 */
function impeka_grve_print_header_elements_responsive() {

	global $impeka_grve_social_list_extended;
	$social_list_extended = $impeka_grve_social_list_extended;

	if ( impeka_grve_check_header_elements_visibility_any( 'responsive' ) ) {
		$header_menu_options = impeka_grve_option('responsive_menu_options');

		do_action( 'impeka_grve_header_elements_responsive_first_item' );

		foreach ( $header_menu_options as $key => $value ) {
			if( !empty( $value ) && '0' != $value && impeka_grve_check_header_elements_visibility( $key, 'responsive' ) ) {
				if ( 'text' == $key ) {
					$responsive_menu_text_element = impeka_grve_option('responsive_menu_text_element');
					?>
					<div class="grve-header-responsive-elements">
						<div class="grve-wrapper">
							<?php echo do_shortcode( $responsive_menu_text_element ); ?>
						</div>
					</div>
					<?php
				} else if ( 'search' == $key ) {
				?>
					<div class="grve-header-responsive-elements">
						<div class="grve-header-responsive-element">
							<div class="grve-widget">
								<?php get_search_form(); ?>
							</div>
						</div>
					</div>
				<?php
				} else if ( 'language' == $key ) {
				?>
					<div class="grve-header-responsive-elements">
						<div class="grve-header-responsive-element">
							<?php impeka_grve_print_language_menu_selector( 'responsive' ); ?>
						</div>
					</div>
				<?php
				} else if ( 'form' == $key ) {
				?>
					<div class="grve-header-responsive-elements">
						<div class="grve-header-responsive-element">
							<div class="grve-newsletter">
								<?php
								$responsive_menu_type_form =  impeka_grve_option( 'responsive_menu_type_form', 'contact-form' );
								if( 'gravity-form' == $responsive_menu_type_form ) {
									impeka_grve_print_gravity_form( 'responsive_menu_gravity_form' );
								} elseif( 'fluent-form' == $responsive_menu_type_form ) {
									impeka_grve_print_fluent_form( 'responsive_menu_fluent_form' );
								} else {
									impeka_grve_print_contact_form( 'responsive_menu_form' );
								}
								?>
							</div>
						</div>
					</div>
				<?php
				} else if ( 'social' == $key ) {
					$header_social_options = impeka_grve_option('responsive_menu_social_options');
					$social_options = impeka_grve_option('social_options');
					if ( !empty( $header_social_options ) && !empty( $social_options ) ) {
?>
						<!-- Responsive social Header Elements -->
						<div class="grve-header-responsive-elements">
							<ul class="grve-header-responsive-element">
<?php
									foreach ( $social_options as $key => $value ) {
										if ( isset( $header_social_options[$key] ) && 1 == $header_social_options[$key] && $value ) {
											if ( 'skype' == $key ) {
												echo '<li><a href="' . esc_url( $value, array( 'skype', 'http', 'https' ) ) . '"><span class="grve-item"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span><span class="grve-icon ' . esc_attr( $social_list_extended[$key]['class'] ) . '"></span></span></a></li>';
											} else {
												echo '<li><a href="' . esc_url( $value ) . '" target="_blank" rel="noopener noreferrer"><span class="grve-item"><span class="screen-reader-text">' . esc_html( $social_list_extended[$key]['title'] ) . '</span><span class="grve-icon ' . esc_attr( $social_list_extended[$key]['class'] ) . '"></span></span></a></li>';
											}
										}
									}
?>
							</ul>
						</div>
						<!-- End Social Header Elements -->
<?php
					}
				}
			}
		}
		do_action( 'impeka_grve_header_elements_responsive_last_item' );
	}
}

/**
 * Prints Shop Cart
 */
function impeka_grve_print_cart_area() {

	$header_visibility = impeka_grve_global_param( 'header_visibility' );
	if ( 'no' == $header_visibility ) {
		return;
	}
	//Disable if Scrolling Section
	if ( is_page_template( 'page-templates/template-full-page.php' ) ) {
		return;
	}
	if ( impeka_grve_woocommerce_enabled() && impeka_grve_check_header_elements_visibility( 'cart' ) ) {
?>
		<div id="grve-cart-area">
			<div class="grve-shopping-cart-content"></div>
		</div>
<?php
	}
}

/**
 * Prints Form modals
 */
function impeka_grve_print_contact_form( $option = 'header_menu_form' ) {

	if ( class_exists('WPCF7') ) {
		$contact_form_id = impeka_grve_option( $option );
		if ( !empty( $contact_form_id ) ) {
			$contact_form_id = apply_filters( 'wpml_object_id', $contact_form_id, 'wpcf7_contact_form', TRUE  );
			echo do_shortcode('[contact-form-7 id="' . esc_attr( $contact_form_id ) . '"]');
		}
	}

}
function impeka_grve_print_gravity_form( $option = 'header_menu_gravity_form' ) {

	if ( class_exists('GFForms') ) {
		$contact_form_id = impeka_grve_option( $option );
		if ( !empty( $contact_form_id ) ) {
			echo do_shortcode('[gravityform id="' . esc_attr( $contact_form_id ) . '" title="false" description="false" ajax="true"]');
		}
	}

}

function impeka_grve_print_fluent_form( $option = 'header_menu_fluent_form' ) {

	if ( function_exists( 'wpFluent' ) ) {
		$contact_form_id = impeka_grve_option( $option );
		if ( !empty( $contact_form_id ) ) {
			echo do_shortcode('[fluentform id="' . esc_attr( $contact_form_id ) . '"]');
		}
	}

}

/**
 * Prints header side area toggle button
 */
if ( !function_exists('impeka_grve_print_header_sidearea_button') ) {
	function impeka_grve_print_header_sidearea_button( $mode = '' ) {

		$sidearea_visibility = impeka_grve_global_param( 'sidearea_visibility' );
		$sidearea_icon_style = impeka_grve_global_param( 'sidearea_icon_style' );

		if ( 'yes' == $sidearea_visibility ) {
			if ( 'element' == $mode ) {
	?>
			<div class="grve-header-element">
				<a href="#grve-side-area" class="grve-sliding-btn grve-toggle-side-area">
					<span class="screen-reader-text"><?php echo esc_html__( 'Toggle side area', 'impeka' ); ?></span>
					<?php impeka_grve_print_burger_icon( $sidearea_icon_style ); ?>
				</a>
			</div>
	<?php
			} else {
	?>
			<a href="#grve-side-area" class="grve-sliding-btn grve-toggle-side-area">
				<span class="screen-reader-text"><?php echo esc_html__( 'Toggle side area', 'impeka' ); ?></span>
				<?php impeka_grve_print_burger_icon( $sidearea_icon_style ); ?>
			</a>
	<?php
			}
		}
	}
}

/**
 * Prints header hidden area toggle button
 */
if ( !function_exists('impeka_grve_print_header_responsive_menu_button') ) {
	function impeka_grve_print_header_responsive_menu_button( $position = 'right') {
		$responsive_menu_button_type = impeka_grve_option( 'responsive_menu_button_type');
		$responsive_menu_button_label = impeka_grve_option( 'responsive_menu_button_label');
		$responsive_menu_icon_style = impeka_grve_option( 'responsive_menu_icon_style');
		$responsive_header_visibility = impeka_grve_option( 'responsive_header_visibility');
		$responsive_menu_icon_type = 'simple';
		if( $responsive_header_visibility ) {
			$responsive_menu_icon_type = 'with-close';
		}
		$responsive_menu_button_classes = array( 'grve-hidden-menu-icon', 'grve-toggle-responsive-menu' );
		$responsive_menu_button_classes[] = 'grve-position-' . $position;
		$responsive_menu_button_class_string = implode( ' ', $responsive_menu_button_classes );
	?>
		<a href="#grve-responsive-menu-area" class="<?php echo esc_attr( $responsive_menu_button_class_string ); ?>">
			<span class="screen-reader-text"><?php echo esc_html__( 'Open Menu', 'impeka' ); ?></span>
			<div class="grve-hidden-menu-inner">
				<?php if( 'icon' == $responsive_menu_button_type || 'icon-label' == $responsive_menu_button_type ) { ?>
				<?php impeka_grve_print_burger_icon( $responsive_menu_icon_style, $responsive_menu_icon_type ); ?>
				<?php } ?>
				<?php if( 'label' == $responsive_menu_button_type || 'icon-label' == $responsive_menu_button_type ) { ?>
				<span class="grve-burger-label">
					<?php echo esc_html( $responsive_menu_button_label ); ?>
				</span>
				<?php } ?>
			</div>
		</a>
	<?php
	}
}

/**
 * Prints Offcanvas button
 */
if ( !function_exists('impeka_grve_print_offcanvas_button') ) {
	function impeka_grve_print_offcanvas_button() {

		$header_menu_visibility = impeka_grve_global_param( 'header_menu_visibility' );
		if ( 'no' == $header_menu_visibility ) {
			return;
		}

		$header_orientation = impeka_grve_global_param( 'header_orientation' );
		$offcanvas_width = impeka_grve_option( 'offcanvas_width' );
		$offcanvas_button_type = impeka_grve_option( 'offcanvas_button_type');
		$offcanvas_button_label = impeka_grve_option( 'offcanvas_button_label');
		$offcanvas_icon_style = impeka_grve_option( 'offcanvas_icon_style');
		$offcanvas_close_color = impeka_grve_option( 'offcanvas_close_color' );

		$offcanvas_button_classes = array( 'grve-hidden-menu-icon', 'grve-toggle-offcanvas' );
		if ( 'offcanvas-full-width' == $offcanvas_width  && 'vertical' != $header_orientation ) {
			$offcanvas_button_classes[] = 'grve-close-' . $offcanvas_close_color;
		}
		$offcanvas_button_class_string = implode( ' ', $offcanvas_button_classes );

		$offcanvas_menu_icon_type = 'simple';
		if ( 'offcanvas-full-width' == $offcanvas_width  && 'vertical' != $header_orientation ) {
			$offcanvas_menu_icon_type = 'with-close';
		}
	?>
		<a href="#grve-offcanvas-area" class="<?php echo esc_attr( $offcanvas_button_class_string ); ?>">
			<span class="screen-reader-text"><?php echo esc_html__( 'Toggle offcanvas area', 'impeka' ); ?></span>
			<?php if( 'icon' == $offcanvas_button_type || 'icon-label' == $offcanvas_button_type ) { ?>
			<?php impeka_grve_print_burger_icon( $offcanvas_icon_style, $offcanvas_menu_icon_type ); ?>
			<?php } ?>
			<?php if( 'label' == $offcanvas_button_type || 'icon-label' == $offcanvas_button_type ) { ?>
			<span class="grve-burger-label">
				<?php echo esc_html( $offcanvas_button_label ); ?>
			</span>
			<?php } ?>
		</a>
	<?php

	}
}

/**
 * Prints Offcanvas Morphing button
 */
if ( !function_exists('impeka_grve_print_offcanvas_morphing_button') ) {
	function impeka_grve_print_offcanvas_morphing_button() {

		$header_menu_visibility = impeka_grve_global_param( 'header_menu_visibility' );
		if ( 'no' == $header_menu_visibility ) {
			return;
		}
		$offcanvas_button_type = impeka_grve_option( 'offcanvas_button_type');
		$offcanvas_button_label = impeka_grve_option( 'offcanvas_button_label');
		$offcanvas_icon_style = impeka_grve_option( 'offcanvas_icon_style');

	?>
		<a href="#grve-offcanvas-area" class="grve-toggle-offcanvas">
			<span class="screen-reader-text"><?php echo esc_html__( 'Toggle offcanvas area', 'impeka' ); ?></span>
			<div class="grve-icon-wrapper">
				<div class="grve-icon-inner">
					<?php if( 'icon' == $offcanvas_button_type || 'icon-label' == $offcanvas_button_type ) { ?>
					<?php impeka_grve_print_burger_icon( $offcanvas_icon_style, 'simple' ); ?>
					<?php } ?>
					<?php if( 'label' == $offcanvas_button_type || 'icon-label' == $offcanvas_button_type ) { ?>
					<span class="grve-burger-label">
						<?php echo esc_html( $offcanvas_button_label ); ?>
					</span>
					<?php } ?>
				</div>
				<span class="grve-close-icon">
					<?php echo impeka_grve_get_svg_icon( 'close' ); ?>
				</span>
			</div>
			<div class="grve-morphing-bg grve-svg-primary-1">
				<svg class="grve-morphing-bg-svg" width="110px" height="110px" viewbox="0 0 110 110">
					<path>
						<animate
							attributeName="d"
							dur="6000ms"
							repeatCount="indefinite"
							keyTimes="0; .3; .6; 1"
							values="
								M55,110 C85.3756612,110 110,85.3756612 110,55 C110,24.6243388 85.3756612,0 55,0 C24.6243388,0 0,24.6243388 0,55 C0,68.8477484 5.11765991,81.5002032 13.5648395,91.1692243 C23.6469297,102.709637 38.4720871,110 55,110 Z;
								M56.2658914,105 C84.0269767,105 111.101409,89.7 103.790007,63.6 C96.4786046,37.5 83.1130514,6 55.3519661,6 C27.5908809,6 6,28.1619049 6,55.5 C6,67.9629735 13.816639,80.097881 21.5367301,88.8 C30.7510074,99.1863719 41.1606137,105 56.2658914,105 Z;
								M86.0578285,98.9831539 C105.132229,79.1089628 108.944745,63.2133058 101.315773,36.6152136 C93.6868006,10.0171214 48.8665895,-0.988985756 30.7477808,8.18277017 C12.6289721,17.3545261 5,24.3473835 5,52.2071986 C5,64.9080155 9.97865106,75.8609534 17.3970796,85.22552 C32.6550238,104.486207 74.6143703,110.906437 86.0578285,98.9831539 Z;
								M55,110 C85.3756612,110 110,85.3756612 110,55 C110,24.6243388 85.3756612,0 55,0 C24.6243388,0 0,24.6243388 0,55 C0,68.8477484 5.11765991,81.5002032 13.5648395,91.1692243 C23.6469297,102.709637 38.4720871,110 55,110 Z;"/>
					</path>
				</svg>
				<svg class="grve-morphing-close-bg-svg" width="110px" height="110px" viewBox="0 0 110 110">
					<path d="M55,110 C85.3756612,110 110,85.3756612 110,55 C110,24.6243388 85.3756612,0 55,0 C24.6243388,0 0,24.6243388 0,55 C0,68.8477484 5.11765991,81.5002032 13.5648395,91.1692243 C23.6469297,102.709637 38.4720871,110 55,110 Z"></path>
				</svg>
			</div>
		</a>
	<?php

	}
}

/**
 * Prints Burger Icon
 */
if ( !function_exists('impeka_grve_print_burger_icon') ) {
	function impeka_grve_print_burger_icon( $icon_style = 'style-1', $type = 'simple' ) {
		$icon_library = impeka_grve_option('header_icon_library');

		$burger_classes = array('grve-item', 'grve-burger-icon');
		if( 'awesome-fonts' != $icon_library ) {
			$burger_classes[] = 'grve-' . $icon_style;
		}
		if( 'with-close' == $type ) {
			$burger_classes[] = 'grve-with-close';
		}
		$burger_classes = implode( ' ', $burger_classes );

		if ( 'awesome-fonts' == $icon_library ) {
	?>
		<span class="<?php echo esc_attr( $burger_classes ); ?>">
			<?php echo impeka_grve_get_awesome_font_icon( 'burger' ); ?>
			<?php if ( 'with-close' == $type ) { ?>
				<?php echo impeka_grve_get_awesome_font_icon( 'close' ); ?>
			<?php } ?>
		</span>
	<?php
		} else {
	?>
		<span class="<?php echo esc_attr( $burger_classes ); ?>">
		<?php if ( 'style-2' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'burger-2' ); ?>
		<?php } else if ( 'style-3' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'burger-3' ); ?>
		<?php } else if ( 'style-4' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'burger-4' ); ?>
		<?php } else if ( 'style-5' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'burger-5' ); ?>
		<?php } else if ( 'style-6' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'envelope' ); ?>
		<?php } else if ( 'style-7' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'tooltip' ); ?>
		<?php } else if ( 'style-8' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'info' ); ?>
		<?php } else if ( 'style-9' == $icon_style ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'marker' ); ?>
		<?php } else { ?>
			<?php echo impeka_grve_get_svg_icon( 'burger-1' ); ?>
		<?php } ?>
		<?php if ( 'with-close' == $type ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'close' ); ?>
		<?php } ?>
		</span>
	<?php
		}
	}
}

/**
 * Prints Custom Burger Icon
 */
if ( !function_exists('impeka_grve_print_custom_burger_icon') ) {
	function impeka_grve_print_custom_burger_icon( $icon_svg = '', $type = 'simple' ) {
		$burger_classes = array('grve-item', 'grve-burger-icon');
		if( 'with-close' == $type ) {
			$burger_classes[] = 'grve-with-close';
		}
		$burger_classes = implode( ' ', $burger_classes );
	?>
		<span class="<?php echo esc_attr( $burger_classes ); ?>">
		<?php echo impeka_grve_get_custom_svg_icon( $icon_svg ); ?>
		<?php if ( 'with-close' == $type ) { ?>
			<?php echo impeka_grve_get_svg_icon( 'close' ); ?>
		<?php } ?>
		</span>
	<?php
	}
}

/**
 * Prints Close Icon
 */
if ( !function_exists('impeka_grve_print_close_icon') ) {
	function impeka_grve_print_close_icon( $icon_color = 'white', $position = '' ) {
		$close_btn_classes = array('grve-close-button-wrapper');
		if( !empty( $position ) ) {
			$close_btn_classes[] = 'grve-position-' . $position;
		}
		$close_btn_classes = implode( ' ', $close_btn_classes );
	?>
	<div class="<?php echo esc_attr( $close_btn_classes ); ?>">
		<a href="#" class="grve-close-btn grve-<?php echo esc_attr( $icon_color ); ?>">
			<span class="grve-item">
				<span class="screen-reader-text"><?php echo esc_html__( 'Close', 'impeka' ); ?></span>
				<?php echo impeka_grve_get_icon( 'close' ); ?>
			</span>
		</a>
	</div>
	<?php
	}
}


/**
 * Prints Shop Cart Responsive link
 */
function impeka_grve_print_cart_responsive_link() {

	if ( impeka_grve_woocommerce_enabled() && impeka_grve_check_header_elements_visibility( 'cart' ) ) {

		global $woocommerce;

		if ( function_exists( 'wc_get_cart_url' ) ) {
			$get_cart_url = wc_get_cart_url();
		} else {
			$get_cart_url = WC()->cart->get_cart_url();
		}
?>

	<div class="grve-header-element grve-cart-element">
		<a href="<?php echo esc_url( $get_cart_url ); ?>">
			<span class="grve-item">
				<span class="screen-reader-text"><?php echo esc_html__( 'Open cart', 'impeka' ); ?></span>
				<?php echo impeka_grve_get_icon( 'cart' ); ?>
			</span>
			<span class="grve-purchased-items"><?php echo esc_html( $woocommerce->cart->cart_contents_count ); ?></span>
		</a>
	</div>

<?php

	}
}

function impeka_grve_print_item_nav_link( $post_id,  $direction, $title = '' ) {

	$icon_class = 'arrow-right';
	if ( 'prev' == $direction ) {
		$icon_class = 'arrow-left';
	}
?>
	<li><a href="<?php echo esc_url( get_permalink( $post_id ) ); ?>" class="grve-icon-<?php echo esc_attr( $icon_class ); ?>" title="<?php echo esc_attr($title); ?>"></a></li>
<?php
}


/**
 * Check Theme Loader Visibility
 */
function impeka_grve_check_theme_loader_visibility() {

	$theme_loader = '';

	if ( is_singular() ) {
		$theme_loader = impeka_grve_post_meta( '_impeka_grve_theme_loader' );
	}
	if ( impeka_grve_is_woo_shop() ) {
		$theme_loader = impeka_grve_post_meta_shop( '_impeka_grve_theme_loader' );
	}

	if( empty( $theme_loader ) ) {
		return impeka_grve_visibility( 'theme_loader' );
	} else {
		if ( 'yes' == $theme_loader ) {
			return true;
		} else {
			return false;
		}
	}

}

/**
 * Prints Frames
 */
if ( !function_exists('impeka_grve_print_frames') ) {
	function impeka_grve_print_frames() {
		$theme_layout = impeka_grve_option( 'theme_layout', 'stretched' );
		$frame_size = impeka_grve_option( 'frame_size', 30 );

		if ( 'framed' == $theme_layout ) {
?>
		<div id="grve-frames" data-frame-size="<?php echo esc_attr( $frame_size ); ?>">
			<div class="grve-frame grve-top"></div>
			<div class="grve-frame grve-left"></div>
			<div class="grve-frame grve-right"></div>
			<div class="grve-frame grve-bottom"></div>
		</div>
<?php
		}

	}
}
add_action( 'wp_body_open', 'impeka_grve_print_frames', 10 );

/**
 * Prints Theme Loader
 */
if ( !function_exists('impeka_grve_print_theme_loader') ) {
	function impeka_grve_print_theme_loader() {
		$page_transition = impeka_grve_option('page_transition');
		$show_spinner = impeka_grve_option('show_spinner');

		$loader_classes = array();
		if( 'none' != $page_transition ) {
			$loader_classes[] = 'grve-page-transition';
			$loader_classes[] = 'grve-' . $page_transition . '-transition';
		}

		$loader_classes = implode( ' ', $loader_classes );

		if ( impeka_grve_check_theme_loader_visibility() ) {
?>
		<!-- LOADER -->
		<div id="grve-loader-overflow" class="<?php echo esc_attr( $loader_classes ); ?>">
			<?php
				if( '0' != $show_spinner ) {
					impeka_grve_print_spinner_icon();
				}
			?>
		</div>
<?php
		}
	}
}
add_action( 'wp_body_open', 'impeka_grve_print_theme_loader', 20 );

/**
 * Prints Intro Loader
 */
if ( !function_exists('impeka_grve_print_intro_loader') ) {
	function impeka_grve_print_intro_loader() {
		if ( impeka_grve_check_theme_intro_visibility() ) {
			get_template_part( 'templates/intro/intro-style-1' );
		}
	}
}
add_action( 'wp_body_open', 'impeka_grve_print_intro_loader', 30 );

/**
 * Prints Spinner
 */
if ( !function_exists('impeka_grve_print_spinner_icon') ) {
	function impeka_grve_print_spinner_icon() {
		$spinner_icon = impeka_grve_option('spinner_icon');
		$spinner_classes = array('grve-spinner');
		$spinner_classes[] = 'grve-' . $spinner_icon;
		$spinner_classes = implode( ' ', $spinner_classes );

		?>
			<div class="<?php echo esc_attr( $spinner_classes ); ?>"></div>
		<?php
	}
}


/**
 * Prints Indicator
 */
if ( !function_exists('impeka_grve_print_indicator') ) {
	function impeka_grve_print_indicator() {
		$indicator_style = impeka_grve_option('theme_indicator_style');
		$indicator_classes = array('');
		$indicator_classes[] = 'grve-' . $indicator_style;
		if ( 'style-1' == $indicator_style ) {
			$indicator_classes[] = 'grve-blend';
		}
		$indicator_class_string = implode( ' ', $indicator_classes );
?>
		<div id="grve-indicator" class="<?php echo esc_attr( $indicator_class_string ); ?>">
			<div class="grve-default"></div>
			<div class="grve-inner grve-ind-arrow"><?php echo impeka_grve_get_svg_icon( 'arrow-2'); ?></div>
			<div class="grve-inner grve-ind-search"><?php echo impeka_grve_get_svg_icon( 'search'); ?></div>
			<div class="grve-inner grve-ind-plus"><?php echo impeka_grve_get_svg_icon( 'plus'); ?></div>
			<div class="grve-inner grve-ind-arrows-left-right"><?php echo impeka_grve_get_svg_icon( 'arrows-left-right'); ?></div>
			<div class="grve-inner grve-ind-text"><span class="grve-link-text"></span></div>
			<div class="grve-ind-content"><?php echo impeka_grve_get_svg_icon( 'plus'); ?></div>
		</div>
<?php
	}
}
add_action( 'impeka_grve_theme_wrapper_top', 'impeka_grve_print_indicator', 40 );

function impeka_grve_shop_css() {
	$shop_id = $custom_css_code = '';

	if ( impeka_grve_woocommerce_enabled() && is_shop() ) {
		$shop_id = wc_get_page_id( 'shop' );
	}
	if ( !empty( $shop_id ) ) {
		$custom_css_code = get_post_meta( $shop_id, '_wpb_shortcodes_custom_css', true );
		if ( ! empty( $custom_css_code ) ) {
			$custom_css_code = strip_tags( $custom_css_code );
		}
	}
	return $custom_css_code;
}

function impeka_grve_get_all_area_item_custom_css() {

	$css_code = $custom_css_code = '';

	$area_item_posts = get_posts( array(
		'posts_per_page' => '-1',
		'post_status'=>'publish',
		'post_type' => 'area-item',
	) );

	if ( !empty( $area_item_posts ) ) {
		foreach ( $area_item_posts as $post ) {
			$custom_css_code = get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );
			if ( ! empty( $custom_css_code ) ) {
				$css_code .= strip_tags( $custom_css_code );
			}
		}
		wp_reset_postdata();
	}

	return $css_code;
}

function impeka_grve_area_content( $area_id ) {

	if ( function_exists( 'vc_is_inline' ) && vc_is_inline() ) {
		return;
	}

	if ( !empty( $area_id ) ) {
		$area_id = apply_filters( 'wpml_object_id', $area_id, 'area-item', TRUE  );
		$args = array(
			'p'         => $area_id,
			'post_type' => 'area-item',
			'post_status' => 'publish',
		);
		$query = new WP_Query($args);

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				the_content();
			}
			wp_reset_postdata();
		}
	}
}
add_action( 'impeka_grve_area_content', 'impeka_grve_area_content', 99, 1 );

/**
 * Area Item ajax callback
 */
function impeka_grve_area_content_callback() {

	check_ajax_referer( 'impeka-grve-area-item', '_grve_nonce' );

	if ( isset( $_POST['grve_area_id'] ) ) {
		$area_id = sanitize_text_field( $_POST['grve_area_id'] );
		if( class_exists('WPBMap') && method_exists('WPBMap', 'addAllMappedShortcodes') ) {
			WPBMap::addAllMappedShortcodes();
		}
		impeka_grve_area_content( $area_id );
	}
	die();
}

add_action( 'wp_ajax_impeka_grve_area_content_callback', 'impeka_grve_area_content_callback' );
add_action( 'wp_ajax_nopriv_impeka_grve_area_content_callback', 'impeka_grve_area_content_callback' );

//Omit closing PHP tag to avoid accidental whitespace output errors.
