<?php

/*
 *	Singular Helper functions
 *
 * 	@version	1.0
 * 	@author		Greatives Team
 * 	@URI		https://greatives.eu
 */


 /**
 * Add post class
 */
function impeka_grve_post_class( $classes, $class, $post_id ) {
	$post_type = get_post_type( $post_id );
	$classes[] = 'grve-entry-item';
	switch( $post_type ) {
		case 'post':
			$classes[] = 'grve-blog-item';
		break;
		default:
		break;
	}
    return $classes;
}
add_filter( 'post_class', 'impeka_grve_post_class', 10, 3 );

 /**
 * Prints Post Nav Bar
 */
if ( !function_exists('impeka_grve_print_singular_navigation') ) {
	function impeka_grve_print_singular_navigation() {
		get_template_part( 'templates/navigation/page-nav' );
	}
}
add_action( 'impeka_grve_singular_after_content', 'impeka_grve_print_singular_navigation', 10 );

 /**
 * Prints Page Comments
 */
if ( !function_exists('impeka_grve_print_singular_comments_section') ) {
	function impeka_grve_print_singular_comments_section() {
		if ( impeka_grve_visibility( 'page_comments_visibility' ) && ( comments_open() || get_comments_number() ) ) {
?>
			<div id="grve-comments-section" data-header-color="default" class="grve-border grve-padding-top-3x grve-padding-bottom-3x">
				<div class="grve-container">
					<?php comments_template(); ?>
				</div>
			</div>
<?php
		}
	}
}
add_action( 'impeka_grve_singular_after_content', 'impeka_grve_print_singular_comments_section', 20 );


//Omit closing PHP tag to avoid accidental whitespace output errors.
