<?php
/*
*	Main Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

get_header();
impeka_grve_print_header_title( 'blog' );
impeka_grve_print_header_breadcrumbs( 'post' );
?>
<!-- CONTENT -->
<div id="grve-content" <?php impeka_grve_content_class(); ?>>
	<div class="grve-content-wrapper">
		<!-- MAIN CONTENT -->
		<div id="grve-main-content">
			<div class="grve-main-content-wrapper clearfix">
				<div class="grve-section" style="margin-bottom: 0px;">
					<div class="grve-container">
						<!-- Blog FitRows -->
						<?php
							$blog_mode = impeka_grve_option( 'blog_mode', 'large' );
							$blog_class = impeka_grve_get_blog_class( $blog_mode );

							$wrapper_params = impeka_grve_get_blog_grid_wrapper_params();
							$wrapper_attributes = impeka_grve_get_grid_layout_atts( $wrapper_params );
							$wrapper_attributes[] = 'id="grve-main-blog-loop"';
							$wrapper_attributes[] = 'class="' . esc_attr( $blog_class ) . '"';

							$blog_params = impeka_grve_get_blog_params();
						?>
						<div <?php echo implode( ' ', $wrapper_attributes ); ?>>

							<?php
							if ( have_posts() ) :
								if ( 'large' == $blog_mode ) {
							?>
								<div class="grve-standard-container">
							<?php
								} else {
							?>
								<div class="grve-isotope-container">
									<div class="grve-grid-sizer"></div>
							<?php
								}
							// Start the Loop.
							while ( have_posts() ) : the_post();

							$blog_params['post_format'] = get_post_format();
							$blog_style = impeka_grve_get_blog_style( $blog_params );
							$inner_wrapper_attributes = impeka_grve_get_post_inner_attributes( $blog_params );
                            ?>
							<article <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
								<div <?php echo implode( ' ', $inner_wrapper_attributes ); ?>>
									<?php get_template_part( 'templates/post/' . $blog_style . '/loop-post-content', get_post_format(), $blog_params ); ?>
								</div>
							</article>
							<?php
							endwhile;

							?>
							</div>
							<?php
								// Previous/next post navigation.
								impeka_grve_paginate_links( 'blog' );
							else :
								// If no content, include the "No posts found" template.
								get_template_part( 'content', 'none' );
							endif;
							?>

						</div>
						<!-- End Element Blog -->
					</div>
				</div>
			</div>
		</div>
		<!-- End Content -->
		<?php get_sidebar(); ?>
	</div>
</div>
<?php get_footer();

//Omit closing PHP tag to avoid accidental whitespace output errors.
