<?php
/*
*	Search Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

get_header();
impeka_grve_print_header_title('search_page');
$search_mode = impeka_grve_option( 'search_page_mode', 'masonry' );

$wrapper_params = array(
	'mode' => $search_mode,
	'columns_large_screen' => impeka_grve_option( 'search_page_columns_large_screen', '3' ),
	'columns' => impeka_grve_option( 'search_page_columns', '3' ),
	'columns_tablet_landscape' => impeka_grve_option( 'search_page_columns_tablet_landscape', '2' ),
	'columns_tablet_portrait' => impeka_grve_option( 'search_page_columns_tablet_portrait', '2' ),
	'columns_mobile' => impeka_grve_option( 'search_page_columns_mobile', '1' ),
	'gutter' => impeka_grve_option( 'search_page_gutter', 'yes' ),
	'gutter_size' => impeka_grve_option( 'search_page_gutter_size', '30' ),
	'spinner' => impeka_grve_option( 'search_page_spinner', 'no' ),
	'display_style' => impeka_grve_option( 'search_display_style', 'pagination' ),
);
$wrapper_attributes = impeka_grve_get_grid_layout_atts( $wrapper_params );

$search_class_string = impeka_grve_get_blog_class( $search_mode );
$wrapper_attributes[] = 'class="' . esc_attr( $search_class_string ) . '"';
$wrapper_attributes[] = 'id="grve-main-search-loop"';
?>
<!-- CONTENT -->
<div id="grve-content" <?php impeka_grve_content_class(); ?>>
	<div class="grve-content-wrapper">
		<!-- MAIN CONTENT -->
		<div id="grve-main-content">
			<div class="grve-main-content-wrapper clearfix">
				<div class="grve-section" style="margin-bottom: 0px;">
					<div class="grve-container">
						<?php
							if ( have_posts() ) :
						?>
							<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
								<?php
									$post_items = $page_items = $portfolio_items = $other_post_items = 0;
									$has_post_items = $has_page_items = $has_portfolio_items = 0;

									while ( have_posts() ) : the_post();
										$post_type = get_post_type();
										switch( $post_type ) {
											case 'post':
												 $post_items++;
												 $has_post_items = 1;
											break;
											case 'page':
												 $page_items++;
												 $has_page_items = 1;
											break;
											case 'portfolio':
												 $portfolio_items++;
												 $has_portfolio_items = 1;
											break;
											default:
												$other_post_items++;
											break;
										}
									endwhile;
									$item_types = $has_post_items + $has_page_items + $has_portfolio_items;

									if ( $item_types > 1 ) {
								?>
								<div class="grve-filter grve-link-text grve-list-divider grve-align-left">
									<ul>
										<li data-filter="*" class="selected"><?php esc_html_e( "All", 'impeka' ); ?></li>
										<?php if ( $has_post_items ) { ?>
										<li data-filter=".post"><?php esc_html_e( "Post", 'impeka' ); ?></li>
										<?php } ?>
										<?php if ( $has_page_items ) { ?>
										<li data-filter=".page"><?php esc_html_e( "Page", 'impeka' ); ?></li>
										<?php } ?>
										<?php if ( $has_portfolio_items ) { ?>
										<li data-filter=".portfolio"><?php esc_html_e( "Portfolio", 'impeka' ); ?></li>
										<?php } ?>
									</ul>
								</div>
								<?php
									}
									$search_image_mode = 'large';
									$show_image = impeka_grve_option( 'search_page_show_image', 'yes' );
									if ( 'yes' == $show_image ) {
										$search_image_mode = impeka_grve_option( 'search_image_mode', 'landscape' );
										$search_masonry_image_mode = impeka_grve_option( 'search_masonry_image_mode', 'medium' );
										if ( 'masonry' == $search_mode) {
											$search_image_mode = $search_masonry_image_mode;
										}
									}
									$search_params = array(
										'mode' => $search_mode,
										'heading' => impeka_grve_option( 'search_page_heading' ),
										'heading_tag' => impeka_grve_option( 'search_page_heading_tag' ),
										'excerpt_length' => impeka_grve_option( 'search_page_excerpt_length' ),
										'excerpt_more' => impeka_grve_option( 'search_page_excerpt_more' ),
										'excerpt_more_text' => impeka_grve_option( 'search_page_excerpt_more_text' ),
										'show_image' => $show_image,
										'image_size' => impeka_grve_get_image_size( $search_image_mode ),
										'shadow' => impeka_grve_option( 'search_page_shadow' ),
										'radius' => impeka_grve_option( 'search_page_radius' ),
									);
									echo '<div class="grve-isotope-container">';
									echo '<div class="grve-grid-sizer"></div>';
									while ( have_posts() ) : the_post();
										$inner_wrapper_attributes = impeka_grve_get_post_inner_attributes( $search_params );
								?>
									<div <?php post_class(); ?>>
										<div <?php echo implode( ' ', $inner_wrapper_attributes ); ?>>
										<?php
											if( 'small' == $search_mode ) {
												get_template_part( 'templates/search/loop-search-content', 'small', $search_params );
											} else {
												get_template_part( 'templates/search/loop-search-content', 'grid', $search_params );
											}
										?>
										</div>
									</div>
								<?php
									endwhile;
									echo '</div>';

									// Previous/next post navigation.
									impeka_grve_paginate_links( 'search' );
								?>
							</div>
						<?php
							else :
									// If no content, include the "No posts found" template.
									get_template_part( 'templates/search/loop-search-content', 'none' );
							endif;
						?>
					</div>
				</div>
			</div>
		</div>
		<!-- End Content -->
		<?php get_sidebar(); ?>
	</div>
</div>
<?php get_footer();

//Omit closing PHP tag to avoid accidental whitespace output errors.
