<?php
/*
*	Single Portfolio Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

get_header();
the_post();
impeka_grve_print_header_title( 'portfolio' );
impeka_grve_print_header_breadcrumbs( 'portfolio' );
impeka_grve_print_anchor_menu( 'portfolio' );

$portfolio_media = impeka_grve_post_meta( '_impeka_grve_portfolio_media_selection' );
$portfolio_media_fullwidth = impeka_grve_post_meta( '_impeka_grve_portfolio_media_fullwidth', 'no' );
$sidebar_details = impeka_grve_global_param( 'sidebar_details' );

$portfolio_media_classes = array( 'grve-portfolio-media' );
if( 'yes' == $portfolio_media_fullwidth ){
	array_push( $portfolio_media_classes, 'grve-section', 'grve-fullwidth');
}
if ( 'yes' == $sidebar_details ) {
	array_push( $portfolio_media_classes, 'grve-without-sidebar' );
} else {
	array_push( $portfolio_media_classes, 'grve-with-sidebar' );
}
$portfolio_media_class_string = implode( ' ', $portfolio_media_classes );
?>

<div class="grve-single-wrapper">
	<?php
		if ( 'yes' == $sidebar_details  && 'none' != $portfolio_media ) {
	?>
		<div id="grve-single-media" class="<?php echo esc_attr( $portfolio_media_class_string ); ?>">
			<div class="grve-container">
				<?php impeka_grve_print_portfolio_media(); ?>
			</div>
		</div>
	<?php
		}
	?>
	<!-- CONTENT -->
	<div id="grve-content" <?php impeka_grve_content_class(); ?>>
		<div class="grve-content-wrapper">
			<!-- MAIN CONTENT -->
			<div id="grve-main-content">
				<?php do_action( 'impeka_grve_portfolio_main_content_wrapper_before' ); ?>
				<div class="grve-main-content-wrapper clearfix">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php
							if ( 'no' == $sidebar_details && 'none' != $portfolio_media ) {
						?>
							<div id="grve-single-media" class="<?php echo esc_attr( $portfolio_media_class_string ); ?>">
								<div class="grve-container">
									<?php impeka_grve_print_portfolio_media(); ?>
								</div>
							</div>
						<?php
							}
						?>
						<div id="grve-post-content">
							<?php the_content(); ?>
						</div>
					</article>
					<div class="grve-single-section">
						<div class="grve-container">
							<?php
								/**
								 * impeka_grve_portfolio_section hook
								 *
								 * @hooked impeka_grve_print_portfolio_social_bar - 10
								 */
								do_action( 'impeka_grve_portfolio_section' );
							?>
						</div>
					</div>
				</div>
				<?php do_action( 'impeka_grve_portfolio_main_content_wrapper_after' ); ?>
			</div>
			<!-- END MAIN CONTENT -->
			<?php
				if ( 'yes' == $sidebar_details ) {
			?>
				<aside id="grve-sidebar">
					<?php impeka_grve_print_portfolio_details(); ?>
				</aside>
			<?php
				} else {
					get_sidebar();
				}
			?>
		</div>
	</div>
	<!-- End CONTENT -->
	<?php
		/**
		 * impeka_grve_single_portfolio_after_content hook
		 *
		 * @hooked impeka_grve_print_portfolio_comments_section - 10
		 * @hooked impeka_grve_print_portfolio_related_section - 20
		 * @hooked impeka_grve_print_portfolio_nav_bar - 30
		 */
		do_action( 'impeka_grve_single_portfolio_after_content' );
	?>
</div>
<?php get_footer();

//Omit closing PHP tag to avoid accidental whitespace output errors.
