<?php
/*
*	Responsive Header: Style 1
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

$responsive_menu = impeka_grve_get_responsive_nav();
$responsive_sticky_type = impeka_grve_option( 'responsive_sticky_type', 'none' );

$responsive_header_classes = array();
if ( 'none' != $responsive_sticky_type ) {
	$responsive_header_classes[] = 'grve-' . $responsive_sticky_type . '-sticky';
}
$responsive_header_class_string = implode( ' ', $responsive_header_classes );
$header_layout = impeka_grve_option( 'header_layout' );

?>
<div id="grve-main-responsive-header" data-sticky="<?php echo esc_attr( $responsive_sticky_type ); ?>" class="<?php echo esc_attr( $responsive_header_class_string ); ?>">
	<div class="grve-header-row">
		<div class="grve-left-area">
			<?php impeka_grve_print_logo('responsive' ); ?>
		</div>
		<div class="grve-right-area">
			<div class="grve-header-elements">
				<?php do_action( 'impeka_grve_responsive_header_elements_first_item' ); ?>
				<?php impeka_grve_print_cart_responsive_link(); ?>
				<?php impeka_grve_print_header_sidearea_button( 'element' ); ?>
				<?php if( 'layout-default-style-2' != $header_layout ) { ?>
				<?php impeka_grve_print_header_safebutton( 'element' ); ?>
				<?php } ?>
				<?php do_action( 'impeka_grve_responsive_header_elements_last_item' ); ?>
			</div>
			<?php
				if ( 'disabled' != $responsive_menu || impeka_grve_check_header_elements_visibility_any( 'responsive' ) ){
					impeka_grve_print_header_responsive_menu_button();
				}
			?>
		</div>
	</div>
</div>