<?php
/*
*	Hover Item Style None
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$img_params = isset( $args ) ? $args : array();

$hover_style = impeka_grve_array_value( $img_params, 'hover_style' );
$link_atts = impeka_grve_array_value( $img_params, 'link_atts', array() );
$link_wrap = impeka_grve_array_value( $img_params, 'link_wrap' );

$radius = impeka_grve_array_value( $img_params, 'radius' );
$shadow = impeka_grve_array_value( $img_params, 'shadow' );
$image_effect = impeka_grve_array_value( $img_params, 'image_effect', 'no-effect' );

$wrapper_classes = array( 'grve-image-wrapper' );
if ( 'none' != $radius ) {
	$wrapper_classes[] = 'grve-radius-' . $radius;
}
if ( 'none' != $shadow ) {
	$wrapper_classes[] = 'grve-shadow-' . $shadow;
}
if ( 'no-effect' != $shadow ) {
	$wrapper_classes[] = 'grve-' . $image_effect;
}
$wrapper_classes_string = implode( ' ', $wrapper_classes );

?>


<div class="<?php echo esc_attr( $wrapper_classes_string ); ?>">
	<?php if ( !empty( $link_atts ) ) { ?>
	<a <?php echo implode( ' ', $link_atts ); ?>><?php if ( empty( $link_wrap ) ) { ?></a><?php } ?>
	<?php } ?>
	<?php impeka_grve_print_hover_media( $img_params ); ?>
	<?php if ( 'wrap' == $link_wrap ) { ?></a><?php } ?>
</div>
