<?php
/*
*	Modal Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$params = isset( $args ) ? $args : array();

$modal_id = impeka_grve_array_value( $params, 'modal_id' );
$modal_mode = impeka_grve_array_value( $params, 'modal_mode', 'full');
$modal_trigger = impeka_grve_array_value( $params, 'modal_trigger' );
$modal_reset = impeka_grve_array_value( $params, 'modal_reset', '1' );
$area_id = impeka_grve_array_value( $params, 'area_id' );
$close_color = impeka_grve_option( 'sliding_modals_close_color', 'black' );

//Element Wrapper
$wrapper_attributes = array();
$element_classes = array( 'grve-modal-element' );

if ( 'full' != $modal_mode ) {
	$element_classes[] = 'grve-modal-dialog';
	$element_classes[] = 'grve-drop-shadow';
	$element_classes[] = 'grve-content-' . $modal_mode;
} else {
	$element_classes[] = 'grve-modal-full';
}

$element_class_string = implode( ' ', $element_classes );
$wrapper_attributes[] = 'class="' . esc_attr( $element_class_string ) . '"';
$wrapper_attributes[] = 'id="' . esc_attr( $modal_id ) . '"';
$wrapper_attributes[] = 'data-area-id="' . esc_attr( $area_id ) . '"';
$wrapper_attributes[] = 'data-modal-mode="' . esc_attr( $modal_mode ) . '"';
if ( !empty( $modal_trigger ) ) {
	$wrapper_attributes[] = 'data-trigger-delay="' . esc_attr( $modal_trigger ) . '"';
	$wrapper_attributes[] = 'data-reset="' . esc_attr( $modal_reset ) . '"';
	echo '<a href="#' . esc_attr( $modal_id ) . '" class="grve-modal-trigger grve-hidden"></a>';
}

?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
	<div class="grve-modal-content">
		<?php impeka_grve_print_close_icon( $close_color ); ?>
		<div class="grve-modal-inner">
			<?php do_action( 'impeka_grve_area_content', $area_id ); ?>
		</div>
	</div>
</div>
<?php

//Omit closing PHP tag to avoid accidental whitespace output errors.