<?php
/*
*	Carousel Navigation
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$nav_params = isset( $args ) ? $args : array();

$show_nav = impeka_grve_is_enabled( impeka_grve_array_value( $nav_params, 'nav_visibility' ) );
if ( $show_nav ) {
	$icon = impeka_grve_array_value( $nav_params, 'nav_icon' );
	$icon_color = impeka_grve_array_value( $nav_params, 'nav_icon_color' );
	$shape = impeka_grve_array_value( $nav_params, 'nav_shape' );
	$shape_type = impeka_grve_array_value( $nav_params, 'nav_shape_type' );
	$shape_color = impeka_grve_array_value( $nav_params, 'nav_shape_color' );
	$extra_class = impeka_grve_array_value( $nav_params, 'nav_class' );

	$nav_left_options = array(
		'icon'  => $icon,
		'icon_color'  => $icon_color,
		'shape'  => $shape,
		'shape_type'  => $shape_type,
		'shape_color' => $shape_color,
		'direction' => 'left',
		'extra_class' => $extra_class,
	);
	$nav_right_options = array(
		'icon'  => $icon,
		'icon_color'  => $icon_color,
		'shape'  => $shape,
		'shape_type'  => $shape_type,
		'shape_color' => $shape_color,
		'direction' => 'right',
		'extra_class' => $extra_class,
	);
?>
	<div class="grve-carousel-navigation grve-navigation-<?php echo esc_attr( $icon ); ?>">
		<div class="grve-carousel-buttons">
			<div class="grve-carousel-prev"><?php echo impeka_grve_build_svg_icon( $nav_left_options ); ?></div>
			<div class="grve-carousel-next"><?php echo impeka_grve_build_svg_icon( $nav_right_options ); ?></div>
		</div>
	</div>
<?php
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
