<?php
/*
*	Template Portfolio Related Start
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$related_subtitle = impeka_grve_option( 'portfolio_related_subtitle' );
$related_title = impeka_grve_option( 'portfolio_related_title' );

$backlink_url = "";
$backlink = impeka_grve_option( 'portfolio_related_backlink_id' );
if( !empty( $backlink ) ) {
	$backlink = apply_filters( 'wpml_object_id', $backlink, 'page', TRUE  );
	$backlink_url = get_permalink( $backlink );
}
$backlink_text = impeka_grve_option( 'portfolio_related_backlink_text' );

?>
<div id="grve-related-section" data-header-color="default" class="grve-border grve-border-top grve-padding-top-2x grve-padding-bottom-3x">
	<div class="grve-container">
		<div id="grve-related-portfolio" class="grve-related">
			<div class="grve-wrapper">
				<?php if( !empty( $related_subtitle ) || !empty( $related_title ) || !empty( $backlink_url ) ) { ?>
				<div class="grve-related-top">
					<div class="grve-related-title-wrapper">
						<?php if( !empty( $related_subtitle ) ) { ?>
						<div class="grve-subtitle grve-subtitle-text"><?php echo esc_html( $related_subtitle ); ?></div>
						<?php } ?>
						<?php if( !empty( $related_title ) ) { ?>
						<div class="grve-title grve-h4"><?php echo esc_html( $related_title ); ?></div>
						<?php } ?>
					</div>
					<?php if ( !empty( $backlink_url ) ) { ?>
					<a href="<?php echo esc_url( $backlink_url ); ?>" class="grve-related-backlink grve-btn-text grve-btn-only-text grve-text-black grve-text-hover-black grve-btn-medium grve-with-svg-icon-arrow-1">
						<div class="grve-btn-inner">
							<span><?php echo esc_html( $backlink_text ); ?></span>
							<div class="grve-btn-svg-icon grve-with-shape grve-svg-white">
								<svg width="12px" height="12px" viewBox="0 0 12 12">
									<polygon points="3.6 0 10 6 3.6 12 2 10.5 6.8 6 2 1.5"></polygon>
								</svg>
								<div class="grve-shape-icon grve-circle grve-simple grve-bg-primary-1"></div>
							</div>
						</div>
					</a>
					<?php } ?>
				</div>
				<?php } ?>
				<div class="grve-related-row">