<?php
/*
*	Loop Post List Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$heading_tag = impeka_grve_array_value( $blog_params, 'heading_tag', 'h2' );
$small_post_heading = impeka_grve_array_value( $blog_params, 'small_post_heading', 'h5' );
$animation = impeka_grve_array_value( $blog_params, 'animation' );
$animation_delay = impeka_grve_array_value( $blog_params, 'animation_delay' );
$animation_duration = impeka_grve_array_value( $blog_params, 'animation_duration' );
$image_size = impeka_grve_array_value( $blog_params, 'image_size' );
$image_load_mode = impeka_grve_array_value( $blog_params, 'image_load_mode' );

//Inner Wrapper
$inner_attributes = array();
$inner_classes = array( 'grve-blog-item-inner' );
if ( !empty( $animation ) ) {
	$inner_classes[] = 'grve-animated-item';
	$inner_attributes[] = 'data-animation="' . esc_attr( $animation ) . '"';
	$inner_attributes[] = 'data-delay="' . esc_attr( $animation_delay ) . '"';
	$inner_attributes[] = 'data-duration="' . esc_attr( $animation_duration ) . '"';
}
$inner_class_string = implode( ' ', $inner_classes );
$inner_attributes[] = 'class="' . esc_attr( $inner_class_string ) . '"';

?>
<article <?php post_class(); ?> itemscope itemType="http://schema.org/BlogPosting">
	<div <?php echo implode( ' ', $inner_attributes ); ?>>
		<?php if( has_post_thumbnail() ) { ?>
			<div class="grve-media clearfix">
				<a href="<?php echo esc_url( get_permalink() ); ?>"><?php impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => '100', 'data-lazyload' => $image_load_mode ) ); ?></a>
			</div>
		<?php } ?>
		<div class="grve-post-content">
			<?php if ( 'yes' == $show_date ) { ?>
				<div class="grve-post-date grve-small-text"><span><?php impeka_grve_print_post_loop_meta( 'date' ); ?></span></div>
			<?php } ?>
			<?php the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark"><' . tag_escape( $heading_tag ) . ' class="grve-post-title grve-' . esc_attr( $small_post_heading ) . '" itemprop="headline">', '</' . tag_escape( $heading_tag ) . '></a>' ); ?>
			<?php echo impeka_grve_excerpt( '12' ); ?>
		</div>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</article>
