<?php
/*
*	Loop Post Style 1 Quote Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();
$quote_name = impeka_grve_admin_post_meta( get_the_ID(), '_impeka_grve_post_quote_name' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$anim_bg_class = array( 'grve-post-animated-bg' );
$anim_bg_class[]  = 'grve-radius-' . $radius;
$anim_bg_class_string = implode( ' ', $anim_bg_class );

?>
<div class="grve-post-item grve-style-1 grve-format-quote">
	<div class="grve-post-item-inner">
		<div class="grve-post-content-wrapper">
			<div class="grve-post-content">
				<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
				<?php impeka_grve_print_post_icon_format('quote'); ?>
				<?php impeka_grve_loop_post_title( $blog_params ); ?>
				<div class="grve-post-exerpt grve-h5" itemprop="articleBody">
					<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
				</div>
				<?php if ( !empty( $quote_name ) ) { ?>
				<div class="grve-post-quote-name grve-h6">
					<div class="grve-line grve-bg-primary-1"></div>
					<?php echo wp_kses_post(  $quote_name ); ?>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php impeka_grve_print_post_structured_data(); ?>
		<div class="<?php echo esc_attr( $anim_bg_class_string ); ?>"></div>
	</div>
</div>