<?php
/*
*	Loop Post Style 1 Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$link_url = get_post_meta( get_the_ID(), '_impeka_grve_post_link_url', true );
if( empty( $link_url ) ) {
	$link_url = get_permalink();
}

$item_class = array(
	'grve-post-item',
	'grve-small-style-1',
	'grve-format-link',
	'grve-bg-primary-1',
	'grve-text-white',
	'grve-headings-white',
	'grve-radius-' . $radius,
	'grve-shadow-' . $shadow
);
$item_class_string = implode( ' ', $item_class );

?>

<div class="<?php echo esc_attr( $item_class_string ); ?>">
	<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
	<div class="grve-post-item-inner">
		<?php impeka_grve_loop_post_title( $blog_params ); ?>
		<?php impeka_grve_loop_post_link_text(); ?>
		<div class="grve-arrow-icon grve-svg-white">
			<?php echo impeka_grve_get_svg_icon( 'arrow-2' ); ?>
		</div>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>
