<?php
/*
*	Loop Post Style 1 Quote Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();
$quote_name = impeka_grve_admin_post_meta( get_the_ID(), '_impeka_grve_post_quote_name' );
$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );

$item_class = array(
	'grve-post-item-inner',
	'grve-bg-dark-grey',
	'grve-text-white',
	'grve-headings-white',
	'grve-radius-' . $radius,
	'grve-shadow-' . $shadow
);
$item_class_string = implode( ' ', $item_class );

?>

<div class="grve-post-item grve-small-style-1 grve-format-quote">
	<div class="<?php echo esc_attr( $item_class_string ); ?>">
		<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
		<?php impeka_grve_print_post_overview_bg_image_container( $blog_params ); ?>
		<div class="grve-post-content">
			<div class="grve-post-icon grve-bg-primary-1 grve-svg-white">
				<?php echo impeka_grve_get_svg_icon( 'quote-1'); ?>
			</div>
			<?php impeka_grve_loop_post_title( $blog_params ); ?>
			<div class="grve-post-exerpt grve-quote-text" itemprop="articleBody">
				<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
			</div>
			<?php if ( !empty( $quote_name ) ) { ?>
			<div class="grve-post-quote-name grve-h6">
				<div class="grve-line grve-bg-primary-1"></div>
				<?php echo wp_kses_post(  $quote_name ); ?>
			</div>
			<?php } ?>
		</div>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>