<?php
/*
*	Loop Post Style 1 Video Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$show_categories = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'categories_visibility' ) );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );
$image_prio = impeka_grve_array_value( $blog_params, 'image_prio', 'no' );

?>
<div class="grve-post-item grve-small-style-1 grve-format-video">
	<div class="grve-post-item-inner">
		<?php if ( 'yes' == $image_prio && has_post_thumbnail() ) { ?>
		<div class="grve-post-media grve-radius-<?php echo esc_attr( $radius ); ?> grve-shadow-<?php echo esc_attr( $shadow ); ?>">
			<?php impeka_grve_print_post_bg_link( $blog_params ); ?>
			<?php impeka_grve_print_post_feature_image( $blog_params ); ?>
			<?php if ( $show_categories ) { ?>
			<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
			<?php } ?>
		</div>
		<?php } else { ?>
		<div class="grve-post-media grve-radius-<?php echo esc_attr( $radius ); ?> grve-shadow-<?php echo esc_attr( $shadow ); ?>">
			<?php impeka_grve_print_post_video(); ?>
		</div>
		<?php } ?>
		<div class="grve-post-content">
			<?php impeka_grve_loop_post_title_link( $blog_params ); ?>
			<?php get_template_part( 'templates/post/meta/loop-post-meta-style-1', '', $blog_params ); ?>
			<div class="grve-post-exerpt" itemprop="articleBody">
				<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
			</div>
		</div>

	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>

