<?php
/*
*	Loop Post Style Large Gallery Template
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$blog_params = isset( $args ) ? $args : array();

$show_date = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'date_visibility'  ) );
$show_categories = impeka_grve_is_enabled( impeka_grve_array_value( $blog_params, 'categories_visibility' ) );
$categories_mode = impeka_grve_array_value( $blog_params, 'categories_mode', 'all' );
$shadow = impeka_grve_array_value( $blog_params, 'shadow', 'none' );
$radius = impeka_grve_array_value( $blog_params, 'radius', 'none' );
$excerpt_more = impeka_grve_array_value( $blog_params, 'excerpt_more' );
$excerpt_more_text = impeka_grve_array_value( $blog_params, 'excerpt_more_text' );
?>
<div class="grve-post-item grve-small-style-2 grve-format-gallery">
	<div class="grve-post-item-inner">
		<?php impeka_grve_print_post_bg_link( $blog_params ); ?>

		<?php if ( has_post_thumbnail() ) { ?>
			<div class="grve-post-media">
				<div class="grve-media-inner">
					<div class="grve-background-wrapper">
						<?php impeka_grve_print_post_bg_image(); ?>
					</div>
				</div>
			</div>
		<?php } ?>

		<?php if ( $show_date ) { ?>
		<div class="grve-post-date grve-h5 grve-heading-color"><?php impeka_grve_print_post_loop_meta( 'date' ); ?></div>
		<?php } ?>
		<div class="grve-post-content">
			<?php impeka_grve_loop_post_title( $blog_params ); ?>
			<?php get_template_part( 'templates/post/meta/loop-post-meta-style-2', '', $blog_params ); ?>
			<?php impeka_grve_print_post_excerpt( $blog_params ); ?>
			<?php if ( $show_categories ) { ?>
			<div class="grve-post-category grve-small-text"><?php impeka_grve_print_post_loop_meta( 'categories-' . $categories_mode ); ?></div>
			<?php } ?>
		</div>
		<?php
			if( $excerpt_more ) {
				echo impeka_grve_read_more('', $excerpt_more_text);
			}
		?>
	</div>
	<?php impeka_grve_print_post_structured_data(); ?>
</div>
