<?php
/*
*	Anchor Menu
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$anchor_params = isset( $args ) ? $args : array();

$anchor_id = impeka_grve_array_value( $anchor_params, 'id' );
$anchor_nav_menu = impeka_grve_array_value( $anchor_params, 'nav_menu' );
$anchor_fullwidth = impeka_grve_array_value( $anchor_params, 'fullwidth' );
$anchor_alignment = impeka_grve_array_value( $anchor_params, 'alignment', 'left' );
$anchor_device_layout = impeka_grve_array_value( $anchor_params, 'device_layout' );

$anchor_classes = array( 'grve-anchor-menu', 'grve-align-' . $anchor_alignment );
if ( impeka_grve_is_enabled( $anchor_fullwidth ) ) {
	$anchor_classes[] = ' grve-fullwidth';
}

if ( empty( $anchor_device_layout  ) ) {
	$anchor_classes[] = 'grve-anchor-responsive-layout';
}
		
$anchor_class_string = implode( ' ', $anchor_classes );
?>

<div id="<?php echo esc_attr( $anchor_id ); ?>" class="<?php echo esc_attr( $anchor_class_string ); ?>">
	<div class="grve-wrapper grve-anchor-wrapper">
		<div class="grve-container">
			<?php
			if ( empty( $anchor_nav_menu ) ) {
				wp_nav_menu(
					array(
						'theme_location' => 'impeka_anchor_nav',
						'container' => false,
						'depth' => '1',
						'walker' => new Impeka_Grve_Simple_Navigation_Walker(),
					)
				);
			} else {
				wp_nav_menu(
					array(
						'menu' => $anchor_nav_menu,
						'container' => false,
						'depth' => '1',
						'walker' => new Impeka_Grve_Simple_Navigation_Walker(),
					)
				);
				if ( empty( $anchor_device_layout  ) ) {
					wp_nav_menu(
						array(
							'menu' => $anchor_nav_menu,
							'container' => false,
							'depth' => '1',
							'walker' => new Impeka_Grve_Dropdown_Navigation_Walker(),
							'items_wrap' => '<div class="grve-anchor-dropdown-wrapper"><select class="grve-anchor-dropdown">%3$s</select></div>',
						)
					);
				}
			}
			?>
		</div>
	</div>
</div>