<?php
/*
*	Navigation Bar Layout 3
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$nav_params = isset( $args ) ? $args : array();

$post_type = impeka_grve_array_value( $nav_params, 'post_type', 'post' );
$backlink_url = impeka_grve_array_value( $nav_params, 'backlink_url' );
$prev_post = impeka_grve_array_value( $nav_params, 'prev_post' );
$prev_post_text = impeka_grve_array_value( $nav_params, 'prev_post_text' );
$prev_post_img_url = impeka_grve_array_value( $nav_params, 'prev_post_img_url' );
$next_post = impeka_grve_array_value( $nav_params, 'next_post' );
$next_post_text = impeka_grve_array_value( $nav_params, 'next_post_text' );
$next_post_img_url = impeka_grve_array_value( $nav_params, 'next_post_img_url' );
$skin_assets = impeka_grve_array_value( $nav_params, 'skin_assets' );


?>

<div id="grve-<?php echo esc_attr( $post_type ); ?>-bar" class="grve-navigation-bar grve-layout-3" data-header-color="<?php echo esc_attr( $skin_assets ); ?>">
	<?php if ( is_a( $prev_post, 'WP_Post' ) ) { ?>
	<a href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" class="grve-nav-item grve-prev grve-hide-indicator" data-item="prev">
		<div class="grve-title grve-h1"><?php echo esc_html( $prev_post_text ); ?></div>
		<div class="grve-media">
			<?php if( !empty( $prev_post_img_url ) ) { ?>
			<div class="grve-inner">
				<div class="grve-nav-image" style="background-image: url(<?php echo esc_url( $prev_post_img_url ); ?>);"></div>
			</div>
			<?php } ?>
		</div>
	</a>
	<?php } ?>
	<?php if ( is_a( $prev_post, 'WP_Post' ) && is_a( $next_post, 'WP_Post' ) ) { ?>
	<div class="grve-line"></div>
	<?php } ?>
	<?php if ( is_a( $next_post, 'WP_Post' ) ) { ?>
	<a href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" class="grve-nav-item grve-next grve-hide-indicator" data-item="next">
		<div class="grve-title grve-h1"><?php echo esc_html( $next_post_text ); ?></div>
		<div class="grve-media">
			<?php if( !empty( $next_post_img_url ) ) { ?>
			<div class="grve-inner">
				<div class="grve-nav-image" style="background-image: url(<?php echo esc_url( $next_post_img_url ); ?>);"></div>
			</div>
			<?php } ?>
		</div>
	</a>
	<?php } ?>
</div>