<?php
/*
*	Modal Language Switcher
*
* 	@version	1.0
* 	@author		Greatives Team
* 	@URI		https://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$skip_missing = impeka_grve_option('language_switcher_skip_missing', '0' );
$skip_missing = intval( $skip_missing );

?>
<div id="grve-language-modal" class="grve-sliding-item">
	<ul class="grve-language grve-leader-text">
<?php
	if( function_exists( 'pll_the_languages' ) ) {
		//Polylang
		$languages = pll_the_languages( array( 'raw'=>1, 'hide_if_no_translation' => $skip_missing  ) );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {
				echo '<li>';
				if ( !$l['current_lang'] ) {
					echo '<a href="' . esc_url( $l['url'] ) . '">';
				} else {
					echo '<a href="#" class="grve-active">';
				}
				echo esc_html( $l['name'] );
				echo '</a></li>';
			}
		}
	} else if ( defined( 'ICL_SITEPRESS_VERSION' ) && defined( 'ICL_LANGUAGE_CODE' ) && function_exists( 'icl_get_languages' ) ) {
		//WPML
		$languages = icl_get_languages( 'skip_missing=' . $skip_missing );
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {
				echo '<li>';
				if ( !$l['active'] ) {
					echo '<a href="' . esc_url( $l['url'] ) . '">';
				} else {
					echo '<a href="#" class="grve-active">';
				}
				echo esc_html( $l['native_name'] );
				echo '</a></li>';
			}
		}
	}
?>
	</ul>
</div>