<?php
/**
 * View: Day View - Single Event Featured Image
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/day/event/featured-image.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://m.tri.be/1aiy
 *
 * @version 5.0.0
 *
 * @var WP_Post $event The event post object with properties added by the `tribe_get_event` function.
 *
 * @see tribe_get_event() For the format of the event object.
 */

if ( ! $event->thumbnail->exists ) {
	return;
}
$event_image_size = impeka_grve_option( 'event_overview_image_size' );
if( 'default' != $event_image_size ) {
	$image_size = impeka_grve_get_image_size( $event_image_size );
} else {
	$image_size = 'full';
}

?>
<div class="tribe-events-calendar-day__event-featured-image-wrapper">
	<a
		href="<?php echo esc_url( $event->permalink ); ?>"
		title="<?php echo esc_attr( $event->title ); ?>"
		rel="bookmark"
		class="tribe-events-calendar-day__event-featured-image-link"
	>
	<?php impeka_grve_the_post_thumbnail( $image_size, array( 'data-column-space' => '100', 'class'=> "tribe-events-calendar-day__event-featured-image" ) ); ?>
	</a>
</div>
