<?php
/**
 * View: List View - Single Event Title
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/list/event/title.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://m.tri.be/1aiy
 *
 * @version 5.0.0
 *
 * @var WP_Post $event The event post object with properties added by the `tribe_get_event` function.
 *
 * @see tribe_get_event() For the format of the event object.
 */
$title_heading_tag = impeka_grve_option( 'event_overview_heading_tag', 'h2' );
$title_heading = impeka_grve_option( 'event_overview_heading', 'h2' ); 
?>
<<?php echo tag_escape( $title_heading_tag ); ?> class="tribe-events-calendar-list__event-title grve-<?php echo esc_attr( $title_heading ); ?>">
	<a
		href="<?php echo esc_url( $event->permalink ); ?>"
		title="<?php echo esc_attr( $event->title ); ?>"
		rel="bookmark"
		class="tribe-events-calendar-list__event-title-link tribe-common-anchor-thin"
	>
		<?php
		// phpcs:ignore
		echo wp_kses_post( $event->title );
		?>
	</a>
</<?php echo tag_escape( $title_heading_tag ); ?>>
