jQuery(document).ready(function($) {

	"use strict";

	if( 0 === $('.grve-custom-modal-normal').length ) {
		$('.grve-custom-modal-empty').show();
	}

	$(document).on("click",".grve-custom-modal-item-delete-button",function() {
		$(this).parents('.grve-custom-modal-item').remove();
		$('.grve-modal-changed').show();
		if( 0 === $('.grve-custom-modal-normal').length ) {
			$('.grve-custom-modal-empty').show();
		}
		$('#grve-custom-modal-form').submit();
	});

	$(document).on("change",".grve-modal-wrap .grve-modal-select",function() {
		$(this).parents('.grve-custom-modal-item').find('.grve-custom-modal-item-save-button').show();
	});
	$(document).on("change",".grve-modal-wrap .grve-modal-trigger",function() {
		var $resetSelect = $(this).parents('.grve-custom-modal-item').find('.grve-modal-reset');
		if ($resetSelect.length ) {
			if ( '' == $(this).val() ) {
				$resetSelect.prop("disabled", true);
			} else {
				$resetSelect.prop("disabled", false);
			}
		}
	});
	$(document).on("change","#grve-custom-modal-item-trigger",function() {
		var $resetSelect = $('#grve-custom-modal-item-reset');
		if ($resetSelect.length ) {
			if ( '' == $(this).val() ) {
				$resetSelect.prop("disabled", true);
			} else {
				$resetSelect.prop("disabled", false);
			}
		}
	});

	$(document).on("click",".grve-custom-modal-item-save-button",function() {
		$('#grve-custom-modal-form').submit();
	});

	$(document).on("click","#grve-add-custom-modal-item",function(event) {
		event.preventDefault();
		$('.grve-modal-wrap .button').attr('disabled','disabled').addClass('disabled');
		$('.grve-modal-notice').hide();
		$('.grve-modal-notice-exists').hide();
		$('.grve-modal-spinner').show();

		var modalID = $.trim( $('#grve-custom-modal-item-id').val() ),
			modalMode = $('#grve-custom-modal-item-mode').val(),
			modalTrigger = $('#grve-custom-modal-item-trigger').val(),
			modalReset = $('#grve-custom-modal-item-reset').val(),
			modalAreaID = $('#grve-custom-modal-item-area-id').val();
		if ( '' == modalID ) {
			$('.grve-modal-notice').show();
			$('.grve-modal-spinner').hide();
			$('.grve-modal-wrap .button').removeAttr('disabled').removeClass('disabled');
		} else {

			var alreadyExists = false;

			modalID = modalID.replace(/\s+/g, '-').toLowerCase();

			$('.grve-modal-wrap .grve-custom-modal-item-id').each(function () {
				if( $(this).val() == modalID ) {
					alreadyExists = true;
					return false;
				}
			});
			if ( alreadyExists ) {
				$('.grve-modal-notice-exists').show();
				$('.grve-modal-spinner').hide();
				$('.grve-modal-wrap .button').removeAttr('disabled').removeClass('disabled');
			} else {
				var dataParams = {
					action:'impeka_grve_get_custom_modal',
					modal_id: modalID,
					modal_mode: modalMode,
					modal_trigger: modalTrigger,
					modal_reset: modalReset,
					modal_area_id: modalAreaID,
					_grve_nonce: impeka_ext_custom_modal_texts.nonce_custom_modal
				};
				$.post( impeka_ext_custom_modal_texts.ajaxurl, dataParams, function( modalHtml ) {
					$('#grve-custom-modal-container').append(modalHtml);
					$('#grve-custom-modal-item-id').val('');
					$('.grve-modal-spinner').hide();
					$('.grve-modal-changed').show();
					$('.grve-modal-wrap .button').removeAttr('disabled').removeClass('disabled');
					if( 0 !== $('.grve-custom-modal-normal').length ) {
						$('.grve-custom-modal-empty').hide();
					}
					$('#grve-custom-modal-form').submit();
				}).fail(function(xhr, status, error) {
					$('.grve-modal-spinner').hide();
					$('.grve-modal-wrap .button').removeAttr('disabled').removeClass('disabled');
				});
			}
		}
	});
	$('.grve-modal-saved').delay(4000).slideUp();


});