<?php
/*
*	Admin Functions
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function impeka_ext_add_admin_screens( $screens ){
	$screens['impeka-modals'] = array(
		'id' => 'impeka-modals',
		'title' => esc_html__('Global Modals','impeka-extension'),
		'tab' => 'modals',
		'admin_url' => '?page=impeka-modals',
		'function' => 'impeka_ext_admin_page_modals',
	);
	$screens['impeka-codes'] = array(
		'id' => 'impeka-codes',
		'title' => esc_html__('Custom Codes','impeka-extension'),
		'tab' => 'codes',
		'admin_url' => '?page=impeka-codes',
		'function' => 'impeka_ext_admin_page_html_codes',
	);
	$screens['impeka-fonts'] = array(
		'id' => 'impeka-fonts',
		'title' => esc_html__('Font Manager','impeka-extension'),
		'tab' => 'fonts',
		'admin_url' => '?page=impeka-fonts',
		'function' => 'impeka_ext_admin_page_font_manager',
	);

	return $screens;
}
add_filter( 'impeka_grve_admin_screens', 'impeka_ext_add_admin_screens' );

function impeka_ext_admin_page_modals(){
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/pages/impeka-ext-admin-page-modals.php';
}
function impeka_ext_admin_page_html_codes(){
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/pages/impeka-ext-admin-page-codes.php';
}
function impeka_ext_admin_page_font_manager(){
	require_once IMPEKA_EXT_PLUGIN_DIR_PATH . 'includes/admin/pages/impeka-ext-admin-page-font-manager.php';
}

function impeka_ext_add_settings() {

	if ( isset( $_POST['_impeka_ext_options_nonce_save'] ) && wp_verify_nonce( $_POST['_impeka_ext_options_nonce_save'], 'impeka_ext_options_nonce_save' ) ) {

		if ( isset( $_POST['impeka_grve_ext_options'] ) ) {
			$options = get_option('impeka_grve_ext_options');

			$keys = array_keys( $_POST['impeka_grve_ext_options'] );
			foreach ( $keys as $key ) {
				if ( isset( $_POST['impeka_grve_ext_options'][$key] ) ) {
					$options[$key] = $_POST['impeka_grve_ext_options'][$key];
				}
			}
			if ( empty( $options ) ) {
				delete_option( 'impeka_grve_ext_options' );
			} else {
				update_option( 'impeka_grve_ext_options', $options );
			}
		}
		wp_safe_redirect( 'admin.php?page=impeka-codes&ext-settings=saved' );
	}
}
add_action( 'admin_menu', 'impeka_ext_add_settings' );



if ( !function_exists('impeka_ext_print_head_code') ) {
	function impeka_ext_print_head_code() {
		$options = get_option('impeka_grve_ext_options');
		$code = impeka_ext_array_value( $options, 'head_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('wp_head', 'impeka_ext_print_head_code');

if ( !function_exists('impeka_ext_print_body_code') ) {
	function impeka_ext_print_body_code() {
		$options = get_option('impeka_grve_ext_options');
		$code = impeka_ext_array_value( $options, 'body_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('wp_body_open', 'impeka_ext_print_body_code', 1 );

if ( !function_exists('impeka_ext_print_footer_code') ) {
	function impeka_ext_print_footer_code() {
		$options = get_option('impeka_grve_ext_options');
		$code = impeka_ext_array_value( $options, 'footer_code' );
		if ( !empty( $code ) ) {
			echo wp_unslash( $code );
		}
	}
}
add_action('wp_footer', 'impeka_ext_print_footer_code');

//Omit closing PHP tag to avoid accidental whitespace output errors.
