<?php
/*
*	Testimonial Post Type Registration
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( ! class_exists( 'Impeka_Testimonial_Post_Type' ) ) {
	class Impeka_Testimonial_Post_Type {

		function __construct() {

			// Adds the testimonial post type and taxonomies
			$this->impeka_ext_testimonial_init();

			// Manage Columns for testimonial overview
			add_filter( 'manage_edit-testimonial_columns',  array( &$this, 'impeka_ext_testimonial_edit_columns' ) );
			add_action( 'manage_posts_custom_column', array( &$this, 'impeka_ext_testimonial_custom_columns' ), 10, 2 );

		}

		function impeka_ext_testimonial_init() {

			$labels = array(
				'name' => esc_html_x( 'Testimonial Items', 'Testimonial General Name', 'impeka-extension' ),
				'singular_name' => esc_html_x( 'Testimonial Item', 'Testimonial Singular Name', 'impeka-extension' ),
				'add_new' => esc_html__( 'Add New', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Testimonial Item', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Testimonial Item', 'impeka-extension' ),
				'new_item' => esc_html__( 'New Testimonial Item', 'impeka-extension' ),
				'view_item' => esc_html__( 'View Testimonial Item', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Testimonial Items', 'impeka-extension' ),
				'not_found' =>  esc_html__( 'No Testimonial Items found', 'impeka-extension' ),
				'not_found_in_trash' => esc_html__( 'No Testimonial Items found in Trash', 'impeka-extension' ),
				'parent_item_colon' => '',
			);

			$category_labels = array(
				'name' => esc_html__( 'Testimonial Categories', 'impeka-extension' ),
				'singular_name' => esc_html__( 'Testimonial Category', 'impeka-extension' ),
				'search_items' => esc_html__( 'Search Testimonial Categories', 'impeka-extension' ),
				'all_items' => esc_html__( 'All Testimonial Categories', 'impeka-extension' ),
				'parent_item' => esc_html__( 'Parent Testimonial Category', 'impeka-extension' ),
				'parent_item_colon' => esc_html__( 'Parent Testimonial Category:', 'impeka-extension' ),
				'edit_item' => esc_html__( 'Edit Testimonial Category', 'impeka-extension' ),
				'update_item' => esc_html__( 'Update Testimonial Category', 'impeka-extension' ),
				'add_new_item' => esc_html__( 'Add New Testimonial Category', 'impeka-extension' ),
				'new_item_name' => esc_html__( 'New Testimonial Category Name', 'impeka-extension' ),
			);

			$args = array(
				'labels' => $labels,
				'public' => false,
				'publicly_queryable' => false,
				'show_ui' => true,
				'query_var' => false,
				'rewrite' => true,
				'capability_type' => 'post',
				'hierarchical' => false,
				'menu_position' => 5,
				'menu_icon' => 'dashicons-testimonial',
				'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'page-attributes' ),
				'rewrite' => array( 'slug' => 'testimonial', 'with_front' => false ),
			);

			register_post_type(
				'testimonial' ,
				apply_filters( "impeka_ext_register_post_type_testimonial_args", $args )
			);

			register_taxonomy(
				'testimonial_category',
				apply_filters( 'impeka_ext_register_taxonomy_testimonial_category_object_type',
					array( 'testimonial' )
				),
				apply_filters( 'impeka_ext_register_taxonomy_testimonial_category_args',
					array(
						'hierarchical' => true,
						'label' => esc_html__( 'Testimonial Categories', 'impeka-extension' ),
						'labels' => $category_labels,
						'show_in_nav_menus' => false,
						'show_tagcloud' => false,
						'show_in_rest' => true,
						'rewrite' => true,
					)
				)
			);
		}

		function impeka_ext_testimonial_edit_columns( $columns ) {
			$columns['cb'] = "<input type=\"checkbox\" />";
			$columns['title'] = esc_html__( 'Title', 'impeka-extension' );
			$columns['testimonial_thumbnail'] = esc_html__( 'Featured Image', 'impeka-extension' );
			$columns['author'] = esc_html__( 'Author', 'impeka-extension' );
			$columns['testimonial_category'] = esc_html__( 'Testimonial Categories', 'impeka-extension' );
			$columns['date'] = esc_html__( 'Date', 'impeka-extension' );
			return $columns;
		}

		function impeka_ext_testimonial_custom_columns( $column, $post_id ) {

			switch ( $column ) {
				case "testimonial_thumbnail":
					if ( has_post_thumbnail( $post_id ) ) {
						$thumbnail_id = get_post_thumbnail_id( $post_id );
						$attachment_src = wp_get_attachment_image_src( $thumbnail_id, array( 80, 80 ) );
						if ( $attachment_src ) {
							$thumb = $attachment_src[0];
						} else {
							$thumb = get_template_directory_uri() . '/includes/images/not-found.jpg';
						}
					} else {
						$thumb = get_template_directory_uri() . '/includes/images/no-image.jpg';
					}
					echo '<img class="attachment-80x80" width="80" height="80" alt="testimonial image" src="' . esc_url( $thumb ) . '">';
					break;
				case 'testimonial_category':
					echo get_the_term_list( $post_id, 'testimonial_category', '', ', ','' );
				break;
			}
		}

	}
	new Impeka_Testimonial_Post_Type;
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
