<?php
/**
 * Misc Shortcodes
 */

function impeka_ext_email_shortcode( $atts , $content = null ) {
    if ( ! is_email( $content ) ) {
        return;
    }
    return '<a href="' . esc_url('mailto:' . antispambot( $content ) ) . '">' . esc_html( antispambot( $content ) ) . '</a>';
}
add_shortcode( 'impeka_email', 'impeka_ext_email_shortcode' );

function impeka_ext_tel_shortcode( $atts , $content = null ) {
    if ( empty( $content ) ) {
        return;
    }
	$trim_content = preg_replace("/\s+/", "", $content);
    return '<a href="' . esc_attr('tel:' . trim( $trim_content ) ) . '">' . esc_html( $content ) . '</a>';
}
add_shortcode( 'impeka_tel', 'impeka_ext_tel_shortcode' );


function impeka_ext_year_shortcode() {
  $year = date('Y');
  return $year;
}
add_shortcode('impeka_year', 'impeka_ext_year_shortcode');

//Omit closing PHP tag to avoid accidental whitespace output errors.
