<?php
/**
 * Privacy Custom Shortcode
 */

if( !function_exists( 'impeka_ext_privacy_custom_shortcode' ) ) {

	function impeka_ext_privacy_custom_shortcode( $atts, $content ) {

		$output = '';

		$combined_atts = $atts;

		extract(
			$combined_atts = shortcode_atts(
				array(
					'id' => 'custom',
				),
				$atts
			)
		);

		if( empty( $content ) ) {
			$content = "Click to enable/disable custom content.";
		}
		if( empty( $id ) ) {
			$id = 'custom-id';
		}
		$id = sanitize_title_with_dashes( $id );

		if ( function_exists( 'impeka_grve_get_privacy_switch' ) ) {
			$output .= impeka_grve_get_privacy_switch ( 'grve-privacy-content-' . esc_attr( $id ) , $content );
		}

		return $output;
	}
	add_shortcode( 'impeka_privacy_custom', 'impeka_ext_privacy_custom_shortcode' );

}

//Omit closing PHP tag to avoid accidental whitespace output errors.
